/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.function;

import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import swaydb.core.data.Value;
import swaydb.core.function.FunctionStore;
import swaydb.core.function.MemoryStore;
import swaydb.data.order.KeyOrder$;
import swaydb.data.slice.Slice;

public final class FunctionStore$ {
    public static final FunctionStore$ MODULE$ = new FunctionStore$();
    private static final FunctionStore.FunctionIdOrder order = new FunctionStore.FunctionIdOrder(){

        public Some tryCompare(Object x, Object y) {
            return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
        }

        public Object max(Object x, Object y) {
            return Ordering.max$((Ordering)this, (Object)x, (Object)y);
        }

        public Object min(Object x, Object y) {
            return Ordering.min$((Ordering)this, (Object)x, (Object)y);
        }

        public Ordering<Slice<Object>> reverse() {
            return Ordering.reverse$((Ordering)this);
        }

        public boolean isReverseOf(Ordering<?> other) {
            return Ordering.isReverseOf$((Ordering)this, other);
        }

        public <U> Ordering<U> on(Function1<U, Slice<Object>> f) {
            return Ordering.on$((Ordering)this, f);
        }

        public Ordering<Slice<Object>> orElse(Ordering<Slice<Object>> other) {
            return Ordering.orElse$((Ordering)this, other);
        }

        public <S> Ordering<Slice<Object>> orElseBy(Function1<Slice<Object>, S> f, Ordering<S> ord) {
            return Ordering.orElseBy$((Ordering)this, f, ord);
        }

        public Ordering.OrderingOps mkOrderingOps(Object lhs) {
            return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
        }

        public int compare(Slice<Object> x, Slice<Object> y) {
            return KeyOrder$.MODULE$.lexicographic().compare(x, y);
        }
        {
            PartialOrdering.$init$((PartialOrdering)this);
            Ordering.$init$((Ordering)this);
        }
    };

    public MemoryStore memory() {
        return new MemoryStore();
    }

    public FunctionStore.FunctionIdOrder order() {
        return order;
    }

    public boolean containsFunction(Slice<Object> functionId, Slice<Value> values) {
        return this.checkContains$1(values, functionId);
    }

    private final boolean checkContains$1(Slice values, Slice functionId$1) {
        boolean bl;
        block9: {
            Option option;
            while ((option = values.headOption()) instanceof Some) {
                boolean bl2;
                Value value = (Value)((Some)option).value();
                boolean bl3 = value instanceof Value.Remove ? true : (value instanceof Value.Update ? true : value instanceof Value.Put);
                if (bl3) {
                    bl2 = false;
                } else if (value instanceof Value.Function) {
                    Slice<Object> function = ((Value.Function)value).function();
                    if (!this.order().equiv(function, functionId$1)) {
                        values = values.dropHead();
                        continue;
                    }
                    bl2 = true;
                } else {
                    if (value instanceof Value.PendingApply) {
                        values = ((Value.PendingApply)value).applies();
                        continue;
                    }
                    throw new MatchError((Object)value);
                }
                bl = bl2;
                break block9;
            }
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError((Object)option);
            }
        }
        return bl;
    }

    private FunctionStore$() {
    }
}

