/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.file;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import swaydb.core.actor.MemorySweeper;
import swaydb.core.actor.MemorySweeper$Disabled$;
import swaydb.core.io.file.BlockCache;
import swaydb.core.io.file.DBFileType;
import swaydb.core.util.HashedMap;
import swaydb.core.util.HashedMap$;
import swaydb.data.slice.Slice;
import swaydb.data.slice.SliceOption;

public final class BlockCache$ {
    public static final BlockCache$ MODULE$ = new BlockCache$();

    public Option<BlockCache.State> init(MemorySweeper memorySweeper) {
        None$ none$;
        if (MemorySweeper$Disabled$.MODULE$.equals(memorySweeper)) {
            none$ = None$.MODULE$;
        } else if (memorySweeper instanceof MemorySweeper.Enabled) {
            None$ none$2;
            MemorySweeper.Enabled enabled = (MemorySweeper.Enabled)memorySweeper;
            if (enabled instanceof MemorySweeper.BlockSweeper) {
                MemorySweeper.BlockSweeper blockSweeper = (MemorySweeper.BlockSweeper)enabled;
                none$2 = new Some((Object)this.init(blockSweeper));
            } else if (enabled instanceof MemorySweeper.KeyValueSweeper) {
                none$2 = None$.MODULE$;
            } else if (enabled instanceof MemorySweeper.All) {
                MemorySweeper.All all = (MemorySweeper.All)enabled;
                none$2 = new Some((Object)this.init(all));
            } else {
                throw new MatchError((Object)enabled);
            }
            none$ = none$2;
        } else {
            throw new MatchError((Object)memorySweeper);
        }
        return none$;
    }

    public BlockCache.State init(MemorySweeper.BlockSweeper memorySweeper) {
        int x$1 = memorySweeper.blockSize();
        int x$3 = memorySweeper.skipBlockCacheSeekSize();
        HashedMap.Concurrent x$4 = HashedMap$.MODULE$.concurrent(Slice.Null$.MODULE$, (Option<Object>)None$.MODULE$);
        return new BlockCache.State(x$1, x$3, memorySweeper, x$4);
    }

    public BlockCache.State init(MemorySweeper.All memorySweeper) {
        int x$1 = memorySweeper.blockSize();
        int x$3 = memorySweeper.skipBlockCacheSeekSize();
        HashedMap.Concurrent x$4 = HashedMap$.MODULE$.concurrent(Slice.Null$.MODULE$, (Option<Object>)None$.MODULE$);
        return new BlockCache.State(x$1, x$3, memorySweeper, x$4);
    }

    public int seekSize(int keyPosition, int size, DBFileType file, BlockCache.State state) {
        long fileSize = file.fileSize();
        int seekSize = state.blockSize() <= 0 ? size : (int)(state.blockSizeDouble() * Math.ceil(Math.abs((double)size / state.blockSizeDouble())));
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper((int)fileSize - keyPosition), seekSize)), 0);
    }

    public int seekPosition(int position, BlockCache.State state) {
        if (state.blockSize() <= 0) {
            return position;
        }
        return (int)(state.blockSizeDouble() * Math.floor(Math.abs((double)position / state.blockSizeDouble())));
    }

    private Slice<Object> getOrSeek(int position, int size, Slice<Object> headBytes, DBFileType file, BlockCache.State state, BlockCache.BlockIO blockIO) {
        Slice slice;
        block4: {
            SliceOption<Object> sliceOption;
            int keyPosition;
            block3: {
                Slice mergedBytes;
                while (true) {
                    keyPosition = this.seekPosition(position, state);
                    sliceOption = state.map().get(new BlockCache.Key(file.blockCacheFileId(), keyPosition));
                    if (!(sliceOption instanceof Slice)) break block3;
                    Slice seekedBytes = ((Slice)sliceOption).take(position - keyPosition, size);
                    Slice slice2 = mergedBytes = headBytes == null ? seekedBytes : headBytes.$plus$plus(seekedBytes, (ClassTag)ClassTag$.MODULE$.Byte());
                    if (seekedBytes.isEmpty() || seekedBytes.size() == size) break;
                    headBytes = mergedBytes;
                    size -= seekedBytes.size();
                    position += seekedBytes.size();
                }
                slice = mergedBytes;
                break block4;
            }
            if (Slice.Null$.MODULE$.equals(sliceOption)) {
                int x$3 = position - keyPosition + size;
                Slice bytesToReturn = blockIO.seek(keyPosition, x$3, file, state).take(position - keyPosition, size);
                slice = headBytes == null ? bytesToReturn : headBytes.$plus$plus(bytesToReturn, (ClassTag)ClassTag$.MODULE$.Byte());
            } else {
                throw new MatchError(sliceOption);
            }
        }
        return slice;
    }

    public Slice<Object> getOrSeek(int position, int size, DBFileType file, BlockCache.State state, BlockCache.BlockIO effect) {
        if (size >= state.skipBlockCacheSeekSize()) {
            return file.read(position, size);
        }
        return this.getOrSeek(position, size, null, file, state, effect);
    }

    private BlockCache$() {
    }
}

