/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.file;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple3;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import swaydb.Error;
import swaydb.IO;
import swaydb.Scheduler;
import swaydb.core.io.file.BufferCleaner;
import swaydb.core.io.file.Cleaner;

public final class BufferCleaner$
implements LazyLogging {
    public static final BufferCleaner$ MODULE$ = new BufferCleaner$();
    private static Option<BufferCleaner> cleaner;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        cleaner = Option$.MODULE$.empty();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Option<BufferCleaner> cleaner() {
        return cleaner;
    }

    public void cleaner_$eq(Option<BufferCleaner> x$1) {
        cleaner = x$1;
    }

    private MethodHandle java9Cleaner() {
        Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
        Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
        theUnsafe.setAccessible(true);
        return MethodHandles.lookup().findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(BoxedUnit.TYPE, ByteBuffer.class)).bindTo(theUnsafe.get(null));
    }

    private MethodHandle java8Cleaner() {
        Class<?> directByteBuffer = Class.forName("java.nio.DirectByteBuffer");
        Method cleanerMethod = directByteBuffer.getDeclaredMethod("cleaner", new Class[0]);
        cleanerMethod.setAccessible(true);
        MethodHandle cleaner = MethodHandles.lookup().unreflect(cleanerMethod);
        Method cleanMethod = Class.forName("sun.misc.Cleaner").getDeclaredMethod("clean", new Class[0]);
        cleanerMethod.setAccessible(true);
        return MethodHandles.foldArguments(MethodHandles.dropArguments(MethodHandles.lookup().unreflect(cleanMethod), 1, new Class[]{directByteBuffer}), cleaner);
    }

    public IO<Error.IO, BufferCleaner.State> initialiseCleaner(BufferCleaner.State state, MappedByteBuffer buffer, Path path) {
        IO.Right right;
        Error.IO$.ExceptionHandler$ apply_evidence$13 = Error.IO$.ExceptionHandler$.MODULE$;
        try {
            right = new IO.Right((Object)BufferCleaner$.$anonfun$initialiseCleaner$1(buffer, state), (IO.ExceptionHandler)apply_evidence$13);
        }
        catch (Throwable apply_ex) {
            right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
        }
        IO.Right right2 = right;
        Object var4_4 = null;
        Object var5_7 = null;
        right = null;
        return right2.orElse((Function0 & Serializable)() -> {
            IO.Right right;
            Error.IO$.ExceptionHandler$ apply_evidence$13 = Error.IO$.ExceptionHandler$.MODULE$;
            try {
                right = new IO.Right((Object)BufferCleaner$.$anonfun$initialiseCleaner$3(buffer, state), (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            return right;
        }, (IO.ExceptionHandler)Error.IO$.ExceptionHandler$.MODULE$).onLeftSideEffect((Function1 & Serializable)error -> {
            String errorMessage = new StringBuilder(64).append("ByteBuffer cleaner not initialised. Failed to clean MMAP file: ").append(((Object)path).toString()).append(".").toString();
            Throwable exception = error.exception();
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(errorMessage, exception);
            }
            throw new Exception(errorMessage, exception);
        });
    }

    public IO<Error.IO, BufferCleaner.State> clean(BufferCleaner.State state, MappedByteBuffer buffer, Path path) {
        IO iO;
        Option<Cleaner> option = state.cleaner();
        if (option instanceof Some) {
            IO.Right right;
            Cleaner cleaner = (Cleaner)((Some)option).value();
            Error.IO$.ExceptionHandler$ apply_evidence$13 = Error.IO$.ExceptionHandler$.MODULE$;
            try {
                cleaner.clean(buffer);
                right = new IO.Right((Object)state, (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            IO.Right right2 = right;
            Object var7_6 = null;
            Object var8_9 = null;
            right = null;
            iO = right2.onLeftSideEffect((Function1 & Serializable)error -> {
                String errorMessage = new StringBuilder(44).append("Failed to clean MappedByteBuffer at path '").append(((Object)path).toString()).append("'.").toString();
                Throwable exception = error.exception();
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error(errorMessage, exception);
                }
                throw new Exception(errorMessage, exception);
            });
        } else if (None$.MODULE$.equals(option)) {
            iO = this.initialiseCleaner(state, buffer, path);
        } else {
            throw new MatchError(option);
        }
        return iO;
    }

    public void initialiseCleaner(Scheduler scheduler) {
        if (this.cleaner().isEmpty()) {
            this.cleaner_$eq((Option<BufferCleaner>)new Some((Object)new BufferCleaner(scheduler)));
        }
    }

    public void clean(MappedByteBuffer buffer, Path path) {
        Option<BufferCleaner> option = this.cleaner();
        if (option instanceof Some) {
            ((BufferCleaner)((Some)option).value()).swaydb$core$io$file$BufferCleaner$$actor().send((Object)new Tuple3((Object)buffer, (Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Cleaner not initialised! ByteBuffer not cleaned.");
                return;
            }
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ BufferCleaner.State $anonfun$initialiseCleaner$1(MappedByteBuffer buffer$1, BufferCleaner.State state$1) {
        MethodHandle cleaner = MODULE$.java9Cleaner();
        cleaner.invoke(buffer$1);
        state$1.cleaner_$eq((Option<Cleaner>)new Some((Object)new Cleaner(cleaner)));
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Initialised Java 9 ByteBuffer cleaner.");
        }
        return state$1;
    }

    public static final /* synthetic */ BufferCleaner.State $anonfun$initialiseCleaner$3(MappedByteBuffer buffer$1, BufferCleaner.State state$1) {
        MethodHandle cleaner = MODULE$.java8Cleaner();
        cleaner.invoke(buffer$1);
        state$1.cleaner_$eq((Option<Cleaner>)new Some((Object)new Cleaner(cleaner)));
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Initialised Java 8 ByteBuffer cleaner.");
        }
        return state$1;
    }

    public static final /* synthetic */ BufferCleaner.State $anonfun$clean$1(Cleaner cleaner$1, MappedByteBuffer buffer$2, BufferCleaner.State state$2) {
        cleaner$1.clean(buffer$2);
        return state$2;
    }

    private BufferCleaner$() {
    }
}

