/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.file;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.collection.Iterable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import swaydb.core.io.file.ChannelFile$;
import swaydb.core.io.file.DBFileType;
import swaydb.core.io.file.Effect$;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;

@ScalaSignature(bytes="\u0006\u0005\u0005erAB\r\u001b\u0011\u0003Q\"E\u0002\u0004%5!\u0005!$\n\u0005\u0006Y\u0005!\tA\f\u0005\u0006_\u0005!\t\u0001\r\u0005\u0007}\u0006!\t!a\r\u0007\u000b\u0011R\u0002A\u0007\u001a\t\u0011\u0001+!Q1A\u0005\u0002\u0005C\u0001bS\u0003\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0019\u0016\u0011\t\u0011)A\u0005\u001b\"A1+\u0002BC\u0002\u0013\u0005A\u000b\u0003\u0005Y\u000b\t\u0005\t\u0015!\u0003V\u0011\u0015aS\u0001\"\u0001Z\u0011\u0015iV\u0001\"\u0001_\u0011\u0015\u0011W\u0001\"\u0001d\u0011\u0015\u0011W\u0001\"\u0001q\u0011\u0015qX\u0001\"\u0001\u0000\u0011\u001d\ty!\u0002C\u0001\u0003#Aq!!\u0006\u0006\t\u0003\t9\u0002\u0003\u0004\u0002\u001a\u0015!\t\u0001\u0016\u0005\b\u00037)A\u0011IA\u000f\u0011\u001d\t)#\u0002C!\u0003;Aq!a\n\u0006\t\u0003\ni\u0002C\u0004\u0002*\u0015!\t%!\b\t\r\u0005-R\u0001\"\u0011_\u0011\u0019\ti#\u0002C!=\u0006Y1\t[1o]\u0016dg)\u001b7f\u0015\tYB$\u0001\u0003gS2,'BA\u000f\u001f\u0003\tIwN\u0003\u0002 A\u0005!1m\u001c:f\u0015\u0005\t\u0013AB:xCf$'\r\u0005\u0002$\u00035\t!DA\u0006DQ\u0006tg.\u001a7GS2,7CA\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001#\u0003\u00159(/\u001b;f)\u0015\t\u0014qFA\u0019!\t\u0019Sa\u0005\u0003\u0006MMj\u0004C\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tA\u0014(\u0001\u0005usB,7/\u00194f\u0015\u0005Q\u0014aA2p[&\u0011A(\u000e\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0005\u0002$}%\u0011qH\u0007\u0002\u000b\t\n3\u0015\u000e\\3UsB,\u0017\u0001\u00029bi\",\u0012A\u0011\t\u0003\u0007&k\u0011\u0001\u0012\u0006\u00037\u0015S!AR$\u0002\u00079LwNC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)#%\u0001\u0002)bi\"\fQ\u0001]1uQ\u0002\nqa\u00195b]:,G\u000e\u0005\u0002O#6\tqJ\u0003\u0002Q\u000b\u0006A1\r[1o]\u0016d7/\u0003\u0002S\u001f\nYa)\u001b7f\u0007\"\fgN\\3m\u0003A\u0011Gn\\2l\u0007\u0006\u001c\u0007.\u001a$jY\u0016LE-F\u0001V!\t9c+\u0003\u0002XQ\t!Aj\u001c8h\u0003E\u0011Gn\\2l\u0007\u0006\u001c\u0007.\u001a$jY\u0016LE\r\t\u000b\u0005ci[F\fC\u0003A\u0017\u0001\u0007!\tC\u0003M\u0017\u0001\u0007Q\nC\u0003T\u0017\u0001\u0007Q+A\u0003dY>\u001cX\rF\u0001`!\t9\u0003-\u0003\u0002bQ\t!QK\\5u\u0003\u0019\t\u0007\u000f]3oIR\u0011q\f\u001a\u0005\u0006K6\u0001\rAZ\u0001\u0006g2L7-\u001a\t\u0004O.lW\"\u00015\u000b\u0005\u0015L'B\u00016!\u0003\u0011!\u0017\r^1\n\u00051D'!B*mS\u000e,\u0007CA\u0014o\u0013\ty\u0007F\u0001\u0003CsR,GCA0r\u0011\u0015)g\u00021\u0001s!\r\u00198P\u001a\b\u0003ift!!\u001e=\u000e\u0003YT!a^\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013B\u0001>)\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001`?\u0003\u0011%#XM]1cY\u0016T!A\u001f\u0015\u0002\tI,\u0017\r\u001a\u000b\u0006M\u0006\u0005\u00111\u0002\u0005\b\u0003\u0007y\u0001\u0019AA\u0003\u0003!\u0001xn]5uS>t\u0007cA\u0014\u0002\b%\u0019\u0011\u0011\u0002\u0015\u0003\u0007%sG\u000fC\u0004\u0002\u000e=\u0001\r!!\u0002\u0002\tML'0Z\u0001\u0004O\u0016$HcA7\u0002\u0014!9\u00111\u0001\tA\u0002\u0005\u0015\u0011a\u0002:fC\u0012\fE\u000e\\\u000b\u0002M\u0006Aa-\u001b7f'&TX-\u0001\u0004jg>\u0003XM\\\u000b\u0003\u0003?\u00012aJA\u0011\u0013\r\t\u0019\u0003\u000b\u0002\b\u0005>|G.Z1o\u00039I7/T3n_JLX*\u00199qK\u0012\f\u0001\"[:M_\u0006$W\rZ\u0001\u0007SN4U\u000f\u001c7\u0002\r\u0011,G.\u001a;f\u0003%1wN]2f'\u00064X\rC\u0003A\u0007\u0001\u0007!\tC\u0003T\u0007\u0001\u0007Q\u000bF\u00032\u0003k\t9\u0004C\u0003A\t\u0001\u0007!\tC\u0003T\t\u0001\u0007Q\u000b")
public class ChannelFile
implements LazyLogging,
DBFileType {
    private final Path path;
    private final FileChannel channel;
    private final long blockCacheFileId;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static ChannelFile write(Path path, long l) {
        return ChannelFile$.MODULE$.write(path, l);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public long blockCacheFileId() {
        return this.blockCacheFileId;
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public void append(Slice<Object> slice) {
        Effect$.MODULE$.writeUnclosed((WritableByteChannel)this.channel, slice);
    }

    @Override
    public void append(Iterable<Slice<Object>> slice) {
        Effect$.MODULE$.writeUnclosed((WritableByteChannel)this.channel, slice);
    }

    @Override
    public Slice<Object> read(int position, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        this.channel.read(buffer, position);
        return SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)buffer.array(), (ClassTag)ClassTag$.MODULE$.Byte());
    }

    @Override
    public byte get(int position) {
        return BoxesRunTime.unboxToByte((Object)this.read(position, 1).head());
    }

    @Override
    public Slice<Object> readAll() {
        byte[] bytes = new byte[(int)this.channel.size()];
        this.channel.read(ByteBuffer.wrap(bytes));
        ManifestFactory.ByteManifest apply_evidence$4 = ClassTag$.MODULE$.Byte();
        return SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)bytes, (ClassTag)apply_evidence$4);
    }

    @Override
    public long fileSize() {
        return this.channel.size();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public boolean isMemoryMapped() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public void delete() {
        this.close();
        Files.delete(this.path());
    }

    @Override
    public void forceSave() {
    }

    public ChannelFile(Path path, FileChannel channel, long blockCacheFileId) {
        this.path = path;
        this.channel = channel;
        this.blockCacheFileId = blockCacheFileId;
        LazyLogging.$init$((LazyLogging)this);
    }
}

