/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.file;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import swaydb.Error;
import swaydb.Exception;
import swaydb.IO;
import swaydb.core.actor.FileSweeper;
import swaydb.core.actor.FileSweeperItem;
import swaydb.core.cache.Cache;
import swaydb.core.cache.Lazy$;
import swaydb.core.cache.LazyIO;
import swaydb.core.cache.ReservedIO;
import swaydb.core.cache.SynchronisedIO;
import swaydb.core.io.file.BlockCache;
import swaydb.core.io.file.ChannelFile;
import swaydb.core.io.file.ChannelFile$;
import swaydb.core.io.file.DBFile;
import swaydb.core.io.file.DBFile$;
import swaydb.core.io.file.DBFileType;
import swaydb.core.io.file.Effect$;
import swaydb.core.io.file.MMAPFile;
import swaydb.core.io.file.MMAPFile$;
import swaydb.data.Reserve$;
import swaydb.data.config.IOStrategy;
import swaydb.data.slice.Slice;

public final class DBFile$
implements LazyLogging {
    public static final DBFile$ MODULE$ = new DBFile$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public Cache<Error.IO, BoxedUnit, DBFileType> fileCache(Path filePath, boolean memoryMapped, IOStrategy ioStrategy, Option<DBFileType> file, long blockCacheFileId, boolean autoClose, FileSweeper fileSweeper) {
        SynchronisedIO<Error.IO, BoxedUnit, DBFileType> cache;
        Object var27_25;
        ReservedIO reservedIO;
        IOStrategy.AsyncIO asyncIO;
        SynchronisedIO synchronisedIO;
        IOStrategy.SynchronisedIO synchronisedIO2;
        Cache cache2;
        void io_evidence$6;
        void io_fetch;
        SynchronisedIO<Error.IO, BoxedUnit, DBFileType> synchronisedIO3;
        IOStrategy.ConcurrentIO concurrentIO;
        ObjectRef self = ObjectRef.create(null);
        FileSweeperItem closer = new FileSweeperItem(filePath, self){
            private final Path filePath$1;
            private final ObjectRef self$1;

            public Path path() {
                return this.filePath$1;
            }

            public void delete() {
                Error.IO$.ExceptionHandler$ failed_evidence$21 = Error.IO$.ExceptionHandler$.MODULE$;
                String failed_exceptionMessage = "only closable";
                Exception failed_toError_exception = new Exception(failed_exceptionMessage);
                Object var3_3 = null;
                new IO.Left((Object)failed_evidence$21.toError((Throwable)failed_toError_exception), (IO.ExceptionHandler)failed_evidence$21);
            }

            public void close() {
                ((Cache)this.self$1.elem).get().foreach((Function1 & Serializable)fileType -> {
                    anon.1.$anonfun$close$1(this, fileType);
                    return BoxedUnit.UNIT;
                });
            }

            public boolean isOpen() {
                return ((Cache)this.self$1.elem).getIO().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$isOpen$1(x$1)));
            }

            public static final /* synthetic */ void $anonfun$close$1(anon.1 $this, DBFileType fileType) {
                fileType.close();
                ((Cache)$this.self$1.elem).clear();
            }

            public static final /* synthetic */ boolean $anonfun$isOpen$2(DBFileType x$2) {
                return x$2.isOpen();
            }

            public static final /* synthetic */ boolean $anonfun$isOpen$1(IO.Right x$1) {
                return ((DBFileType)x$1.value()).isOpen();
            }
            {
                this.filePath$1 = filePath$1;
                this.self$1 = self$1;
            }

            public static final /* synthetic */ Object $anonfun$isOpen$2$adapted(DBFileType x$2) {
                return BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$isOpen$2(x$2));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$close$1$adapted(swaydb.core.io.file.DBFile$$anon$1 swaydb.core.io.file.DBFileType ), $anonfun$isOpen$1$adapted(swaydb.IO$Right )}, serializedLambda);
            }
        };
        Error.IO$.ExceptionHandler$ exceptionHandler$ = Error.IO$.ExceptionHandler$.MODULE$;
        Function2 & Serializable intersect = (Function2 & Serializable)(x$3, x$4) -> {
            IO.Right right;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("{}: Opening closed file.", (Object)filePath);
            }
            Error.IO$.ExceptionHandler$ apply_evidence$13 = Error.IO$.ExceptionHandler$.MODULE$;
            try {
                right = new IO.Right((Object)DBFile$.$anonfun$fileCache$3(memoryMapped, filePath, blockCacheFileId, autoClose, fileSweeper, closer), (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            return right;
        };
        IOStrategy io_strategy = ioStrategy.forceCacheOnAccess();
        if (io_strategy instanceof IOStrategy.ConcurrentIO) {
            concurrentIO = (IOStrategy.ConcurrentIO)io_strategy;
            boolean io_cacheOnAccess = concurrentIO.cacheOnAccess();
            boolean io_concurrentIO_synchronised = false;
            SynchronisedIO<Error.IO, BoxedUnit, DBFileType> synchronisedIO4 = synchronisedIO3 = new SynchronisedIO<Error.IO, BoxedUnit, DBFileType>((Function2<BoxedUnit, Cache<Error.IO, BoxedUnit, DBFileType>, IO<Error.IO, DBFileType>>)io_fetch, Lazy$.MODULE$.io(io_concurrentIO_synchronised, io_cacheOnAccess, file, io_evidence$6), (IO.ExceptionHandler<Error.IO>)io_evidence$6);
            synchronisedIO3 = null;
            cache2 = synchronisedIO4;
        } else if (io_strategy instanceof IOStrategy.SynchronisedIO) {
            synchronisedIO2 = (IOStrategy.SynchronisedIO)io_strategy;
            boolean io_cacheOnAccess = synchronisedIO2.cacheOnAccess();
            boolean io_concurrentIO_synchronised = true;
            SynchronisedIO synchronisedIO5 = synchronisedIO = new SynchronisedIO(io_fetch, Lazy$.MODULE$.io(io_concurrentIO_synchronised, io_cacheOnAccess, file, io_evidence$6), io_evidence$6);
            synchronisedIO = null;
            cache2 = synchronisedIO5;
        } else if (io_strategy instanceof IOStrategy.AsyncIO) {
            asyncIO = (IOStrategy.AsyncIO)io_strategy;
            boolean io_cacheOnAccess = asyncIO.cacheOnAccess();
            Error.OpeningFile io_x$11 = DBFile$.$anonfun$fileCache$1(filePath, memoryMapped);
            LazyIO io_reservedIO_x$6 = Lazy$.MODULE$.io(false, io_cacheOnAccess, file, io_evidence$6);
            ReservedIO reservedIO2 = reservedIO = new ReservedIO(io_fetch, io_reservedIO_x$6, io_x$11, io_evidence$6);
            var27_25 = null;
            reservedIO = null;
            cache2 = reservedIO2;
        } else {
            throw new MatchError((Object)io_strategy);
        }
        SynchronisedIO<Error.IO, BoxedUnit, DBFileType> synchronisedIO6 = cache2;
        Object var12_12 = null;
        intersect = null;
        exceptionHandler$ = null;
        cache2 = null;
        concurrentIO = null;
        synchronisedIO2 = null;
        asyncIO = null;
        Object var22_24 = null;
        synchronisedIO3 = null;
        synchronisedIO = null;
        var27_25 = null;
        reservedIO = null;
        self.elem = cache = synchronisedIO6;
        if (autoClose && file.isDefined()) {
            fileSweeper.close(closer);
        }
        return cache;
    }

    public DBFile channelWrite(Path path, IOStrategy ioStrategy, long blockCacheFileId, boolean autoClose, FileSweeper fileSweeper, Option<BlockCache.State> blockCache) {
        ChannelFile file = ChannelFile$.MODULE$.write(path, blockCacheFileId);
        Some x$3 = new Some((Object)file);
        return new DBFile(path, false, autoClose, blockCacheFileId, this.fileCache(path, false, ioStrategy, (Option<DBFileType>)x$3, blockCacheFileId, autoClose, fileSweeper), blockCache);
    }

    public DBFile channelRead(Path path, IOStrategy ioStrategy, boolean autoClose, long blockCacheFileId, boolean checkExists, FileSweeper fileSweeper, Option<BlockCache.State> blockCache) {
        if (checkExists && Effect$.MODULE$.notExists(path)) {
            throw new Exception.NoSuchFile(path);
        }
        None$ x$3 = None$.MODULE$;
        return new DBFile(path, false, autoClose, blockCacheFileId, this.fileCache(path, false, ioStrategy, (Option<DBFileType>)x$3, blockCacheFileId, autoClose, fileSweeper), blockCache);
    }

    public boolean channelRead$default$5() {
        return true;
    }

    public DBFile mmapWriteAndRead(Path path, IOStrategy ioStrategy, boolean autoClose, long blockCacheFileId, Iterable<Slice<Object>> bytes, FileSweeper fileSweeper, Option<BlockCache.State> blockCache) {
        long x$2 = BoxesRunTime.unboxToInt((Object)bytes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DBFile$.$anonfun$mmapWriteAndRead$1(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        DBFile file = this.mmapInit(path, ioStrategy, x$2, blockCacheFileId, autoClose, fileSweeper, blockCache);
        file.append(bytes);
        return file;
    }

    public DBFile mmapWriteAndRead(Path path, IOStrategy ioStrategy, boolean autoClose, long blockCacheFileId, Slice<Object> bytes, FileSweeper fileSweeper, Option<BlockCache.State> blockCache) {
        if (!bytes.isFull()) {
            throw new Exception.FailedToWriteAllBytes(0, bytes.size(), bytes.size());
        }
        long x$2 = bytes.size();
        DBFile file = this.mmapInit(path, ioStrategy, x$2, blockCacheFileId, autoClose, fileSweeper, blockCache);
        file.append(bytes);
        return file;
    }

    public DBFile mmapRead(Path path, IOStrategy ioStrategy, boolean autoClose, long blockCacheFileId, boolean checkExists, FileSweeper fileSweeper, Option<BlockCache.State> blockCache) {
        if (checkExists && Effect$.MODULE$.notExists(path)) {
            throw new Exception.NoSuchFile(path);
        }
        None$ x$5 = None$.MODULE$;
        return new DBFile(path, true, autoClose, blockCacheFileId, this.fileCache(path, true, ioStrategy, (Option<DBFileType>)x$5, blockCacheFileId, autoClose, fileSweeper), blockCache);
    }

    public boolean mmapRead$default$5() {
        return true;
    }

    public DBFile mmapInit(Path path, IOStrategy ioStrategy, long bufferSize, long blockCacheFileId, boolean autoClose, FileSweeper fileSweeper, Option<BlockCache.State> blockCache) {
        MMAPFile file = MMAPFile$.MODULE$.write(path, bufferSize, blockCacheFileId);
        Some x$3 = new Some((Object)file);
        return new DBFile(path, true, autoClose, blockCacheFileId, this.fileCache(path, true, ioStrategy, (Option<DBFileType>)x$3, blockCacheFileId, autoClose, fileSweeper), blockCache);
    }

    public static final /* synthetic */ Error.OpeningFile $anonfun$fileCache$1(Path filePath$1, boolean memoryMapped$1) {
        return new Error.OpeningFile(filePath$1, Reserve$.MODULE$.free(new StringBuilder(24).append("DBFile: ").append(filePath$1).append(". MemoryMapped: ").append(memoryMapped$1).toString()));
    }

    public static final /* synthetic */ DBFileType $anonfun$fileCache$3(boolean memoryMapped$1, Path filePath$1, long blockCacheFileId$1, boolean autoClose$1, FileSweeper fileSweeper$1, FileSweeperItem closer$1) {
        LazyLogging openResult;
        LazyLogging lazyLogging = openResult = memoryMapped$1 ? MMAPFile$.MODULE$.read(filePath$1, blockCacheFileId$1) : ChannelFile$.MODULE$.read(filePath$1, blockCacheFileId$1);
        if (autoClose$1) {
            fileSweeper$1.close(closer$1);
        }
        return openResult;
    }

    public static final /* synthetic */ int $anonfun$mmapWriteAndRead$1(int x0$1, Slice x1$1) {
        if (!x1$1.isFull()) {
            throw new Exception.FailedToWriteAllBytes(0, x1$1.size(), x1$1.size());
        }
        return x0$1 + x1$1.size();
    }

    private DBFile$() {
    }
}

