/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.file;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.hashing.MurmurHash3$;
import swaydb.Error;
import swaydb.IO;
import swaydb.core.actor.FileSweeper;
import swaydb.core.cache.Cache;
import swaydb.core.io.file.BlockCache;
import swaydb.core.io.file.BlockCache$;
import swaydb.core.io.file.BlockCache$BlockIO$;
import swaydb.core.io.file.DBFile$;
import swaydb.core.io.file.DBFileType;
import swaydb.core.io.file.Effect$;
import swaydb.data.config.IOStrategy;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005u!\u0002\u0017.\u0011\u00031d!\u0002\u001d.\u0011\u0003I\u0004\"\u0002&\u0002\t\u0003Y\u0005\"\u0002'\u0002\t\u0003i\u0005bBA\u0015\u0003\u0011\u0005\u00111\u0006\u0005\b\u0003\u007f\fA\u0011\u0001B\u0001\u0011%\u0011)\"AI\u0001\n\u0003\u00119\u0002C\u0004\u0003.\u0005!\tAa\f\t\u000f\t5\u0012\u0001\"\u0001\u0003D!9!QK\u0001\u0005\u0002\t]\u0003\"\u0003B5\u0003E\u0005I\u0011\u0001B\f\u0011\u001d\u0011Y'\u0001C\u0001\u0005[2Q\u0001O\u0017\u0001\u0003cA!\"a\r\r\u0005\u000b\u0007I\u0011AA\u001b\u0011%\t9\u0004\u0004B\u0001B\u0003%\u0011\u000f\u0003\u0005|\u0019\t\u0005\t\u0015!\u0003}\u0011%\t9\u0003\u0004B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u001e1\u0011)\u0019!C\u0001\u0003sA!\"a\u000f\r\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011!aEB!A!\u0002\u0013y\u0005BCA\u001f\u0019\t\u0005\t\u0015a\u0003\u0002@!1!\n\u0004C\u0001\u0003\u001fBq!a\u0018\r\t\u0003\t\t\u0007C\u0004\u0002d1!\t!!\u001a\t\r9bA\u0011AA8\u0011\u001d\t\t\b\u0004C\u0001\u0003gBq!!\u001e\r\t\u0003\t\u0019\bC\u0004\u0002x1!\t!!\u001f\t\u000f\u0005}D\u0002\"\u0001\u0002\u0002\"9\u0011q\u0010\u0007\u0005\u0002\u0005]\u0005bBAW\u0019\u0011\u0005\u0011q\u0016\u0005\b\u0003ocA\u0011AA]\u0011\u001d\t9\f\u0004C\u0001\u0003\u0003Dq!!3\r\t\u0003\tY\rC\u0004\u0002P2!\t!!5\t\u000f\u0005MG\u0002\"\u0001\u0002:!9\u0011Q\u001b\u0007\u0005\u0002\u0005\u0005\u0004bBAl\u0019\u0011\u0005\u0011\u0011\r\u0005\b\u00033dA\u0011AA1\u0011\u001d\tY\u000e\u0004C\u0001\u0003CBq!!8\r\t\u0003\t\t\u0007C\u0004\u0002`2!\t!a\u001d\t\u000f\u0005\u0005H\u0002\"\u0011\u0002d\"9\u0011q\u001e\u0007\u0005B\u0005E\u0018A\u0002#C\r&dWM\u0003\u0002/_\u0005!a-\u001b7f\u0015\t\u0001\u0014'\u0001\u0002j_*\u0011!gM\u0001\u0005G>\u0014XMC\u00015\u0003\u0019\u0019x/Y=eE\u000e\u0001\u0001CA\u001c\u0002\u001b\u0005i#A\u0002#C\r&dWmE\u0002\u0002u\u0001\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!I\u001b\u0005\u0011%BA\"E\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t)e)\u0001\u0005usB,7/\u00194f\u0015\u00059\u0015aA2p[&\u0011\u0011J\u0011\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002m\u0005Ia-\u001b7f\u0007\u0006\u001c\u0007.\u001a\u000b\u000b\u001d>Tx0a\u0005\u0002\u001c\u0005\u0015BCA(h!\u0015\u00016+V1e\u001b\u0005\t&B\u0001*2\u0003\u0015\u0019\u0017m\u00195f\u0013\t!\u0016KA\u0003DC\u000eDW\r\u0005\u0002W=:\u0011q\u000b\u0018\b\u00031nk\u0011!\u0017\u0006\u00035V\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0005u\u001b\u0014!B#se>\u0014\u0018BA0a\u0005\tIuJ\u0003\u0002^gA\u00111HY\u0005\u0003Gr\u0012A!\u00168jiB\u0011q'Z\u0005\u0003M6\u0012!\u0002\u0012\"GS2,G+\u001f9f\u0011\u0015A7\u0001q\u0001j\u0003-1\u0017\u000e\\3To\u0016,\u0007/\u001a:\u0011\u0005)lW\"A6\u000b\u00051\f\u0014!B1di>\u0014\u0018B\u00018l\u0005-1\u0015\u000e\\3To\u0016,\u0007/\u001a:\t\u000bA\u001c\u0001\u0019A9\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"A\u001d=\u000e\u0003MT!A\f;\u000b\u0005U4\u0018a\u00018j_*\tq/\u0001\u0003kCZ\f\u0017BA=t\u0005\u0011\u0001\u0016\r\u001e5\t\u000bm\u001c\u0001\u0019\u0001?\u0002\u00195,Wn\u001c:z\u001b\u0006\u0004\b/\u001a3\u0011\u0005mj\u0018B\u0001@=\u0005\u001d\u0011un\u001c7fC:Dq!!\u0001\u0004\u0001\u0004\t\u0019!\u0001\u0006j_N#(/\u0019;fOf\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004d_:4\u0017n\u001a\u0006\u0004\u0003\u001b\u0019\u0014\u0001\u00023bi\u0006LA!!\u0005\u0002\b\tQ\u0011jT*ue\u0006$XmZ=\t\r9\u001a\u0001\u0019AA\u000b!\u0011Y\u0014q\u00033\n\u0007\u0005eAH\u0001\u0004PaRLwN\u001c\u0005\b\u0003;\u0019\u0001\u0019AA\u0010\u0003A\u0011Gn\\2l\u0007\u0006\u001c\u0007.\u001a$jY\u0016LE\rE\u0002<\u0003CI1!a\t=\u0005\u0011auN\\4\t\r\u0005\u001d2\u00011\u0001}\u0003%\tW\u000f^8DY>\u001cX-\u0001\u0007dQ\u0006tg.\u001a7Xe&$X\r\u0006\u0006\u0002.\u0005]\u0018\u0011`A~\u0003{$b!a\f\u0002t\u0006U\bCA\u001c\r'\ra!\bQ\u0001\u0005a\u0006$\b.F\u0001r\u0003\u0015\u0001\u0018\r\u001e5!+\t\ty\"A\tcY>\u001c7nQ1dQ\u00164\u0015\u000e\\3JI\u0002\n!B\u00197pG.\u001c\u0015m\u00195f!\u0015Y\u0014qCA!!\u0011\t\u0019%!\u0013\u000f\u0007]\n)%C\u0002\u0002H5\n!B\u00117pG.\u001c\u0015m\u00195f\u0013\u0011\tY%!\u0014\u0003\u000bM#\u0018\r^3\u000b\u0007\u0005\u001dS\u0006\u0006\u0007\u0002R\u0005U\u0013qKA-\u00037\ni\u0006\u0006\u0003\u00020\u0005M\u0003bBA\u001f+\u0001\u000f\u0011q\b\u0005\u0007\u0003g)\u0002\u0019A9\t\u000bm,\u0002\u0019\u0001?\t\r\u0005\u001dR\u00031\u0001}\u0011\u001d\ti\"\u0006a\u0001\u0003?AQ\u0001T\u000bA\u0002=\u000bA\"\u001a=jgR\u001cxJ\u001c#jg.,\u0012\u0001`\u0001\nE2|7m[*ju\u0016,\"!a\u001a\u0011\u000bm\n9\"!\u001b\u0011\u0007m\nY'C\u0002\u0002nq\u00121!\u00138u+\u0005!\u0017A\u00023fY\u0016$X\rF\u0001b\u0003\u0015\u0019Gn\\:f\u0003\u0019\u0019w\u000e]=U_R\u0019\u0011/a\u001f\t\r\u0005u4\u00041\u0001r\u0003\u0019!x\u000eU1uQ\u00061\u0011\r\u001d9f]\u0012$2!YAB\u0011\u001d\t)\t\ba\u0001\u0003\u000f\u000bQa\u001d7jG\u0016\u0004b!!#\u0002\u000e\u0006EUBAAF\u0015\u0011\t))a\u0003\n\t\u0005=\u00151\u0012\u0002\u0006'2L7-\u001a\t\u0004w\u0005M\u0015bAAKy\t!!)\u001f;f)\r\t\u0017\u0011\u0014\u0005\b\u0003\u000bk\u0002\u0019AAN!\u0019\ti*a*\u0002\b:!\u0011qTAR\u001d\rA\u0016\u0011U\u0005\u0002{%\u0019\u0011Q\u0015\u001f\u0002\u000fA\f7m[1hK&!\u0011\u0011VAV\u0005!IE/\u001a:bE2,'bAASy\u0005I!/Z1e\u00052|7m\u001b\u000b\u0005\u0003c\u000b\u0019\fE\u0003<\u0003/\t9\tC\u0004\u00026z\u0001\r!!\u001b\u0002\u0011A|7/\u001b;j_:\fAA]3bIR1\u0011qQA^\u0003{Cq!!. \u0001\u0004\tI\u0007C\u0004\u0002@~\u0001\r!!\u001b\u0002\tML'0\u001a\u000b\t\u0003\u000f\u000b\u0019-!2\u0002H\"9\u0011Q\u0017\u0011A\u0002\u0005%\u0004bBA`A\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003{\u0001\u0003\u0019AA!\u0003\r9W\r\u001e\u000b\u0005\u0003#\u000bi\rC\u0004\u00026\u0006\u0002\r!!\u001b\u0002\u000fI,\u0017\rZ!mYV\u0011\u0011qQ\u0001\tM&dWmU5{K\u00061\u0011n](qK:\fQ\"[:GS2,G)\u001a4j]\u0016$\u0017AD5t\u001b\u0016lwN]=NCB\u0004X\rZ\u0001\tSNdu.\u00193fI\u00061\u0011n\u001d$vY2\f\u0011BZ8sG\u0016\u001c\u0016M^3\u0002\r\u0015\fX/\u00197t)\ra\u0018Q\u001d\u0005\b\u0003OT\u0003\u0019AAu\u0003\u0011!\b.\u0019;\u0011\u0007m\nY/C\u0002\u0002nr\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,GCAA5\u0011\u0015AG\u0001q\u0001j\u0011\u001d\ti\u0004\u0002a\u0002\u0003\u007fAa!a\r\u0005\u0001\u0004\t\bbBA\u0001\t\u0001\u0007\u00111\u0001\u0005\b\u0003;!\u0001\u0019AA\u0010\u0011\u0019\t9\u0003\u0002a\u0001y\u0006Y1\r[1o]\u0016d'+Z1e)1\u0011\u0019A!\u0003\u0003\f\t5!q\u0002B\t)\u0019\tyC!\u0002\u0003\b!)\u0001.\u0002a\u0002S\"9\u0011QH\u0003A\u0004\u0005}\u0002BBA\u001a\u000b\u0001\u0007\u0011\u000fC\u0004\u0002\u0002\u0015\u0001\r!a\u0001\t\r\u0005\u001dR\u00011\u0001}\u0011\u001d\ti\"\u0002a\u0001\u0003?A\u0001Ba\u0005\u0006!\u0003\u0005\r\u0001`\u0001\fG\",7m[#ySN$8/A\u000bdQ\u0006tg.\u001a7SK\u0006$G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\te!f\u0001?\u0003\u001c-\u0012!Q\u0004\t\u0005\u0005?\u0011I#\u0004\u0002\u0003\")!!1\u0005B\u0013\u0003%)hn\u00195fG.,GMC\u0002\u0003(q\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YC!\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\tn[\u0006\u0004xK]5uK\u0006sGMU3bIRa!\u0011\u0007B\u001c\u0005s\u0011YD!\u0010\u0003@Q1\u0011q\u0006B\u001a\u0005kAQ\u0001[\u0004A\u0004%Dq!!\u0010\b\u0001\b\ty\u0004\u0003\u0004\u00024\u001d\u0001\r!\u001d\u0005\b\u0003\u00039\u0001\u0019AA\u0002\u0011\u0019\t9c\u0002a\u0001y\"9\u0011QD\u0004A\u0002\u0005}\u0001b\u0002B!\u000f\u0001\u0007\u00111T\u0001\u0006Ef$Xm\u001d\u000b\r\u0005\u000b\u0012YE!\u0014\u0003P\tE#1\u000b\u000b\u0007\u0003_\u00119E!\u0013\t\u000b!D\u00019A5\t\u000f\u0005u\u0002\u0002q\u0001\u0002@!1\u00111\u0007\u0005A\u0002EDq!!\u0001\t\u0001\u0004\t\u0019\u0001\u0003\u0004\u0002(!\u0001\r\u0001 \u0005\b\u0003;A\u0001\u0019AA\u0010\u0011\u001d\u0011\t\u0005\u0003a\u0001\u0003\u000f\u000b\u0001\"\\7baJ+\u0017\r\u001a\u000b\r\u00053\u0012yF!\u0019\u0003d\t\u0015$q\r\u000b\u0007\u0003_\u0011YF!\u0018\t\u000b!L\u00019A5\t\u000f\u0005u\u0012\u0002q\u0001\u0002@!1\u00111G\u0005A\u0002EDq!!\u0001\n\u0001\u0004\t\u0019\u0001\u0003\u0004\u0002(%\u0001\r\u0001 \u0005\b\u0003;I\u0001\u0019AA\u0010\u0011!\u0011\u0019\"\u0003I\u0001\u0002\u0004a\u0018AE7nCB\u0014V-\u00193%I\u00164\u0017-\u001e7uIU\n\u0001\"\\7ba&s\u0017\u000e\u001e\u000b\r\u0005_\u0012)Ha\u001e\u0003z\tu$q\u0010\u000b\u0007\u0003_\u0011\tHa\u001d\t\u000b!\\\u00019A5\t\u000f\u0005u2\u0002q\u0001\u0002@!1\u00111G\u0006A\u0002EDq!!\u0001\f\u0001\u0004\t\u0019\u0001C\u0004\u0003|-\u0001\r!a\b\u0002\u0015\t,hMZ3s'&TX\rC\u0004\u0002\u001e-\u0001\r!a\b\t\r\u0005\u001d2\u00021\u0001}\u0001")
public class DBFile
implements LazyLogging {
    private final Path path;
    private final long blockCacheFileId;
    private final Cache<Error.IO, BoxedUnit, DBFileType> fileCache;
    private final Option<BlockCache.State> blockCache;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static DBFile mmapInit(Path path, IOStrategy iOStrategy, long l, long l2, boolean bl, FileSweeper fileSweeper, Option<BlockCache.State> option) {
        return DBFile$.MODULE$.mmapInit(path, iOStrategy, l, l2, bl, fileSweeper, option);
    }

    public static boolean mmapRead$default$5() {
        return true;
    }

    public static DBFile mmapRead(Path path, IOStrategy iOStrategy, boolean bl, long l, boolean bl2, FileSweeper fileSweeper, Option<BlockCache.State> option) {
        return DBFile$.MODULE$.mmapRead(path, iOStrategy, bl, l, bl2, fileSweeper, option);
    }

    public static DBFile mmapWriteAndRead(Path path, IOStrategy iOStrategy, boolean bl, long l, Slice<Object> slice, FileSweeper fileSweeper, Option<BlockCache.State> option) {
        return DBFile$.MODULE$.mmapWriteAndRead(path, iOStrategy, bl, l, slice, fileSweeper, option);
    }

    public static DBFile mmapWriteAndRead(Path path, IOStrategy iOStrategy, boolean bl, long l, Iterable<Slice<Object>> iterable, FileSweeper fileSweeper, Option<BlockCache.State> option) {
        return DBFile$.MODULE$.mmapWriteAndRead(path, iOStrategy, bl, l, iterable, fileSweeper, option);
    }

    public static boolean channelRead$default$5() {
        return true;
    }

    public static DBFile channelRead(Path path, IOStrategy iOStrategy, boolean bl, long l, boolean bl2, FileSweeper fileSweeper, Option<BlockCache.State> option) {
        return DBFile$.MODULE$.channelRead(path, iOStrategy, bl, l, bl2, fileSweeper, option);
    }

    public static DBFile channelWrite(Path path, IOStrategy iOStrategy, long l, boolean bl, FileSweeper fileSweeper, Option<BlockCache.State> option) {
        return DBFile$.MODULE$.channelWrite(path, iOStrategy, l, bl, fileSweeper, option);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Path path() {
        return this.path;
    }

    public long blockCacheFileId() {
        return this.blockCacheFileId;
    }

    public boolean existsOnDisk() {
        return Files.exists(this.path(), new LinkOption[0]);
    }

    public Option<Object> blockSize() {
        return this.blockCache.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.blockSize()));
    }

    public DBFileType file() {
        return (DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get();
    }

    public void delete() {
        this.close();
        this.fileCache.get().map((Function1 & Serializable)x$6 -> {
            x$6.delete();
            return BoxedUnit.UNIT;
        }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> Effect$.MODULE$.deleteIfExists(this.path()));
        this.fileCache.clear();
    }

    public void close() {
        this.fileCache.get().foreach((Function1 & Serializable)file -> {
            DBFile.$anonfun$close$2(this, file);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Path copyTo(Path toPath) {
        void var2_4;
        Path path;
        this.forceSave();
        Path copy_copyFrom = this.path();
        Path path2 = path = Files.copy(copy_copyFrom, toPath, new CopyOption[0]);
        Object var3_2 = null;
        path = null;
        Path copiedPath = path2;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("{}: Copied: to {}", (Object[])new Path[]{copiedPath, toPath});
        }
        return var2_4;
    }

    public void append(Slice<Object> slice) {
        ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).append(slice);
    }

    public void append(Iterable<Slice<Object>> slice) {
        ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).append(slice);
    }

    public Option<Slice<Object>> readBlock(int position) {
        return this.blockCache.map((Function1 & Serializable)blockCache -> this.read(position, blockCache.blockSize(), (BlockCache.State)blockCache));
    }

    public Slice<Object> read(int position, int size) {
        Slice<Object> slice;
        if (size == 0) {
            return Slice$.MODULE$.emptyBytes();
        }
        Option<BlockCache.State> option = this.blockCache;
        if (option instanceof Some) {
            BlockCache.State blockCache = (BlockCache.State)((Some)option).value();
            slice = this.read(position, size, blockCache);
        } else if (None$.MODULE$.equals(option)) {
            slice = ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).read(position, size);
        } else {
            throw new MatchError(option);
        }
        return slice;
    }

    public Slice<Object> read(int position, int size, BlockCache.State blockCache) {
        if (size == 0) {
            return Slice$.MODULE$.emptyBytes();
        }
        return BlockCache$.MODULE$.getOrSeek(position, size, (DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get(), blockCache, BlockCache$BlockIO$.MODULE$);
    }

    public byte get(int position) {
        if (this.blockCache.isDefined()) {
            return BoxesRunTime.unboxToByte((Object)this.read(position, 1).head());
        }
        return ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).get(position);
    }

    public Slice<Object> readAll() {
        return ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).readAll();
    }

    public long fileSize() {
        return ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).fileSize();
    }

    public boolean isOpen() {
        return this.fileCache.getIO().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DBFile.$anonfun$isOpen$3(x$7)));
    }

    public boolean isFileDefined() {
        return this.fileCache.getIO().isDefined();
    }

    public boolean isMemoryMapped() {
        return ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).isMemoryMapped();
    }

    public boolean isLoaded() {
        return ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).isLoaded();
    }

    public boolean isFull() {
        return ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).isFull();
    }

    public void forceSave() {
        ((DBFileType)this.fileCache.value((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}).get()).forceSave();
    }

    public boolean equals(Object that) {
        boolean bl;
        if (that instanceof DBFile) {
            DBFile dBFile = (DBFile)that;
            Path path = this.path();
            Path path2 = dBFile.path();
            bl = !(path != null ? !((Object)path).equals(path2) : path2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.stringHash(((Object)this.path()).toString());
    }

    public static final /* synthetic */ void $anonfun$close$2(DBFile $this, DBFileType file) {
        file.close();
        $this.fileCache.clear();
    }

    public static final /* synthetic */ boolean $anonfun$isOpen$3(IO.Right x$7) {
        return ((DBFileType)x$7.value()).isOpen();
    }

    public DBFile(Path path, boolean memoryMapped, boolean autoClose, long blockCacheFileId, Cache<Error.IO, BoxedUnit, DBFileType> fileCache, Option<BlockCache.State> blockCache) {
        this.path = path;
        this.blockCacheFileId = blockCacheFileId;
        this.fileCache = fileCache;
        this.blockCache = blockCache;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static final /* synthetic */ Object $anonfun$isOpen$4$adapted(DBFileType x$8) {
        return BoxesRunTime.boxToBoolean((boolean)x$8.isOpen());
    }
}

