/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.file;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import swaydb.Exception;
import swaydb.core.io.file.Effect;
import swaydb.core.util.Extension;
import swaydb.core.util.Extension$Log$;
import swaydb.core.util.Extension$Seg$;
import swaydb.core.util.PipeOps;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;

public final class Effect$
implements LazyLogging {
    public static final Effect$ MODULE$ = new Effect$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Effect.PathExtensionImplicits PathExtensionImplicits(Path path) {
        return new Effect.PathExtensionImplicits(path);
    }

    public Path write(Path to, Slice<Object> bytes) {
        Path path;
        try (SeekableByteChannel channel = Files.newByteChannel(to, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            this.writeUnclosed((WritableByteChannel)channel, bytes);
            path = to;
        }
        return path;
    }

    public Path write(Path to, Iterable<Slice<Object>> bytes) {
        Path path;
        try (SeekableByteChannel channel = Files.newByteChannel(to, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            this.writeUnclosed((WritableByteChannel)channel, bytes);
            path = to;
        }
        return path;
    }

    public Path replace(Slice<Object> bytes, Path to) {
        Path path;
        try (SeekableByteChannel channel = Files.newByteChannel(to, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            this.writeUnclosed((WritableByteChannel)channel, bytes);
            path = to;
        }
        return path;
    }

    public void writeUnclosed(WritableByteChannel channel, Iterable<Slice<Object>> bytes2) {
        bytes2.foreach((Function1 & Serializable)bytes -> {
            Effect$.MODULE$.writeUnclosed(channel, (Slice<Object>)bytes);
            return BoxedUnit.UNIT;
        });
    }

    public void writeUnclosed(WritableByteChannel channel, Slice<Object> bytes) {
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, bytes);
        if (byteSliceImplicits == null) {
            throw null;
        }
        int written = channel.write(byteSliceImplicits.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice.toByteBufferWrap());
        if (written != bytes.size()) {
            throw new Exception.FailedToWriteAllBytes(written, bytes.size(), bytes.size());
        }
    }

    public Path copy(Path copyFrom, Path copyTo) {
        return Files.copy(copyFrom, copyTo, new CopyOption[0]);
    }

    public void delete(Path path) {
        Files.delete(path);
    }

    public void deleteIfExists(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
            return;
        }
    }

    public Path createFile(Path path) {
        return Files.createFile(path, new FileAttribute[0]);
    }

    public Path createFileIfAbsent(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return Files.createFile(path, new FileAttribute[0]);
    }

    public boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public boolean notExists(Path path) {
        return !Files.exists(path, new LinkOption[0]);
    }

    public Path createDirectoryIfAbsent(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return Files.createDirectory(path, new FileAttribute[0]);
    }

    public Path createDirectoriesIfAbsent(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return Files.createDirectories(path, new FileAttribute[0]);
    }

    public void walkDelete(Path folder) {
        if (Files.exists(folder, new LinkOption[0])) {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public void release(FileLock lock) {
        lock.release();
        lock.close();
    }

    public <T> T stream(Path path, Function1<DirectoryStream<Path>, T> f) {
        Object object;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            object = f.apply(stream);
        }
        return (T)object;
    }

    public void release(Option<FileLock> lock2) {
        lock2.foreach((Function1 & Serializable)lock -> {
            Effect$.MODULE$.release(lock);
            return BoxedUnit.UNIT;
        });
    }

    public Effect.FileIdImplicits FileIdImplicits(long id) {
        return new Effect.FileIdImplicits(id);
    }

    /*
     * WARNING - void declaration
     */
    public Path incrementFileId(Path path) {
        void var5_4;
        void var3_3;
        Tuple2<Object, Extension> tuple2 = this.fileId(path);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long id = tuple2._1$mcJ$sp();
        Extension ext = (Extension)tuple2._2();
        return path.getParent().resolve(new StringBuilder(1).append((long)(var3_3 + 1L)).append(".").append(var5_4.toString()).toString());
    }

    public Path incrementFolderId(Path path) {
        Long pipe_a = BoxesRunTime.boxToLong((long)this.folderId(path));
        Object var2_2 = null;
        Object a = new PipeOps.Pipe<Long>(pipe_a).swaydb$core$util$PipeOps$Pipe$$a;
        return Effect$.$anonfun$incrementFolderId$1(path, BoxesRunTime.unboxToLong(a));
    }

    public long folderId(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((Object)path.getFileName()).toString()));
    }

    public Extension fileExtension(Path path) {
        return (Extension)this.fileId(path)._2();
    }

    public Tuple2<Object, Extension> fileId(Path path) {
        String string;
        String string2;
        String ext;
        long l;
        String fileName = ((Object)path.getFileName()).toString();
        int extensionIndex = fileName.lastIndexOf(".");
        int extIndex = extensionIndex <= 0 ? fileName.length() : extensionIndex;
        try {
            l = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(fileName.substring(0, extIndex)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception.NotAnIntFile(path);
        }
        long fileId = l;
        String string3 = ext = fileName.substring(extIndex + 1, fileName.length());
        String string4 = string2 = "log";
        string2 = null;
        String string5 = string4;
        if (string3 != null && string3.equals(string5)) {
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)fileId), (Object)Extension$Log$.MODULE$);
        }
        String string6 = ext;
        String string7 = string = "seg";
        string = null;
        String string8 = string7;
        if (string6 != null && string6.equals(string8)) {
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)fileId), (Object)Extension$Seg$.MODULE$);
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Unknown extension for file {}", (Object)path);
        }
        throw new Exception.UnknownExtension(path);
    }

    public boolean isExtension(Path path, Extension ext) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.fileId(path)).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Effect$.$anonfun$isExtension$2(ext, x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public List<Path> files(Path folder, Extension extension) {
        List list;
        try (DirectoryStream<Path> stream_stream = Files.newDirectoryStream(folder);){
            list = Effect$.$anonfun$files$1(extension, stream_stream);
        }
        return list;
    }

    public List<Path> folders(Path folder) {
        List list;
        try (DirectoryStream<Path> stream_stream = Files.newDirectoryStream(folder);){
            list = Effect$.$anonfun$folders$1(stream_stream);
        }
        return list;
    }

    public Seq<Path> segmentFilesOnDisk(Seq<Path> paths) {
        return (Seq)((SeqOps)paths.flatMap((Function1 & Serializable)x$6 -> new Effect.PathExtensionImplicits((Path)x$6).files(Extension$Seg$.MODULE$))).sortBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)Effect$.$anonfun$segmentFilesOnDisk$2(x$7)), (Ordering)Ordering.Long$.MODULE$);
    }

    public Slice<Object> readAll(Path path) {
        return SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)Files.readAllBytes(path), (ClassTag)ClassTag$.MODULE$.Byte());
    }

    public long size(Path path) {
        return Files.size(path);
    }

    public static final /* synthetic */ Path $anonfun$incrementFolderId$1(Path path$1, long currentFolderId) {
        return path$1.getParent().resolve(((Object)BoxesRunTime.boxToLong((long)(currentFolderId + 1L))).toString());
    }

    public static final /* synthetic */ boolean $anonfun$isExtension$2(Extension ext$1, Tuple2 x$2) {
        Object object = x$2._2();
        return !(object != null ? !object.equals(ext$1) : ext$1 != null);
    }

    public static final /* synthetic */ long $anonfun$files$3(Path path) {
        return MODULE$.fileId(path)._1$mcJ$sp();
    }

    public static final /* synthetic */ List $anonfun$files$1(Extension extension$1, DirectoryStream x$3) {
        return (List)CollectionConverters$.MODULE$.IteratorHasAsScala(x$3.iterator()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Effect$.MODULE$.isExtension(x$4, extension$1))).toList().sortBy((Function1 & Serializable)path -> BoxesRunTime.boxToLong((long)Effect$.$anonfun$files$3(path)), (Ordering)Ordering.Long$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$folders$2(Path folder) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.folderId(folder)).isSuccess();
    }

    public static final /* synthetic */ List $anonfun$folders$1(DirectoryStream x$5) {
        return (List)CollectionConverters$.MODULE$.IteratorHasAsScala(x$5.iterator()).asScala().filter((Function1 & Serializable)folder -> BoxesRunTime.boxToBoolean((boolean)Effect$.$anonfun$folders$2(folder))).toList().sortBy((Function1 & Serializable)path -> BoxesRunTime.boxToLong((long)Effect$.MODULE$.folderId(path)), (Ordering)Ordering.Long$.MODULE$);
    }

    public static final /* synthetic */ long $anonfun$segmentFilesOnDisk$2(Path x$7) {
        Path PathExtensionImplicits_path = x$7.getFileName();
        Object var1_1 = null;
        return new Effect.PathExtensionImplicits(PathExtensionImplicits_path).fileId()._1$mcJ$sp();
    }

    private Effect$() {
    }

    public static final /* synthetic */ Path $anonfun$incrementFolderId$1$adapted(Path path$1, Object currentFolderId) {
        return Effect$.$anonfun$incrementFolderId$1(path$1, BoxesRunTime.unboxToLong((Object)currentFolderId));
    }
}

