/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.file;

import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import swaydb.core.io.file.MMAPFile;

public final class MMAPFile$ {
    public static final MMAPFile$ MODULE$ = new MMAPFile$();

    public MMAPFile write(Path path, long bufferSize, long blockCacheFileId) {
        return this.apply(path, FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), FileChannel.MapMode.READ_WRITE, bufferSize, blockCacheFileId);
    }

    public MMAPFile read(Path path, long blockCacheFileId) {
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
        return this.apply(path, FileChannel.open(path, StandardOpenOption.READ), FileChannel.MapMode.READ_ONLY, channel.size(), blockCacheFileId);
    }

    private MMAPFile apply(Path path, FileChannel channel, FileChannel.MapMode mode, long bufferSize, long blockCacheFileId) {
        MappedByteBuffer buff = channel.map(mode, 0L, bufferSize);
        return new MMAPFile(path, channel, mode, bufferSize, blockCacheFileId, buff);
    }

    private MMAPFile$() {
    }
}

