/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.file;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import swaydb.Exception;
import swaydb.IO$;
import swaydb.core.io.file.BufferCleaner$;
import swaydb.core.io.file.DBFileType;
import swaydb.core.io.file.MMAPFile$;
import swaydb.data.Reserve$;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;

@ScalaSignature(bytes="\u0006\u0005\u0005mxA\u0002\u0013&\u0011\u0003)SF\u0002\u00040K!\u0005Q\u0005\r\u0005\u0006o\u0005!\t!\u000f\u0005\u0006u\u0005!\ta\u000f\u0005\b\u0003_\u000bA\u0011AAt\u0011\u001d\ti/\u0001C\u0005\u0003_4QaL\u0013\u0001KuB\u0001b\u0013\u0004\u0003\u0006\u0004%\t\u0001\u0014\u0005\t-\u001a\u0011\t\u0011)A\u0005\u001b\"AqK\u0002B\u0001B\u0003%\u0001\f\u0003\u0005_\r\t\u0005\t\u0015!\u0003`\u0011!ygA!A!\u0002\u0013\u0001\b\u0002C:\u0007\u0005\u000b\u0007I\u0011\u0001;\t\u0011U4!\u0011!Q\u0001\nAD\u0001B\u001e\u0004\u0003\u0002\u0004%Ia\u001e\u0005\ty\u001a\u0011\t\u0019!C\u0005{\"I\u0011q\u0001\u0004\u0003\u0002\u0003\u0006K\u0001\u001f\u0005\u0007o\u0019!\t!!\u0005\t\u0013\u0005}aA1A\u0005\n\u0005\u0005\u0002\u0002CA\u001c\r\u0001\u0006I!a\t\t\u000f\u0005eb\u0001\"\u0004\u0002<!9\u0011q\r\u0004\u0005\u0002\u0005%\u0004bBA6\r\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003[2A\u0011BA5\u0011\u001d\tyG\u0002C!\u0003cBq!a\u001c\u0007\t\u000b\ti\nC\u0004\u00020\u001a!\t!!-\t\u000f\u0005\u0005g\u0001\"\u0001\u0002D\"1\u0011q\u0019\u0004\u0005BQDq!!3\u0007\t\u0003\nY\rC\u0004\u0002N\u001a!\t%a4\t\u000f\u0005]g\u0001\"\u0011\u0002P\"9\u0011\u0011\u001c\u0004\u0005B\u0005=\u0007bBAn\r\u0011\u0005\u0013q\u001a\u0005\b\u0003;4A\u0011IA5\u0011\u001d\tyN\u0002C\u0001\u0003\u001f\f\u0001\"T'B!\u001aKG.\u001a\u0006\u0003M\u001d\nAAZ5mK*\u0011\u0001&K\u0001\u0003S>T!AK\u0016\u0002\t\r|'/\u001a\u0006\u0002Y\u000511o^1zI\n\u0004\"AL\u0001\u000e\u0003\u0015\u0012\u0001\"T'B!\u001aKG.Z\n\u0003\u0003E\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u00035\nQa\u001e:ji\u0016$r\u0001PAq\u0003G\f)\u000f\u0005\u0002/\rM!a!\r I!\tyd)D\u0001A\u0015\t\t%)\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002D\t\u0006AA/\u001f9fg\u00064WMC\u0001F\u0003\r\u0019w.\\\u0005\u0003\u000f\u0002\u00131\u0002T1{s2{wmZ5oOB\u0011a&S\u0005\u0003\u0015\u0016\u0012!\u0002\u0012\"GS2,G+\u001f9f\u0003\u0011\u0001\u0018\r\u001e5\u0016\u00035\u0003\"A\u0014+\u000e\u0003=S!A\n)\u000b\u0005E\u0013\u0016a\u00018j_*\t1+\u0001\u0003kCZ\f\u0017BA+P\u0005\u0011\u0001\u0016\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u000f\rD\u0017M\u001c8fYB\u0011\u0011\fX\u0007\u00025*\u00111\fU\u0001\tG\"\fgN\\3mg&\u0011QL\u0017\u0002\f\r&dWm\u00115b]:,G.\u0001\u0003n_\u0012,\u0007C\u00011m\u001d\t\t'N\u0004\u0002cS:\u00111\r\u001b\b\u0003I\u001el\u0011!\u001a\u0006\u0003Mb\na\u0001\u0010:p_Rt\u0014\"A*\n\u0005E\u0013\u0016BA.Q\u0013\tY',A\u0006GS2,7\t[1o]\u0016d\u0017BA7o\u0005\u001di\u0015\r]'pI\u0016T!a\u001b.\u0002\u0015\t,hMZ3s'&TX\r\u0005\u00023c&\u0011!o\r\u0002\u0005\u0019>tw-\u0001\tcY>\u001c7nQ1dQ\u00164\u0015\u000e\\3JIV\t\u0001/A\tcY>\u001c7nQ1dQ\u00164\u0015\u000e\\3JI\u0002\naAY;gM\u0016\u0014X#\u0001=\u0011\u0005eTX\"\u0001)\n\u0005m\u0004&\u0001E'baB,GMQ=uK\n+hMZ3s\u0003)\u0011WO\u001a4fe~#S-\u001d\u000b\u0004}\u0006\r\u0001C\u0001\u001a\u0000\u0013\r\t\ta\r\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0006=\t\t\u00111\u0001y\u0003\rAH%M\u0001\bEV4g-\u001a:!Q\r\u0001\u00121\u0002\t\u0004e\u00055\u0011bAA\bg\tAao\u001c7bi&dW\rF\u0007=\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011Q\u0004\u0005\u0006\u0017F\u0001\r!\u0014\u0005\u0006/F\u0001\r\u0001\u0017\u0005\u0006=F\u0001\ra\u0018\u0005\u0006_F\u0001\r\u0001\u001d\u0005\u0006gF\u0001\r\u0001\u001d\u0005\u0006mF\u0001\r\u0001_\u0001\u0005_B,g.\u0006\u0002\u0002$A!\u0011QEA\u001a\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012AB1u_6L7M\u0003\u0003\u0002.\u0005=\u0012AC2p]\u000e,(O]3oi*\u0019\u0011\u0011\u0007*\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003k\t9CA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0006_B,g\u000eI\u0001\u0011o\u0006$8\r\u001b(vY2\u0004v.\u001b8uKJ,B!!\u0010\u0002DQ!\u0011qHA+!\u0011\t\t%a\u0011\r\u0001\u00119\u0011Q\t\u000bC\u0002\u0005\u001d#!\u0001+\u0012\t\u0005%\u0013q\n\t\u0004e\u0005-\u0013bAA'g\t9aj\u001c;iS:<\u0007c\u0001\u001a\u0002R%\u0019\u00111K\u001a\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002XQ!\t\u0019AA-\u0003\u00051\u0007#\u0002\u001a\u0002\\\u0005}\u0012bAA/g\tAAHY=oC6,g\bK\u0002\u0015\u0003C\u00022AMA2\u0013\r\t)g\r\u0002\u0007S:d\u0017N\\3\u0002\u000b\rdwn]3\u0015\u0003y\f\u0011BZ8sG\u0016\u001c\u0016M^3\u0002\u0017\rdW-\u0019:Ck\u001a4WM]\u0001\u0007CB\u0004XM\u001c3\u0015\u0007y\f\u0019\bC\u0004\u0002va\u0001\r!a\u001e\u0002\u000bMd\u0017nY3\u0011\r\u0005e\u00141QAE\u001d\u0011\tY(a \u000f\u0007\u0011\fi(C\u00015\u0013\r\t\tiM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t))a\"\u0003\u0011%#XM]1cY\u0016T1!!!4!\u0019\tY)a%\u0002\u00186\u0011\u0011Q\u0012\u0006\u0005\u0003k\nyIC\u0002\u0002\u0012.\nA\u0001Z1uC&!\u0011QSAG\u0005\u0015\u0019F.[2f!\r\u0011\u0014\u0011T\u0005\u0004\u00037\u001b$\u0001\u0002\"zi\u0016$2A`AP\u0011\u001d\t)(\u0007a\u0001\u0003\u0013C3!GAR!\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAUg\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u0016q\u0015\u0002\bi\u0006LGN]3d\u0003\u0011\u0011X-\u00193\u0015\r\u0005%\u00151WA_\u0011\u001d\t)L\u0007a\u0001\u0003o\u000b\u0001\u0002]8tSRLwN\u001c\t\u0004e\u0005e\u0016bAA^g\t\u0019\u0011J\u001c;\t\u000f\u0005}&\u00041\u0001\u00028\u0006!1/\u001b>f\u0003\r9W\r\u001e\u000b\u0005\u0003/\u000b)\rC\u0004\u00026n\u0001\r!a.\u0002\u0011\u0019LG.Z*ju\u0016\fqA]3bI\u0006cG.\u0006\u0002\u0002\n\u00061\u0011n](qK:,\"!!5\u0011\u0007I\n\u0019.C\u0002\u0002VN\u0012qAQ8pY\u0016\fg.\u0001\bjg6+Wn\u001c:z\u001b\u0006\u0004\b/\u001a3\u0002\u0011%\u001cHj\\1eK\u0012\fa![:Gk2d\u0017A\u00023fY\u0016$X-A\u0007jg\n+hMZ3s\u000b6\u0004H/\u001f\u0005\u0006\u0017\u000e\u0001\r!\u0014\u0005\u0006_\u000e\u0001\r\u0001\u001d\u0005\u0006g\u000e\u0001\r\u0001\u001d\u000b\u0006y\u0005%\u00181\u001e\u0005\u0006\u0017\u0012\u0001\r!\u0014\u0005\u0006g\u0012\u0001\r\u0001]\u0001\u0006CB\u0004H.\u001f\u000b\fy\u0005E\u00181_A{\u0003o\fI\u0010C\u0003L\u000b\u0001\u0007Q\nC\u0003X\u000b\u0001\u0007\u0001\fC\u0003_\u000b\u0001\u0007q\fC\u0003p\u000b\u0001\u0007\u0001\u000fC\u0003t\u000b\u0001\u0007\u0001\u000f")
public class MMAPFile
implements LazyLogging,
DBFileType {
    private final Path path;
    private final FileChannel channel;
    private final FileChannel.MapMode mode;
    private final long blockCacheFileId;
    private volatile MappedByteBuffer buffer;
    private final AtomicBoolean open;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static MMAPFile write(Path path, long l, long l2) {
        return MMAPFile$.MODULE$.write(path, l, l2);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public long blockCacheFileId() {
        return this.blockCacheFileId;
    }

    private MappedByteBuffer buffer() {
        return this.buffer;
    }

    private void buffer_$eq(MappedByteBuffer x$1) {
        this.buffer = x$1;
    }

    private AtomicBoolean open() {
        return this.open;
    }

    private final <T> T watchNullPointer(Function0<T> f) {
        try {
            return (T)f.apply();
        }
        catch (NullPointerException ex) {
            throw new Exception.NullMappedByteBuffer((Exception)ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    @Override
    public void close() {
        if (this.open().compareAndSet(true, false)) {
            try {
                MMAPFile.$anonfun$close$1(this);
                return;
            }
            catch (NullPointerException watchNullPointer_ex) {
                throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
            }
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("{}: Already closed.", (Object)this.path());
        }
    }

    @Override
    public void forceSave() {
        synchronized (this) {
            FileChannel.MapMode mapMode = this.mode;
            FileChannel.MapMode mapMode2 = FileChannel.MapMode.READ_ONLY;
            if (!(mapMode == null ? mapMode2 != null : !mapMode.equals(mapMode2)) || this.isBufferEmpty()) {
                IO$.MODULE$.unit();
            } else {
                try {
                    MMAPFile.$anonfun$forceSave$1(this);
                }
                catch (NullPointerException watchNullPointer_ex) {
                    throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
                }
            }
            return;
        }
    }

    private synchronized void clearBuffer() {
        MappedByteBuffer swapBuffer = this.buffer();
        this.buffer_$eq(null);
        BufferCleaner$.MODULE$.clean(swapBuffer, this.path());
    }

    @Override
    public void append(Iterable<Slice<Object>> slice2) {
        slice2.foreach((Function1 & Serializable)slice -> {
            this.append((Slice<Object>)slice);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public final void append(Slice<Object> slice) {
        while (true) {
            try {
                try {
                    MMAPFile.$anonfun$append$2(this, slice);
                }
                catch (NullPointerException watchNullPointer_ex) {
                    throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
                }
                return;
            }
            catch (BufferOverflowException ex) {
                try {
                    MMAPFile.$anonfun$append$3(this, slice, ex);
                }
                catch (NullPointerException watchNullPointer_ex) {
                    throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
                }
                Object var4_4 = null;
                continue;
            }
            break;
        }
    }

    @Override
    public Slice<Object> read(int position, int size) {
        try {
            return MMAPFile.$anonfun$read$1(this, size, position);
        }
        catch (NullPointerException watchNullPointer_ex) {
            throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    @Override
    public byte get(int position) {
        try {
            return MMAPFile.$anonfun$get$1(this, position);
        }
        catch (NullPointerException watchNullPointer_ex) {
            throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    @Override
    public long fileSize() {
        try {
            return this.channel.size();
        }
        catch (NullPointerException watchNullPointer_ex) {
            throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    @Override
    public Slice<Object> readAll() {
        try {
            return this.read(0, (int)this.channel.size());
        }
        catch (NullPointerException watchNullPointer_ex) {
            throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    @Override
    public boolean isOpen() {
        try {
            return this.channel.isOpen();
        }
        catch (NullPointerException watchNullPointer_ex) {
            throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    @Override
    public boolean isMemoryMapped() {
        return true;
    }

    @Override
    public boolean isLoaded() {
        try {
            return MMAPFile.$anonfun$isLoaded$1(this);
        }
        catch (NullPointerException watchNullPointer_ex) {
            throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    @Override
    public boolean isFull() {
        try {
            return MMAPFile.$anonfun$isFull$1(this);
        }
        catch (NullPointerException watchNullPointer_ex) {
            throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    @Override
    public void delete() {
        try {
            MMAPFile.$anonfun$delete$1(this);
            return;
        }
        catch (NullPointerException watchNullPointer_ex) {
            throw new Exception.NullMappedByteBuffer((Exception)watchNullPointer_ex, Reserve$.MODULE$.free(new StringBuilder(2).append(this.getClass().getSimpleName()).append(": ").append(this.path()).toString()));
        }
    }

    public boolean isBufferEmpty() {
        return this.buffer() == null;
    }

    public static final /* synthetic */ void $anonfun$close$1(MMAPFile $this) {
        $this.forceSave();
        $this.clearBuffer();
        $this.channel.close();
    }

    public static final /* synthetic */ MappedByteBuffer $anonfun$forceSave$1(MMAPFile $this) {
        return $this.buffer().force();
    }

    public static final /* synthetic */ void $anonfun$append$2(MMAPFile $this, Slice slice$1) {
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)slice$1);
        if (byteSliceImplicits == null) {
            throw null;
        }
        $this.buffer().put(byteSliceImplicits.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice.toByteBufferWrap());
    }

    public static final /* synthetic */ Buffer $anonfun$append$3(MMAPFile $this, Slice slice$1, BufferOverflowException ex$1) {
        long requiredByteSize = slice$1.size();
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("{}: BufferOverflowException. Required bytes: {}. Remaining bytes: {}. Extending buffer with {} bytes.", new Object[]{$this.path(), BoxesRunTime.boxToLong((long)requiredByteSize), BoxesRunTime.boxToInteger((int)$this.buffer().remaining()), BoxesRunTime.boxToLong((long)requiredByteSize), ex$1});
        }
        int positionBeforeClear = $this.buffer().position();
        $this.buffer().force();
        $this.clearBuffer();
        $this.buffer_$eq($this.channel.map($this.mode, 0L, (long)positionBeforeClear + requiredByteSize));
        return $this.buffer().position(positionBeforeClear);
    }

    public static final /* synthetic */ Slice $anonfun$read$1(MMAPFile $this, int size$1, int position$1) {
        byte[] array = new byte[size$1];
        for (int i = 0; i < size$1; ++i) {
            array[i] = $this.buffer().get(i + position$1);
        }
        ManifestFactory.ByteManifest apply_evidence$4 = ClassTag$.MODULE$.Byte();
        return SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)array, (ClassTag)apply_evidence$4);
    }

    public static final /* synthetic */ byte $anonfun$get$1(MMAPFile $this, int position$2) {
        return $this.buffer().get(position$2);
    }

    public static final /* synthetic */ boolean $anonfun$isLoaded$1(MMAPFile $this) {
        return $this.buffer().isLoaded();
    }

    public static final /* synthetic */ boolean $anonfun$isFull$1(MMAPFile $this) {
        return $this.buffer().remaining() == 0;
    }

    public static final /* synthetic */ void $anonfun$delete$1(MMAPFile $this) {
        $this.close();
        Files.delete($this.path());
    }

    public MMAPFile(Path path, FileChannel channel, FileChannel.MapMode mode, long bufferSize, long blockCacheFileId, MappedByteBuffer buffer) {
        this.path = path;
        this.channel = channel;
        this.mode = mode;
        this.blockCacheFileId = blockCacheFileId;
        this.buffer = buffer;
        LazyLogging.$init$((LazyLogging)this);
        this.open = new AtomicBoolean(true);
    }
}

