/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.io.reader;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import swaydb.IO;
import swaydb.core.io.file.DBFile;
import swaydb.data.slice.Reader;
import swaydb.data.slice.ReaderBase;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da!B\u000b\u0017\u0001iq\u0002\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011A\u001d\t\u0011}\u0002!\u0011!Q\u0001\niBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq!\u0012\u0001A\u0002\u0013%a\tC\u0004K\u0001\u0001\u0007I\u0011B&\t\rE\u0003\u0001\u0015)\u0003H\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015a\u0006\u0001\"\u0001a\u0011\u0015\u0011\u0007\u0001\"\u0001T\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015A\u0007\u0001\"\u0011G\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u0015!\b\u0001\"\u0001v\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!A\u00111\u0001\u0001C\u0002\u0013\u00153\u000bC\u0004\u0002\u0006\u0001\u0001\u000bQ\u0002+\u0003\u0015\u0019KG.\u001a*fC\u0012,'O\u0003\u0002\u00181\u00051!/Z1eKJT!!\u0007\u000e\u0002\u0005%|'BA\u000e\u001d\u0003\u0011\u0019wN]3\u000b\u0003u\taa]<bs\u0012\u00147\u0003\u0002\u0001 K5\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0015\u0019H.[2f\u0015\tQC$\u0001\u0003eCR\f\u0017B\u0001\u0017(\u0005\u0019\u0011V-\u00193feB\u0011a&N\u0007\u0002_)\u0011\u0001'M\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003eM\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002i\u0005\u00191m\\7\n\u0005Yz#a\u0003'bufdunZ4j]\u001e\fAAZ5mK\u000e\u0001Q#\u0001\u001e\u0011\u0005mjT\"\u0001\u001f\u000b\u0005]B\u0012B\u0001 =\u0005\u0019!%IR5mK\u0006)a-\u001b7fA\u00051A(\u001b8jiz\"\"A\u0011#\u0011\u0005\r\u0003Q\"\u0001\f\t\u000b]\u001a\u0001\u0019\u0001\u001e\u0002\u0011A|7/\u001b;j_:,\u0012a\u0012\t\u0003A!K!!S\u0011\u0003\u0007%sG/\u0001\u0007q_NLG/[8o?\u0012*\u0017\u000f\u0006\u0002M\u001fB\u0011\u0001%T\u0005\u0003\u001d\u0006\u0012A!\u00168ji\"9\u0001+BA\u0001\u0002\u00049\u0015a\u0001=%c\u0005I\u0001o\\:ji&|g\u000eI\u0001\tSNdu.\u00193fIV\tA\u000b\u0005\u0002!+&\u0011a+\t\u0002\b\u0005>|G.Z1o\u0003\u0011\u0019\u0018N_3\u0016\u0003e\u0003\"\u0001\t.\n\u0005m\u000b#\u0001\u0002'p]\u001e\fa!\\8wKR{GC\u0001\"_\u0011\u0015y\u0016\u00021\u0001Z\u0003-qWm\u001e)pg&$\u0018n\u001c8\u0015\u0005\t\u000b\u0007\"B0\u000b\u0001\u00049\u0015a\u00025bg6{'/Z\u0001\u000bQ\u0006\u001c\u0018\t\u001e'fCN$HC\u0001+f\u0011\u00159F\u00021\u0001Z\u0003\u0011\u0019w\u000e]=\u0015\u0003\t\u000b1bZ3u!>\u001c\u0018\u000e^5p]\u0006\u0019q-\u001a;\u0015\u0003-\u0004\"\u0001\t7\n\u00055\f#\u0001\u0002\"zi\u0016\fAA]3bIR\u0011\u0001o\u001d\t\u0004ME\\\u0017B\u0001:(\u0005\u0015\u0019F.[2f\u0011\u00159\u0006\u00031\u0001H\u0003\u0011\u0001\u0018\r\u001e5\u0016\u0003Y\u0004\"a^?\u000e\u0003aT!aN=\u000b\u0005i\\\u0018a\u00018j_*\tA0\u0001\u0003kCZ\f\u0017B\u0001@y\u0005\u0011\u0001\u0016\r\u001e5\u0002\u001bI,\u0017\r\u001a*f[\u0006Lg.\u001b8h)\u0005\u0001\u0018AB5t\r&dW-A\u0004jg\u001aKG.\u001a\u0011")
public class FileReader
implements Reader,
LazyLogging {
    private final DBFile file;
    private int position;
    private final boolean isFile;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public Reader skip(long skip) {
        return Reader.skip$((Reader)this, (long)skip);
    }

    public Reader reset() {
        return Reader.reset$((Reader)this);
    }

    public Slice<Object> read(long size) {
        return ReaderBase.read$((ReaderBase)this, (long)size);
    }

    public boolean readBoolean() {
        return ReaderBase.readBoolean$((ReaderBase)this);
    }

    public int readInt() {
        return ReaderBase.readInt$((ReaderBase)this);
    }

    public int readInt(boolean unsigned) {
        return ReaderBase.readInt$((ReaderBase)this, (boolean)unsigned);
    }

    public int readUnsignedInt() {
        return ReaderBase.readUnsignedInt$((ReaderBase)this);
    }

    public Tuple2<Object, Object> readUnsignedIntWithByteSize() {
        return ReaderBase.readUnsignedIntWithByteSize$((ReaderBase)this);
    }

    public int readNonZeroUnsignedInt() {
        return ReaderBase.readNonZeroUnsignedInt$((ReaderBase)this);
    }

    public int readNonZeroStrictUnsignedInt() {
        return ReaderBase.readNonZeroStrictUnsignedInt$((ReaderBase)this);
    }

    public Tuple2<Object, Object> readNonZeroUnsignedIntWithByteSize() {
        return ReaderBase.readNonZeroUnsignedIntWithByteSize$((ReaderBase)this);
    }

    public Slice<Object> readUnsignedIntSized() {
        return ReaderBase.readUnsignedIntSized$((ReaderBase)this);
    }

    public int readSignedInt() {
        return ReaderBase.readSignedInt$((ReaderBase)this);
    }

    public long readLong() {
        return ReaderBase.readLong$((ReaderBase)this);
    }

    public long readUnsignedLong() {
        return ReaderBase.readUnsignedLong$((ReaderBase)this);
    }

    public long readSignedLong() {
        return ReaderBase.readSignedLong$((ReaderBase)this);
    }

    public String readRemainingAsString(Charset charset) {
        return ReaderBase.readRemainingAsString$((ReaderBase)this, (Charset)charset);
    }

    public Charset readRemainingAsString$default$1() {
        return ReaderBase.readRemainingAsString$default$1$((ReaderBase)this);
    }

    public String readString(int size, Charset charset) {
        return ReaderBase.readString$((ReaderBase)this, (int)size, (Charset)charset);
    }

    public Charset readString$default$2() {
        return ReaderBase.readString$default$2$((ReaderBase)this);
    }

    public long remaining() {
        return ReaderBase.remaining$((ReaderBase)this);
    }

    public final <E, R> IO<E, R> foldLeftIO(R result, Function2<R, ReaderBase, IO<E, R>> f, IO.ExceptionHandler<E> evidence$1) {
        return ReaderBase.foldLeftIO$((ReaderBase)this, result, f, evidence$1);
    }

    public final <R> R foldLeft(R result, Function2<R, ReaderBase, R> f) {
        return (R)ReaderBase.foldLeft$((ReaderBase)this, result, f);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public DBFile file() {
        return this.file;
    }

    private int position() {
        return this.position;
    }

    private void position_$eq(int x$1) {
        this.position = x$1;
    }

    public boolean isLoaded() {
        return this.file().isLoaded();
    }

    public long size() {
        return this.file().fileSize();
    }

    public FileReader moveTo(long newPosition) {
        this.position_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)newPosition), 0));
        return this;
    }

    public FileReader moveTo(int newPosition) {
        this.position_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(newPosition), 0));
        return this;
    }

    public boolean hasMore() {
        return (long)this.position() < this.size();
    }

    public boolean hasAtLeast(long size) {
        return this.file().fileSize() - (long)this.position() >= size;
    }

    public FileReader copy() {
        return new FileReader(this.file());
    }

    public int getPosition() {
        return this.position();
    }

    /*
     * WARNING - void declaration
     */
    public byte get() {
        void var1_1;
        byte by = this.file().get(this.position());
        this.position_$eq(this.position() + 1);
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Slice<Object> read(int size) {
        void var2_2;
        if (size <= 0) {
            return Slice$.MODULE$.emptyBytes();
        }
        Slice<Object> bytes = this.file().read(this.position(), size);
        this.position_$eq(this.position() + size);
        return var2_2;
    }

    public Path path() {
        return this.file().path();
    }

    public Slice<Object> readRemaining() {
        return this.read(this.remaining());
    }

    public final boolean isFile() {
        return this.isFile;
    }

    public FileReader(DBFile file) {
        this.file = file;
        LazyLogging.$init$((LazyLogging)this);
        this.position = 0;
        this.isFile = true;
    }
}

