/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.level;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple14;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import swaydb.Error;
import swaydb.Exception;
import swaydb.IO;
import swaydb.IO$;
import swaydb.core.actor.FileSweeper;
import swaydb.core.actor.MemorySweeper;
import swaydb.core.function.FunctionStore;
import swaydb.core.io.file.BlockCache;
import swaydb.core.io.file.Effect;
import swaydb.core.io.file.Effect$;
import swaydb.core.level.AppendixSkipListMerger$;
import swaydb.core.level.Level;
import swaydb.core.level.LevelRef;
import swaydb.core.level.NextLevel;
import swaydb.core.level.PathsDistributor;
import swaydb.core.map.Map$;
import swaydb.core.map.MapEntry;
import swaydb.core.map.MemoryMap;
import swaydb.core.map.PersistentMap;
import swaydb.core.map.PersistentMap$;
import swaydb.core.map.serializer.AppendixMapEntryReader;
import swaydb.core.map.serializer.AppendixMapEntryReader$AppendixReader$;
import swaydb.core.map.serializer.AppendixMapEntryWriter$AppendixPutWriter$;
import swaydb.core.map.serializer.AppendixMapEntryWriter$AppendixRemoveWriter$;
import swaydb.core.map.serializer.MapEntryWriter;
import swaydb.core.segment.Segment;
import swaydb.core.segment.Segment$;
import swaydb.core.segment.Segment$Null$;
import swaydb.core.segment.SegmentIO;
import swaydb.core.segment.SegmentIO$;
import swaydb.core.segment.SegmentOption;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchIndexBlock;
import swaydb.core.segment.format.a.block.bloomfilter.BloomFilterBlock;
import swaydb.core.segment.format.a.block.hashindex.HashIndexBlock;
import swaydb.core.segment.format.a.block.segment.SegmentBlock;
import swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock;
import swaydb.core.segment.format.a.block.values.ValuesBlock;
import swaydb.core.util.Collections;
import swaydb.core.util.Extension$Log$;
import swaydb.core.util.Extension$Seg$;
import swaydb.core.util.IDGenerator;
import swaydb.core.util.ReserveRange;
import swaydb.core.util.ReserveRange$;
import swaydb.data.compaction.LevelMeter;
import swaydb.data.compaction.Throttle;
import swaydb.data.config.Dir;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;
import swaydb.data.slice.SliceOption;
import swaydb.data.storage.AppendixStorage;
import swaydb.data.storage.LevelStorage;

public final class Level$
implements LazyLogging,
Serializable {
    public static final Level$ MODULE$ = new Level$();
    private static final Tuple2<Iterable<Segment>, Iterable<Segment>> emptySegmentsToPush;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        emptySegmentsToPush = new Tuple2(package$.MODULE$.Iterable().empty(), package$.MODULE$.Iterable().empty());
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Tuple2<Iterable<Segment>, Iterable<Segment>> emptySegmentsToPush() {
        return emptySegmentsToPush;
    }

    public IO<Error.Level, Option<FileLock>> acquireLock(LevelStorage.Persistent storage) {
        IO.Right right;
        Error.Level$.ExceptionHandler$ apply_evidence$13 = Error.Level$.ExceptionHandler$.MODULE$;
        try {
            right = new IO.Right((Object)Level$.$anonfun$acquireLock$1(storage), (IO.ExceptionHandler)apply_evidence$13);
        }
        catch (Throwable apply_ex) {
            right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
        }
        return right;
    }

    public IO<Error.Level, Option<FileLock>> acquireLock(LevelStorage levelStorage) {
        IO<Error.Level, Option<FileLock>> iO;
        if (levelStorage instanceof LevelStorage.Persistent) {
            LevelStorage.Persistent persistent = (LevelStorage.Persistent)levelStorage;
            iO = this.acquireLock(persistent);
        } else if (levelStorage instanceof LevelStorage.Memory) {
            iO = IO$.MODULE$.none();
        } else {
            throw new MatchError((Object)levelStorage);
        }
        return iO;
    }

    public IO<Error.Level, Level> apply(BloomFilterBlock.Config bloomFilterConfig, HashIndexBlock.Config hashIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, SortedIndexBlock.Config sortedIndexConfig, ValuesBlock.Config valuesConfig, SegmentBlock.Config segmentConfig, LevelStorage levelStorage, AppendixStorage appendixStorage, Option<NextLevel> nextLevel, Function1<LevelMeter, Throttle> throttle, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, Option<BlockCache.State> blockCache, FileSweeper.Enabled fileSweeper) {
        return this.acquireLock(levelStorage).flatMap(arg_0 -> Level$.$anonfun$apply$1(bloomFilterConfig, hashIndexConfig, binarySearchIndexConfig, sortedIndexConfig, valuesConfig, segmentConfig, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, fileSweeper, blockCache, appendixStorage, levelStorage, throttle, nextLevel, arg_0), (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
    }

    public boolean removeDeletes(Option<LevelRef> nextLevel) {
        return nextLevel.isEmpty() || nextLevel.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isTrash()));
    }

    public long largestSegmentId(Iterable<Segment> appendix) {
        return BoxesRunTime.unboxToLong((Object)appendix.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)Level$.$anonfun$largestSegmentId$1(BoxesRunTime.unboxToLong((Object)x0$1), x1$1))));
    }

    public boolean isSmallSegment(Segment segment, long levelSegmentSize) {
        return (double)segment.segmentSize() < (double)levelSegmentSize * 0.4;
    }

    /*
     * WARNING - void declaration
     */
    public IO<Error.Level, BoxedUnit> deleteUncommittedSegments(Seq<Dir> dirs, Iterable<Segment> appendixSegments) {
        void IterableIOImplicit_evidence$8;
        void IterableIOImplicit_evidence$7;
        IO.IterableIOImplicit iterableIOImplicit;
        ClassTag classTag = ClassTag$.MODULE$.apply(Path.class);
        Error.Level$.ExceptionHandler$ exceptionHandler$ = Error.Level$.ExceptionHandler$.MODULE$;
        Iterable IterableIOImplicit_iterable = (Iterable)dirs.flatMap((Function1 & Serializable)x$3 -> {
            Path PathExtensionImplicits_path = x$3.path();
            Object var1_1 = null;
            return new Effect.PathExtensionImplicits(PathExtensionImplicits_path).files(Extension$Seg$.MODULE$);
        });
        IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit(IterableIOImplicit_iterable, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        Object var6_5 = null;
        exceptionHandler$ = null;
        classTag = null;
        iterableIOImplicit = null;
        IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
        Function1 & Serializable x$1 = (Function1 & Serializable)segmentToDelete -> {
            if (BoxesRunTime.unboxToBoolean((Object)appendixSegments.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)Level$.$anonfun$deleteUncommittedSegments$3(segmentToDelete, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))))) {
                IO.Right right;
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("SEGMENT {} not in appendix. Deleting uncommitted segment.", segmentToDelete);
                }
                Error.Level$.ExceptionHandler$ apply_evidence$13 = Error.Level$.ExceptionHandler$.MODULE$;
                try {
                    Files.delete(segmentToDelete);
                    right = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
                }
                catch (Throwable apply_ex) {
                    right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                }
                return right;
            }
            return IO$.MODULE$.unit();
        };
        boolean x$2 = qual$1.foreachIO$default$2();
        return (IO)qual$1.foreachIO((Function1)x$1, x$2).getOrElse((Function0 & Serializable)() -> IO$.MODULE$.unit());
    }

    public Tuple2<Iterable<Segment>, Iterable<Segment>> optimalSegmentsToPushForward(NextLevel level, NextLevel nextLevel, int take, ReserveRange.State<BoxedUnit> reserve, KeyOrder<Slice<Object>> keyOrder) {
        ListBuffer segmentsToCopy = ListBuffer$.MODULE$.empty();
        ListBuffer segmentsToMerge = ListBuffer$.MODULE$.empty();
        Iterable<Segment> IterableImplicit_items = level.segmentsInLevel();
        Object var10_8 = null;
        Iterator foreachBreak_iterator = new Collections.IterableImplicit<Segment>(IterableImplicit_items).swaydb$core$util$Collections$IterableImplicit$$items.iterator();
        boolean foreachBreak_break = false;
        while (foreachBreak_iterator.hasNext() && !foreachBreak_break) {
            Segment segment = (Segment)foreachBreak_iterator.next();
            foreachBreak_break = Level$.$anonfun$optimalSegmentsToPushForward$1(reserve, keyOrder, nextLevel, segmentsToCopy, segmentsToMerge, take, segment);
        }
        Object var8_9 = null;
        return new Tuple2((Object)segmentsToCopy, (Object)segmentsToMerge);
    }

    public boolean shouldCollapse(NextLevel level, Segment segment, ReserveRange.State<BoxedUnit> reserve, KeyOrder<Slice<Object>> keyOrder) {
        return ReserveRange$.MODULE$.isUnreserved(segment, reserve, keyOrder) && (this.isSmallSegment(segment, level.minSegmentSize()) || segment.createdInLevel() != level.levelNumber());
    }

    public Iterable<Segment> optimalSegmentsToCollapse(NextLevel level, int take, ReserveRange.State<BoxedUnit> reserve, KeyOrder<Slice<Object>> keyOrder) {
        int n = 0;
        ListBuffer segmentsToCollapse = ListBuffer$.MODULE$.empty();
        Iterable<Segment> IterableImplicit_items = level.segmentsInLevel();
        Object var8_7 = null;
        Iterator foreachBreak_iterator = new Collections.IterableImplicit<Segment>(IterableImplicit_items).swaydb$core$util$Collections$IterableImplicit$$items.iterator();
        boolean foreachBreak_break = false;
        while (foreachBreak_iterator.hasNext() && !foreachBreak_break) {
            Segment segment = (Segment)foreachBreak_iterator.next();
            if (MODULE$.shouldCollapse(level, segment, reserve, keyOrder)) {
                segmentsToCollapse.$plus$eq((Object)segment);
                ++n;
            }
            foreachBreak_break = n >= take;
        }
        return segmentsToCollapse;
    }

    public IO<Error.Delete, BoxedUnit> delete(NextLevel level) {
        return level.close().flatMap((Function1 & Serializable)x$4 -> (IO)level.nextLevel().map((Function1 & Serializable)x$5 -> x$5.delete()).getOrElse((Function0 & Serializable)() -> {
            void IterableIOImplicit_evidence$8;
            void IterableIOImplicit_evidence$7;
            IO.IterableIOImplicit iterableIOImplicit;
            ClassTag classTag = ClassTag$.MODULE$.apply(Dir.class);
            Error.Delete$.ExceptionHandler$ exceptionHandler$ = Error.Delete$.ExceptionHandler$.MODULE$;
            Seq<Dir> IterableIOImplicit_iterable = level.pathDistributor().dirs();
            IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit(IterableIOImplicit_iterable, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
            Object var4_3 = null;
            exceptionHandler$ = null;
            classTag = null;
            iterableIOImplicit = null;
            IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
            Function1 & Serializable x$1 = (Function1 & Serializable)path -> {
                IO.Right right;
                Error.Delete$.ExceptionHandler$ apply_evidence$13 = Error.Delete$.ExceptionHandler$.MODULE$;
                try {
                    Effect$.MODULE$.walkDelete(path.path());
                    right = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
                }
                catch (Throwable apply_ex) {
                    right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                }
                return right;
            };
            boolean x$2 = qual$1.foreachIO$default$2();
            return (Product)qual$1.foreachIO((Function1)x$1, x$2).getOrElse((Function0 & Serializable)() -> IO$.MODULE$.unit());
        }), (IO.ExceptionHandler)Error.Delete$.ExceptionHandler$.MODULE$);
    }

    public Level apply(Seq<Dir> dirs, BloomFilterBlock.Config bloomFilterConfig, HashIndexBlock.Config hashIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, SortedIndexBlock.Config sortedIndexConfig, ValuesBlock.Config valuesConfig, SegmentBlock.Config segmentConfig, boolean inMemory, Function1<LevelMeter, Throttle> throttle, Option<NextLevel> nextLevel, swaydb.core.map.Map<SliceOption<Object>, SegmentOption, Slice<Object>, Segment> appendix, Option<FileLock> lock, PathsDistributor pathDistributor, boolean removeDeletedRecords, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, MapEntryWriter<MapEntry.Remove<Slice<Object>>> removeWriter, MapEntryWriter<MapEntry.Put<Slice<Object>, Segment>> addWriter, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, FileSweeper.Enabled fileSweeper, Option<BlockCache.State> blockCache, IDGenerator segmentIDGenerator, SegmentIO segmentIO, ReserveRange.State<BoxedUnit> reserve) {
        return new Level(dirs, bloomFilterConfig, hashIndexConfig, binarySearchIndexConfig, sortedIndexConfig, valuesConfig, segmentConfig, inMemory, throttle, nextLevel, appendix, lock, pathDistributor, removeDeletedRecords, keyOrder, timeOrder, functionStore, removeWriter, addWriter, keyValueMemorySweeper, fileSweeper, blockCache, segmentIDGenerator, segmentIO, reserve);
    }

    public Option<Tuple14<Seq<Dir>, BloomFilterBlock.Config, HashIndexBlock.Config, BinarySearchIndexBlock.Config, SortedIndexBlock.Config, ValuesBlock.Config, SegmentBlock.Config, Object, Function1<LevelMeter, Throttle>, Option<NextLevel>, swaydb.core.map.Map<SliceOption<Object>, SegmentOption, Slice<Object>, Segment>, Option<FileLock>, PathsDistributor, Object>> unapply(Level x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple14(x$0.dirs(), (Object)x$0.bloomFilterConfig(), (Object)x$0.hashIndexConfig(), (Object)x$0.binarySearchIndexConfig(), (Object)x$0.sortedIndexConfig(), (Object)x$0.valuesConfig(), (Object)x$0.segmentConfig(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.inMemory()), x$0.throttle(), x$0.nextLevel(), x$0.appendix(), x$0.lock(), (Object)x$0.pathDistributor(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.removeDeletedRecords())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Level$.class);
    }

    public static final /* synthetic */ Some $anonfun$acquireLock$1(LevelStorage.Persistent storage$1) {
        Effect$.MODULE$.createDirectoriesIfAbsent(storage$1.dir());
        Path lockFile = storage$1.dir().resolve("LOCK");
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("{}: Acquiring lock.", (Object)lockFile);
        }
        Effect$.MODULE$.createFileIfAbsent(lockFile);
        FileLock lock = FileChannel.open(lockFile, StandardOpenOption.WRITE).tryLock();
        storage$1.dirs().foreach((Function1 & Serializable)dir -> Effect$.MODULE$.createDirectoriesIfAbsent(dir.path()));
        return new Some((Object)lock);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ PersistentMap $anonfun$apply$2(Path appendixFolder$1, boolean mmap$1, long appendixFlushCheckpointSize$1, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, FileSweeper.Enabled fileSweeper$1, AppendixMapEntryReader appendixReader$1, AppendixSkipListMerger$ merger$1) {
        void persistent_writer;
        void persistent_reader;
        void persistent_nullValue;
        void persistent_dropCorruptedTailEntries;
        void persistent_flushOnOverflow;
        Effect$.MODULE$.createDirectoriesIfAbsent(appendixFolder$1);
        AppendixMapEntryReader$AppendixReader$ appendixMapEntryReader$AppendixReader$ = appendixReader$1.AppendixReader();
        AppendixMapEntryWriter$AppendixPutWriter$ appendixMapEntryWriter$AppendixPutWriter$ = AppendixMapEntryWriter$AppendixPutWriter$.MODULE$;
        boolean bl = false;
        boolean bl2 = true;
        Segment$Null$ segment$Null$ = Segment$Null$.MODULE$;
        Slice.Null$ persistent_nullKey = Slice.Null$.MODULE$;
        Object var10_14 = null;
        segment$Null$ = null;
        appendixMapEntryWriter$AppendixPutWriter$ = null;
        appendixMapEntryReader$AppendixReader$ = null;
        return PersistentMap$.MODULE$.apply(appendixFolder$1, mmap$1, (boolean)persistent_flushOnOverflow, appendixFlushCheckpointSize$1, (boolean)persistent_dropCorruptedTailEntries, persistent_nullKey, persistent_nullValue, keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, fileSweeper$1, persistent_reader, persistent_writer, merger$1).item();
    }

    public static final /* synthetic */ MemoryMap $anonfun$apply$3(KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, AppendixSkipListMerger$ merger$1) {
        return Map$.MODULE$.memory(Slice.Null$.MODULE$, Segment$Null$.MODULE$, Map$.MODULE$.memory$default$3(), true, keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, merger$1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ IO $anonfun$apply$4(LevelStorage levelStorage$1, AppendixStorage appendixStorage$1, BloomFilterBlock.Config bloomFilterConfig$1, HashIndexBlock.Config hashIndexConfig$1, BinarySearchIndexBlock.Config binarySearchIndexConfig$1, SortedIndexBlock.Config sortedIndexConfig$1, ValuesBlock.Config valuesConfig$1, SegmentBlock.Config segmentConfig$1, Function1 throttle$1, Option nextLevel$1, Option lock$1, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, Option keyValueMemorySweeper$1, FileSweeper.Enabled fileSweeper$1, Option blockCache$1, SegmentIO segmentIO$1, swaydb.core.map.Map appendix) {
        IO.Left left;
        IO.Left left2;
        void IterableIOImplicit_evidence$8;
        void IterableIOImplicit_evidence$7;
        IO.IterableIOImplicit iterableIOImplicit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("{}: Checking Segments exist.", (Object)levelStorage$1.dir());
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(Tuple2.class);
        Error.Level$.ExceptionHandler$ exceptionHandler$ = Error.Level$.ExceptionHandler$.MODULE$;
        Map IterableIOImplicit_iterable = appendix.skipList().asScala();
        IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit(IterableIOImplicit_iterable, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        Object var36_21 = null;
        exceptionHandler$ = null;
        classTag = null;
        iterableIOImplicit = null;
        IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
        Function1 & Serializable x$12 = (Function1 & Serializable)x0$1 -> {
            IO.Right right;
            if (x0$1 != null) {
                Segment segment = (Segment)x0$1._2();
                if (segment.existsOnDisk()) {
                    right = IO$.MODULE$.unit();
                } else {
                    void failed_evidence$20;
                    Error.Level$.ExceptionHandler$ exceptionHandler$ = Error.Level$.ExceptionHandler$.MODULE$;
                    Exception.SegmentFileMissing failed_exception = new Exception.SegmentFileMissing(segment.path());
                    IO.Left left = new IO.Left((Object)failed_evidence$20.toError((Throwable)failed_exception), (IO.ExceptionHandler)failed_evidence$20);
                    right = left;
                    Object var3_3 = null;
                    exceptionHandler$ = null;
                    left = null;
                }
            } else {
                throw new MatchError(null);
            }
            IO.Right right2 = right;
            return right2;
        };
        boolean x$2 = qual$1.foreachIO$default$2();
        Option option = qual$1.foreachIO((Function1)x$12, x$2);
        if (option instanceof Some && (left2 = (IO.Left)((Some)option).value()) != null) {
            Error.Level error = (Error.Level)left2.value();
            left = new IO.Left((Object)error, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
        } else if (None$.MODULE$.equals(option)) {
            void apply_segments;
            PathsDistributor pathsDistributor;
            IDGenerator iDGenerator;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("{}: Starting level.", (Object)levelStorage$1.dir());
            }
            Iterable allSegments = CollectionConverters$.MODULE$.CollectionHasAsScala(appendix.skipList().values()).asScala();
            long apply_initial = MODULE$.largestSegmentId((Iterable<Segment>)allSegments);
            IDGenerator iDGenerator2 = iDGenerator = new IDGenerator(apply_initial);
            iDGenerator = null;
            IDGenerator segmentIDGenerator = iDGenerator2;
            ReserveRange.State reserveRange = ReserveRange$.MODULE$.create();
            Function0 & Serializable intersect = (Function0 & Serializable)() -> allSegments;
            Seq apply_dirs = levelStorage$1.dirs();
            PathsDistributor pathsDistributor2 = pathsDistributor = new PathsDistributor((Seq<Dir>)apply_dirs, (Function0<Iterable<Segment>>)apply_segments);
            Object var33_36 = null;
            intersect = null;
            pathsDistributor = null;
            PathsDistributor paths = pathsDistributor2;
            left = (appendixStorage$1.persistent() ? MODULE$.deleteUncommittedSegments((Seq<Dir>)levelStorage$1.dirs(), (Iterable<Segment>)CollectionConverters$.MODULE$.CollectionHasAsScala(appendix.skipList().values()).asScala()) : IO$.MODULE$.unit()).transform((Function1 & Serializable)x$1 -> new Level((Seq<Dir>)levelStorage$1.dirs(), bloomFilterConfig$1, hashIndexConfig$1, binarySearchIndexConfig$1, sortedIndexConfig$1, valuesConfig$1, segmentConfig$1, levelStorage$1.memory(), (Function1<LevelMeter, Throttle>)throttle$1, (Option<NextLevel>)nextLevel$1, appendix, (Option<FileLock>)lock$1, paths, MODULE$.removeDeletes((Option<LevelRef>)nextLevel$1), (KeyOrder<Slice<Object>>)keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, AppendixMapEntryWriter$AppendixRemoveWriter$.MODULE$, AppendixMapEntryWriter$AppendixPutWriter$.MODULE$, (Option<MemorySweeper.KeyValue>)keyValueMemorySweeper$1, fileSweeper$1, (Option<BlockCache.State>)blockCache$1, segmentIDGenerator, segmentIO$1, reserveRange));
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ IO $anonfun$apply$1(BloomFilterBlock.Config bloomFilterConfig$1, HashIndexBlock.Config hashIndexConfig$1, BinarySearchIndexBlock.Config binarySearchIndexConfig$1, SortedIndexBlock.Config sortedIndexConfig$1, ValuesBlock.Config valuesConfig$1, SegmentBlock.Config segmentConfig$1, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, Option keyValueMemorySweeper$1, FileSweeper.Enabled fileSweeper$1, Option blockCache$1, AppendixStorage appendixStorage$1, LevelStorage levelStorage$1, Function1 throttle$1, Option nextLevel$1, Option lock) {
        block13: {
            block11: {
                block12: {
                    segmentIO = SegmentIO$.MODULE$.apply(bloomFilterConfig$1, hashIndexConfig$1, binarySearchIndexConfig$1, sortedIndexConfig$1, valuesConfig$1, segmentConfig$1);
                    appendixReader = new AppendixMapEntryReader(segmentConfig$1.mmapWrites(), segmentConfig$1.mmapReads(), (KeyOrder<Slice<Object>>)keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, (Option<MemorySweeper.KeyValue>)keyValueMemorySweeper$1, fileSweeper$1, (Option<BlockCache.State>)blockCache$1, segmentIO);
                    merger = AppendixSkipListMerger$.MODULE$;
                    if (!(appendixStorage$1 instanceof AppendixStorage.Persistent)) break block11;
                    var21_20 = (AppendixStorage.Persistent)appendixStorage$1;
                    mmap = var21_20.mmap();
                    appendixFlushCheckpointSize = var21_20.appendixFlushCheckpointSize();
                    if (Level$.MODULE$.logger().underlying().isInfoEnabled()) {
                        Level$.MODULE$.logger().underlying().info("{}: Initialising appendix.", (Object)levelStorage$1.dir());
                    }
                    appendixFolder = levelStorage$1.dir().resolve("appendix");
                    if (!Files.exists(appendixFolder, new LinkOption[0])) break block12;
                    if (!new Effect.PathExtensionImplicits(appendixFolder).files(Extension$Log$.MODULE$).isEmpty()) ** GOTO lbl-1000
                }
                DirsImplicits_dirs = levelStorage$1.dirs();
                var34_24 = null;
                if (Effect$.MODULE$.segmentFilesOnDisk((Seq<Path>)((Set)((IterableOnceOps)new Dir.DirsImplicits((Iterable)DirsImplicits_dirs).swaydb$data$config$Dir$DirsImplicits$$dirs.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$pathsSet$1(swaydb.data.config.Dir ), (Lswaydb/data/config/Dir;)Ljava/nio/file/Path;)())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Predef$.MODULE$.Set()))).toSeq()).nonEmpty()) {
                    if (Level$.MODULE$.logger().underlying().isInfoEnabled()) {
                        Level$.MODULE$.logger().underlying().info("{}: Failed to start Level. Appendix file is missing", (Object)appendixFolder);
                    }
                    var27_25 = Error.Level$.ExceptionHandler$.MODULE$;
                    failed_exception = new IllegalStateException(new StringBuilder(51).append("Failed to start Level. Appendix file is missing '").append(appendixFolder).append("'.").toString());
                    v0 = new IO.Left((Object)failed_evidence$20.toError((Throwable)failed_exception), (IO.ExceptionHandler)failed_evidence$20);
                    var26_26 = null;
                    var27_25 = null;
                } else lbl-1000:
                // 2 sources

                {
                    apply_evidence$13 = Error.Level$.ExceptionHandler$.MODULE$;
                    try {
                        var30_28 = new IO.Right((Object)Level$.$anonfun$apply$2(appendixFolder, mmap, appendixFlushCheckpointSize, keyOrder$1, timeOrder$1, functionStore$1, fileSweeper$1, appendixReader, merger), (IO.ExceptionHandler)apply_evidence$13);
                    }
                    catch (Throwable apply_ex) {
                        var30_28 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                    }
                    v0 = var30_28;
                    var28_27 = null;
                    var29_30 = null;
                    var30_28 = null;
                }
                var17_31 = v0;
                break block13;
            }
            if (AppendixStorage.Memory$.MODULE$.equals(appendixStorage$1)) {
                if (Level$.MODULE$.logger().underlying().isInfoEnabled()) {
                    Level$.MODULE$.logger().underlying().info("{}: Initialising appendix for in-memory Level", (Object)levelStorage$1.dir());
                }
                apply_evidence$13 = Error.Level$.ExceptionHandler$.MODULE$;
                try {
                    var33_33 = new IO.Right((Object)Level$.$anonfun$apply$3(keyOrder$1, timeOrder$1, functionStore$1, merger), (IO.ExceptionHandler)apply_evidence$13);
                }
                catch (Throwable apply_ex) {
                    var33_33 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                }
                v1 = var33_33;
                var31_32 = null;
                var32_35 = null;
                var33_33 = null;
                var17_31 = v1;
            } else {
                throw new MatchError((Object)appendixStorage$1);
            }
        }
        return var17_31.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$4(swaydb.data.storage.LevelStorage swaydb.data.storage.AppendixStorage swaydb.core.segment.format.a.block.bloomfilter.BloomFilterBlock$Config swaydb.core.segment.format.a.block.hashindex.HashIndexBlock$Config swaydb.core.segment.format.a.block.binarysearch.BinarySearchIndexBlock$Config swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock$Config swaydb.core.segment.format.a.block.values.ValuesBlock$Config swaydb.core.segment.format.a.block.segment.SegmentBlock$Config scala.Function1 scala.Option scala.Option swaydb.data.order.KeyOrder swaydb.data.order.TimeOrder swaydb.core.function.FunctionStore scala.Option swaydb.core.actor.FileSweeper$Enabled scala.Option swaydb.core.segment.SegmentIO swaydb.core.map.Map ), (Lswaydb/core/map/Map;)Lswaydb/IO;)((LevelStorage)levelStorage$1, (AppendixStorage)appendixStorage$1, (BloomFilterBlock.Config)bloomFilterConfig$1, (HashIndexBlock.Config)hashIndexConfig$1, (BinarySearchIndexBlock.Config)binarySearchIndexConfig$1, (SortedIndexBlock.Config)sortedIndexConfig$1, (ValuesBlock.Config)valuesConfig$1, (SegmentBlock.Config)segmentConfig$1, (Function1)throttle$1, (Option)nextLevel$1, (Option)lock, (KeyOrder)keyOrder$1, (TimeOrder)timeOrder$1, (FunctionStore)functionStore$1, (Option)keyValueMemorySweeper$1, (FileSweeper.Enabled)fileSweeper$1, (Option)blockCache$1, (SegmentIO)segmentIO), (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$largestSegmentId$1(long x0$1, Segment x1$1) {
        void var3_3;
        Path PathExtensionImplicits_path = x1$1.path();
        Object var5_2 = null;
        long segmentId = new Effect.PathExtensionImplicits(PathExtensionImplicits_path).fileId()._1$mcJ$sp();
        if (x0$1 > segmentId) {
            return x0$1;
        }
        return (long)var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$deleteUncommittedSegments$3(Path segmentToDelete$1, boolean x0$1, Segment x1$1) {
        Path path = x1$1.path();
        if (!(path != null ? !((Object)path).equals(segmentToDelete$1) : segmentToDelete$1 != null)) {
            return false;
        }
        return x0$1;
    }

    public static final /* synthetic */ void $anonfun$deleteUncommittedSegments$4(Path segmentToDelete$1) {
        Effect$.MODULE$.delete(segmentToDelete$1);
    }

    public static final /* synthetic */ boolean $anonfun$optimalSegmentsToPushForward$1(ReserveRange.State reserve$1, KeyOrder keyOrder$2, NextLevel nextLevel$2, ListBuffer segmentsToCopy$1, ListBuffer segmentsToMerge$1, int take$1, Segment segment) {
        if (ReserveRange$.MODULE$.isUnreserved(segment, reserve$1, (KeyOrder<Slice<Object>>)keyOrder$2) && nextLevel$2.isUnreserved(segment)) {
            if (!Segment$.MODULE$.overlaps(segment, nextLevel$2.segmentsInLevel(), (KeyOrder<Slice<Object>>)keyOrder$2)) {
                segmentsToCopy$1.$plus$eq((Object)segment);
            } else if (segmentsToMerge$1.size() < take$1) {
                segmentsToMerge$1.$plus$eq((Object)segment);
            }
        }
        return segmentsToCopy$1.size() >= take$1;
    }

    public static final /* synthetic */ boolean $anonfun$optimalSegmentsToCollapse$1(NextLevel level$1, ReserveRange.State reserve$2, KeyOrder keyOrder$3, ListBuffer segmentsToCollapse$1, IntRef segmentsTaken$1, int take$2, Segment segment) {
        if (MODULE$.shouldCollapse(level$1, segment, reserve$2, (KeyOrder<Slice<Object>>)keyOrder$3)) {
            segmentsToCollapse$1.$plus$eq((Object)segment);
            ++segmentsTaken$1.elem;
        }
        return segmentsTaken$1.elem >= take$2;
    }

    private Level$() {
    }

    public static final /* synthetic */ Object $anonfun$optimalSegmentsToPushForward$1$adapted(ReserveRange.State reserve$1, KeyOrder keyOrder$2, NextLevel nextLevel$2, ListBuffer segmentsToCopy$1, ListBuffer segmentsToMerge$1, int take$1, Segment segment) {
        return BoxesRunTime.boxToBoolean((boolean)Level$.$anonfun$optimalSegmentsToPushForward$1(reserve$1, keyOrder$2, nextLevel$2, segmentsToCopy$1, segmentsToMerge$1, take$1, segment));
    }

    public static final /* synthetic */ Object $anonfun$optimalSegmentsToCollapse$1$adapted(NextLevel level$1, ReserveRange.State reserve$2, KeyOrder keyOrder$3, ListBuffer segmentsToCollapse$1, IntRef segmentsTaken$1, int take$2, Segment segment) {
        return BoxesRunTime.boxToBoolean((boolean)Level$.$anonfun$optimalSegmentsToCollapse$1(level$1, reserve$2, keyOrder$3, segmentsToCollapse$1, segmentsTaken$1, take$2, segment));
    }
}

