/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.level.compaction.throttle;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import swaydb.Error;
import swaydb.IO;
import swaydb.IO$;
import swaydb.core.data.Memory;
import swaydb.core.data.MemoryOption;
import swaydb.core.level.LevelRef;
import swaydb.core.level.NextLevel;
import swaydb.core.level.TrashLevel$;
import swaydb.core.level.compaction.Compaction;
import swaydb.core.level.compaction.throttle.ThrottleLevelState;
import swaydb.core.level.compaction.throttle.ThrottleLevelState$;
import swaydb.core.level.compaction.throttle.ThrottleState;
import swaydb.core.level.zero.LevelZero;
import swaydb.core.map.Map;
import swaydb.core.segment.Segment;
import swaydb.core.segment.Segment$;
import swaydb.core.segment.Segment$Null$;
import swaydb.core.segment.SegmentOption;
import swaydb.data.slice.Slice;
import swaydb.data.slice.SliceOption;

public final class ThrottleCompaction$
implements Compaction<ThrottleState>,
LazyLogging {
    public static final ThrottleCompaction$ MODULE$ = new ThrottleCompaction$();
    private static final FiniteDuration awaitPullTimeout;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        awaitPullTimeout = new package.DurationInt(package$.MODULE$.DurationInt(6)).seconds();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public FiniteDuration awaitPullTimeout() {
        return awaitPullTimeout;
    }

    @Override
    public void run(ThrottleState state, boolean forwardCopyOnAllLevels) {
        if (state.terminate()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{}: Ignoring wakeUp call. Compaction is terminated!", (Object)state.name());
                return;
            }
        } else {
            this.runNow(state, forwardCopyOnAllLevels);
        }
    }

    public void runNow(ThrottleState state, boolean forwardCopyOnAllLevels) {
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("\n\n\n\n\n\n{}: Running compaction now! forwardCopyOnAllLevels = {}!", new Object[]{state.name(), BoxesRunTime.boxToBoolean((boolean)forwardCopyOnAllLevels)});
        }
        if (forwardCopyOnAllLevels) {
            int totalCopies = this.copyForwardForEach(state.levelsReversed());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{}: Copies {} compacted. Continuing compaction.", new Object[]{state.name(), BoxesRunTime.boxToInteger((int)totalCopies)});
            }
        }
        this.runJobs(state, (Slice<LevelRef>)state.levels().sorted(state.ordering()));
    }

    public boolean shouldRun(LevelRef level, long newStateId, ThrottleLevelState state) {
        boolean bl;
        if (state instanceof ThrottleLevelState.AwaitingPull) {
            ThrottleLevelState.AwaitingPull awaitingPull = (ThrottleLevelState.AwaitingPull)state;
            Deadline timeout = awaitingPull.timeout();
            long stateId = awaitingPull.stateId();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): {}", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), state});
            }
            bl = awaitingPull.listenerInvoked() || timeout.isOverdue() || newStateId != stateId && level.nextCompactionDelay().fromNow().isOverdue();
        } else if (state instanceof ThrottleLevelState.Sleeping) {
            ThrottleLevelState.Sleeping sleeping = (ThrottleLevelState.Sleeping)state;
            Deadline sleepDeadline = sleeping.sleepDeadline();
            long stateId = sleeping.stateId();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): {}", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), state});
            }
            bl = sleepDeadline.isOverdue() || newStateId != stateId && level.nextCompactionDelay().fromNow().isOverdue();
        } else {
            throw new MatchError((Object)state);
        }
        return bl;
    }

    public void runJobs(ThrottleState state, Slice<LevelRef> currentJobs) {
        while (true) {
            long stateId;
            Option currentState;
            LevelRef level;
            if (state.terminate()) {
                if (!this.logger().underlying().isWarnEnabled()) break;
                this.logger().underlying().warn("{}: Cannot run jobs. Compaction is terminated.", (Object)state.name());
                return;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{}: Compaction order: {}", (Object[])new String[]{state.name(), ((IterableOnceOps)currentJobs.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.levelNumber()))).mkString(", ")});
            }
            if ((level = (LevelRef)currentJobs.headOrNull()) == null) {
                if (!this.logger().underlying().isDebugEnabled()) break;
                this.logger().underlying().debug("{}: Compaction round complete.", (Object)state.name());
                return;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): {}: Running compaction.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), state.name()});
            }
            if ((currentState = state.compactionStates().get((Object)level)).forall(arg_0 -> ThrottleCompaction$.$anonfun$runJobs$2$adapted(level, stateId = level.stateId(), arg_0))) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Level({}): {}: {}.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), state.name(), currentState.isEmpty() ? "Initial run" : "shouldRun = true"});
                }
                ThrottleLevelState nextState = this.runJob(level, stateId, state.executionContext());
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Level({}): {}: next state {}.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), state.name(), nextState});
                }
                state.compactionStates().put((Object)level, (Object)nextState);
                currentJobs = currentJobs.dropHead();
                continue;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): {}: shouldRun = false.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), state.name()});
            }
            currentJobs = currentJobs.dropHead();
        }
    }

    public ThrottleLevelState runJob(LevelRef level, long stateId, ExecutionContext ec) {
        ThrottleLevelState throttleLevelState;
        if (level instanceof LevelZero) {
            LevelZero levelZero = (LevelZero)level;
            throttleLevelState = this.pushForward(levelZero, stateId);
        } else if (level instanceof NextLevel) {
            NextLevel nextLevel = (NextLevel)level;
            throttleLevelState = this.pushForward(nextLevel, stateId, ec);
        } else if (TrashLevel$.MODULE$.equals(level)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Level({}):Received job for {}.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), TrashLevel$.MODULE$.getClass().getSimpleName()});
            }
            throttleLevelState = new ThrottleLevelState.Sleeping(ThrottleLevelState$.MODULE$.longSleep(), stateId);
        } else {
            throw new MatchError((Object)level);
        }
        return throttleLevelState;
    }

    public ThrottleLevelState pushForward(LevelZero zero, long stateId) {
        ThrottleLevelState throttleLevelState;
        Option<NextLevel> option = zero.nextLevel();
        if (option instanceof Some) {
            NextLevel nextLevel = (NextLevel)((Some)option).value();
            throttleLevelState = this.pushForward(zero, nextLevel, stateId);
        } else if (None$.MODULE$.equals(option)) {
            throttleLevelState = new ThrottleLevelState.Sleeping(ThrottleLevelState$.MODULE$.longSleep(), stateId);
        } else {
            throw new MatchError(option);
        }
        return throttleLevelState;
    }

    public ThrottleLevelState pushForward(LevelZero zero, NextLevel nextLevel, long stateId) {
        ThrottleLevelState throttleLevelState;
        Option<Map<SliceOption<Object>, MemoryOption, Slice<Object>, Memory>> option = zero.maps().lastOption();
        if (option instanceof Some) {
            Map map = (Map)((Some)option).value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): Pushing LevelZero map :{} ", new Object[]{BoxesRunTime.boxToInteger((int)zero.levelNumber()), map.pathOption()});
            }
            throttleLevelState = this.pushForward(zero, nextLevel, stateId, map);
        } else if (None$.MODULE$.equals(option)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): NO LAST MAP. No more maps to merge.", (Object)BoxesRunTime.boxToInteger((int)zero.levelNumber()));
            }
            throttleLevelState = new ThrottleLevelState.Sleeping(zero.levelZeroMeter().mapsCount() == 1 ? ThrottleLevelState$.MODULE$.longSleep() : zero.nextCompactionDelay().fromNow(), stateId);
        } else {
            throw new MatchError(option);
        }
        return throttleLevelState;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ThrottleLevelState pushForward(LevelZero zero, NextLevel nextLevel, long stateId, Map<SliceOption<Object>, MemoryOption, Slice<Object>, Memory> map) {
        IO iO;
        void var6_11;
        boolean bl = false;
        IO.Right right = null;
        IO<Promise<BoxedUnit>, IO<Error.Level, Set<Object>>> iO2 = nextLevel.put(map);
        if (iO2 instanceof IO.Right) {
            bl = true;
            right = (IO.Right)iO2;
            if ((IO)right.value() instanceof IO.Right) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Level({}): Put to map successful.", (Object)BoxesRunTime.boxToInteger((int)zero.levelNumber()));
                }
                zero.maps().removeLast().foreach((Function1 & Serializable)result -> result.onLeftSideEffect((Function1 & Serializable)error -> {
                    ThrottleCompaction$.$anonfun$pushForward$2(zero, error);
                    return BoxedUnit.UNIT;
                }));
                ThrottleLevelState.Sleeping sleeping = new ThrottleLevelState.Sleeping(zero.levelZeroMeter().mapsCount() == 1 ? ThrottleLevelState$.MODULE$.longSleep() : zero.nextCompactionDelay().fromNow(), stateId);
                return var6_11;
            }
        }
        if (bl && (iO = (IO)right.value()) instanceof IO.Left) {
            Error.Level error = (Error.Level)((IO.Left)iO).value();
            if (Error.OverlappingPushSegment$.MODULE$.equals(error)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(23).append("Level(").append(zero.levelNumber()).append("): Failed to push").toString(), (Object)StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(Error.OverlappingPushSegment$.MODULE$.getClass().getSimpleName()), 1));
                }
            } else if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(23).append("Level(").append(zero.levelNumber()).append("): Failed to push").toString(), error.exception());
            }
            ThrottleLevelState.Sleeping sleeping = new ThrottleLevelState.Sleeping(zero.levelZeroMeter().mapsCount() == 1 ? ThrottleLevelState$.MODULE$.longSleep() : zero.nextCompactionDelay().fromNow(), stateId);
            return var6_11;
        }
        if (!(iO2 instanceof IO.Left)) throw new MatchError(iO2);
        Promise promise = (Promise)((IO.Left)iO2).value();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Level({}): Awaiting pull. stateId: {}.", new Object[]{BoxesRunTime.boxToInteger((int)zero.levelNumber()), BoxesRunTime.boxToLong((long)stateId)});
        }
        ThrottleLevelState.AwaitingPull awaitingPull = new ThrottleLevelState.AwaitingPull((Promise<BoxedUnit>)promise, this.awaitPullTimeout().fromNow(), stateId);
        return var6_11;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ThrottleLevelState pushForward(NextLevel level, long stateId, ExecutionContext ec) {
        void var5_12;
        boolean bl = false;
        IO.Right right = null;
        IO<Promise<BoxedUnit>, IO<Error.Level, Object>> iO = this.pushForward(level, RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(level.nextThrottlePushCount()), 1), ec);
        if (iO instanceof IO.Right) {
            bl = true;
            right = (IO.Right)iO;
            IO iO2 = (IO)right.value();
            if (iO2 instanceof IO.Right) {
                int pushed = BoxesRunTime.unboxToInt((Object)((IO.Right)iO2).value());
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Level({}): pushed {} Segments.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), BoxesRunTime.boxToInteger((int)pushed)});
                }
                ThrottleLevelState.Sleeping sleeping = new ThrottleLevelState.Sleeping(level.isEmpty() ? ThrottleLevelState$.MODULE$.longSleep() : level.nextCompactionDelay().fromNow(), stateId);
                return var5_12;
            }
        }
        if (bl && (IO)right.value() instanceof IO.Left) {
            ThrottleLevelState.Sleeping sleeping = new ThrottleLevelState.Sleeping(level.isEmpty() ? ThrottleLevelState$.MODULE$.longSleep() : ThrottleLevelState$.MODULE$.failureSleepDuration().min(level.nextCompactionDelay()).fromNow(), stateId);
            return var5_12;
        }
        if (!(iO instanceof IO.Left)) throw new MatchError(iO);
        Promise promise = (Promise)((IO.Left)iO).value();
        ThrottleLevelState.AwaitingPull awaitingPull = new ThrottleLevelState.AwaitingPull((Promise<BoxedUnit>)promise, this.awaitPullTimeout().fromNow(), stateId);
        return var5_12;
    }

    /*
     * WARNING - void declaration
     */
    private IO<Promise<BoxedUnit>, IO<Error.Level, Object>> pushForward(NextLevel level, int segmentsToPush, ExecutionContext ec) {
        IO.Right right;
        Option<NextLevel> option = level.nextLevel();
        if (option instanceof Some) {
            void var9_8;
            void var8_7;
            NextLevel nextLevel = (NextLevel)((Some)option).value();
            Tuple2<Iterable<Segment>, Iterable<Segment>> tuple2 = level.optimalSegmentsPushForward(segmentsToPush);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Iterable copyable = (Iterable)tuple2._1();
            Iterable mergeable = (Iterable)tuple2._2();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): copyable: {}, mergeable: {} ", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), BoxesRunTime.boxToInteger((int)var8_7.size()), BoxesRunTime.boxToInteger((int)var9_8.size())});
            }
            IO.ExceptionHandler$.PromiseUnit$ promise = IO.ExceptionHandler$.PromiseUnit$.MODULE$;
            right = this.putForward((Iterable<Segment>)var8_7, level, nextLevel).flatMap(arg_0 -> ThrottleCompaction$.$anonfun$pushForward$7(segmentsToPush, promise, (Iterable)var9_8, level, nextLevel, arg_0), (IO.ExceptionHandler)promise);
        } else if (None$.MODULE$.equals(option)) {
            right = new IO.Right(this.runLastLevelCompaction(level, true, segmentsToPush, 0, ec), (IO.ExceptionHandler)IO.ExceptionHandler$.PromiseUnit$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    public IO<Error.Level, Object> runLastLevelCompaction(NextLevel level, boolean checkExpired, int remainingCompactions, int segmentsCompacted, ExecutionContext ec) {
        IO<Promise<BoxedUnit>, IO<Error.Level, Object>> iO;
        while (true) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): Last level compaction. checkExpired = {}. remainingCompactions = {}. segmentsCompacted = {}.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), BoxesRunTime.boxToBoolean((boolean)checkExpired), BoxesRunTime.boxToInteger((int)remainingCompactions), BoxesRunTime.boxToInteger((int)segmentsCompacted)});
            }
            if (level.hasNextLevel() || remainingCompactions <= 0) {
                return new IO.Right((Object)BoxesRunTime.boxToInteger((int)segmentsCompacted), (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
            }
            if (checkExpired) {
                Segment segment;
                SegmentOption segmentOption;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Level({}): checking expired.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
                }
                if ((segmentOption = Segment$.MODULE$.getNearestDeadlineSegment(level.segmentsInLevel())) instanceof Segment && (segment = (Segment)segmentOption).nearestPutDeadline().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ThrottleCompaction$.$anonfun$runLastLevelCompaction$1(x$7)))) {
                    boolean bl = false;
                    IO.Right right = null;
                    IO<Promise<BoxedUnit>, IO<Error.Level, BoxedUnit>> iO2 = level.refresh(segment);
                    if (iO2 instanceof IO.Right) {
                        bl = true;
                        right = (IO.Right)iO2;
                        if ((IO)right.value() instanceof IO.Right) {
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug("Level({}): Refresh successful.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
                            }
                            ++segmentsCompacted;
                            --remainingCompactions;
                            continue;
                        }
                    }
                    if (iO2 instanceof IO.Left) {
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Level({}): Later on refresh.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
                        }
                        checkExpired = false;
                        continue;
                    }
                    if (bl && (IO)right.value() instanceof IO.Left) {
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Level({}): Later on refresh 2.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
                        }
                        checkExpired = false;
                        continue;
                    }
                    throw new MatchError(iO2);
                }
                boolean bl = Segment$Null$.MODULE$.equals(segmentOption) ? true : segmentOption instanceof Segment;
                if (bl) {
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Level({}): Check expired complete.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
                    }
                    checkExpired = false;
                    continue;
                }
                throw new MatchError((Object)segmentOption);
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): Collapse run.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
            }
            boolean bl = false;
            IO.Right right = null;
            iO = level.collapse(level.optimalSegmentsToCollapse(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(remainingCompactions), 2)));
            if (iO instanceof IO.Right) {
                bl = true;
                right = (IO.Right)iO;
                IO iO3 = (IO)right.value();
                if (iO3 instanceof IO.Right) {
                    int count = BoxesRunTime.unboxToInt((Object)((IO.Right)iO3).value());
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Level({}): Collapsed {} small segments.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), BoxesRunTime.boxToInteger((int)count)});
                    }
                    int n = count == 0 ? 0 : remainingCompactions - count;
                    segmentsCompacted += count;
                    remainingCompactions = n;
                    continue;
                }
            }
            if (iO instanceof IO.Left) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Level({}): Later on collapse.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
                }
                remainingCompactions = 0;
                continue;
            }
            if (!bl || !((IO)right.value() instanceof IO.Left)) break;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): Later on collapse 2.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
            }
            remainingCompactions = 0;
        }
        throw new MatchError(iO);
    }

    public int copyForwardForEach(Slice<LevelRef> levels) {
        return BoxesRunTime.unboxToInt((Object)levels.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)ThrottleCompaction$.$anonfun$copyForwardForEach$1(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
    }

    /*
     * Unable to fully structure code
     */
    private int copyForward(NextLevel level) {
        block14: {
            block13: {
                var4_2 = level.nextLevel();
                if (!(var4_2 instanceof Some)) break block13;
                nextLevel = (NextLevel)((Some)var4_2).value();
                var7_5 = nextLevel.partitionUnreservedCopyable(segmentsInLevel = level.segmentsInLevel());
                if (var7_5 == null) {
                    throw new MatchError(null);
                }
                copyable = (Iterable)var7_5._1();
                nonCopyable = (Iterable)var7_5._2();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Level({}): Total segments: {}, Can copy: {} segments. Remaining: {} segments.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), BoxesRunTime.boxToInteger((int)segmentsInLevel.size()), BoxesRunTime.boxToInteger((int)var8_6.size()), BoxesRunTime.boxToInteger((int)var9_7.size())});
                }
                var10_8 = false;
                var11_9 = null;
                var12_10 = this.putForward((Iterable<Segment>)var8_6, level, nextLevel);
                if (!(var12_10 instanceof IO.Right)) ** GOTO lbl-1000
                var10_8 = true;
                var11_9 = (IO.Right)var12_10;
                var13_11 = (IO)var11_9.value();
                if (var13_11 instanceof IO.Right) {
                    copied = BoxesRunTime.unboxToInt((Object)((IO.Right)var13_11).value());
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Level({}): Forward copied {} Segments.", new Object[]{BoxesRunTime.boxToInteger((int)level.levelNumber()), BoxesRunTime.boxToInteger((int)copied)});
                    }
                    var3_13 = copied;
                } else if (var10_8 && (var15_14 = (IO)var11_9.value()) instanceof IO.Left) {
                    error = (Error.Level)((IO.Left)var15_14).value();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(38).append("Level(").append(level.levelNumber()).append("): Failed copy Segments forward.").toString(), error.exception());
                    }
                    var3_13 = 0;
                } else if (var12_10 instanceof IO.Left) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Level({}): Received later compaction.", (Object)BoxesRunTime.boxToInteger((int)level.levelNumber()));
                    }
                    var3_13 = 0;
                } else {
                    throw new MatchError(var12_10);
                }
                var2_16 = var3_13;
                break block14;
            }
            if (None$.MODULE$.equals(var4_2)) {
                var2_16 = 0;
            } else {
                throw new MatchError(var4_2);
            }
        }
        return var2_16;
    }

    public IO<Promise<BoxedUnit>, IO<Error.Level, Object>> putForward(Iterable<Segment> segments, NextLevel thisLevel, NextLevel nextLevel) {
        if (segments.isEmpty()) {
            return IO$.MODULE$.zeroZero();
        }
        return nextLevel.put(segments).map((Function1 & Serializable)x0$1 -> {
            IO iO;
            if (x0$1 instanceof IO.Right) {
                iO = thisLevel.removeSegments(segments).transform((Function1)(JFunction1.mcII.sp & Serializable)x$9 -> segments.size()).recover((PartialFunction)new Serializable(segments){
                    private static final long serialVersionUID = 0L;
                    private final Iterable segments$1;

                    public final <A1 extends Error.Level, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        return (B1)BoxesRunTime.boxToInteger((int)this.segments$1.size());
                    }

                    public final boolean isDefinedAt(Error.Level x1) {
                        return true;
                    }
                    {
                        this.segments$1 = segments$1;
                    }
                });
            } else if (x0$1 instanceof IO.Left) {
                Error.Level error = (Error.Level)((IO.Left)x0$1).value();
                iO = new IO.Left((Object)error, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
            } else {
                throw new MatchError(x0$1);
            }
            return iO;
        });
    }

    public static final /* synthetic */ void $anonfun$pushForward$2(LevelZero zero$1, IO.Left error) {
        String mapPath = (String)zero$1.maps().lastOption().map((Function1 & Serializable)x$2 -> (String)x$2.pathOption().map((Function1 & Serializable)x$3 -> ((Object)x$3).toString()).getOrElse((Function0 & Serializable)() -> "No path")).getOrElse((Function0 & Serializable)() -> "No map");
        if (MODULE$.logger().underlying().isErrorEnabled()) {
            MODULE$.logger().underlying().error(new StringBuilder(261).append(new StringBuilder(90).append("Failed to delete the oldest memory map '").append(mapPath).append("'. The map is added back to the memory-maps queue.").toString()).append("No more maps will be pushed to Level1 until this error is fixed ").append("as sequential conversion of memory-map files to Segments is required to maintain data accuracy. ").append("Please check file system permissions and ensure that SwayDB can delete files and reboot the database.").toString(), error.exception());
        }
    }

    public static final /* synthetic */ IO $anonfun$pushForward$7(int segmentsToPush$1, IO.ExceptionHandler$.PromiseUnit$ promise$1, Iterable mergeable$1, NextLevel level$2, NextLevel nextLevel$1, IO x0$1) {
        IO.Right right;
        if (x0$1 instanceof IO.Right) {
            int copied = BoxesRunTime.unboxToInt((Object)((IO.Right)x0$1).value());
            right = copied >= segmentsToPush$1 ? new IO.Right((Object)new IO.Right((Object)BoxesRunTime.boxToInteger((int)copied), (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$), (IO.ExceptionHandler)promise$1) : MODULE$.putForward((Iterable<Segment>)((Iterable)mergeable$1.take(segmentsToPush$1)), level$2, nextLevel$1).transform((Function1 & Serializable)x$5 -> x$5.transform((Function1)(JFunction1.mcII.sp & Serializable)x$6 -> x$6 + copied));
        } else if (x0$1 instanceof IO.Left) {
            Error.Level error = (Error.Level)((IO.Left)x0$1).value();
            right = new IO.Right((Object)new IO.Left((Object)error, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$), (IO.ExceptionHandler)promise$1);
        } else {
            throw new MatchError((Object)x0$1);
        }
        return right;
    }

    public static final /* synthetic */ boolean $anonfun$runLastLevelCompaction$1(Deadline x$7) {
        return !x$7.hasTimeLeft();
    }

    public static final /* synthetic */ int $anonfun$copyForwardForEach$1(int x0$1, LevelRef x1$1) {
        int n;
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (x1$1 instanceof NextLevel) {
            NextLevel nextLevel = (NextLevel)x1$1;
            int copied = MODULE$.copyForward(nextLevel);
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Level({}): Compaction copied {}.", new Object[]{BoxesRunTime.boxToInteger((int)nextLevel.levelNumber()), BoxesRunTime.boxToInteger((int)copied)});
            }
            n = x0$1 + copied;
        } else {
            boolean bl = TrashLevel$.MODULE$.equals(x1$1) ? true : x1$1 instanceof LevelZero;
            if (bl) {
                n = x0$1;
            } else {
                throw new MatchError((Object)tuple2);
            }
        }
        return n;
    }

    private ThrottleCompaction$() {
    }

    public static final /* synthetic */ Object $anonfun$runJobs$2$adapted(LevelRef level$1, long stateId$1, ThrottleLevelState state) {
        return BoxesRunTime.boxToBoolean((boolean)ThrottleCompaction$.MODULE$.shouldRun(level$1, stateId$1, state));
    }
}

