/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.level.compaction.throttle;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.TimerTask;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordered;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;
import swaydb.ActorWire;
import swaydb.Bag;
import swaydb.Bag$;
import swaydb.Error;
import swaydb.IO;
import swaydb.Scheduler;
import swaydb.core.level.LevelRef;
import swaydb.core.level.LevelRef$;
import swaydb.core.level.NextLevel;
import swaydb.core.level.compaction.Compaction;
import swaydb.core.level.compaction.Compactor;
import swaydb.core.level.compaction.throttle.ThrottleCompaction$;
import swaydb.core.level.compaction.throttle.ThrottleLevelState;
import swaydb.core.level.compaction.throttle.ThrottleState;
import swaydb.core.level.zero.LevelZero;
import swaydb.core.util.FiniteDurations;
import swaydb.core.util.FiniteDurations$;
import swaydb.data.compaction.CompactionExecutionContext;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.util.Futures$;

public final class ThrottleCompactor$
implements Compactor<ThrottleState>,
LazyLogging {
    public static final ThrottleCompactor$ MODULE$ = new ThrottleCompactor$();
    private static final Random random;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        random = new Random();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private Random random() {
        return random;
    }

    public boolean forwardCopyOnAllLevelsRandomly() {
        return this.random().nextDouble() <= 0.1;
    }

    /*
     * WARNING - void declaration
     */
    public IO<Error.Level, ActorWire<Compactor<ThrottleState>, ThrottleState>> createActor(List<LevelRef> levels, List<CompactionExecutionContext> executionContexts) {
        void IterableIOImplicit_evidence$8;
        void IterableIOImplicit_evidence$7;
        IO.IterableIOImplicit iterableIOImplicit;
        if (levels.size() != executionContexts.size()) {
            return new IO.Left((Object)new Error.Fatal((Throwable)new IllegalStateException(new StringBuilder(68).append("Number of ExecutionContexts(").append(executionContexts.size()).append(") is not the same as number of Levels(").append(levels.size()).append(").").toString())), (IO.ExceptionHandler)Error.Fatal$.ExceptionHandler$.MODULE$);
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(Tuple2.class);
        Error.Level$.ExceptionHandler$ exceptionHandler$ = Error.Level$.ExceptionHandler$.MODULE$;
        Iterable IterableIOImplicit_iterable = (Iterable)levels.zip(executionContexts);
        IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit(IterableIOImplicit_iterable, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        Object var8_5 = null;
        exceptionHandler$ = null;
        classTag = null;
        iterableIOImplicit = null;
        IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
        ListBuffer x$1 = ListBuffer$.MODULE$.empty();
        boolean x$2 = qual$1.foldLeftRecoverIO$default$2();
        Function2 x$3 = qual$1.foldLeftRecoverIO$default$3();
        Function2 & Serializable x$4 = (Function2 & Serializable)(x0$1, x1$1) -> {
            IO.Left left;
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (x1$1 != null) {
                LevelRef level = (LevelRef)x1$1._1();
                CompactionExecutionContext compactionExecutionContext = (CompactionExecutionContext)x1$1._2();
                if (compactionExecutionContext instanceof CompactionExecutionContext.Create) {
                    ExecutionContext executionContext = ((CompactionExecutionContext.Create)compactionExecutionContext).executionContext();
                    x0$1.$plus$eq((Object)new Tuple2(ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LevelRef[]{level})), (Object)executionContext));
                    return new IO.Right(x0$1, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
                }
            }
            if (x1$1 == null) throw new MatchError((Object)tuple22);
            LevelRef level = (LevelRef)x1$1._1();
            CompactionExecutionContext compactionExecutionContext = (CompactionExecutionContext)x1$1._2();
            if (!CompactionExecutionContext.Shared$.MODULE$.equals(compactionExecutionContext)) throw new MatchError((Object)tuple22);
            Option option = x0$1.lastOption();
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                ((ListBuffer)tuple2._1()).$plus$eq((Object)level);
                left = new IO.Right(x0$1, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
                return left;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                left = new IO.Left((Object)new Error.Fatal((Throwable)new IllegalStateException("Shared ExecutionContext submitted without Create.")), (IO.ExceptionHandler)Error.Fatal$.ExceptionHandler$.MODULE$);
            }
            return left;
        };
        return qual$1.foldLeftRecoverIO((Object)x$1, x$2, x$3, (Function2)x$4).map((Function1 & Serializable)jobs -> (ActorWire)Option$.MODULE$.option2Iterable((Option)jobs.foldRight((Object)Option$.MODULE$.empty(), (Function2 & Serializable)(x0$2, x1$2) -> {
            void wire_scheduler;
            void apply_evidence$4;
            void apply_data;
            Slice slice;
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (x0$2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ListBuffer jobs = (ListBuffer)x0$2._1();
            ExecutionContext executionContext = (ExecutionContext)x0$2._2();
            Map statesMap = (Map)Map$.MODULE$.empty();
            ClassTag classTag = ClassTag$.MODULE$.apply(LevelRef.class);
            Object object = jobs.toArray(ClassTag$.MODULE$.apply(LevelRef.class));
            Slice$ apply_this = Slice$.MODULE$;
            Slice slice2 = slice = SliceCompanionBase.apply$((SliceCompanionBase)apply_this, (Object)apply_data, (ClassTag)apply_evidence$4);
            Object var9_8 = null;
            object = null;
            classTag = null;
            slice = null;
            Slice x$5 = slice2;
            ThrottleState state = new ThrottleState((Slice<LevelRef>)x$5, (Option<ActorWire<Compactor<ThrottleState>, ThrottleState>>)x1$2, executionContext, (Map<LevelRef, ThrottleLevelState>)statesMap);
            Scheduler scheduler = state.scheduler();
            ThrottleCompactor$ wire_impl = MODULE$;
            Object var13_13 = null;
            scheduler = null;
            Some some = new Some((Object)new ActorWire((Object)wire_impl, (Option)None$.MODULE$, (Object)state, (Scheduler)wire_scheduler));
            return some;
        })).head());
    }

    public void scheduleNextWakeUp(ThrottleState state, ActorWire<Compactor<ThrottleState>, ThrottleState> self) {
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: scheduling next wakeup for updated state: {}. Current scheduled: {}", new Object[]{state.name(), BoxesRunTime.boxToInteger((int)state.levels().size()), state.sleepTask().map((Function1 & Serializable)x$1 -> {
                FiniteDuration FiniteDurationImplicits_duration = ((Deadline)x$1._2()).timeLeft();
                Object var3_1 = null;
                double asString_seconds = (double)new FiniteDurations.FiniteDurationImplicits((Duration)FiniteDurationImplicits_duration).swaydb$core$util$FiniteDurations$FiniteDurationImplicits$$duration.toMillis() / 1000.0;
                return new StringBuilder(8).append(asString_seconds).append(" seconds").toString();
            })});
        }
        Map levelsToCompact = (Map)state.compactionStates().collect((PartialFunction)new Serializable(state){
            private static final long serialVersionUID = 0L;
            private final ThrottleState state$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<LevelRef, ThrottleLevelState>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    LevelRef level = (LevelRef)x1._1();
                    ThrottleLevelState levelState = (ThrottleLevelState)x1._2();
                    if (levelState.stateId() != level.stateId() || this.state$1.sleepTask().isEmpty()) {
                        object = new Tuple2((Object)level, (Object)levelState);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<LevelRef, ThrottleLevelState> x1) {
                if (x1 == null) return false;
                LevelRef level = (LevelRef)x1._1();
                if (((ThrottleLevelState)x1._2()).stateId() != level.stateId()) return true;
                if (!this.state$1.sleepTask().isEmpty()) return false;
                return true;
            }
            {
                this.state$1 = state$1;
            }
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: Levels to compact: \t\n{}", (Object[])new String[]{state.name(), levelsToCompact.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                LevelRef level = (LevelRef)x0$1._1();
                ThrottleLevelState state = (ThrottleLevelState)x0$1._2();
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)level.levelNumber()), (Object)state);
                return tuple2;
            }).mkString("\t\n")});
        }
        Option nextDeadline = (Option)levelsToCompact.foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable)(x0$2, x1$1) -> {
            ThrottleLevelState throttleLevelState;
            Option<Deadline> option;
            ThrottleLevelState waiting;
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (x1$1 != null && (waiting = (ThrottleLevelState)x1$1._2()) instanceof ThrottleLevelState.AwaitingPull) {
                ThrottleLevelState.AwaitingPull awaitingPull = (ThrottleLevelState.AwaitingPull)waiting;
                Promise<BoxedUnit> promise = awaitingPull.promise();
                Deadline timeout = awaitingPull.timeout();
                if (!awaitingPull.listenerInitialised()) {
                    awaitingPull.listenerInitialised_$eq(true);
                    promise.future().foreach((Function1 & Serializable)x$2 -> {
                        ThrottleCompactor$.$anonfun$scheduleNextWakeUp$4(state, awaitingPull, self, x$2);
                        return BoxedUnit.UNIT;
                    }, self.ec());
                } else if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("{}: listener already initialised.", (Object)state.name());
                }
                option = FiniteDurations$.MODULE$.getNearestDeadline((Option<Deadline>)x0$2, (Option<Deadline>)new Some((Object)timeout));
            } else if (x1$1 != null && (throttleLevelState = (ThrottleLevelState)x1$1._2()) instanceof ThrottleLevelState.Sleeping) {
                Deadline sleepDeadline = ((ThrottleLevelState.Sleeping)throttleLevelState).sleepDeadline();
                option = FiniteDurations$.MODULE$.getNearestDeadline((Option<Deadline>)x0$2, (Option<Deadline>)new Some((Object)sleepDeadline));
            } else {
                throw new MatchError((Object)tuple2);
            }
            return option;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: Time left for new deadline {}", new Object[]{state.name(), nextDeadline.map((Function1 & Serializable)x$3 -> {
                FiniteDuration FiniteDurationImplicits_duration = x$3.timeLeft();
                Object var3_1 = null;
                double asString_seconds = (double)new FiniteDurations.FiniteDurationImplicits((Duration)FiniteDurationImplicits_duration).swaydb$core$util$FiniteDurations$FiniteDurationImplicits$$duration.toMillis() / 1000.0;
                return new StringBuilder(8).append(asString_seconds).append(" seconds").toString();
            })});
        }
        nextDeadline.foreach((Function1 & Serializable)newWakeUpDeadline -> {
            ThrottleCompactor$.$anonfun$scheduleNextWakeUp$7(state, self, newWakeUpDeadline);
            return BoxedUnit.UNIT;
        });
    }

    public void wakeUpChild(ThrottleState state) {
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: Waking up child: {}.", new Object[]{state.name(), state.child().map((Function1 & Serializable)x$6 -> "child")});
        }
        state.child().foreach((Function1 & Serializable)child -> {
            ThrottleCompactor$.MODULE$.sendWakeUp(ThrottleCompactor$.MODULE$.forwardCopyOnAllLevelsRandomly(), (ActorWire<Compactor<ThrottleState>, ThrottleState>)child);
            return BoxedUnit.UNIT;
        });
    }

    public <T> void postCompaction(ThrottleState state, ActorWire<Compactor<ThrottleState>, ThrottleState> self) {
        try {
            this.scheduleNextWakeUp(state, self);
        }
        finally {
            this.wakeUpChild(state);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendWakeUp(boolean forwardCopyOnAllLevels, ActorWire<Compactor<ThrottleState>, ThrottleState> compactor) {
        void send_function;
        Function3 & Serializable intersect = (Function3 & Serializable)(impl, state, self) -> {
            impl.wakeUp(state, forwardCopyOnAllLevels, self);
            return BoxedUnit.UNIT;
        };
        if (compactor == null) {
            throw null;
        }
        compactor.swaydb$ActorWire$$actor().send((arg_0, arg_1) -> ActorWire.$anonfun$send$2$adapted(compactor, (Function3)send_function, arg_0, arg_1));
    }

    public IO<Error.Level, ActorWire<Compactor<ThrottleState>, ThrottleState>> createCompactor(LevelZero zero, List<CompactionExecutionContext> executionContexts) {
        IO<Error.Level, ActorWire<Compactor<ThrottleState>, ThrottleState>> iO;
        Option<NextLevel> option = zero.nextLevel();
        if (option instanceof Some) {
            NextLevel nextLevel = (NextLevel)((Some)option).value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Level({}): Creating actor.", (Object)BoxesRunTime.boxToInteger((int)zero.levelNumber()));
            }
            iO = this.createActor((List<LevelRef>)((List)LevelRef$.MODULE$.getLevels(nextLevel).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isTrash())).$plus$colon((Object)zero)), executionContexts);
        } else if (None$.MODULE$.equals(option)) {
            iO = new IO<Error.Level, ActorWire<Compactor<ThrottleState>, ThrottleState>>((Object)new Error.Fatal((Throwable)new Exception("Compaction not started because there is no lower level.")), (IO.ExceptionHandler)Error.Fatal$.ExceptionHandler$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return iO;
    }

    public void listen(LevelZero zero, ActorWire<Compactor<ThrottleState>, ThrottleState> actor) {
        zero.onNextMapCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.sendWakeUp(false, actor));
    }

    public IO<Error.Level, ActorWire<Compactor<ThrottleState>, ThrottleState>> doCreateAndListen(LevelZero zero, List<CompactionExecutionContext> executionContexts) {
        return this.createCompactor(zero, executionContexts).map((Function1 & Serializable)compactor -> {
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Level({}): Initialising listener.", (Object)BoxesRunTime.boxToInteger((int)zero.levelNumber()));
            }
            MODULE$.listen(zero, (ActorWire<Compactor<ThrottleState>, ThrottleState>)compactor);
            return compactor;
        });
    }

    public void doWakeUp(ThrottleState state, boolean forwardCopyOnAllLevels, ActorWire<Compactor<ThrottleState>, ThrottleState> self, Compaction<ThrottleState> compaction) {
        try {
            compaction.run(state, forwardCopyOnAllLevels);
        }
        finally {
            this.postCompaction(state, self);
        }
    }

    @Override
    public IO<Error.Level, ActorWire<Compactor<ThrottleState>, ThrottleState>> createAndListen(LevelZero zero, List<CompactionExecutionContext> executionContexts) {
        return this.doCreateAndListen(zero, executionContexts);
    }

    @Override
    public void wakeUp(ThrottleState state, boolean forwardCopyOnAllLevels, ActorWire<Compactor<ThrottleState>, ThrottleState> self) {
        this.doWakeUp(state, forwardCopyOnAllLevels, self, ThrottleCompaction$.MODULE$);
    }

    @Override
    public Future<BoxedUnit> terminate(ThrottleState state, ActorWire<Compactor<ThrottleState>, ThrottleState> compactor) {
        Future future;
        Bag$.anon.17 var8_4;
        ExecutionContext future_ec = state.executionContext();
        Bag$.anon.17 v0 = var8_4 = new /* Unavailable Anonymous Inner Class!! */;
        Object var7_3 = null;
        var8_4 = null;
        Bag$.anon.17 tag = v0;
        Option<ActorWire<Compactor<ThrottleState>, ThrottleState>> option = state.child();
        if (option instanceof Some) {
            future = (Future)((ActorWire)((Some)option).value()).ask().flatMap((Function3 & Serializable)(impl, childState, childActor) -> impl.terminate(childState, childActor), (Bag.Async)tag);
        } else if (None$.MODULE$.equals(option)) {
            future = Futures$.MODULE$.unit();
        } else {
            throw new MatchError(option);
        }
        ExecutionContext ec = compactor.ec();
        return future.map((Function1 & Serializable)x$8 -> {
            ThrottleCompactor$.$anonfun$terminate$2(compactor, state, x$8);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public static final /* synthetic */ void $anonfun$scheduleNextWakeUp$5(Compactor impl, ThrottleState state, ActorWire self) {
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("{}: Wake up executed.", (Object)state.name());
        }
        impl.wakeUp(state, MODULE$.forwardCopyOnAllLevelsRandomly(), self);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$scheduleNextWakeUp$4(ThrottleState state$1, ThrottleLevelState.AwaitingPull x4$1, ActorWire self$1, BoxedUnit x$2) {
        void send_function;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("{}: received pull request. Sending wakeUp now.", (Object)state$1.name());
        }
        x4$1.listenerInvoked_$eq(true);
        Function3 & Serializable intersect = (Function3 & Serializable)(impl, state, self) -> {
            ThrottleCompactor$.$anonfun$scheduleNextWakeUp$5(impl, state, self);
            return BoxedUnit.UNIT;
        };
        if (self$1 == null) {
            throw null;
        }
        self$1.swaydb$ActorWire$$actor().send((arg_0, arg_1) -> ActorWire.$anonfun$send$2$adapted((ActorWire)self$1, (Function3)send_function, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$scheduleNextWakeUp$8(Deadline newWakeUpDeadline$1, Tuple2 x$4) {
        return ((Ordered)x$4._2()).$greater((Object)newWakeUpDeadline$1);
    }

    public static final /* synthetic */ boolean $anonfun$scheduleNextWakeUp$9(Tuple2 x$5) {
        return ((TimerTask)x$5._1()).cancel();
    }

    public static final /* synthetic */ void $anonfun$scheduleNextWakeUp$10(ActorWire self$1, Compactor impl, ThrottleState state) {
        state.sleepTask_$eq((Option<Tuple2<TimerTask, Deadline>>)None$.MODULE$);
        impl.wakeUp(state, MODULE$.forwardCopyOnAllLevelsRandomly(), self$1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$scheduleNextWakeUp$7(ThrottleState state$1, ActorWire self$1, Deadline newWakeUpDeadline) {
        if (state$1.sleepTask().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ThrottleCompactor$.$anonfun$scheduleNextWakeUp$8(newWakeUpDeadline, x$4)))) {
            void send_delay;
            void send_function;
            TimerTask timerTask;
            state$1.sleepTask().foreach((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ThrottleCompactor$.$anonfun$scheduleNextWakeUp$9(x$5)));
            Function2 & Serializable intersect = (Function2 & Serializable)(impl, state) -> {
                ThrottleCompactor$.$anonfun$scheduleNextWakeUp$10(self$1, impl, state);
                return BoxedUnit.UNIT;
            };
            FiniteDuration finiteDuration = newWakeUpDeadline.timeLeft();
            if (self$1 == null) {
                throw null;
            }
            TimerTask timerTask2 = timerTask = self$1.swaydb$ActorWire$$actor().send((arg_0, arg_1) -> ActorWire.$anonfun$send$3$adapted((Function2)send_function, arg_0, arg_1), (FiniteDuration)send_delay, self$1.scheduler());
            finiteDuration = null;
            intersect = null;
            timerTask = null;
            TimerTask newTask = timerTask2;
            state$1.sleepTask_$eq((Option<Tuple2<TimerTask, Deadline>>)new Some((Object)new Tuple2((Object)newTask, (Object)newWakeUpDeadline)));
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                Object[] objectArray = new String[2];
                objectArray[0] = state$1.name();
                FiniteDuration FiniteDurationImplicits_duration = newWakeUpDeadline.timeLeft();
                Object var9_7 = null;
                double asString_seconds = (double)new FiniteDurations.FiniteDurationImplicits((Duration)FiniteDurationImplicits_duration).swaydb$core$util$FiniteDurations$FiniteDurationImplicits$$duration.toMillis() / 1000.0;
                objectArray[1] = new StringBuilder(8).append(asString_seconds).append(" seconds").toString();
                MODULE$.logger().underlying().debug("{}: Next wakeup scheduled!. Current scheduled: {}", objectArray);
                return;
            }
        } else if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("{}: Some or later deadline. Ignoring re-scheduling. Keeping currently scheduled.", (Object)state$1.name());
        }
    }

    public static final /* synthetic */ void $anonfun$terminate$2(ActorWire compactor$1, ThrottleState state$2, BoxedUnit x$8) {
        compactor$1.clear();
        state$2.terminateCompaction();
    }

    private ThrottleCompactor$() {
    }
}

