/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.level.compaction.throttle;

import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import swaydb.core.level.Level;
import swaydb.core.level.LevelRef;
import swaydb.core.level.TrashLevel$;
import swaydb.core.level.compaction.throttle.ThrottleLevelState;
import swaydb.core.level.zero.LevelZero;
import swaydb.data.compaction.Throttle;

public final class ThrottleLevelOrdering$ {
    public static final ThrottleLevelOrdering$ MODULE$ = new ThrottleLevelOrdering$();

    public Ordering<LevelRef> ordering(Function1<LevelRef, ThrottleLevelState> levelState) {
        return new Ordering<LevelRef>(levelState){
            private final Function1 levelState$1;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<LevelRef> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public boolean isReverseOf(Ordering<?> other) {
                return Ordering.isReverseOf$((Ordering)this, other);
            }

            public <U> Ordering<U> on(Function1<U, LevelRef> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering<LevelRef> orElse(Ordering<LevelRef> other) {
                return Ordering.orElse$((Ordering)this, other);
            }

            public <S> Ordering<LevelRef> orElseBy(Function1<LevelRef, S> f, Ordering<S> ord) {
                return Ordering.orElseBy$((Ordering)this, f, ord);
            }

            public Ordering.OrderingOps mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public int compare(LevelRef left, LevelRef right) {
                Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
                if (left instanceof Level) {
                    Level level = (Level)left;
                    if (right instanceof Level) {
                        Level level2 = (Level)right;
                        return ThrottleLevelOrdering$.MODULE$.order(level, level2, (ThrottleLevelState)this.levelState$1.apply((Object)level), (ThrottleLevelState)this.levelState$1.apply((Object)level2));
                    }
                }
                if (left instanceof Level) {
                    Level level = (Level)left;
                    if (right instanceof LevelZero) {
                        LevelZero levelZero = (LevelZero)right;
                        return ThrottleLevelOrdering$.MODULE$.order(levelZero, level, (ThrottleLevelState)this.levelState$1.apply((Object)level), (ThrottleLevelState)this.levelState$1.apply((Object)levelZero)) * -1;
                    }
                }
                if (tuple2 != null && left instanceof Level && TrashLevel$.MODULE$.equals(right)) {
                    return 1;
                }
                if (tuple2 != null && left instanceof LevelZero) {
                    LevelZero levelZero = (LevelZero)left;
                    if (right instanceof Level) {
                        Level level = (Level)right;
                        return ThrottleLevelOrdering$.MODULE$.order(levelZero, level, (ThrottleLevelState)this.levelState$1.apply((Object)levelZero), (ThrottleLevelState)this.levelState$1.apply((Object)level));
                    }
                }
                if (tuple2 != null && left instanceof LevelZero && right instanceof LevelZero) {
                    return 0;
                }
                if (tuple2 != null && left instanceof LevelZero && TrashLevel$.MODULE$.equals(right)) {
                    return 1;
                }
                if (tuple2 != null && TrashLevel$.MODULE$.equals(left) && right instanceof Level) {
                    return -1;
                }
                if (tuple2 != null && TrashLevel$.MODULE$.equals(left) && right instanceof LevelZero) {
                    return -1;
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                if (!TrashLevel$.MODULE$.equals(left)) throw new MatchError((Object)tuple2);
                if (!TrashLevel$.MODULE$.equals(right)) throw new MatchError((Object)tuple2);
                return 0;
            }
            {
                this.levelState$1 = levelState$1;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }

    public int order(LevelZero left, Level right, ThrottleLevelState leftState, ThrottleLevelState rightState) {
        return ((FiniteDuration)left.throttle().apply((Object)left.levelZeroMeter())).compare((Duration)((Throttle)right.throttle().apply((Object)right.meter())).pushDelay());
    }

    public int order(Level left, Level right, ThrottleLevelState leftState, ThrottleLevelState rightState) {
        return ((Throttle)left.throttle().apply((Object)left.meter())).pushDelay().compare((Duration)((Throttle)right.throttle().apply((Object)right.meter())).pushDelay());
    }

    private ThrottleLevelOrdering$() {
    }
}

