/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.level.zero;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentLinkedDeque;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.Tuple7;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import swaydb.Error;
import swaydb.IO;
import swaydb.core.actor.FileSweeper$Disabled$;
import swaydb.core.data.Memory;
import swaydb.core.data.Memory$Null$;
import swaydb.core.data.MemoryOption;
import swaydb.core.function.FunctionStore;
import swaydb.core.io.file.Effect$;
import swaydb.core.level.LevelRef$;
import swaydb.core.level.NextLevel;
import swaydb.core.level.zero.LevelZero;
import swaydb.core.level.zero.LevelZeroSkipListMerger$;
import swaydb.core.map.Map$;
import swaydb.core.map.MapEntry;
import swaydb.core.map.Maps;
import swaydb.core.map.Maps$;
import swaydb.core.map.serializer.LevelZeroMapEntryReader$Level0Reader$;
import swaydb.core.map.serializer.LevelZeroMapEntryWriter$Level0MapEntryPutWriter$;
import swaydb.core.map.serializer.MapEntryReader;
import swaydb.core.map.serializer.MapEntryWriter;
import swaydb.core.map.serializer.TimerMapEntryReader$TimerPutMapEntryReader$;
import swaydb.core.map.serializer.TimerMapEntryWriter$TimerPutMapEntryWriter$;
import swaydb.core.map.timer.EmptyTimer$;
import swaydb.core.map.timer.MemoryTimer$;
import swaydb.core.map.timer.PersistentTimer;
import swaydb.core.map.timer.PersistentTimer$;
import swaydb.core.map.timer.Timer;
import swaydb.core.segment.format.a.entry.reader.PersistentReader$;
import swaydb.data.accelerate.Accelerator;
import swaydb.data.accelerate.LevelZeroMeter;
import swaydb.data.config.RecoveryMode;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.KeyOrder$;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;
import swaydb.data.slice.SliceOption;
import swaydb.data.storage.Level0Storage;
import swaydb.data.util.StorageUnits;

public final class LevelZero$
implements LazyLogging,
Serializable {
    public static final LevelZero$ MODULE$ = new LevelZero$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public IO<Error.Level, LevelZero> apply(long mapSize, Level0Storage storage, boolean enableTimer, boolean cacheKeyValueIds, Option<NextLevel> nextLevel, Function1<LevelZeroMeter, Accelerator> acceleration, Function1<LevelZeroMeter, FiniteDuration> throttle, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore) {
        IO iO;
        if (cacheKeyValueIds) {
            PersistentReader$.MODULE$.populateBaseEntryIds();
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("cacheKeyValueIds is false. Key-value IDs cache disabled!");
        }
        FileSweeper$Disabled$ fileSweeper = FileSweeper$Disabled$.MODULE$;
        LevelZeroSkipListMerger$ skipListMerger = LevelZeroSkipListMerger$.MODULE$;
        if (storage instanceof Level0Storage.Persistent) {
            IO<Error.Map, PersistentTimer> iO2;
            Level0Storage.Persistent persistent = (Level0Storage.Persistent)storage;
            boolean mmap = persistent.mmap();
            Path databaseDirectory = persistent.dir();
            RecoveryMode recovery = persistent.recovery();
            if (enableTimer) {
                void persistent_reader;
                void persistent_writer;
                void persistent_keyOrder;
                void persistent_flushCheckpointSize;
                Path timerDir = databaseDirectory.resolve("0").resolve("timer");
                Effect$.MODULE$.createDirectoriesIfAbsent(timerDir);
                double StorageDoubleImplicits_measure = 1.0;
                TimerMapEntryReader$TimerPutMapEntryReader$ timerMapEntryReader$TimerPutMapEntryReader$ = TimerMapEntryReader$TimerPutMapEntryReader$.MODULE$;
                TimerMapEntryWriter$TimerPutMapEntryWriter$ timerMapEntryWriter$TimerPutMapEntryWriter$ = TimerMapEntryWriter$TimerPutMapEntryWriter$.MODULE$;
                KeyOrder keyOrder2 = KeyOrder$.MODULE$.default();
                long l = (int)(new StorageUnits.StorageDoubleImplicits((double)StorageDoubleImplicits_measure).swaydb$data$util$StorageUnits$StorageDoubleImplicits$$measure * (double)1000000);
                long persistent_mod = 100000L;
                iO2 = PersistentTimer$.MODULE$.apply(timerDir, mmap, persistent_mod, (long)persistent_flushCheckpointSize, (KeyOrder<Slice<Object>>)persistent_keyOrder, timeOrder, functionStore, (MapEntryWriter<MapEntry.Put<Slice<Object>, Slice<Object>>>)persistent_writer, (MapEntryReader<MapEntry<Slice<Object>, Slice<Object>>>)persistent_reader);
                keyOrder2 = null;
                timerMapEntryWriter$TimerPutMapEntryWriter$ = null;
                timerMapEntryReader$TimerPutMapEntryReader$ = null;
            } else {
                iO2 = new IO<Error.Map, PersistentTimer>((Object)EmptyTimer$.MODULE$, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
            }
            iO = iO2.flatMap((Function1 & Serializable)timer -> {
                IO.Right right;
                Path path = databaseDirectory.resolve("0");
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("{}: Acquiring lock.", (Object)path);
                }
                Path lockFile = path.resolve("LOCK");
                Effect$.MODULE$.createDirectoriesIfAbsent(path);
                Effect$.MODULE$.createFileIfAbsent(lockFile);
                Error.Level$.ExceptionHandler$ apply_evidence$13 = Error.Level$.ExceptionHandler$.MODULE$;
                try {
                    right = new IO.Right((Object)LevelZero$.$anonfun$apply$2(lockFile), (IO.ExceptionHandler)apply_evidence$13);
                }
                catch (Throwable apply_ex) {
                    right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                }
                IO.Right right2 = right;
                Object var14_13 = null;
                Object var15_16 = null;
                right = null;
                return right2.flatMap((Function1 & Serializable)lock -> {
                    if (MODULE$.logger().underlying().isInfoEnabled()) {
                        MODULE$.logger().underlying().info("{}: Recovering Maps.", (Object)path);
                    }
                    Slice.Null$ x$6 = Slice.Null$.MODULE$;
                    Memory$Null$ x$7 = Memory$Null$.MODULE$;
                    return Maps$.MODULE$.persistent(x$6, x$7, path, mmap, mapSize, acceleration, recovery, keyOrder, timeOrder, fileSweeper, functionStore, LevelZeroMapEntryWriter$Level0MapEntryPutWriter$.MODULE$, LevelZeroMapEntryReader$Level0Reader$.MODULE$, skipListMerger, (Timer)timer).map((Function1 & Serializable)maps -> new Tuple3(maps, (Object)path, (Object)new Some(lock)));
                }, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
            }, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
        } else if (Level0Storage.Memory$.MODULE$.equals(storage)) {
            IO.Right right;
            if (enableTimer) {
                IO<Error.Map, PersistentTimer> iO3;
                Option<Path> option = LevelRef$.MODULE$.firstPersistentPath(nextLevel);
                if (option instanceof Some) {
                    void persistent_reader;
                    void persistent_writer;
                    void persistent_keyOrder;
                    void persistent_flushCheckpointSize;
                    void persistent_mod;
                    IO<Error.Map, PersistentTimer> iO4;
                    Path timerDir = ((Path)((Some)option).value()).getParent().resolve("0").resolve("timer");
                    Effect$.MODULE$.createDirectoriesIfAbsent(timerDir);
                    double StorageDoubleImplicits_measure = 1.0;
                    TimerMapEntryReader$TimerPutMapEntryReader$ timerMapEntryReader$TimerPutMapEntryReader$ = TimerMapEntryReader$TimerPutMapEntryReader$.MODULE$;
                    TimerMapEntryWriter$TimerPutMapEntryWriter$ timerMapEntryWriter$TimerPutMapEntryWriter$ = TimerMapEntryWriter$TimerPutMapEntryWriter$.MODULE$;
                    KeyOrder keyOrder3 = KeyOrder$.MODULE$.default();
                    long l = (int)(new StorageUnits.StorageDoubleImplicits((double)StorageDoubleImplicits_measure).swaydb$data$util$StorageUnits$StorageDoubleImplicits$$measure * (double)1000000);
                    long l2 = 100000L;
                    boolean persistent_mmap = LevelRef$.MODULE$.hasMMAP(nextLevel);
                    IO<Error.Map, PersistentTimer> iO5 = iO4 = PersistentTimer$.MODULE$.apply(timerDir, persistent_mmap, (long)persistent_mod, (long)persistent_flushCheckpointSize, (KeyOrder<Slice<Object>>)persistent_keyOrder, timeOrder, functionStore, (MapEntryWriter<MapEntry.Put<Slice<Object>, Slice<Object>>>)persistent_writer, (MapEntryReader<MapEntry<Slice<Object>, Slice<Object>>>)persistent_reader);
                    keyOrder3 = null;
                    timerMapEntryWriter$TimerPutMapEntryWriter$ = null;
                    timerMapEntryReader$TimerPutMapEntryReader$ = null;
                    iO4 = null;
                    iO3 = iO5;
                } else if (None$.MODULE$.equals(option)) {
                    iO3 = new IO<Error.Map, PersistentTimer>((Object)MemoryTimer$.MODULE$.apply(), (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
                } else {
                    throw new MatchError(option);
                }
                right = iO3;
            } else {
                right = new IO.Right((Object)EmptyTimer$.MODULE$, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
            }
            iO = right.map((Function1 & Serializable)timer -> {
                Maps<Slice.Null$, Memory$Null$, Slice<Object>, Memory> maps;
                Slice.Null$ x$10 = Slice.Null$.MODULE$;
                Memory$Null$ x$11 = Memory$Null$.MODULE$;
                LevelZeroMapEntryWriter$Level0MapEntryPutWriter$ memory_writer = LevelZeroMapEntryWriter$Level0MapEntryPutWriter$.MODULE$;
                Maps<Slice.Null$, Memory$Null$, Slice<Object>, Memory> maps2 = maps = new Maps<Slice.Null$, Memory$Null$, Slice<Object>, Memory>(new ConcurrentLinkedDeque(), mapSize, acceleration, Map$.MODULE$.memory(x$10, x$11, mapSize, false, keyOrder, timeOrder, functionStore, skipListMerger), keyOrder, timeOrder, fileSweeper, functionStore, memory_writer, skipListMerger, (Timer)timer);
                Object var12_10 = null;
                maps = null;
                Maps<Slice.Null$, Memory$Null$, Slice<Object>, Memory> map = maps2;
                return new Tuple3(map, (Object)Paths.get("MEMORY_DB", new String[0]).resolve(((Object)BoxesRunTime.boxToInteger((int)0)).toString()), (Object)None$.MODULE$);
            });
        } else {
            throw new MatchError((Object)storage);
        }
        return iO.map((Function1 & Serializable)x0$1 -> {
            Option lock;
            Path path;
            Maps maps;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    maps = (Maps)x0$1._1();
                    path = (Path)x0$1._2();
                    lock = (Option)x0$1._3();
                    if (lock != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            LevelZero levelZero = new LevelZero(path, mapSize, maps, nextLevel, storage.memory(), throttle, (Option<FileLock>)lock, keyOrder, timeOrder, functionStore);
            return levelZero;
        });
    }

    public IO<Error.Delete, BoxedUnit> delete(LevelZero zero) {
        return zero.close().flatMap((Function1 & Serializable)x$1 -> (IO)zero.nextLevel().map((Function1 & Serializable)x$2 -> x$2.delete()).getOrElse((Function0 & Serializable)() -> {
            IO.Right right;
            Error.Delete$.ExceptionHandler$ apply_evidence$13 = Error.Delete$.ExceptionHandler$.MODULE$;
            try {
                Effect$.MODULE$.walkDelete(zero.path().getParent());
                right = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            return right;
        }), (IO.ExceptionHandler)Error.Delete$.ExceptionHandler$.MODULE$);
    }

    public LevelZero apply(Path path, long mapSize, Maps<SliceOption<Object>, MemoryOption, Slice<Object>, Memory> maps, Option<NextLevel> nextLevel, boolean inMemory, Function1<LevelZeroMeter, FiniteDuration> throttle, Option<FileLock> lock, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore) {
        return new LevelZero(path, mapSize, maps, nextLevel, inMemory, throttle, lock, keyOrder, timeOrder, functionStore);
    }

    public Option<Tuple7<Path, Object, Maps<SliceOption<Object>, MemoryOption, Slice<Object>, Memory>, Option<NextLevel>, Object, Function1<LevelZeroMeter, FiniteDuration>, Option<FileLock>>> unapply(LevelZero x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.path(), (Object)BoxesRunTime.boxToLong((long)x$0.mapSize()), x$0.maps(), x$0.nextLevel(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.inMemory()), x$0.throttle(), x$0.swaydb$core$level$zero$LevelZero$$lock()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LevelZero$.class);
    }

    public static final /* synthetic */ FileLock $anonfun$apply$2(Path lockFile$1) {
        return FileChannel.open(lockFile$1, StandardOpenOption.WRITE).tryLock();
    }

    private LevelZero$() {
    }
}

