/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.map;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedDeque;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import swaydb.Error;
import swaydb.IO;
import swaydb.IO$;
import swaydb.core.actor.FileSweeper;
import swaydb.core.function.FunctionStore;
import swaydb.core.io.file.Effect;
import swaydb.core.io.file.Effect$;
import swaydb.core.map.Map;
import swaydb.core.map.Map$;
import swaydb.core.map.MapEntry;
import swaydb.core.map.Maps;
import swaydb.core.map.PersistentMap;
import swaydb.core.map.PersistentMap$;
import swaydb.core.map.RecoveryResult;
import swaydb.core.map.SkipListMerger;
import swaydb.core.map.serializer.MapEntryReader;
import swaydb.core.map.serializer.MapEntryWriter;
import swaydb.core.map.timer.Timer;
import swaydb.data.accelerate.Accelerator;
import swaydb.data.accelerate.LevelZeroMeter;
import swaydb.data.config.RecoveryMode;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;

public final class Maps$
implements LazyLogging {
    public static final Maps$ MODULE$ = new Maps$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public <OK, OV, K extends OK, V extends OV> Maps<OK, OV, K, V> memory(OK nullKey, OV nullValue, long fileSize, Function1<LevelZeroMeter, Accelerator> acceleration, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> writer, SkipListMerger<OK, OV, K, V> skipListMerger, Timer timer) {
        return new Maps(new ConcurrentLinkedDeque(), fileSize, acceleration, Map$.MODULE$.memory(nullKey, nullValue, fileSize, false, keyOrder, timeOrder, functionStore, skipListMerger), keyOrder, timeOrder, fileSweeper, functionStore, writer, skipListMerger, timer);
    }

    public <OK, OV, K extends OK, V extends OV> IO<Error.Map, Maps<OK, OV, K, V>> persistent(OK nullKey, OV nullValue, Path path, boolean mmap, long fileSize, Function1<LevelZeroMeter, Accelerator> acceleration, RecoveryMode recovery, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> writer, MapEntryReader<MapEntry<K, V>> reader, SkipListMerger<OK, OV, K, V> skipListMerger, Timer timer) {
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: Maps persistent started. Initialising recovery.", (Object)path);
        }
        return this.recover(nullKey, nullValue, path, mmap, fileSize, recovery, keyOrder, timeOrder, fileSweeper, functionStore, writer, reader, skipListMerger).map((Function1 & Serializable)x$1 -> (ListBuffer)x$1.reverse()).flatMap((Function1 & Serializable)recoveredMapsReversed -> {
            IO.Left left;
            IO.Left left2;
            void IterableIOImplicit_evidence$8;
            IO.IterableIOImplicit iterableIOImplicit;
            void var24_24;
            Path path;
            Option option;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("{}: Recovered {} maps.", new Object[]{path, BoxesRunTime.boxToInteger((int)recoveredMapsReversed.size())});
            }
            if ((option = recoveredMapsReversed.headOption()) instanceof Some) {
                Path path2;
                Map lastMaps = (Map)((Some)option).value();
                if (lastMaps instanceof PersistentMap) {
                    Path path3 = ((PersistentMap)lastMaps).path();
                    path2 = new Effect.PathExtensionImplicits(path3).incrementFolderId();
                } else {
                    long FileIdImplicits_id = 0L;
                    path2 = path.resolve(String.valueOf(BoxesRunTime.boxToLong((long)new Effect.FileIdImplicits((long)FileIdImplicits_id).swaydb$core$io$file$Effect$FileIdImplicits$$id)));
                }
                path = path2;
            } else if (None$.MODULE$.equals(option)) {
                long FileIdImplicits_id = 0L;
                path = path.resolve(String.valueOf(BoxesRunTime.boxToLong((long)new Effect.FileIdImplicits((long)FileIdImplicits_id).swaydb$core$io$file$Effect$FileIdImplicits$$id)));
            } else {
                throw new MatchError((Object)option);
            }
            Tuple2 tuple2 = recoveredMapsReversed.partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty()));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ListBuffer emptyMaps = (ListBuffer)tuple2._1();
            ListBuffer otherMaps = (ListBuffer)tuple2._2();
            if (var24_24.nonEmpty() && MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("{}: Deleting empty {} maps {}.", new Object[]{path, BoxesRunTime.boxToInteger((int)var24_24.size()), ((IterableOnceOps)((StrictOptimizedIterableOps)var24_24.flatMap((Function1 & Serializable)x$4 -> x$4.pathOption())).map((Function1 & Serializable)x$5 -> ((Object)x$5).toString())).mkString(", ")});
            }
            ClassTag classTag = ClassTag$.MODULE$.apply(Map.class);
            Error.Map$.ExceptionHandler$ IterableIOImplicit_evidence$7 = Error.Map$.ExceptionHandler$.MODULE$;
            IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit((Iterable)var24_24, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
            Object var40_27 = null;
            classTag = null;
            iterableIOImplicit = null;
            IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
            Function1 & Serializable x$72 = (Function1 & Serializable)map -> {
                IO.Right right;
                Error.Map$.ExceptionHandler$ apply_evidence$13 = Error.Map$.ExceptionHandler$.MODULE$;
                try {
                    map.delete();
                    right = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
                }
                catch (Throwable apply_ex) {
                    right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                }
                return right;
            };
            boolean x$8 = qual$1.foreachIO$default$2();
            Option option2 = qual$1.foreachIO((Function1)x$72, x$8);
            if (option2 instanceof Some && (left2 = (IO.Left)((Some)option2).value()) != null) {
                Error.Map error = (Error.Map)left2.value();
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error("{}: Failed to delete empty maps {}", new Object[]{path, ((IterableOnceOps)((StrictOptimizedIterableOps)var24_24.flatMap((Function1 & Serializable)x$6 -> x$6.pathOption())).map((Function1 & Serializable)x$7 -> ((Object)x$7).toString())).mkString(", ")});
                }
                left = new IO.Left((Object)error, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
            } else if (None$.MODULE$.equals(option2)) {
                IO.Left left3;
                void var25_25;
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("{}: Creating next map with ID {} maps.", (Object[])new Path[]{path, path});
                }
                ConcurrentLinkedDeque queue = new ConcurrentLinkedDeque(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)var25_25).asJavaCollection());
                Error.Map$.ExceptionHandler$ apply_evidence$13 = Error.Map$.ExceptionHandler$.MODULE$;
                try {
                    left3 = new IO.Right((Object)Maps$.$anonfun$persistent$10(nullKey, nullValue, path, mmap, fileSize, recovery, keyOrder, timeOrder, functionStore, fileSweeper, writer, reader, skipListMerger), (IO.ExceptionHandler)apply_evidence$13);
                }
                catch (Throwable apply_ex) {
                    left3 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                }
                IO.Left left4 = left3;
                Object var33_37 = null;
                Object var34_40 = null;
                left3 = null;
                left = left4.map((Function1 & Serializable)nextMap -> {
                    if (MODULE$.logger().underlying().isDebugEnabled()) {
                        MODULE$.logger().underlying().debug("{}: Next map created with ID {}.", (Object[])new Path[]{path, path});
                    }
                    return new Maps(queue, fileSize, acceleration, (Map)nextMap.item(), keyOrder, timeOrder, fileSweeper, functionStore, writer, skipListMerger, timer);
                });
            } else {
                throw new MatchError((Object)option2);
            }
            return left;
        }, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
    }

    private <OK, OV, K extends OK, V extends OV> IO<Error.Map, ListBuffer<Map<OK, OV, K, V>>> recover(OK nullKey, OV nullValue, Path folder, boolean mmap, long fileSize, RecoveryMode recovery, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> writer, MapEntryReader<MapEntry<K, V>> mapReader, SkipListMerger<OK, OV, K, V> skipListMerger) {
        return this.doRecovery$1(new Effect.PathExtensionImplicits(folder).folders(), ListBuffer$.MODULE$.empty(), nullKey, nullValue, mmap, fileSize, recovery, keyOrder, timeOrder, functionStore, fileSweeper, writer, mapReader, skipListMerger);
    }

    public <OK, OV, K extends OK, V extends OV> Map<OK, OV, K, V> nextMapUnsafe(long nextMapSize, Map<OK, OV, K, V> currentMap, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> writer, SkipListMerger<OK, OV, K, V> skipListMerger) {
        Map<OK, OV, K, V> map;
        if (currentMap instanceof PersistentMap) {
            PersistentMap persistentMap;
            PersistentMap persistentMap2 = (PersistentMap)currentMap;
            persistentMap2.close();
            Path PathExtensionImplicits_path = persistentMap2.path();
            Object var16_10 = null;
            Path x$1 = new Effect.PathExtensionImplicits(PathExtensionImplicits_path).incrementFolderId();
            boolean x$2 = persistentMap2.mmap();
            Object x$5 = persistentMap2.skipList().nullKey();
            Object x$6 = persistentMap2.skipList().nullValue();
            boolean persistent_flushOnOverflow = false;
            PersistentMap persistentMap3 = persistentMap = PersistentMap$.MODULE$.apply(x$1, x$2, persistent_flushOnOverflow, nextMapSize, x$5, x$6, keyOrder, timeOrder, fileSweeper, functionStore, writer, skipListMerger);
            persistentMap = null;
            map = persistentMap3;
        } else {
            map = Map$.MODULE$.memory(currentMap.skipList().nullKey(), currentMap.skipList().nullValue(), nextMapSize, false, keyOrder, timeOrder, functionStore, skipListMerger);
        }
        return map;
    }

    public static final /* synthetic */ void $anonfun$persistent$7(Map map$1) {
        map$1.delete();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ RecoveryResult $anonfun$persistent$10(Object nullKey$1, Object nullValue$1, Path nextMapId$1, boolean mmap$1, long fileSize$1, RecoveryMode recovery$1, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, FileSweeper fileSweeper$1, MapEntryWriter writer$1, MapEntryReader reader$1, SkipListMerger skipListMerger$1) {
        void persistent_dropCorruptedTailEntries;
        boolean bl = recovery$1.drop();
        boolean persistent_flushOnOverflow = false;
        return PersistentMap$.MODULE$.apply(nextMapId$1, mmap$1, persistent_flushOnOverflow, fileSize$1, (boolean)persistent_dropCorruptedTailEntries, nullKey$1, nullValue$1, keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, fileSweeper$1, reader$1, writer$1, skipListMerger$1);
    }

    public static final /* synthetic */ void $anonfun$recover$2(Path mapPath$1) {
        Effect$.MODULE$.walkDelete(mapPath$1);
    }

    /*
     * WARNING - void declaration
     */
    private final IO applyRecoveryMode$1(Throwable exception, Path mapPath2, List otherMapsPaths, ListBuffer recoveredMaps, RecoveryMode recovery$2, Object nullKey$2, Object nullValue$2, boolean mmap$2, long fileSize$2, KeyOrder keyOrder$2, TimeOrder timeOrder$2, FunctionStore functionStore$2, FileSweeper fileSweeper$2, MapEntryWriter writer$2, MapEntryReader mapReader$1, SkipListMerger skipListMerger$2) {
        IO.Left left;
        if (exception instanceof IllegalStateException) {
            IO.Left left2;
            IllegalStateException illegalStateException = (IllegalStateException)exception;
            if (RecoveryMode.ReportFailure$.MODULE$.equals(recovery$2)) {
                IO.Left left3;
                Error.Map$.ExceptionHandler$ failed_evidence$20 = Error.Map$.ExceptionHandler$.MODULE$;
                IO.Left left4 = left3 = new IO.Left((Object)failed_evidence$20.toError((Throwable)illegalStateException), (IO.ExceptionHandler)failed_evidence$20);
                Object var28_18 = null;
                left3 = null;
                left2 = left4;
            } else if (RecoveryMode.DropCorruptedTailEntries$.MODULE$.equals(recovery$2)) {
                left2 = this.doRecovery$1(otherMapsPaths, recoveredMaps, nullKey$2, nullValue$2, mmap$2, fileSize$2, recovery$2, keyOrder$2, timeOrder$2, functionStore$2, fileSweeper$2, writer$2, mapReader$1, skipListMerger$2);
            } else if (RecoveryMode.DropCorruptedTailEntriesAndMaps$.MODULE$.equals(recovery$2)) {
                IO.Right right;
                IO.Left left5;
                void IterableIOImplicit_evidence$8;
                IO.IterableIOImplicit iterableIOImplicit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{}: Skipping files after corrupted file. Recovery mode: {}", new Object[]{mapPath2, recovery$2.name()});
                }
                ClassTag classTag = ClassTag$.MODULE$.apply(Path.class);
                Error.Map$.ExceptionHandler$ IterableIOImplicit_evidence$7 = Error.Map$.ExceptionHandler$.MODULE$;
                IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit((Iterable)otherMapsPaths, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
                Object var32_22 = null;
                classTag = null;
                iterableIOImplicit = null;
                IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
                Function1 & Serializable x$1 = (Function1 & Serializable)mapPath -> {
                    IO.Right right;
                    IO.Right right2;
                    Error.Map$.ExceptionHandler$ apply_evidence$13 = Error.Map$.ExceptionHandler$.MODULE$;
                    try {
                        Effect$.MODULE$.walkDelete((Path)mapPath);
                        right2 = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
                    }
                    catch (Throwable apply_ex) {
                        right2 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                    }
                    IO.Right right3 = right2;
                    Object var5_2 = null;
                    Object var6_5 = null;
                    right2 = null;
                    IO.Right right4 = right3;
                    if (right4 instanceof IO.Right) {
                        if (MODULE$.logger().underlying().isInfoEnabled()) {
                            MODULE$.logger().underlying().info("{}: Deleted file after corruption. Recovery mode: {}", new Object[]{mapPath, recovery$2.name()});
                        }
                        right = IO$.MODULE$.unit();
                    } else if (right4 instanceof IO.Left) {
                        Error.Map error = (Error.Map)((IO.Left)right4).value();
                        if (MODULE$.logger().underlying().isErrorEnabled()) {
                            MODULE$.logger().underlying().error("{}: IO.Left to delete file after corruption file. Recovery mode: {}", new Object[]{mapPath, recovery$2.name()});
                        }
                        right = new IO.Left((Object)error, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
                    } else {
                        throw new MatchError((Object)right4);
                    }
                    return right;
                };
                boolean x$2 = qual$1.foreachIO$default$2();
                Option option = qual$1.foreachIO((Function1)x$1, x$2);
                if (option instanceof Some && (left5 = (IO.Left)((Some)option).value()) != null) {
                    Error.Map error = (Error.Map)left5.value();
                    right = new IO.Left((Object)error, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
                } else if (None$.MODULE$.equals(option)) {
                    right = new IO.Right((Object)recoveredMaps, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
                } else {
                    throw new MatchError((Object)option);
                }
                left2 = right;
            } else {
                throw new MatchError((Object)recovery$2);
            }
            left = left2;
        } else if (exception != null) {
            IO.Left left6;
            Error.Map$.ExceptionHandler$ failed_evidence$20 = Error.Map$.ExceptionHandler$.MODULE$;
            IO.Left left7 = left6 = new IO.Left((Object)failed_evidence$20.toError(exception), (IO.ExceptionHandler)failed_evidence$20);
            Object var30_32 = null;
            left6 = null;
            left = left7;
        } else {
            throw new MatchError(null);
        }
        return left;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ RecoveryResult $anonfun$recover$3(Object nullKey$2, Object nullValue$2, Path mapPath$2, boolean mmap$2, long fileSize$2, RecoveryMode recovery$2, KeyOrder keyOrder$2, TimeOrder timeOrder$2, FunctionStore functionStore$2, FileSweeper fileSweeper$2, MapEntryWriter writer$2, MapEntryReader mapReader$1, SkipListMerger skipListMerger$2) {
        void persistent_dropCorruptedTailEntries;
        boolean bl = recovery$2.drop();
        boolean persistent_flushOnOverflow = false;
        return PersistentMap$.MODULE$.apply(mapPath$2, mmap$2, persistent_flushOnOverflow, fileSize$2, (boolean)persistent_dropCorruptedTailEntries, nullKey$2, nullValue$2, keyOrder$2, (TimeOrder<Slice<Object>>)timeOrder$2, functionStore$2, fileSweeper$2, mapReader$1, writer$2, skipListMerger$2);
    }

    public static final /* synthetic */ void $anonfun$recover$4(RecoveryResult recoveredMap$1) {
        ((PersistentMap)recoveredMap$1.item()).close();
    }

    private final IO doRecovery$1(List maps, ListBuffer recoveredMaps, Object nullKey$2, Object nullValue$2, boolean mmap$2, long fileSize$2, RecoveryMode recovery$2, KeyOrder keyOrder$2, TimeOrder timeOrder$2, FunctionStore functionStore$2, FileSweeper fileSweeper$2, MapEntryWriter writer$2, MapEntryReader mapReader$1, SkipListMerger skipListMerger$2) {
        IO.Right right;
        block12: {
            block13: {
                IO iO;
                block17: {
                    IO.Left left;
                    List otherMapsPaths;
                    Path mapPath;
                    block14: {
                        IO.Left left2;
                        block16: {
                            IO.Right right2;
                            block15: {
                                IO<Error.Map, BoxedUnit> iO2;
                                while (true) {
                                    IO.Right right3;
                                    IO.Left left3;
                                    if (Nil$.MODULE$.equals(maps)) {
                                        right = new IO.Right((Object)recoveredMaps, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
                                        break block12;
                                    }
                                    if (!(maps instanceof .colon.colon)) break block13;
                                    .colon.colon colon2 = (.colon.colon)maps;
                                    mapPath = (Path)colon2.head();
                                    otherMapsPaths = colon2.next$access$1();
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("{}: Recovering.", (Object)mapPath);
                                    }
                                    Error.Map$.ExceptionHandler$ apply_evidence$13 = Error.Map$.ExceptionHandler$.MODULE$;
                                    try {
                                        left3 = new IO.Right((Object)Maps$.$anonfun$recover$3(nullKey$2, nullValue$2, mapPath, mmap$2, fileSize$2, recovery$2, keyOrder$2, timeOrder$2, functionStore$2, fileSweeper$2, writer$2, mapReader$1, skipListMerger$2), (IO.ExceptionHandler)apply_evidence$13);
                                    }
                                    catch (Throwable apply_ex) {
                                        left3 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
                                    }
                                    IO.Left left4 = left3;
                                    Object var30_22 = null;
                                    Object var31_23 = null;
                                    left3 = null;
                                    left = left4;
                                    if (!(left instanceof IO.Right)) break block14;
                                    RecoveryResult recoveredMap = (RecoveryResult)((IO.Right)left).value();
                                    Error.Map$.ExceptionHandler$ apply_evidence$132 = Error.Map$.ExceptionHandler$.MODULE$;
                                    try {
                                        Maps$.$anonfun$recover$4(recoveredMap);
                                        right3 = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$132);
                                    }
                                    catch (Throwable apply_ex) {
                                        right3 = new IO.Left((Object)apply_evidence$132.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$132);
                                    }
                                    IO.Right right4 = right3;
                                    Object var33_26 = null;
                                    Object var34_27 = null;
                                    right3 = null;
                                    right2 = right4;
                                    if (!(right2 instanceof IO.Right)) break block15;
                                    recoveredMaps.$plus$eq(recoveredMap.item());
                                    iO2 = recoveredMap.result();
                                    if (!(iO2 instanceof IO.Right)) break;
                                    maps = otherMapsPaths;
                                }
                                if (!(iO2 instanceof IO.Left)) {
                                    throw new MatchError(iO2);
                                }
                                Error.Map error = (Error.Map)((IO.Left)iO2).value();
                                IO iO3 = this.applyRecoveryMode$1(error.exception(), mapPath, otherMapsPaths, recoveredMaps, recovery$2, nullKey$2, nullValue$2, mmap$2, fileSize$2, keyOrder$2, timeOrder$2, functionStore$2, fileSweeper$2, writer$2, mapReader$1, skipListMerger$2);
                                left2 = iO3;
                                break block16;
                            }
                            if (right2 instanceof IO.Left) {
                                Error.Map error = (Error.Map)((IO.Left)right2).value();
                                left2 = new IO.Left((Object)error, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
                            } else {
                                throw new MatchError((Object)right2);
                            }
                        }
                        iO = left2;
                        break block17;
                    }
                    if (left instanceof IO.Left) {
                        Error.Map error = (Error.Map)left.value();
                        iO = this.applyRecoveryMode$1(error.exception(), mapPath, otherMapsPaths, recoveredMaps, recovery$2, nullKey$2, nullValue$2, mmap$2, fileSize$2, keyOrder$2, timeOrder$2, functionStore$2, fileSweeper$2, writer$2, mapReader$1, skipListMerger$2);
                    } else {
                        throw new MatchError((Object)left);
                    }
                }
                right = iO;
                break block12;
            }
            throw new MatchError((Object)maps);
        }
        return right;
    }

    private Maps$() {
    }
}

