/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.map;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import swaydb.Error;
import swaydb.IO;
import swaydb.IO$;
import swaydb.core.actor.FileSweeper;
import swaydb.core.brake.BrakePedal;
import swaydb.core.function.FunctionStore;
import swaydb.core.map.Map;
import swaydb.core.map.Map$;
import swaydb.core.map.MapEntry;
import swaydb.core.map.Maps$;
import swaydb.core.map.SkipListMerger;
import swaydb.core.map.serializer.MapEntryReader;
import swaydb.core.map.serializer.MapEntryWriter;
import swaydb.core.map.timer.Timer;
import swaydb.data.accelerate.Accelerator;
import swaydb.data.accelerate.Brake;
import swaydb.data.accelerate.LevelZeroMeter;
import swaydb.data.config.RecoveryMode;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001dvAB\"E\u0011\u00031%J\u0002\u0004M\t\"\u0005a)\u0014\u0005\u0006=\u0006!\t\u0001\u0019\u0005\u0006C\u0006!\tA\u0019\u0005\b\u0007O\u000bA\u0011ABU\u0011\u001d!I\"\u0001C\u0005\t7Aq\u0001b\u001c\u0002\t\u0003!\tHB\u0003M\t\u00021e\r\u0003\u0005i\u000f\t\u0015\r\u0011\"\u0001j\u0011%\tYb\u0002B\u0001B\u0003%!\u000e\u0003\u0006\u0002\u001e\u001d\u0011\t\u0011)A\u0005\u0003?A!\"!\n\b\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011)\t\u0019e\u0002BA\u0002\u0013%\u0011Q\t\u0005\u000b\u0003\u000f:!\u00111A\u0005\n\u0005%\u0003\"CA+\u000f\t\u0005\t\u0015)\u0003u\u0011)\tyf\u0002B\u0001B\u0003-\u0011\u0011\r\u0005\u000b\u0003[:!\u0011!Q\u0001\f\u0005=\u0004BCAD\u000f\t\u0005\t\u0015a\u0003\u0002\n\"Q\u0011QS\u0004\u0003\u0002\u0003\u0006Y!a&\t\u0015\u0005\rvA!A!\u0002\u0017\t)\u000b\u0003\u0006\u0002@\u001e\u0011\t\u0011)A\u0006\u0003\u0003D!\"a2\b\u0005\u0003\u0005\u000b1BAe\u0011\u0019qv\u0001\"\u0001\u0002T\"I\u0011q^\u0004A\u0002\u0013%\u0011\u0011\u001f\u0005\n\u0003s<\u0001\u0019!C\u0005\u0003wD\u0001\"a@\bA\u0003&\u00111\u001f\u0005\f\u0005\u00039\u0001\u0019!a\u0001\n\u0013\u0011\u0019\u0001C\u0006\u0003\u0012\u001d\u0001\r\u00111A\u0005\n\tM\u0001b\u0003B\f\u000f\u0001\u0007\t\u0011)Q\u0005\u0005\u000bA\u0011B!\u0007\b\u0005\u0004%\tAa\u0007\t\u0011\tuq\u0001)A\u0005\u0003\u000bA\u0011Ba\b\b\u0005\u0004%\tA!\t\t\u000f\t\rr\u0001)A\u0005o\"I!QE\u0004A\u0002\u0013%!q\u0005\u0005\n\u0005_9\u0001\u0019!C\u0005\u0005cA\u0001B!\u000e\bA\u0003&!\u0011\u0006\u0005\n\u0005s9\u0001\u0019!C\u0005\u0005OA\u0011Ba\u000f\b\u0001\u0004%IA!\u0010\t\u0011\t\u0005s\u0001)Q\u0005\u0005SA\u0011B!\u0012\b\u0001\u0004%\tAa\u0012\t\u0013\t-s\u00011A\u0005\u0002\t5\u0003\u0002\u0003B)\u000f\u0001\u0006KA!\u0013\t\u0013\tUsA1A\u0005\u0002\t]\u0003\u0002\u0003B0\u000f\u0001\u0006IA!\u0017\t\u0011\t\u0005t\u0001\"\u0001G\u0005GBqA!\u001b\b\t\u0003\u0011Y\u0007C\u0004\u0003z\u001d!\tAa\u001f\t\u000f\tut\u0001\"\u0001\u0003\u0000!9!\u0011Q\u0004\u0005\n\t\r\u0005b\u0002BE\u000f\u0011%!1\u0012\u0005\b\u0005?;AQ\u0002BQ\u0011\u001d\u0011il\u0002C\u0007\u0005\u007fCqAa8\b\t\u0003\u0011\t\u000fC\u0004\u0003r\u001e!\tAa=\t\u000f\t}x\u0001\"\u0001\u0004\u0002!91QA\u0004\u0005\u0002\r\u001d\u0001bBB\r\u000f\u0011\u000511\u0004\u0005\b\u0007G9A\u0011AB\u0013\u0011\u001d\u00199e\u0002C\u0001\u0005OAqa!\u0013\b\t\u0003\u00119\u0003C\u0004\u0004L\u001d!\tAa\n\t\u000f\r5s\u0001\"\u0001\u0004P!1Qi\u0002C\u0001\u0003\u000bBqa!\u0015\b\t\u0003\u0019\u0019\u0006C\u0004\u0004V\u001d!\taa\u0016\t\u000f\r\u0005t\u0001\"\u0001\u0004d!91QM\u0004\u0005\u0002\r\u001d\u0014\u0001B'baNT!!\u0012$\u0002\u00075\f\u0007O\u0003\u0002H\u0011\u0006!1m\u001c:f\u0015\u0005I\u0015AB:xCf$'\r\u0005\u0002L\u00035\tAI\u0001\u0003NCB\u001c8cA\u0001O)B\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n1\u0011I\\=SK\u001a\u0004\"!\u0016/\u000e\u0003YS!a\u0016-\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005eS\u0016\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\u000b1aY8n\u0013\tifKA\u0006MCjLHj\\4hS:<\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003)\u000ba!\\3n_JLX#C2\u0004x\rm4qPBC)%!7qTBQ\u0007G\u001b)\u000bF\bf\u0007\u0013\u001biia$\u0004\u0012\u000eM5\u0011TBO!)Yua!\u001e\u0004z\ru41Q\u000b\tOf\f9!!\u0004\u0002\u0016M\u0019qA\u0014+\u0002\t5\f\u0007o]\u000b\u0002UB\u00191N\u001d;\u000e\u00031T!!\u001c8\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002pa\u0006!Q\u000f^5m\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d7\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$G)Z9vKBI1*^<\u0002\u0006\u0005-\u00111C\u0005\u0003m\u0012\u00131!T1q!\tA\u0018\u0010\u0004\u0001\u0005\u000bi<!\u0019A>\u0003\u0005=[\u0015C\u0001?\u0000!\tyU0\u0003\u0002\u007f!\n9aj\u001c;iS:<\u0007cA(\u0002\u0002%\u0019\u00111\u0001)\u0003\u0007\u0005s\u0017\u0010E\u0002y\u0003\u000f!a!!\u0003\b\u0005\u0004Y(AA(W!\rA\u0018Q\u0002\u0003\b\u0003\u001f9!\u0019AA\t\u0005\u0005Y\u0015C\u0001?x!\rA\u0018Q\u0003\u0003\b\u0003/9!\u0019AA\r\u0005\u00051\u0016c\u0001?\u0002\u0006\u0005)Q.\u00199tA\u0005Aa-\u001b7f'&TX\rE\u0002P\u0003CI1!a\tQ\u0005\u0011auN\\4\u0002\u0019\u0005\u001c7-\u001a7fe\u0006$\u0018n\u001c8\u0011\u000f=\u000bI#!\f\u0002>%\u0019\u00111\u0006)\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\u000bC\u000e\u001cW\r\\3sCR,'bAA\u001c\u0011\u0006!A-\u0019;b\u0013\u0011\tY$!\r\u0003\u001d1+g/\u001a7[KJ|W*\u001a;feB!\u0011qFA \u0013\u0011\t\t%!\r\u0003\u0017\u0005\u001b7-\u001a7fe\u0006$xN]\u0001\u000bGV\u0014(/\u001a8u\u001b\u0006\u0004X#\u0001;\u0002\u001d\r,(O]3oi6\u000b\u0007o\u0018\u0013fcR!\u00111JA)!\ry\u0015QJ\u0005\u0004\u0003\u001f\u0002&\u0001B+oSRD\u0001\"a\u0015\u000e\u0003\u0003\u0005\r\u0001^\u0001\u0004q\u0012\n\u0014aC2veJ,g\u000e^'ba\u0002B3ADA-!\ry\u00151L\u0005\u0004\u0003;\u0002&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0011-,\u0017p\u0014:eKJ\u0004b!a\u0019\u0002j\u0005-QBAA3\u0015\u0011\t9'!\u000e\u0002\u000b=\u0014H-\u001a:\n\t\u0005-\u0014Q\r\u0002\t\u0017\u0016LxJ\u001d3fe\u0006IA/[7f\u001fJ$WM\u001d\t\u0007\u0003G\n\t(!\u001e\n\t\u0005M\u0014Q\r\u0002\n)&lWm\u0014:eKJ\u0004b!a\u001e\u0002~\u0005\u0005UBAA=\u0015\u0011\tY(!\u000e\u0002\u000bMd\u0017nY3\n\t\u0005}\u0014\u0011\u0010\u0002\u0006'2L7-\u001a\t\u0004\u001f\u0006\r\u0015bAAC!\n!!)\u001f;f\u0003-1\u0017\u000e\\3To\u0016,\u0007/\u001a:\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$G\u0003\u0015\t7\r^8s\u0013\u0011\t\u0019*!$\u0003\u0017\u0019KG.Z*xK\u0016\u0004XM]\u0001\u000eMVt7\r^5p]N#xN]3\u0011\t\u0005e\u0015qT\u0007\u0003\u00037S1!!(G\u0003!1WO\\2uS>t\u0017\u0002BAQ\u00037\u0013QBR;oGRLwN\\*u_J,\u0017AB<sSR,'\u000f\u0005\u0004\u0002(\u00065\u0016\u0011W\u0007\u0003\u0003SS1!a+E\u0003)\u0019XM]5bY&TXM]\u0005\u0005\u0003_\u000bIK\u0001\bNCB,e\u000e\u001e:z/JLG/\u001a:\u0011\u0011\u0005M\u0016\u0011XA\u0006\u0003'q1aSA[\u0013\r\t9\fR\u0001\t\u001b\u0006\u0004XI\u001c;ss&!\u00111XA_\u0005\r\u0001V\u000f\u001e\u0006\u0004\u0003o#\u0015AD:lSBd\u0015n\u001d;NKJ<WM\u001d\t\u000b\u0017\u0006\rw/!\u0002\u0002\f\u0005M\u0011bAAc\t\nq1k[5q\u0019&\u001cH/T3sO\u0016\u0014\u0018!\u0002;j[\u0016\u0014\b\u0003BAf\u0003\u001fl!!!4\u000b\u0007\u0005\u001dG)\u0003\u0003\u0002R\u00065'!\u0002+j[\u0016\u0014HCCAk\u0003O\fI/a;\u0002nR\u0001\u0012q[Am\u00037\fi.a8\u0002b\u0006\r\u0018Q\u001d\t\n\u0017\u001e9\u0018QAA\u0006\u0003'Aq!a\u0018\u0017\u0001\b\t\t\u0007C\u0004\u0002nY\u0001\u001d!a\u001c\t\u000f\u0005\u001de\u0003q\u0001\u0002\n\"9\u0011Q\u0013\fA\u0004\u0005]\u0005bBAR-\u0001\u000f\u0011Q\u0015\u0005\b\u0003\u007f3\u00029AAa\u0011\u001d\t9M\u0006a\u0002\u0003\u0013DQ\u0001\u001b\fA\u0002)Dq!!\b\u0017\u0001\u0004\ty\u0002C\u0004\u0002&Y\u0001\r!a\n\t\r\u0005\rc\u00031\u0001u\u0003EygNT3yi6\u000b\u0007\u000fT5ti\u0016tWM]\u000b\u0003\u0003g\u0004RaTA{\u0003\u0017J1!a>Q\u0005%1UO\\2uS>t\u0007'A\u000bp]:+\u0007\u0010^'ba2K7\u000f^3oKJ|F%Z9\u0015\t\u0005-\u0013Q \u0005\n\u0003'B\u0012\u0011!a\u0001\u0003g\f!c\u001c8OKb$X*\u00199MSN$XM\\3sA\u0005Q!M]1lKB+G-\u00197\u0016\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005\u001bi!A!\u0003\u000b\u0007\t-a)A\u0003ce\u0006\\W-\u0003\u0003\u0003\u0010\t%!A\u0003\"sC.,\u0007+\u001a3bY\u0006q!M]1lKB+G-\u00197`I\u0015\fH\u0003BA&\u0005+A\u0011\"a\u0015\u001c\u0003\u0003\u0005\rA!\u0002\u0002\u0017\t\u0014\u0018m[3QK\u0012\fG\u000eI\u0001\n]VdGNV1mk\u0016,\"!!\u0002\u0002\u00159,H\u000e\u001c,bYV,\u0007%A\u0004ok2d7*Z=\u0016\u0003]\f\u0001B\\;mY.+\u0017\u0010I\u0001\u000fi>$\u0018\r\\'baN\u001cu.\u001e8u+\t\u0011I\u0003E\u0002P\u0005WI1A!\fQ\u0005\rIe\u000e^\u0001\u0013i>$\u0018\r\\'baN\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002L\tM\u0002\"CA*E\u0005\u0005\t\u0019\u0001B\u0015\u0003=!x\u000e^1m\u001b\u0006\u00048oQ8v]R\u0004\u0003fA\u0012\u0002Z\u0005\u00012-\u001e:sK:$X*\u00199t\u0007>,h\u000e^\u0001\u0015GV\u0014(/\u001a8u\u001b\u0006\u00048oQ8v]R|F%Z9\u0015\t\u0005-#q\b\u0005\n\u0003'*\u0013\u0011!a\u0001\u0005S\t\u0011cY;se\u0016tG/T1qg\u000e{WO\u001c;!Q\r1\u0013\u0011L\u0001\u0011GV\u0014(/\u001a8u\u001b\u0006\u00048o\u00157jG\u0016,\"A!\u0013\u0011\u000b\u0005]\u0014Q\u0010;\u0002)\r,(O]3oi6\u000b\u0007o]*mS\u000e,w\fJ3r)\u0011\tYEa\u0014\t\u0013\u0005M\u0003&!AA\u0002\t%\u0013!E2veJ,g\u000e^'baN\u001cF.[2fA!\u001a\u0011&!\u0017\u0002\u000b5,G/\u001a:\u0016\u0005\te##\u0002B.\u001d\u00065bA\u0002B/W\u0001\u0011IF\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0001\u0004nKR,'\u000fI\u0001\u0012_:tU\r\u001f;NCB\u001c\u0015\r\u001c7cC\u000e\\G\u0003BA&\u0005KBqAa\u001a-\u0001\u0004\t\u00190A\u0003fm\u0016tG/A\u0003xe&$X\r\u0006\u0003\u0002L\t5\u0004b\u0002B8[\u0001\u0007!\u0011O\u0001\t[\u0006\u0004XI\u001c;ssB9q*!\u000b\u0002J\nM\u0004cB&\u0003v\u0005-\u00111C\u0005\u0004\u0005o\"%\u0001C'ba\u0016sGO]=\u0002\u0017Q|W*\u00199t'2L7-\u001a\u000b\u0003\u0005\u0013\nq\"\u001e9eCR,W*\u00199t'2L7-\u001a\u000b\u0003\u0003\u0017\n1\"\u001b8ji:+\u0007\u0010^'baR!\u00111\nBC\u0011\u001d\u00119\t\ra\u0001\u0003?\tq!\\1q'&TX-A\u0004qKJ\u001c\u0018n\u001d;\u0015\t\u0005-#Q\u0012\u0005\b\u0005\u001f\u000b\u0004\u0019\u0001B:\u0003\u0015)g\u000e\u001e:zQ\r\t$1\u0013\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*\u0019!\u0011\u0014)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001e\n]%a\u0002;bS2\u0014XmY\u0001\nM&tGMR5sgR,BAa)\u0003(R1!Q\u0015BV\u0005_\u00032\u0001\u001fBT\t\u0019\u0011IK\rb\u0001w\n\t!\u000bC\u0004\u0003.J\u0002\rA!*\u0002\u00159,H\u000e\u001c*fgVdG\u000fC\u0004\u00032J\u0002\rAa-\u0002\u0003\u0019\u0004baTA\u0015i\n\u0015\u0006f\u0001\u001a\u00038B\u0019qJ!/\n\u0007\tm\u0006K\u0001\u0004j]2Lg.Z\u0001\u000eM&tG-\u00118e%\u0016$WoY3\u0016\t\t\u0005'Q\u0019\u000b\u000b\u0005\u0007\u00149M!3\u0003N\nM\u0007c\u0001=\u0003F\u00121!\u0011V\u001aC\u0002mDqA!,4\u0001\u0004\u0011\u0019\rC\u0004\u0003LN\u0002\rAa1\u0002\u000f%t\u0017\u000e^5bY\"9!qZ\u001aA\u0002\tE\u0017aB1qa2LWM\u001d\t\u0007\u001f\u0006%BOa1\t\u000f\tU7\u00071\u0001\u0003X\u00069!/\u001a3vG\u0016\u0014\b#C(\u0003Z\n\r'1\u0019Bb\u0013\r\u0011Y\u000e\u0015\u0002\n\rVt7\r^5p]JB3a\rB\\\u0003\u00111\u0017N\u001c3\u0016\t\t\r(q\u001d\u000b\u0007\u0005K\u0014IOa;\u0011\u0007a\u00149\u000f\u0002\u0004\u0003*R\u0012\ra\u001f\u0005\b\u0005[#\u0004\u0019\u0001Bs\u0011\u001d\u0011i\u000f\u000ea\u0001\u0005_\fq!\\1uG\",'\u000f\u0005\u0004P\u0003S!(Q]\u0001\tG>tG/Y5ogR!!Q\u001fB~!\ry%q_\u0005\u0004\u0005s\u0004&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005{,\u0004\u0019AA\u0006\u0003\rYW-_\u0001\u0004O\u0016$H\u0003BA\u0003\u0007\u0007AqA!@7\u0001\u0004\tY!\u0001\u0004sK\u0012,8-Z\u000b\u0005\u0007\u0013\u0019i\u0001\u0006\u0005\u0004\f\r=1\u0011CB\u000b!\rA8Q\u0002\u0003\u0007\u0005S;$\u0019A>\t\u000f\teq\u00071\u0001\u0004\f!9!qZ\u001cA\u0002\rM\u0001CB(\u0002*Q\u001cY\u0001C\u0004\u0004\u0006]\u0002\raa\u0006\u0011\u0013=\u0013Ina\u0003\u0004\f\r-\u0011A\u00037bgR|\u0005\u000f^5p]R\u00111Q\u0004\t\u0005\u001f\u000e}A/C\u0002\u0004\"A\u0013aa\u00149uS>t\u0017A\u0003:f[>4X\rT1tiR\u00111q\u0005\t\u0006\u001f\u000e}1\u0011\u0006\t\t\u0007W\u0019ic!\r\u0002L5\t\u0001*C\u0002\u00040!\u0013!!S(\u0011\t\rM21\t\b\u0005\u0007k\u0019yD\u0004\u0003\u00048\ruRBAB\u001d\u0015\r\u0019YdX\u0001\u0007yI|w\u000e\u001e \n\u0003%K1a!\u0011I\u0003\u0015)%O]8s\u0013\r18Q\t\u0006\u0004\u0007\u0003B\u0015!D6fsZ\u000bG.^3D_VtG/A\brk\u0016,X\rZ'baN\u001cu.\u001e8u\u0003i\tX/Z;fI6\u000b\u0007o]\"pk:$x+\u001b;i\u0007V\u0014(/\u001a8u\u0003\u001dI7/R7qif,\"A!>\u0002\u000b\rdwn]3\u0016\u0005\r%\u0012AE9vKV,G-T1qg&#XM]1u_J,\"a!\u0017\u0011\u000b\rm3Q\f;\u000e\u00039L1aa\u0018o\u0005!IE/\u001a:bi>\u0014\u0018aB:uCR,\u0017\nZ\u000b\u0003\u0003?\t!\"];fk\u0016$W*\u00199t+\t\u0019I\u0007E\u0003\u0004l\rED/\u0004\u0002\u0004n)\u00191q\u000e)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004t\r5$\u0001C%uKJ\f'\r\\3\u0011\u0007a\u001c9\bB\u0003{\u0007\t\u00071\u0010E\u0002y\u0007w\"a!!\u0003\u0004\u0005\u0004Y\bc\u0001=\u0004\u0000\u00119\u0011qB\u0002C\u0002\r\u0005\u0015c\u0001?\u0004vA\u0019\u0001p!\"\u0005\u000f\u0005]1A1\u0001\u0004\bF\u0019Ap!\u001f\t\u000f\u0005}3\u0001q\u0001\u0004\fB1\u00111MA5\u0007{Bq!!\u001c\u0004\u0001\b\ty\u0007C\u0004\u0002\b\u000e\u0001\u001d!!#\t\u000f\u0005U5\u0001q\u0001\u0002\u0018\"9\u00111U\u0002A\u0004\rU\u0005CBAT\u0003[\u001b9\n\u0005\u0005\u00024\u0006e6QPBB\u0011\u001d\tyl\u0001a\u0002\u00077\u00032bSAb\u0007k\u001aIh! \u0004\u0004\"9\u0011qY\u0002A\u0004\u0005%\u0007b\u0002B\u0010\u0007\u0001\u00071Q\u000f\u0005\b\u00053\u0019\u0001\u0019AB=\u0011\u001d\tib\u0001a\u0001\u0003?Aq!!\n\u0004\u0001\u0004\t9#\u0001\u0006qKJ\u001c\u0018n\u001d;f]R,\"ba+\u00046\u000ee6QXBb)A\u0019ik!;\u0004l\u000e5H\u0011\u0001C\u0003\t\u000f!I\u0001\u0006\n\u00040\u000e\u001d71ZBg\u0007\u001f\u001c\tna6\u0004d\u000e\u001d\b\u0003CB\u0016\u0007[\u0019\td!-\u0011\u0015-;11WB\\\u0007w\u001b\t\rE\u0002y\u0007k#QA\u001f\u0003C\u0002m\u00042\u0001_B]\t\u0019\tI\u0001\u0002b\u0001wB\u0019\u0001p!0\u0005\u000f\u0005=AA1\u0001\u0004@F\u0019Apa-\u0011\u0007a\u001c\u0019\rB\u0004\u0002\u0018\u0011\u0011\ra!2\u0012\u0007q\u001c9\fC\u0004\u0002`\u0011\u0001\u001da!3\u0011\r\u0005\r\u0014\u0011NB^\u0011\u001d\ti\u0007\u0002a\u0002\u0003_Bq!a\"\u0005\u0001\b\tI\tC\u0004\u0002\u0016\u0012\u0001\u001d!a&\t\u000f\u0005\rF\u0001q\u0001\u0004TB1\u0011qUAW\u0007+\u0004\u0002\"a-\u0002:\u000em6\u0011\u0019\u0005\b\u00073$\u00019ABn\u0003\u0019\u0011X-\u00193feB1\u0011qUBo\u0007CLAaa8\u0002*\nqQ*\u00199F]R\u0014\u0018PU3bI\u0016\u0014\bcB&\u0003v\rm6\u0011\u0019\u0005\b\u0003\u007f#\u00019ABs!-Y\u00151YBZ\u0007o\u001bYl!1\t\u000f\u0005\u001dG\u0001q\u0001\u0002J\"9!q\u0004\u0003A\u0002\rM\u0006b\u0002B\r\t\u0001\u00071q\u0017\u0005\b\u0007_$\u0001\u0019ABy\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\rM8Q`\u0007\u0003\u0007kTAaa>\u0004z\u0006!a-\u001b7f\u0015\r\u0019Y\u0010]\u0001\u0004]&|\u0017\u0002BB\u0000\u0007k\u0014A\u0001U1uQ\"9A1\u0001\u0003A\u0002\tU\u0018\u0001B7nCBDq!!\b\u0005\u0001\u0004\ty\u0002C\u0004\u0002&\u0011\u0001\r!a\n\t\u000f\u0011-A\u00011\u0001\u0005\u000e\u0005A!/Z2pm\u0016\u0014\u0018\u0010\u0005\u0003\u0005\u0010\u0011UQB\u0001C\t\u0015\u0011!\u0019\"!\u000e\u0002\r\r|gNZ5h\u0013\u0011!9\u0002\"\u0005\u0003\u0019I+7m\u001c<feflu\u000eZ3\u0002\u000fI,7m\u001c<feVQAQ\u0004C\u001a\to!Y\u0004\"\u0011\u0015\u001d\u0011}A\u0011\rC2\tK\"I\u0007b\u001b\u0005nQ\u0001B\u0011\u0005C#\t\u0013\"Y\u0005\"\u0014\u0005P\u0011UCQ\f\t\t\u0007W\u0019ic!\r\u0005$A1AQ\u0005C\u0016\t_i!\u0001b\n\u000b\t\u0011%2QN\u0001\b[V$\u0018M\u00197f\u0013\u0011!i\u0003b\n\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u0006Lk\u0012EBQ\u0007C\u001d\t\u007f\u00012\u0001\u001fC\u001a\t\u0015QXA1\u0001|!\rAHq\u0007\u0003\u0007\u0003\u0013)!\u0019A>\u0011\u0007a$Y\u0004B\u0004\u0002\u0010\u0015\u0011\r\u0001\"\u0010\u0012\u0007q$\t\u0004E\u0002y\t\u0003\"q!a\u0006\u0006\u0005\u0004!\u0019%E\u0002}\tkAq!a\u0018\u0006\u0001\b!9\u0005\u0005\u0004\u0002d\u0005%D\u0011\b\u0005\b\u0003[*\u00019AA8\u0011\u001d\t9)\u0002a\u0002\u0003\u0013Cq!!&\u0006\u0001\b\t9\nC\u0004\u0002$\u0016\u0001\u001d\u0001\"\u0015\u0011\r\u0005\u001d\u0016Q\u0016C*!!\t\u0019,!/\u0005:\u0011}\u0002b\u0002C,\u000b\u0001\u000fA\u0011L\u0001\n[\u0006\u0004(+Z1eKJ\u0004b!a*\u0004^\u0012m\u0003cB&\u0003v\u0011eBq\b\u0005\b\u0003\u007f+\u00019\u0001C0!-Y\u00151\u0019C\u0019\tk!I\u0004b\u0010\t\u000f\t}Q\u00011\u0001\u00052!9!\u0011D\u0003A\u0002\u0011U\u0002b\u0002C4\u000b\u0001\u00071\u0011_\u0001\u0007M>dG-\u001a:\t\u000f\u0011\rQ\u00011\u0001\u0003v\"9\u0011QD\u0003A\u0002\u0005}\u0001b\u0002C\u0006\u000b\u0001\u0007AQB\u0001\u000e]\u0016DH/T1q+:\u001c\u0018MZ3\u0016\u0015\u0011MD1\u0010C@\t\u0007#I\t\u0006\u0004\u0005v\u0011\u0005FQ\u0015\u000b\u000f\to\"i\t\"%\u0005\u0014\u0012UEq\u0013CO!)YU\u000f\"\u001f\u0005~\u0011\u0005Eq\u0011\t\u0004q\u0012mD!\u0002>\u0007\u0005\u0004Y\bc\u0001=\u0005\u0000\u00111\u0011\u0011\u0002\u0004C\u0002m\u00042\u0001\u001fCB\t\u001d\tyA\u0002b\u0001\t\u000b\u000b2\u0001 C=!\rAH\u0011\u0012\u0003\b\u0003/1!\u0019\u0001CF#\raHQ\u0010\u0005\b\u0003?2\u00019\u0001CH!\u0019\t\u0019'!\u001b\u0005\u0002\"9\u0011Q\u000e\u0004A\u0004\u0005=\u0004bBAD\r\u0001\u000f\u0011\u0011\u0012\u0005\b\u0003+3\u00019AAL\u0011\u001d\t\u0019K\u0002a\u0002\t3\u0003b!a*\u0002.\u0012m\u0005\u0003CAZ\u0003s#\t\tb\"\t\u000f\u0005}f\u0001q\u0001\u0005 BY1*a1\u0005z\u0011uD\u0011\u0011CD\u0011\u001d!\u0019K\u0002a\u0001\u0003?\t1B\\3yi6\u000b\u0007oU5{K\"9\u00111\t\u0004A\u0002\u0011]\u0004")
public class Maps<OK, OV, K extends OK, V extends OV>
implements LazyLogging {
    private final ConcurrentLinkedDeque<Map<OK, OV, K, V>> maps;
    public final long swaydb$core$map$Maps$$fileSize;
    private final Function1<LevelZeroMeter, Accelerator> acceleration;
    private volatile Map<OK, OV, K, V> swaydb$core$map$Maps$$currentMap;
    private final KeyOrder<K> keyOrder;
    private final TimeOrder<Slice<Object>> timeOrder;
    private final FileSweeper fileSweeper;
    private final FunctionStore functionStore;
    private final MapEntryWriter<MapEntry.Put<K, V>> writer;
    private final SkipListMerger<OK, OV, K, V> skipListMerger;
    private final Timer timer;
    private Function0<BoxedUnit> onNextMapListener;
    private BrakePedal brakePedal;
    private final OV nullValue;
    private final OK nullKey;
    private volatile int totalMapsCount;
    private volatile int swaydb$core$map$Maps$$currentMapsCount;
    private volatile Slice<Map<OK, OV, K, V>> currentMapsSlice;
    private final LevelZeroMeter meter;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <OK, OV, K extends OK, V extends OV> Map<OK, OV, K, V> nextMapUnsafe(long l, Map<OK, OV, K, V> map, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> mapEntryWriter, SkipListMerger<OK, OV, K, V> skipListMerger) {
        return Maps$.MODULE$.nextMapUnsafe(l, map, keyOrder, timeOrder, fileSweeper, functionStore, mapEntryWriter, skipListMerger);
    }

    public static <OK, OV, K extends OK, V extends OV> IO<Error.Map, Maps<OK, OV, K, V>> persistent(OK OK2, OV OV, Path path, boolean bl, long l, Function1<LevelZeroMeter, Accelerator> function1, RecoveryMode recoveryMode, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> mapEntryWriter, MapEntryReader<MapEntry<K, V>> mapEntryReader, SkipListMerger<OK, OV, K, V> skipListMerger, Timer timer) {
        return Maps$.MODULE$.persistent(OK2, OV, path, bl, l, function1, recoveryMode, keyOrder, timeOrder, fileSweeper, functionStore, mapEntryWriter, mapEntryReader, skipListMerger, timer);
    }

    public static <OK, OV, K extends OK, V extends OV> Maps<OK, OV, K, V> memory(OK OK2, OV OV, long l, Function1<LevelZeroMeter, Accelerator> function1, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> mapEntryWriter, SkipListMerger<OK, OV, K, V> skipListMerger, Timer timer) {
        return new Maps<OK, OV, K, V>(new ConcurrentLinkedDeque<Map<OK, OV, K, V>>(), l, function1, Map$.MODULE$.memory(OK2, OV, l, false, keyOrder, timeOrder, functionStore, skipListMerger), keyOrder, timeOrder, fileSweeper, functionStore, mapEntryWriter, skipListMerger, timer);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ConcurrentLinkedDeque<Map<OK, OV, K, V>> maps() {
        return this.maps;
    }

    public Map<OK, OV, K, V> swaydb$core$map$Maps$$currentMap() {
        return this.swaydb$core$map$Maps$$currentMap;
    }

    private void swaydb$core$map$Maps$$currentMap_$eq(Map<OK, OV, K, V> x$1) {
        this.swaydb$core$map$Maps$$currentMap = x$1;
    }

    private Function0<BoxedUnit> onNextMapListener() {
        return this.onNextMapListener;
    }

    private void onNextMapListener_$eq(Function0<BoxedUnit> x$1) {
        this.onNextMapListener = x$1;
    }

    private BrakePedal brakePedal() {
        return this.brakePedal;
    }

    private void brakePedal_$eq(BrakePedal x$1) {
        this.brakePedal = x$1;
    }

    public OV nullValue() {
        return this.nullValue;
    }

    public OK nullKey() {
        return this.nullKey;
    }

    private int totalMapsCount() {
        return this.totalMapsCount;
    }

    private void totalMapsCount_$eq(int x$1) {
        this.totalMapsCount = x$1;
    }

    public int swaydb$core$map$Maps$$currentMapsCount() {
        return this.swaydb$core$map$Maps$$currentMapsCount;
    }

    private void swaydb$core$map$Maps$$currentMapsCount_$eq(int x$1) {
        this.swaydb$core$map$Maps$$currentMapsCount = x$1;
    }

    public Slice<Map<OK, OV, K, V>> currentMapsSlice() {
        return this.currentMapsSlice;
    }

    public void currentMapsSlice_$eq(Slice<Map<OK, OV, K, V>> x$1) {
        this.currentMapsSlice = x$1;
    }

    public LevelZeroMeter meter() {
        return this.meter;
    }

    public void onNextMapCallback(Function0<BoxedUnit> event) {
        this.onNextMapListener = event;
    }

    public synchronized void write(Function1<Timer, MapEntry<K, V>> mapEntry) {
        if (this.brakePedal() != null && this.brakePedal().applyBrakes()) {
            this.brakePedal_$eq(null);
        }
        this.persist((MapEntry)mapEntry.apply((Object)this.timer));
    }

    /*
     * WARNING - void declaration
     */
    public Slice<Map<OK, OV, K, V>> toMapsSlice() {
        void var1_7;
        void add_value;
        Slice slice;
        Slice slice2;
        Slice slice3;
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ClassTag create_evidence$3 = ClassTag$.MODULE$.apply(Map.class);
        int create_length = this.totalMapsCount();
        Slice slice4 = slice3 = new Slice((Object)new Map[create_length], 0, create_length == 0 ? -1 : create_length - 1, bl ? create_length : 0, create_evidence$3);
        slice3 = null;
        Slice slice5 = slice2 = slice4;
        slice2 = null;
        Slice slice6 = slice = slice5;
        Object var3_2 = null;
        slice = null;
        Slice slice7 = slice6;
        SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)slice7);
        Map<OK, OV, K, V> map = this.swaydb$core$map$Maps$$currentMap();
        if (sliceImplicit == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit add_this = sliceImplicit;
        add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value);
        Slice cfr_ignored_0 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
        Object var5_9 = null;
        map = null;
        this.maps().forEach(new Consumer<Map<OK, OV, K, V>>(null, slice7){
            private final Slice slice$1;

            public Consumer<Map<OK, OV, K, V>> andThen(Consumer<? super Map<OK, OV, K, V>> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(Map<OK, OV, K, V> map) {
                SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)this.slice$1);
                if (sliceImplicit == null) {
                    throw null;
                }
                SliceCompanionBase.SliceImplicit add_this = sliceImplicit;
                add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert(map);
                Slice cfr_ignored_0 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            }
            {
                this.slice$1 = slice$1;
            }
        });
        return var1_7;
    }

    public void updateMapsSlice() {
        this.currentMapsSlice_$eq(this.toMapsSlice());
    }

    private void initNextMap(long mapSize) {
        Map<OK, OV, K, V> nextMap = Maps$.MODULE$.nextMapUnsafe(mapSize, this.swaydb$core$map$Maps$$currentMap(), this.keyOrder, this.timeOrder, this.fileSweeper, this.functionStore, this.writer, this.skipListMerger);
        this.maps().addFirst(this.swaydb$core$map$Maps$$currentMap());
        this.swaydb$core$map$Maps$$currentMap_$eq(nextMap);
        this.totalMapsCount_$eq(this.totalMapsCount() + 1);
        this.swaydb$core$map$Maps$$currentMapsCount_$eq(this.swaydb$core$map$Maps$$currentMapsCount() + 1);
        this.updateMapsSlice();
        this.onNextMapListener().apply$mcV$sp();
    }

    private void persist(MapEntry<K, V> entry) {
        while (true) {
            boolean bl;
            try {
                bl = this.swaydb$core$map$Maps$$currentMap().write(entry);
            }
            catch (Throwable throwable) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(74).append("FATAL: Failed to write Map entry of size ").append(entry.entryBytesSize()).append(".byte(s). Initialising a new Map.").toString(), throwable);
                }
                this.initNextMap(this.swaydb$core$map$Maps$$fileSize);
                throw throwable;
            }
            if (bl) break;
            Accelerator accelerate = (Accelerator)this.acceleration.apply((Object)this.meter());
            if (accelerate.brake().isEmpty()) {
                this.brakePedal_$eq(null);
            } else {
                Brake brake = (Brake)accelerate.brake().get();
                this.brakePedal_$eq(new BrakePedal(brake.brakeFor(), brake.releaseRate()));
            }
            long nextMapSize = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(accelerate.nextMapSize()), (long)entry.totalByteSize());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Map full. Initialising next map of size: {}.bytes.", (Object)BoxesRunTime.boxToLong((long)nextMapSize));
            }
            this.initNextMap(nextMapSize);
        }
    }

    private final <R> R findFirst(R nullResult, Function1<Map<OK, OV, K, V>, R> f) {
        Object find$1_foundOrNullR;
        Iterator<Map<OK, OV, K, V>> iterator = this.maps().iterator();
        Map next = Maps.getNext$1(iterator);
        if (next == null) {
            return nullResult;
        }
        Map find$1_next = next;
        while (BoxesRunTime.equals((Object)(find$1_foundOrNullR = f.apply((Object)find$1_next)), nullResult)) {
            Map find$1_next2 = Maps.getNext$1(iterator);
            if (find$1_next2 == null) {
                return nullResult;
            }
            find$1_next = find$1_next2;
        }
        return (R)find$1_foundOrNullR;
    }

    private final <R> R findAndReduce(R nullResult, R initial, Function1<Map<OK, OV, K, V>, R> applier, Function2<R, R, R> reducer) {
        Iterator<Map<OK, OV, K, V>> iterator = this.maps().iterator();
        R r = initial;
        Map find$2_nextOrNull = Maps.getNextOrNull$1(iterator);
        while (find$2_nextOrNull != null) {
            Object find$2_result;
            Object find$2_previousResult;
            Object find$2_nextResult = applier.apply((Object)find$2_nextOrNull);
            if (BoxesRunTime.equals((Object)find$2_nextResult, nullResult)) {
                find$2_nextOrNull = Maps.getNextOrNull$1(iterator);
                continue;
            }
            if (BoxesRunTime.equals((Object)find$2_previousResult, nullResult)) {
                find$2_previousResult = find$2_nextResult;
                find$2_nextOrNull = Maps.getNextOrNull$1(iterator);
                continue;
            }
            find$2_previousResult = find$2_result = reducer.apply(find$2_previousResult, find$2_nextResult);
            find$2_nextOrNull = Maps.getNextOrNull$1(iterator);
        }
        return r;
    }

    /*
     * WARNING - void declaration
     */
    public <R> R find(R nullResult, Function1<Map<OK, OV, K, V>, R> matcher) {
        void var3_3;
        Object currentMatch = matcher.apply(this.swaydb$core$map$Maps$$currentMap());
        if (BoxesRunTime.equals((Object)currentMatch, nullResult)) {
            Object findFirst_find$1_foundOrNullR;
            Iterator<Map<OK, OV, K, V>> findFirst_iterator = this.maps().iterator();
            Map findFirst_next = Maps.getNext$1(findFirst_iterator);
            if (findFirst_next == null) {
                return nullResult;
            }
            Map findFirst_find$1_next = findFirst_next;
            while (BoxesRunTime.equals((Object)(findFirst_find$1_foundOrNullR = matcher.apply((Object)findFirst_find$1_next)), nullResult)) {
                Map findFirst_find$1_next2 = Maps.getNext$1(findFirst_iterator);
                if (findFirst_find$1_next2 == null) {
                    return nullResult;
                }
                findFirst_find$1_next = findFirst_find$1_next2;
            }
            return (R)findFirst_find$1_foundOrNullR;
        }
        return var3_3;
    }

    public boolean contains(K key) {
        return !BoxesRunTime.equals(this.get(key), this.nullValue());
    }

    public OV get(K key) {
        return this.find(this.nullValue(), (Function1 & Serializable)x$9 -> x$9.skipList().get(key));
    }

    public <R> R reduce(R nullValue, Function1<Map<OK, OV, K, V>, R> applier, Function2<R, R, R> reduce) {
        Object findAndReduce_initial = applier.apply(this.swaydb$core$map$Maps$$currentMap());
        Iterator<Map<OK, OV, K, V>> findAndReduce_iterator = this.maps().iterator();
        Object object = findAndReduce_initial;
        Map findAndReduce_find$2_nextOrNull = Maps.getNextOrNull$1(findAndReduce_iterator);
        while (findAndReduce_find$2_nextOrNull != null) {
            Object findAndReduce_find$2_result;
            Object findAndReduce_find$2_previousResult;
            Object findAndReduce_find$2_nextResult = applier.apply((Object)findAndReduce_find$2_nextOrNull);
            if (BoxesRunTime.equals((Object)findAndReduce_find$2_nextResult, nullValue)) {
                findAndReduce_find$2_nextOrNull = Maps.getNextOrNull$1(findAndReduce_iterator);
                continue;
            }
            if (BoxesRunTime.equals((Object)findAndReduce_find$2_previousResult, nullValue)) {
                findAndReduce_find$2_previousResult = findAndReduce_find$2_nextResult;
                findAndReduce_find$2_nextOrNull = Maps.getNextOrNull$1(findAndReduce_iterator);
                continue;
            }
            findAndReduce_find$2_previousResult = findAndReduce_find$2_result = reduce.apply(findAndReduce_find$2_previousResult, findAndReduce_find$2_nextResult);
            findAndReduce_find$2_nextOrNull = Maps.getNextOrNull$1(findAndReduce_iterator);
        }
        return (R)object;
    }

    public Option<Map<OK, OV, K, V>> lastOption() {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)Maps.$anonfun$lastOption$1(this));
        }
        catch (Throwable throwable) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<IO<Error.Map, BoxedUnit>> removeLast() {
        return Option$.MODULE$.apply(this.maps().pollLast()).map((Function1 & Serializable)removedMap -> {
            IO.Right right;
            IO.Right right2;
            Error.Map$.ExceptionHandler$ apply_evidence$13 = Error.Map$.ExceptionHandler$.MODULE$;
            try {
                removedMap.delete();
                right2 = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right2 = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            IO.Right right3 = right2;
            Object var6_2 = null;
            Object var7_5 = null;
            right2 = null;
            IO.Right right4 = right3;
            if (right4 instanceof IO.Right) {
                this.swaydb$core$map$Maps$$currentMapsCount_$eq(this.swaydb$core$map$Maps$$currentMapsCount() - 1);
                this.updateMapsSlice();
                right = IO$.MODULE$.unit();
            } else if (right4 instanceof IO.Left) {
                Error.Map error = (Error.Map)((IO.Left)right4).value();
                String mapPath = (String)removedMap.pathOption().map((Function1 & Serializable)x$10 -> ((Object)x$10).toString()).getOrElse((Function0 & Serializable)() -> "No path");
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(53).append("Failed to delete map '").append(mapPath).append(";. Adding it back to the queue.").toString(), error.exception());
                }
                this.maps().addLast((Map)removedMap);
                this.updateMapsSlice();
                right = new IO.Left((Object)error, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
            } else {
                throw new MatchError((Object)right4);
            }
            return right;
        });
    }

    public int keyValueCount() {
        return BoxesRunTime.unboxToInt((Object)this.reduce((Object)BoxesRunTime.boxToInteger((int)0), (Function1)(Function1 & Serializable)map -> BoxesRunTime.boxToInteger((int)map.size()), (Function2)(JFunction2.mcIII.sp & Serializable)(x$11, x$12) -> x$11 + x$12));
    }

    public int queuedMapsCount() {
        return this.maps().size();
    }

    public int queuedMapsCountWithCurrent() {
        return this.maps().size() + BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.swaydb$core$map$Maps$$currentMap()).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)Maps.$anonfun$queuedMapsCountWithCurrent$1(x$13))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public boolean isEmpty() {
        return this.maps().isEmpty();
    }

    public Map<OK, OV, K, V> map() {
        return this.swaydb$core$map$Maps$$currentMap();
    }

    /*
     * WARNING - void declaration
     */
    public IO<Error.Map, BoxedUnit> close() {
        void IterableIOImplicit_evidence$8;
        void IterableIOImplicit_evidence$7;
        IO.Right right;
        Error.Map$.ExceptionHandler$ apply_evidence$13 = Error.Map$.ExceptionHandler$.MODULE$;
        try {
            this.timer.close();
            right = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
        }
        catch (Throwable apply_ex) {
            right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
        }
        IO.Right right2 = right;
        Object var1_1 = null;
        Object var2_4 = null;
        right = null;
        right2.onLeftSideEffect((Function1 & Serializable)failure -> {
            Maps.$anonfun$close$2(this, failure);
            return BoxedUnit.UNIT;
        });
        ClassTag classTag = ClassTag$.MODULE$.apply(Map.class);
        Error.Map$.ExceptionHandler$ exceptionHandler$ = Error.Map$.ExceptionHandler$.MODULE$;
        Iterable IterableIOImplicit_iterable = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{this.swaydb$core$map$Maps$$currentMap()})).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(this.maps()).asScala());
        Object var4_7 = null;
        exceptionHandler$ = null;
        classTag = null;
        return (IO)new IO.IterableIOImplicit(IterableIOImplicit_iterable, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8).foreachIO((Function1 & Serializable)map -> {
            IO.Right right;
            Error.Map$.ExceptionHandler$ apply_evidence$13 = Error.Map$.ExceptionHandler$.MODULE$;
            try {
                map.close();
                right = new IO.Right((Object)BoxedUnit.UNIT, (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            return right;
        }, false).getOrElse((Function0 & Serializable)() -> IO$.MODULE$.unit());
    }

    public Iterator<Map<OK, OV, K, V>> queuedMapsIterator() {
        return this.maps().iterator();
    }

    public long stateId() {
        return this.totalMapsCount();
    }

    public Iterable<Map<OK, OV, K, V>> queuedMaps() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.maps()).asScala();
    }

    private static final Map getNext$1(Iterator iterator$1) {
        if (iterator$1.hasNext()) {
            return (Map)iterator$1.next();
        }
        return null;
    }

    private final Object find$1(Map next, Function1 f$1, Object nullResult$1, Iterator iterator$1) {
        Object foundOrNullR;
        while (BoxesRunTime.equals((Object)(foundOrNullR = f$1.apply((Object)next)), (Object)nullResult$1)) {
            Map next2 = Maps.getNext$1(iterator$1);
            if (next2 == null) {
                return nullResult$1;
            }
            next = next2;
        }
        return foundOrNullR;
    }

    private static final Map getNextOrNull$1(Iterator iterator$2) {
        if (iterator$2.hasNext()) {
            return (Map)iterator$2.next();
        }
        return null;
    }

    private final Object find$2(Map nextOrNull, Object previousResult, Function1 applier$1, Object nullResult$2, Function2 reducer$1, Iterator iterator$2) {
        while (nextOrNull != null) {
            Object result;
            Object nextResult = applier$1.apply((Object)nextOrNull);
            if (BoxesRunTime.equals((Object)nextResult, (Object)nullResult$2)) {
                nextOrNull = Maps.getNextOrNull$1(iterator$2);
                continue;
            }
            if (BoxesRunTime.equals((Object)previousResult, (Object)nullResult$2)) {
                previousResult = nextResult;
                nextOrNull = Maps.getNextOrNull$1(iterator$2);
                continue;
            }
            previousResult = result = reducer$1.apply(previousResult, nextResult);
            nextOrNull = Maps.getNextOrNull$1(iterator$2);
        }
        return previousResult;
    }

    public static final /* synthetic */ Map $anonfun$lastOption$1(Maps $this) {
        return $this.maps().getLast();
    }

    public static final /* synthetic */ void $anonfun$removeLast$2(Map removedMap$1) {
        removedMap$1.delete();
    }

    public static final /* synthetic */ int $anonfun$queuedMapsCountWithCurrent$1(Map x$13) {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$close$2(Maps $this, IO.Left failure) {
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error("Failed to close timer file", failure.exception());
        }
    }

    public static final /* synthetic */ void $anonfun$close$4(Map map$2) {
        map$2.close();
    }

    public Maps(ConcurrentLinkedDeque<Map<OK, OV, K, V>> maps, long fileSize, Function1<LevelZeroMeter, Accelerator> acceleration, Map<OK, OV, K, V> currentMap, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> writer, SkipListMerger<OK, OV, K, V> skipListMerger, Timer timer) {
        this.maps = maps;
        this.swaydb$core$map$Maps$$fileSize = fileSize;
        this.acceleration = acceleration;
        this.swaydb$core$map$Maps$$currentMap = currentMap;
        this.keyOrder = keyOrder;
        this.timeOrder = timeOrder;
        this.fileSweeper = fileSweeper;
        this.functionStore = functionStore;
        this.writer = writer;
        this.skipListMerger = skipListMerger;
        this.timer = timer;
        LazyLogging.$init$((LazyLogging)this);
        this.onNextMapListener = (JFunction0.mcV.sp & Serializable)() -> {};
        this.nullValue = this.swaydb$core$map$Maps$$currentMap().skipList().nullValue();
        this.nullKey = this.swaydb$core$map$Maps$$currentMap().skipList().nullKey();
        this.totalMapsCount = maps.size() + 1;
        this.swaydb$core$map$Maps$$currentMapsCount = maps.size() + 1;
        this.currentMapsSlice = this.toMapsSlice();
        this.meter = new LevelZeroMeter(this){
            private final /* synthetic */ Maps $outer;

            public long defaultMapSize() {
                return this.$outer.swaydb$core$map$Maps$$fileSize;
            }

            public long currentMapSize() {
                return this.$outer.swaydb$core$map$Maps$$currentMap().fileSize();
            }

            public int mapsCount() {
                return this.$outer.swaydb$core$map$Maps$$currentMapsCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

