/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.map;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.file.Path;
import scala.Option;
import scala.reflect.ScalaSignature;
import swaydb.IO;
import swaydb.core.function.FunctionStore;
import swaydb.core.map.Map;
import swaydb.core.map.MapEntry;
import swaydb.core.map.SkipListMerger;
import swaydb.core.util.SkipList;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\r\u001b\u0011\u0005B\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t3\u0002\u0011\t\u0011)A\u0005\u001f\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005_\u0001\t\u0015\r\u0011\"\u0001`\u0011!\u0019\u0007A!A!\u0002\u0013\u0001\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b1B3\t\u00115\u0004!\u0011!Q\u0001\f9D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ya\u001f\u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\f\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\t\u0003C\u0001\u0001\u0019!C\u0005?\"I\u00111\u0005\u0001A\u0002\u0013%\u0011Q\u0005\u0005\b\u0003c\u0001\u0001\u0015)\u0003a\u0011%\t\u0019\u0004\u0001a\u0001\n\u0003\t)\u0004C\u0005\u0002>\u0001\u0001\r\u0011\"\u0001\u0002@!A\u00111\t\u0001!B\u0013\t9\u0004C\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H!I\u0011\u0011\n\u0001A\u0002\u0013%\u00111\n\u0005\b\u0003\u001f\u0002\u0001\u0015)\u0003\\\u0011\u001d\tI\u0006\u0001C!\u0003\u000fBq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!1\u0011\u0011\u000f\u0001\u0005\u0002}\u0013\u0011\"T3n_JLX*\u00199\u000b\u0005ma\u0012aA7ba*\u0011QDH\u0001\u0005G>\u0014XMC\u0001 \u0003\u0019\u0019x/Y=eE\u000e\u0001Q#\u0002\u00120sq\u00025\u0003\u0002\u0001$S\r\u0003\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0002\u0016,[aZt(D\u0001\u001b\u0013\ta#DA\u0002NCB\u0004\"AL\u0018\r\u0001\u0011)\u0001\u0007\u0001b\u0001c\t\u0011qjS\t\u0003eU\u0002\"\u0001J\u001a\n\u0005Q*#a\u0002(pi\"Lgn\u001a\t\u0003IYJ!aN\u0013\u0003\u0007\u0005s\u0017\u0010\u0005\u0002/s\u0011)!\b\u0001b\u0001c\t\u0011qJ\u0016\t\u0003]q\"Q!\u0010\u0001C\u0002y\u0012\u0011aS\t\u0003e5\u0002\"A\f!\u0005\u000b\u0005\u0003!\u0019\u0001\"\u0003\u0003Y\u000b\"A\r\u001d\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015\u0001D:dC2\fGn\\4hS:<'B\u0001%J\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001&\u0002\u0007\r|W.\u0003\u0002M\u000b\nYA*\u0019>z\u0019><w-\u001b8h\u0003!\u00198.\u001b9MSN$X#A(\u0011\rA3V\u0006O\u001e@\u001d\t\tF+D\u0001S\u0015\t\u0019F$\u0001\u0003vi&d\u0017BA+S\u0003!\u00196.\u001b9MSN$\u0018BA,Y\u0005)\u0019uN\\2veJ,g\u000e\u001e\u0006\u0003+J\u000b\u0011b]6ja2K7\u000f\u001e\u0011\u0002\u001f\u0019dWo\u001d5P]>3XM\u001d4m_^\u0004\"\u0001\n/\n\u0005u+#a\u0002\"p_2,\u0017M\\\u0001\tM&dWmU5{KV\t\u0001\r\u0005\u0002%C&\u0011!-\n\u0002\u0005\u0019>tw-A\u0005gS2,7+\u001b>fA\u0005A1.Z=Pe\u0012,'\u000fE\u0002gWnj\u0011a\u001a\u0006\u0003Q&\fQa\u001c:eKJT!A\u001b\u0010\u0002\t\u0011\fG/Y\u0005\u0003Y\u001e\u0014\u0001bS3z\u001fJ$WM]\u0001\ni&lWm\u0014:eKJ\u00042AZ8r\u0013\t\u0001xMA\u0005US6,wJ\u001d3feB\u0019!/^<\u000e\u0003MT!\u0001^5\u0002\u000bMd\u0017nY3\n\u0005Y\u001c(!B*mS\u000e,\u0007C\u0001\u0013y\u0013\tIXE\u0001\u0003CsR,\u0017!\u00044v]\u000e$\u0018n\u001c8Ti>\u0014X\r\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f9\u0005Aa-\u001e8di&|g.C\u0002\u0002\u0002u\u0014QBR;oGRLwN\\*u_J,\u0017AD:lSBd\u0015n\u001d;NKJ<WM\u001d\t\bU\u0005\u001dQ\u0006O\u001e@\u0013\r\tIA\u0007\u0002\u000f'.L\u0007\u000fT5ti6+'oZ3s\u0003\u0019a\u0014N\\5u}QA\u0011qBA\u000e\u0003;\ty\u0002\u0006\u0006\u0002\u0012\u0005M\u0011QCA\f\u00033\u0001bA\u000b\u0001.qmz\u0004\"\u00023\u000b\u0001\b)\u0007\"B7\u000b\u0001\bq\u0007\"\u0002>\u000b\u0001\bY\bbBA\u0002\u0015\u0001\u000f\u0011Q\u0001\u0005\u0006\u001b*\u0001\ra\u0014\u0005\u00065*\u0001\ra\u0017\u0005\u0006=*\u0001\r\u0001Y\u0001\u0014GV\u0014(/\u001a8u\u0005f$Xm],sSR$XM\\\u0001\u0018GV\u0014(/\u001a8u\u0005f$Xm],sSR$XM\\0%KF$B!a\n\u0002.A\u0019A%!\u000b\n\u0007\u0005-RE\u0001\u0003V]&$\b\u0002CA\u0018\u0019\u0005\u0005\t\u0019\u00011\u0002\u0007a$\u0013'\u0001\u000bdkJ\u0014XM\u001c;CsR,7o\u0016:jiR,g\u000eI\u0001\u001ag.L\u0007\u000fT5ti.+\u0017PV1mk\u0016\u001cX*\u0019=D_VtG/\u0006\u0002\u00028A\u0019A%!\u000f\n\u0007\u0005mREA\u0002J]R\fQd]6ja2K7\u000f^&fsZ\u000bG.^3t\u001b\u0006D8i\\;oi~#S-\u001d\u000b\u0005\u0003O\t\t\u0005C\u0005\u00020=\t\t\u00111\u0001\u00028\u0005Q2o[5q\u0019&\u001cHoS3z-\u0006dW/Z:NCb\u001cu.\u001e8uA\u0005Iq\f[1t%\u0006tw-Z\u000b\u00027\u0006iq\f[1t%\u0006tw-Z0%KF$B!a\n\u0002N!A\u0011q\u0006\n\u0002\u0002\u0003\u00071,\u0001\u0006`Q\u0006\u001c(+\u00198hK\u0002B3aEA*!\r!\u0013QK\u0005\u0004\u0003/*#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0011!\f7OU1oO\u0016\fa\u0001Z3mKR,WCAA\u0014\u0003\u00159(/\u001b;f)\rY\u00161\r\u0005\b\u0003K2\u0002\u0019AA4\u0003\u0015)g\u000e\u001e:z!\u0015Q\u0013\u0011N\u001e@\u0013\r\tYG\u0007\u0002\t\u001b\u0006\u0004XI\u001c;ss\u0006)1\r\\8tKR\u0011\u0011qE\u0001\u0007M&dW-\u00133")
public class MemoryMap<OK, OV, K extends OK, V extends OV>
implements Map<OK, OV, K, V>,
LazyLogging {
    private final SkipList.Concurrent<OK, OV, K, V> skipList;
    private final boolean flushOnOverflow;
    private final long fileSize;
    private final KeyOrder<K> keyOrder;
    private final TimeOrder<Slice<Object>> timeOrder;
    private final FunctionStore functionStore;
    private final SkipListMerger<OK, OV, K, V> skipListMerger;
    private long currentBytesWritten;
    private int skipListKeyValuesMaxCount;
    private volatile boolean _hasRange;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public <E> IO<E, Object> writeSafe(MapEntry<K, V> mapEntry, IO.ExceptionHandler<E> evidence$1) {
        return Map.writeSafe$(this, mapEntry, evidence$1);
    }

    @Override
    public int size() {
        return Map.size$(this);
    }

    @Override
    public boolean isEmpty() {
        return Map.isEmpty$(this);
    }

    @Override
    public boolean exists() {
        return Map.exists$(this);
    }

    @Override
    public Option<Path> pathOption() {
        return Map.pathOption$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SkipList.Concurrent<OK, OV, K, V> skipList() {
        return this.skipList;
    }

    @Override
    public long fileSize() {
        return this.fileSize;
    }

    private long currentBytesWritten() {
        return this.currentBytesWritten;
    }

    private void currentBytesWritten_$eq(long x$1) {
        this.currentBytesWritten = x$1;
    }

    @Override
    public int skipListKeyValuesMaxCount() {
        return this.skipListKeyValuesMaxCount;
    }

    public void skipListKeyValuesMaxCount_$eq(int x$1) {
        this.skipListKeyValuesMaxCount = x$1;
    }

    private boolean _hasRange() {
        return this._hasRange;
    }

    private void _hasRange_$eq(boolean x$1) {
        this._hasRange = x$1;
    }

    @Override
    public boolean hasRange() {
        return this._hasRange();
    }

    @Override
    public void delete() {
        this.skipList().clear();
    }

    @Override
    public synchronized boolean write(MapEntry<K, V> entry) {
        if (this.flushOnOverflow || this.currentBytesWritten() == 0L || this.currentBytesWritten() + (long)entry.totalByteSize() <= this.fileSize()) {
            if (entry.hasRange()) {
                this._hasRange_$eq(true);
                this.skipListMerger.insert(entry, this.skipList(), this.keyOrder, this.timeOrder, this.functionStore);
            } else if (entry.hasUpdate() || entry.hasRemoveDeadline() || this._hasRange()) {
                this.skipListMerger.insert(entry, this.skipList(), this.keyOrder, this.timeOrder, this.functionStore);
            } else {
                entry.applyTo(this.skipList());
            }
            this.skipListKeyValuesMaxCount_$eq(this.skipListKeyValuesMaxCount() + entry.entriesCount());
            this.currentBytesWritten_$eq(this.currentBytesWritten() + (long)entry.totalByteSize());
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public long fileId() {
        return 0L;
    }

    public MemoryMap(SkipList.Concurrent<OK, OV, K, V> skipList, boolean flushOnOverflow, long fileSize, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, SkipListMerger<OK, OV, K, V> skipListMerger) {
        this.skipList = skipList;
        this.flushOnOverflow = flushOnOverflow;
        this.fileSize = fileSize;
        this.keyOrder = keyOrder;
        this.timeOrder = timeOrder;
        this.functionStore = functionStore;
        this.skipListMerger = skipListMerger;
        LazyLogging.$init$((LazyLogging)this);
        this.currentBytesWritten = 0L;
        this.skipListKeyValuesMaxCount = 0;
        this._hasRange = false;
    }
}

