/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.map;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import swaydb.Error;
import swaydb.IO;
import swaydb.IO$;
import swaydb.core.actor.FileSweeper;
import swaydb.core.function.FunctionStore;
import swaydb.core.io.file.BlockCache;
import swaydb.core.io.file.DBFile;
import swaydb.core.io.file.DBFile$;
import swaydb.core.io.file.Effect;
import swaydb.core.io.file.Effect$;
import swaydb.core.map.MapEntry;
import swaydb.core.map.PersistentMap;
import swaydb.core.map.RecoveryResult;
import swaydb.core.map.SkipListMerger;
import swaydb.core.map.serializer.MapCodec$;
import swaydb.core.map.serializer.MapEntryReader;
import swaydb.core.map.serializer.MapEntryWriter;
import swaydb.core.util.Extension$Log$;
import swaydb.core.util.SkipList;
import swaydb.core.util.SkipList$;
import swaydb.data.config.IOStrategy;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;

public final class PersistentMap$
implements LazyLogging,
Serializable {
    public static final PersistentMap$ MODULE$ = new PersistentMap$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public <OK, OV, K extends OK, V extends OV> RecoveryResult<PersistentMap<OK, OV, K, V>> apply(Path folder, boolean mmap, boolean flushOnOverflow, long fileSize, boolean dropCorruptedTailEntries, OK nullKey, OV nullValue, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, FileSweeper fileSweeper, MapEntryReader<MapEntry<K, V>> reader, MapEntryWriter<MapEntry.Put<K, V>> writer, SkipListMerger<OK, OV, K, V> skipListMerger) {
        void var18_17;
        Effect$.MODULE$.createDirectoryIfAbsent(folder);
        SkipList.Concurrent skipList = SkipList$.MODULE$.concurrent(nullKey, nullValue, keyOrder);
        Tuple2<RecoveryResult<DBFile>, Object> tuple2 = this.recover(folder, mmap, fileSize, skipList, dropCorruptedTailEntries, writer, reader, skipListMerger, keyOrder, fileSweeper, timeOrder, functionStore);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RecoveryResult fileRecoveryResult = (RecoveryResult)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        return new RecoveryResult<PersistentMap<OK, OV, K, V>>(new PersistentMap(folder, mmap, fileSize, flushOnOverflow, skipList, (DBFile)var18_17.item(), bl, keyOrder, timeOrder, fileSweeper, functionStore, writer, skipListMerger), var18_17.result());
    }

    public <OK, OV, K extends OK, V extends OV> PersistentMap<OK, OV, K, V> apply(Path folder, boolean mmap, boolean flushOnOverflow, long fileSize, OK nullKey, OV nullValue, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> writer, SkipListMerger<OK, OV, K, V> skipListMerger) {
        Effect$.MODULE$.createDirectoryIfAbsent(folder);
        SkipList.Concurrent skipList = SkipList$.MODULE$.concurrent(nullKey, nullValue, keyOrder);
        DBFile file = this.firstFile(folder, mmap, fileSize, fileSweeper);
        return new PersistentMap(folder, mmap, fileSize, flushOnOverflow, skipList, file, false, keyOrder, timeOrder, fileSweeper, functionStore, writer, skipListMerger);
    }

    public DBFile firstFile(Path folder, boolean memoryMapped, long fileSize, FileSweeper fileSweeper) {
        Effect.FileIdImplicits fileIdImplicits;
        if (memoryMapped) {
            Effect.FileIdImplicits fileIdImplicits2;
            long FileIdImplicits_id = 0L;
            Effect.FileIdImplicits fileIdImplicits3 = fileIdImplicits2 = new Effect.FileIdImplicits(FileIdImplicits_id);
            fileIdImplicits2 = null;
            Effect.FileIdImplicits toLogFileId_this = fileIdImplicits3;
            Object var12_7 = null;
            Path x$1 = folder.resolve(new StringBuilder(1).append(toLogFileId_this.swaydb$core$io$file$Effect$FileIdImplicits$$id).append(".").append(Extension$Log$.MODULE$).toString());
            IOStrategy.SynchronisedIO x$2 = new IOStrategy.SynchronisedIO(true);
            None$ x$7 = None$.MODULE$;
            return DBFile$.MODULE$.mmapInit(x$1, (IOStrategy)x$2, fileSize, 0L, false, fileSweeper, (Option<BlockCache.State>)x$7);
        }
        long FileIdImplicits_id = 0L;
        Effect.FileIdImplicits fileIdImplicits4 = fileIdImplicits = new Effect.FileIdImplicits(FileIdImplicits_id);
        fileIdImplicits = null;
        Effect.FileIdImplicits toLogFileId_this = fileIdImplicits4;
        Object var13_13 = null;
        Path x$8 = folder.resolve(new StringBuilder(1).append(toLogFileId_this.swaydb$core$io$file$Effect$FileIdImplicits$$id).append(".").append(Extension$Log$.MODULE$).toString());
        IOStrategy.SynchronisedIO x$9 = new IOStrategy.SynchronisedIO(true);
        None$ x$13 = None$.MODULE$;
        return DBFile$.MODULE$.channelWrite(x$8, (IOStrategy)x$9, 0L, false, fileSweeper, (Option<BlockCache.State>)x$13);
    }

    /*
     * WARNING - void declaration
     */
    public <OK, OV, K extends OK, V extends OV> Tuple2<RecoveryResult<DBFile>, Object> recover(Path folder, boolean mmap, long fileSize, SkipList.Concurrent<OK, OV, K, V> skipList, boolean dropCorruptedTailEntries, MapEntryWriter<MapEntry.Put<K, V>> writer, MapEntryReader<MapEntry<K, V>> mapReader, SkipListMerger<OK, OV, K, V> skipListMerger, KeyOrder<K> keyOrder, FileSweeper fileSweeper, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore) {
        void IterableIOImplicit_evidence$8;
        void IterableIOImplicit_evidence$7;
        IO.IterableIOImplicit iterableIOImplicit;
        BooleanRef hasRange = BooleanRef.create((boolean)false);
        ClassTag classTag = ClassTag$.MODULE$.apply(Path.class);
        Error.Map$.ExceptionHandler$ exceptionHandler$ = Error.Map$.ExceptionHandler$.MODULE$;
        List<Path> IterableIOImplicit_iterable = new Effect.PathExtensionImplicits(folder).files(Extension$Log$.MODULE$);
        IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit(IterableIOImplicit_iterable, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        Object var21_16 = null;
        exceptionHandler$ = null;
        classTag = null;
        iterableIOImplicit = null;
        IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
        Function1 & Serializable x$1 = (Function1 & Serializable)path -> {
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("{}: Recovering with dropCorruptedTailEntries = {}.", new Object[]{path, BoxesRunTime.boxToBoolean((boolean)dropCorruptedTailEntries)});
            }
            DBFile file = DBFile$.MODULE$.channelRead((Path)path, (IOStrategy)new IOStrategy.SynchronisedIO(true), false, 0L, true, fileSweeper, (Option<BlockCache.State>)None$.MODULE$);
            Slice<Object> bytes = file.readAll();
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("{}: Reading file.", path);
            }
            RecoveryResult recovery = (RecoveryResult)MapCodec$.MODULE$.read(bytes, dropCorruptedTailEntries, mapReader).get();
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("{}: Recovered! Populating in-memory map with recovered key-values.", path);
            }
            int entriesRecovered = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.option2Iterable((Option)recovery.item()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)PersistentMap$.$anonfun$recover$2(skipListMerger, skipList, keyOrder, timeOrder, functionStore, hasRange, BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(new StringBuilder(18).append("{}: Recovered {} ").append((Object)(entriesRecovered > 1 ? "entries" : "entry")).append(".").toString(), new Object[]{path, BoxesRunTime.boxToInteger((int)entriesRecovered)});
            }
            return new RecoveryResult<DBFile>(file, recovery.result());
        };
        Function2 x$22 = qual$1.mapRecover$default$2();
        boolean x$32 = qual$1.mapRecover$default$3();
        Slice recoveredFiles = qual$1.mapRecover((Function1)x$1, x$22, x$32, ClassTag$.MODULE$.apply(RecoveryResult.class));
        DBFile file = (DBFile)this.nextFile((Iterable<DBFile>)((Iterable)recoveredFiles.map((Function1 & Serializable)x$2 -> (DBFile)x$2.item())), mmap, fileSize, skipList, writer, fileSweeper).getOrElse((Function0 & Serializable)() -> MODULE$.firstFile(folder, mmap, fileSize, fileSweeper));
        return new Tuple2(new RecoveryResult<DBFile>(file, (IO<Error.Map, BoxedUnit>)((IO)recoveredFiles.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PersistentMap$.$anonfun$recover$5(x$3))).map((Function1 & Serializable)x$4 -> x$4.result()).getOrElse((Function0 & Serializable)() -> IO$.MODULE$.unit()))), (Object)BoxesRunTime.boxToBoolean((boolean)hasRange.elem));
    }

    public <OK, OV, K extends OK, V extends OV> Option<DBFile> nextFile(Iterable<DBFile> oldFiles, boolean mmap, long fileSize, SkipList.Concurrent<OK, OV, K, V> skipList, MapEntryWriter<MapEntry.Put<K, V>> writer, FileSweeper fileSweeper) {
        return oldFiles.lastOption().map((Function1 & Serializable)lastFile -> {
            DBFile file = MODULE$.nextFile((DBFile)lastFile, mmap, fileSize, skipList, writer, fileSweeper);
            try {
                ((IterableOnceOps)oldFiles.dropRight(1)).foreach((Function1 & Serializable)x$5 -> {
                    x$5.delete();
                    return BoxedUnit.UNIT;
                });
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Recovery successful");
                }
                return file;
            }
            catch (Throwable throwable) {
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error("Recovery successful but failed to delete old log file. Delete this file manually and every other file except '{}' and reboot.", new Object[]{file.path(), throwable});
                }
                throw throwable;
            }
        });
    }

    public <OK, OV, K extends OK, V extends OV> DBFile nextFile(DBFile currentFile, boolean mmap, long size, SkipList.Concurrent<OK, OV, K, V> skipList, MapEntryWriter<MapEntry.Put<K, V>> writer, FileSweeper fileSweeper) {
        DBFile dBFile;
        Path PathExtensionImplicits_path = currentFile.path();
        Object var17_7 = null;
        Path nextPath = new Effect.PathExtensionImplicits(PathExtensionImplicits_path).incrementFileId();
        Slice<Object> bytes = MapCodec$.MODULE$.write(skipList, writer);
        if (mmap) {
            IOStrategy.SynchronisedIO x$2 = new IOStrategy.SynchronisedIO(true);
            long x$3 = (long)bytes.size() + size;
            None$ x$7 = None$.MODULE$;
            dBFile = DBFile$.MODULE$.mmapInit(nextPath, (IOStrategy)x$2, x$3, 0L, false, fileSweeper, (Option<BlockCache.State>)x$7);
        } else {
            IOStrategy.SynchronisedIO x$9 = new IOStrategy.SynchronisedIO(true);
            None$ x$13 = None$.MODULE$;
            dBFile = DBFile$.MODULE$.channelWrite(nextPath, (IOStrategy)x$9, 0L, false, fileSweeper, (Option<BlockCache.State>)x$13);
        }
        DBFile newFile = dBFile;
        newFile.append(bytes);
        currentFile.delete();
        return newFile;
    }

    public <OK, OV, K extends OK, V extends OV> PersistentMap<OK, OV, K, V> apply(Path path, boolean mmap, long fileSize, boolean flushOnOverflow, SkipList.Concurrent<OK, OV, K, V> skipList, DBFile currentFile, boolean hasRangeInitial, KeyOrder<K> keyOrder, TimeOrder<Slice<Object>> timeOrder, FileSweeper fileSweeper, FunctionStore functionStore, MapEntryWriter<MapEntry.Put<K, V>> writer, SkipListMerger<OK, OV, K, V> skipListMerger) {
        return new PersistentMap<OK, OV, K, V>(path, mmap, fileSize, flushOnOverflow, skipList, currentFile, hasRangeInitial, keyOrder, timeOrder, fileSweeper, functionStore, writer, skipListMerger);
    }

    public <OK, OV, K extends OK, V extends OV> Option<Tuple7<Path, Object, Object, Object, SkipList.Concurrent<OK, OV, K, V>, DBFile, Object>> unapply(PersistentMap<OK, OV, K, V> x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.path(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.mmap()), (Object)BoxesRunTime.boxToLong((long)x$0.fileSize()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.flushOnOverflow()), x$0.skipList(), (Object)x$0.swaydb$core$map$PersistentMap$$currentFile(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.swaydb$core$map$PersistentMap$$hasRangeInitial())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PersistentMap$.class);
    }

    public static final /* synthetic */ int $anonfun$recover$2(SkipListMerger skipListMerger$1, SkipList.Concurrent skipList$1, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, BooleanRef hasRange$1, int x0$1, MapEntry x1$1) {
        if (x1$1.hasRange()) {
            skipListMerger$1.insert(x1$1, skipList$1, keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1);
            hasRange$1.elem = true;
        } else if (hasRange$1.elem || x1$1.hasUpdate() || x1$1.hasRemoveDeadline()) {
            skipListMerger$1.insert(x1$1, skipList$1, keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1);
        } else {
            x1$1.applyTo(skipList$1);
        }
        return x0$1 + x1$1.entriesCount();
    }

    public static final /* synthetic */ boolean $anonfun$recover$5(RecoveryResult x$3) {
        return x$3.result().isLeft();
    }

    private PersistentMap$() {
    }
}

