/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.map.serializer;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import swaydb.Error;
import swaydb.IO;
import swaydb.IO$;
import swaydb.core.map.MapEntry;
import swaydb.core.map.RecoveryResult;
import swaydb.core.map.serializer.MapEntryReader;
import swaydb.core.map.serializer.MapEntryWriter;
import swaydb.core.util.CRC32$;
import swaydb.core.util.SkipList;
import swaydb.data.slice.ReaderBase;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.slice.SliceReader;
import swaydb.data.util.ByteSizeOf$;
import swaydb.data.util.Bytez;
import swaydb.data.util.Bytez$;

public final class MapCodec$
implements LazyLogging {
    public static final MapCodec$ MODULE$ = new MapCodec$();
    private static final int headerSize;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        headerSize = ByteSizeOf$.MODULE$.long() + ByteSizeOf$.MODULE$.int();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public int headerSize() {
        return headerSize;
    }

    public <K, V> Option<MapEntry<K, V>> toMapEntry(SkipList<?, ?, K, V> map, MapEntryWriter<MapEntry.Put<K, V>> writer) {
        return (Option)map.asScala().foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x1$1 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = x1$1._1();
            Object value = x1$1._2();
            MapEntry.Put<Object, Object> nextEntry = new MapEntry.Put<Object, Object>(key, value, writer);
            Option option = x0$1.map((Function1 & Serializable)x$1 -> new MapEntry.MapEntriesBatch(x$1).$plus$plus(nextEntry)).orElse((Function0 & Serializable)() -> new Some((Object)nextEntry));
            return option;
        });
    }

    public <K, V> Slice<Object> write(SkipList<?, ?, K, V> map, MapEntryWriter<MapEntry.Put<K, V>> writer) {
        return (Slice)this.toMapEntry(map, writer).map((Function1 & Serializable)mapEntries -> MODULE$.write((MapEntry)mapEntries)).getOrElse((Function0 & Serializable)() -> Slice$.MODULE$.emptyBytes());
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> Slice<Object> write(MapEntry<K, V> mapEntries) {
        void var3_5;
        void addInt_int;
        void addLong_long;
        void var5_7;
        void var6_8;
        int totalSize = this.headerSize() + mapEntries.entryBytesSize();
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ManifestFactory.ByteManifest create_evidence$3 = ClassTag$.MODULE$.Byte();
        Object var7_4 = null;
        Slice slice = new Slice(create_evidence$3.newArray(totalSize), 0, totalSize == 0 ? -1 : totalSize - 1, bl ? totalSize : 0, (ClassTag)create_evidence$3);
        Tuple2 tuple2 = slice.splitInnerArrayAt(this.headerSize());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Slice headerSlice = (Slice)tuple2._1();
        Slice payloadSlice = (Slice)tuple2._2();
        mapEntries.writeTo((Slice<Object>)var6_8);
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)var5_7);
        long l = CRC32$.MODULE$.forBytes((Slice<Object>)var6_8);
        if (byteSliceImplicits == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addLong_this = byteSliceImplicits;
        Slice addLong_writeLong_slice = addLong_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeLong$((Bytez)Bytez$.MODULE$, (long)addLong_long, (Slice)addLong_writeLong_slice);
        Slice cfr_ignored_0 = addLong_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var8_10 = null;
        Object var11_11 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits2 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)var5_7);
        int n = var6_8.size();
        if (byteSliceImplicits2 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addInt_this = byteSliceImplicits2;
        Slice addInt_writeInt_slice = addInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeInt$((Bytez)Bytez$.MODULE$, (int)addInt_int, (Slice)addInt_writeInt_slice);
        Slice cfr_ignored_1 = addInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var12_13 = null;
        Object var14_14 = null;
        slice.moveWritePosition(slice.allocatedSize());
        Predef$.MODULE$.assert(var5_7.size() + var6_8.size() == slice.allocatedSize(), () -> MapCodec$.$anonfun$write$3((Slice)var5_7, (Slice)var6_8, slice));
        return var3_5;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> IO<Error.Map, RecoveryResult<Option<MapEntry<K, V>>>> read(Slice<Object> bytes, boolean dropCorruptedTailEntries, MapEntryReader<MapEntry<K, V>> mapReader) {
        Object object = new Object();
        try {
            IO.Right right;
            block8: {
                void foldLeftIO_evidence$1;
                Object foldLeftIO_result;
                block9: {
                    IO iO;
                    void foldLeftIO_result2;
                    int n = 0;
                    Error.Map$.ExceptionHandler$ exceptionHandler$ = Error.Map$.ExceptionHandler$.MODULE$;
                    RecoveryResult<Option> recoveryResult = new RecoveryResult<Option>(Option$.MODULE$.empty(), (IO<Error.Map, BoxedUnit>)IO$.MODULE$.unit());
                    SliceReader foldLeftIO_this = new SliceReader(bytes, n);
                    foldLeftIO_result = foldLeftIO_result2;
                    while (true) {
                        IO.Right right2;
                        try {
                            right2 = new IO.Right((Object)BoxesRunTime.boxToBoolean((boolean)foldLeftIO_this.hasMore()), (IO.ExceptionHandler)foldLeftIO_evidence$1);
                        }
                        catch (Throwable foldLeftIO_apply_ex) {
                            right2 = new IO.Left((Object)foldLeftIO_evidence$1.toError(foldLeftIO_apply_ex), (IO.ExceptionHandler)foldLeftIO_evidence$1);
                        }
                        Object var17_12 = null;
                        IO.Right right3 = right2;
                        if (right3 instanceof IO.Left) {
                            Object foldLeftIO_error = ((IO.Left)right3).value();
                            right = new IO.Left(foldLeftIO_error, (IO.ExceptionHandler)foldLeftIO_evidence$1);
                            break block8;
                        }
                        if (!(right3 instanceof IO.Right) || !BoxesRunTime.unboxToBoolean((Object)right3.value())) break block9;
                        RecoveryResult recoveryResult2 = (RecoveryResult)foldLeftIO_result;
                        iO = MapCodec$.$anonfun$read$1(object, mapReader, dropCorruptedTailEntries, recoveryResult2, (ReaderBase)foldLeftIO_this);
                        if (!(iO instanceof IO.Right)) break;
                        foldLeftIO_result = ((IO.Right)iO).value();
                    }
                    if (!(iO instanceof IO.Left)) {
                        throw new MatchError((Object)iO);
                    }
                    Object foldLeftIO_error = ((IO.Left)iO).value();
                    IO.Left left = new IO.Left(foldLeftIO_error, (IO.ExceptionHandler)foldLeftIO_evidence$1);
                    right = left;
                    break block8;
                }
                right = new IO.Right(foldLeftIO_result, (IO.ExceptionHandler)foldLeftIO_evidence$1);
            }
            return right;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (IO)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ String $anonfun$write$3(Slice headerSlice$1, Slice payloadSlice$1, Slice slice$1) {
        return new StringBuilder(49).append("Slice is not full. Actual size: ").append(headerSlice$1.size() + payloadSlice$1.size()).append(", allocatedSize: ").append(slice$1.allocatedSize()).toString();
    }

    public static final /* synthetic */ long $anonfun$read$3(ReaderBase reader$1) {
        return reader$1.readLong();
    }

    public static final /* synthetic */ RecoveryResult $anonfun$read$4(MapEntryReader mapReader$1, Slice payload$1, RecoveryResult recovery$1) {
        int n = 0;
        Object readMapEntry = mapReader$1.read((ReaderBase)new SliceReader(payload$1, n));
        Option nextEntry = ((Option)recovery$1.item()).map((Function1 & Serializable)x$3 -> new MapEntry.MapEntriesBatch(x$3).$plus$plus(readMapEntry)).orElse((Function0 & Serializable)() -> new Some(readMapEntry));
        return new RecoveryResult<Option>(nextEntry, recovery$1.result());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ IO $anonfun$read$1(Object nonLocalReturnKey1$1, MapEntryReader mapReader$1, boolean dropCorruptedTailEntries$1, RecoveryResult x0$1, ReaderBase x1$1) {
        IO.Right right;
        Error.Map$.ExceptionHandler$ apply_evidence$13 = Error.Map$.ExceptionHandler$.MODULE$;
        try {
            right = new IO.Right((Object)BoxesRunTime.boxToBoolean((boolean)x1$1.hasAtLeast((long)ByteSizeOf$.MODULE$.long())), (IO.ExceptionHandler)apply_evidence$13);
        }
        catch (Throwable apply_ex) {
            right = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
        }
        IO.Right right2 = right;
        Object var22_5 = null;
        Object var23_8 = null;
        right = null;
        IO.Right right3 = right2;
        if (right3 instanceof IO.Right) {
            IO.Right right4;
            IO.Left left;
            IO.Right right5;
            if (!BoxesRunTime.unboxToBoolean((Object)right3.value())) throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new IO.Right((Object)x0$1, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$));
            Error.Map$.ExceptionHandler$ apply_evidence$132 = Error.Map$.ExceptionHandler$.MODULE$;
            try {
                right5 = new IO.Right((Object)BoxesRunTime.boxToLong((long)x1$1.readLong()), (IO.ExceptionHandler)apply_evidence$132);
            }
            catch (Throwable apply_ex) {
                right5 = new IO.Left((Object)apply_evidence$132.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$132);
            }
            IO.Right right6 = right5;
            Object var25_10 = null;
            Object var26_13 = null;
            right5 = null;
            IO.Right right7 = right6;
            if (right7 instanceof IO.Right) {
                IO.Right right8;
                block18: {
                    long crc = BoxesRunTime.unboxToLong((Object)right7.value());
                    if (crc == 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new IO.Right((Object)x0$1, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$));
                    }
                    try {
                        void failed_evidence$20;
                        int length = x1$1.readInt();
                        Slice payload = x1$1.read(length);
                        long checkCRC = CRC32$.MODULE$.forBytes((Slice<Object>)payload);
                        if (crc == checkCRC) {
                            IO.Right right9;
                            Error.Map$.ExceptionHandler$ apply_evidence$133 = Error.Map$.ExceptionHandler$.MODULE$;
                            try {
                                right9 = new IO.Right((Object)MapCodec$.$anonfun$read$4(mapReader$1, payload, x0$1), (IO.ExceptionHandler)apply_evidence$133);
                            }
                            catch (Throwable apply_ex) {
                                right9 = new IO.Left((Object)apply_evidence$133.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$133);
                            }
                            right8 = right9;
                            Object var28_19 = null;
                            Object var29_22 = null;
                            right9 = null;
                            break block18;
                        }
                        String failureMessage = new StringBuilder(116).append("File corruption! Failed to match CRC check for entry at position ").append(x1$1.getPosition()).append(". CRC expected = ").append(crc).append(" actual = ").append(checkCRC).append(". Skip on corruption = ").append(dropCorruptedTailEntries$1).append(".").toString();
                        if (MODULE$.logger().underlying().isErrorEnabled()) {
                            MODULE$.logger().underlying().error(failureMessage);
                        }
                        Error.Map$.ExceptionHandler$ exceptionHandler$ = Error.Map$.ExceptionHandler$.MODULE$;
                        IllegalStateException failed_exception = new IllegalStateException(failureMessage);
                        right8 = new IO.Left((Object)failed_evidence$20.toError((Throwable)failed_exception), (IO.ExceptionHandler)failed_evidence$20);
                        Object var31_25 = null;
                        exceptionHandler$ = null;
                    }
                    catch (Throwable ex) {
                        void failed_evidence$20;
                        if (MODULE$.logger().underlying().isErrorEnabled()) {
                            MODULE$.logger().underlying().error("File corruption! Unable to read entry at position {}. dropCorruptedTailEntries = {}.", new Object[]{BoxesRunTime.boxToInteger((int)x1$1.getPosition()), BoxesRunTime.boxToBoolean((boolean)dropCorruptedTailEntries$1), ex});
                        }
                        Error.Map$.ExceptionHandler$ exceptionHandler$ = Error.Map$.ExceptionHandler$.MODULE$;
                        IllegalStateException failed_exception = new IllegalStateException(new StringBuilder(80).append("File corruption! Unable to read entry at position ").append(x1$1.getPosition()).append(". dropCorruptedTailEntries = ").append(dropCorruptedTailEntries$1).append(".").toString(), ex);
                        IO.Left left2 = new IO.Left((Object)failed_evidence$20.toError((Throwable)failed_exception), (IO.ExceptionHandler)failed_evidence$20);
                        right8 = left2;
                        Object var33_28 = null;
                        exceptionHandler$ = null;
                        left2 = null;
                    }
                }
                left = right8;
            } else {
                if (!(right7 instanceof IO.Left)) throw new MatchError((Object)right7);
                Error.Map failure = (Error.Map)((IO.Left)right7).value();
                left = new IO.Left((Object)failure, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
            }
            if (left instanceof IO.Right) {
                RecoveryResult value = (RecoveryResult)((IO.Right)left).value();
                right4 = new IO.Right((Object)value, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
                return right4;
            } else {
                if (!(left instanceof IO.Left)) throw new MatchError((Object)left);
                Error.Map failure = (Error.Map)left.value();
                if (dropCorruptedTailEntries$1) {
                    if (!MODULE$.logger().underlying().isErrorEnabled()) throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new IO.Right(new RecoveryResult(x0$1.item(), (IO<Error.Map, BoxedUnit>)new IO.Left((Object)failure, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$)), (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$));
                    MODULE$.logger().underlying().error("Skipping WAL on failure at position {}", (Object)BoxesRunTime.boxToInteger((int)x1$1.getPosition()));
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new IO.Right(new RecoveryResult(x0$1.item(), (IO<Error.Map, BoxedUnit>)new IO.Left((Object)failure, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$)), (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$));
                }
                right4 = new IO.Left((Object)failure, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
            }
            return right4;
        }
        if (!(right3 instanceof IO.Left)) throw new MatchError((Object)right3);
        Error.Map error = (Error.Map)((IO.Left)right3).value();
        return new IO.Left((Object)error, (IO.ExceptionHandler)Error.Map$.ExceptionHandler$.MODULE$);
    }

    private MapCodec$() {
    }
}

