/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment;

import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple8;
import scala.collection.Iterable;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.concurrent.duration.Deadline;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import swaydb.Error;
import swaydb.IO;
import swaydb.core.actor.FileSweeper;
import swaydb.core.actor.MemorySweeper;
import swaydb.core.cache.Cache;
import swaydb.core.cache.Cache$;
import swaydb.core.cache.CacheNoIO;
import swaydb.core.cache.DeferredIO;
import swaydb.core.cache.Lazy$;
import swaydb.core.cache.SynchronisedIO;
import swaydb.core.data.KeyValue;
import swaydb.core.data.Persistent;
import swaydb.core.data.Persistent$Null$;
import swaydb.core.data.PersistentOption;
import swaydb.core.function.FunctionStore;
import swaydb.core.io.file.BlockCache;
import swaydb.core.io.file.DBFile;
import swaydb.core.io.file.Effect$;
import swaydb.core.segment.DeadlineAndFunctionId;
import swaydb.core.segment.DeadlineAndFunctionId$;
import swaydb.core.segment.PersistentSegmentMany;
import swaydb.core.segment.SegmentIO;
import swaydb.core.segment.SegmentRef;
import swaydb.core.segment.SegmentRef$;
import swaydb.core.segment.SegmentRef$Null$;
import swaydb.core.segment.SegmentRefOption;
import swaydb.core.segment.format.a.block.BlockOffset;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchIndexBlock;
import swaydb.core.segment.format.a.block.bloomfilter.BloomFilterBlock;
import swaydb.core.segment.format.a.block.hashindex.HashIndexBlock;
import swaydb.core.segment.format.a.block.reader.BlockRefReader;
import swaydb.core.segment.format.a.block.reader.BlockRefReader$;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.segment.SegmentBlock;
import swaydb.core.segment.format.a.block.segment.SegmentBlock$SegmentBlockOps$;
import swaydb.core.segment.format.a.block.segment.data.TransientSegment;
import swaydb.core.segment.format.a.block.segment.data.TransientSegmentSerialiser$;
import swaydb.core.segment.format.a.block.segment.footer.SegmentFooterBlock;
import swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock;
import swaydb.core.segment.format.a.block.values.ValuesBlock;
import swaydb.core.util.Extension;
import swaydb.core.util.Extension$Seg$;
import swaydb.core.util.MinMax;
import swaydb.core.util.SkipList;
import swaydb.core.util.SkipList$;
import swaydb.data.MaxKey;
import swaydb.data.Reserve$;
import swaydb.data.config.IOAction;
import swaydb.data.config.IOStrategy;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.ReaderBase;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.slice.SliceOption;

public final class PersistentSegmentMany$
implements Serializable {
    public static final PersistentSegmentMany$ MODULE$ = new PersistentSegmentMany$();
    private static final byte formatId = (byte)127;
    private static final Slice<Object> formatIdSlice;

    static {
        ManifestFactory.ByteManifest apply_evidence$7 = ClassTag$.MODULE$.Byte();
        ArraySeq apply_data = ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{MODULE$.formatId()});
        formatIdSlice = SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)apply_data.toArray((ClassTag)apply_evidence$7), (ClassTag)apply_evidence$7);
    }

    public byte formatId() {
        return formatId;
    }

    public Slice<Object> formatIdSlice() {
        return formatIdSlice;
    }

    public PersistentSegmentMany apply(DBFile file, int createdInLevel, TransientSegment.Many segment, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, Option<BlockCache.State> blockCache, FileSweeper.Enabled fileSweeper, SegmentIO segmentIO) {
        None$ none$;
        if (segment.segments().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            SkipList.Immutable skipList = SkipList$.MODULE$.immutable(Slice.Null$.MODULE$, SegmentRef$Null$.MODULE$, keyOrder);
            Option blockMemorySweeper = blockCache.map((Function1 & Serializable)x$1 -> x$1.sweeper());
            int firstSegmentOffset = segment.headerSize() + ((TransientSegment.One)segment.segments().head()).segmentSize();
            segment.segments().dropHead().foldLeft((Object)BoxesRunTime.boxToInteger((int)firstSegmentOffset), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)PersistentSegmentMany$.$anonfun$apply$2(file, segmentIO, keyOrder, blockMemorySweeper, keyValueMemorySweeper, skipList, BoxesRunTime.unboxToInt((Object)x0$1), x1$1)));
            none$ = new Some(skipList);
        }
        None$ initial = none$;
        Slice<Object> x$3 = segment.minKey();
        MaxKey<Slice<Object>> x$4 = segment.maxKey();
        Option<MinMax<Slice<Object>>> x$5 = segment.minMaxFunctionId();
        int x$6 = segment.segmentSize();
        Option<Deadline> x$7 = segment.nearestPutDeadline();
        return this.apply(file, x$6, createdInLevel, x$3, x$4, x$5, x$7, (Option<SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>>)initial, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, blockCache, fileSweeper, segmentIO);
    }

    /*
     * WARNING - void declaration
     */
    public PersistentSegmentMany apply(DBFile file, int segmentSize, int createdInLevel, Slice<Object> minKey, MaxKey<Slice<Object>> maxKey, Option<MinMax<Slice<Object>>> minMaxFunctionId, Option<Deadline> nearestExpiryDeadline, Option<SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>> initial, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, Option<BlockCache.State> blockCache, FileSweeper.Enabled fileSweeper, SegmentIO segmentIO) {
        DeferredIO<Error.Segment, BoxedUnit, SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>> deferredIO;
        void deferredIO_noIO_stored;
        void deferredIO_noIO_fetch;
        CacheNoIO cacheNoIO;
        None$ none$;
        Object var30_22;
        SynchronisedIO synchronisedIO;
        SynchronisedIO synchronisedIO2;
        SynchronisedIO synchronisedIO3;
        Option blockCacheMemorySweeper = blockCache.map((Function1 & Serializable)x$2 -> x$2.sweeper());
        BlockRefReader<SegmentBlock.Offset> fileBlockRef = BlockRefReader$.MODULE$.apply(file, 1, segmentSize - 1);
        Function1 & Serializable x$22 = (Function1 & Serializable)x$3 -> ((IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.ReadDataOverview$.MODULE$)).forceCacheOnAccess();
        Function0 & Serializable x$32 = (Function0 & Serializable)() -> new Error.ReservedResource(Reserve$.MODULE$.free(new StringBuilder(2).append(file.path()).append(": ").append(MODULE$.getClass().getSimpleName()).toString()));
        Function2 & Serializable x$52 = (Function2 & Serializable)(x$4, x$5) -> {
            IO.Left left;
            Error.Segment$.ExceptionHandler$ apply_evidence$13 = Error.Segment$.ExceptionHandler$.MODULE$;
            try {
                left = new IO.Right((Object)PersistentSegmentMany$.MODULE$.parseSkipList(file, (Slice<Object>)minKey, (MaxKey<Slice<Object>>)maxKey, fileBlockRef, (KeyOrder<Slice<Object>>)keyOrder, (Option<MemorySweeper.KeyValue>)keyValueMemorySweeper, (Option<MemorySweeper.Block>)blockCacheMemorySweeper, segmentIO), (IO.ExceptionHandler)apply_evidence$13);
            }
            catch (Throwable apply_ex) {
                left = new IO.Left((Object)apply_evidence$13.toError(apply_ex), (IO.ExceptionHandler)apply_evidence$13);
            }
            return left;
        };
        Error.Segment$.ExceptionHandler$ deferredIO_evidence$7 = Error.Segment$.ExceptionHandler$.MODULE$;
        if (initial.isDefined()) {
            IOStrategy.ConcurrentIO deferredIO_innerCache$1_ioStrategy = new IOStrategy.ConcurrentIO(true);
            boolean deferredIO_innerCache$1_io_cacheOnAccess = deferredIO_innerCache$1_ioStrategy.cacheOnAccess();
            boolean deferredIO_innerCache$1_io_concurrentIO_synchronised = false;
            SynchronisedIO synchronisedIO4 = synchronisedIO3 = new SynchronisedIO(x$52, Lazy$.MODULE$.io(deferredIO_innerCache$1_io_concurrentIO_synchronised, deferredIO_innerCache$1_io_cacheOnAccess, initial, deferredIO_evidence$7), deferredIO_evidence$7);
            synchronisedIO3 = null;
            SynchronisedIO synchronisedIO5 = synchronisedIO2 = synchronisedIO4;
            synchronisedIO2 = null;
            synchronisedIO3 = null;
            SynchronisedIO synchronisedIO6 = synchronisedIO = synchronisedIO5;
            var30_22 = null;
            synchronisedIO = null;
            SynchronisedIO deferredIO_cache = synchronisedIO6;
            initial.get();
            none$ = new Some(deferredIO_cache);
        } else {
            none$ = None$.MODULE$;
        }
        None$ deferredIO_initialInner = none$;
        Function2 & Serializable intersect = (arg_0, arg_1) -> Cache$.$anonfun$deferredIO$1(x$22, x$32, x$52, (IO.ExceptionHandler)deferredIO_evidence$7, arg_0, arg_1);
        boolean bl = true;
        boolean deferredIO_noIO_synchronised = true;
        CacheNoIO cacheNoIO2 = cacheNoIO = new CacheNoIO(deferredIO_noIO_fetch, Lazy$.MODULE$.value(deferredIO_noIO_synchronised, (boolean)deferredIO_noIO_stored, deferredIO_initialInner));
        intersect = null;
        cacheNoIO = null;
        CacheNoIO deferredIO_cache = cacheNoIO2;
        DeferredIO<Error.Segment, BoxedUnit, SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>> deferredIO2 = deferredIO = new DeferredIO<Error.Segment, BoxedUnit, SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>>(deferredIO_cache, (IO.ExceptionHandler<Error.Segment>)deferredIO_evidence$7);
        Object var22_21 = null;
        Object var23_29 = null;
        Object var24_28 = null;
        Object var25_34 = null;
        var30_22 = null;
        synchronisedIO2 = null;
        synchronisedIO3 = null;
        synchronisedIO = null;
        deferredIO = null;
        DeferredIO<Error.Segment, BoxedUnit, SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>> segments = deferredIO2;
        return new PersistentSegmentMany(file, createdInLevel, minKey, maxKey, minMaxFunctionId, segmentSize, nearestExpiryDeadline, segments, keyOrder, timeOrder, functionStore, blockCache, fileSweeper, keyValueMemorySweeper, segmentIO);
    }

    public PersistentSegmentMany apply(DBFile file, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, Option<MemorySweeper.Block> blockCacheMemorySweeper, Option<BlockCache.State> blockCache, FileSweeper.Enabled fileSweeper, SegmentIO segmentIO) {
        MaxKey.Fixed fixed;
        Extension fileExtension;
        Extension extension = fileExtension = Effect$.MODULE$.fileExtension(file.path());
        Extension$Seg$ extension$Seg$ = Extension$Seg$.MODULE$;
        if (extension == null || !extension.equals(extension$Seg$)) {
            throw new Exception(new StringBuilder(32).append("Invalid Segment file extension: ").append(fileExtension).toString());
        }
        BlockRefReader<SegmentBlock.Offset> fileBlockRef = BlockRefReader$.MODULE$.apply(file, 1, (int)file.fileSize() - 1);
        SegmentRef listSegment = this.parseListSegment(file, null, null, fileBlockRef, keyOrder, keyValueMemorySweeper, blockCacheMemorySweeper, segmentIO);
        SegmentFooterBlock footer = listSegment.getFooter();
        List segmentRefKeyValues = listSegment.iterator().toList();
        DeadlineAndFunctionId deadlineFunctionId = DeadlineAndFunctionId$.MODULE$.apply((Iterable<KeyValue>)segmentRefKeyValues);
        SegmentRefOption segmentRefOption = (SegmentRefOption)this.parseSkipList(file, null, null, fileBlockRef, keyOrder, keyValueMemorySweeper, blockCacheMemorySweeper, segmentIO).last();
        if (SegmentRef$Null$.MODULE$.equals(segmentRefOption)) {
            throw new Exception("Empty List Segment read. List Segment are non-empty lists.");
        }
        if (!(segmentRefOption instanceof SegmentRef)) {
            throw new MatchError((Object)segmentRefOption);
        }
        SegmentRef segmentRef = (SegmentRef)segmentRefOption;
        PersistentOption lastKeyValue = (PersistentOption)segmentRef.iterator().foldLeft((Object)Persistent$Null$.MODULE$, (Function2 & Serializable)(x0$1, x1$1) -> x1$1);
        if (lastKeyValue instanceof Persistent.Fixed) {
            Persistent.Fixed fixed2 = (Persistent.Fixed)lastKeyValue;
            fixed = new MaxKey.Fixed((Object)fixed2.key().unslice());
        } else if (lastKeyValue instanceof Persistent.Range) {
            Persistent.Range range = (Persistent.Range)lastKeyValue;
            fixed = new MaxKey.Range((Object)range.fromKey().unslice(), (Object)range.toKey().unslice());
        } else {
            if (Persistent$Null$.MODULE$.equals(lastKeyValue)) {
                throw new Exception("Empty Segment read. Persisted Segments cannot be empty.");
            }
            throw new MatchError((Object)lastKeyValue);
        }
        return this.apply(file, (int)file.fileSize(), footer.createdInLevel(), (Slice<Object>)((Persistent.Partial)segmentRefKeyValues.head()).key().unslice(), (MaxKey<Slice<Object>>)fixed, (Option<MinMax<Slice<Object>>>)deadlineFunctionId.minMaxFunctionId().map((Function1 & Serializable)x$6 -> new MinMax.MinMaxByteImplicits((MinMax<Slice<Object>>)x$6).unslice()), deadlineFunctionId.nearestDeadline(), (Option<SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>>)None$.MODULE$, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, blockCache, fileSweeper, segmentIO);
    }

    private SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef> parseSkipList(DBFile file, Slice<Object> minKey, MaxKey<Slice<Object>> maxKey, BlockRefReader<SegmentBlock.Offset> fileBlockRef, KeyOrder<Slice<Object>> keyOrder, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, Option<MemorySweeper.Block> blockCacheMemorySweeper, SegmentIO segmentIO) {
        ReaderBase blockedReader = fileBlockRef.copy();
        int listSegmentSize = blockedReader.readUnsignedInt();
        Slice<Object> listSegment = blockedReader.read(listSegmentSize);
        BlockRefReader<SegmentBlock.Offset> listSegmentRef = BlockRefReader$.MODULE$.apply(listSegment, SegmentBlock$SegmentBlockOps$.MODULE$);
        SegmentRef segmentRef = SegmentRef$.MODULE$.apply(file.path(), minKey, maxKey, listSegmentRef, segmentIO, (Option<UnblockedReader<ValuesBlock.Offset, ValuesBlock>>)None$.MODULE$, (Option<UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<HashIndexBlock.Offset, HashIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock>>)None$.MODULE$, (Option<SegmentFooterBlock>)None$.MODULE$, keyOrder, blockCacheMemorySweeper, keyValueMemorySweeper);
        SkipList.Immutable skipList = SkipList$.MODULE$.immutable(Slice.Null$.MODULE$, SegmentRef$Null$.MODULE$, keyOrder);
        int tailSegmentBytesFromOffset = blockedReader.getPosition();
        int tailManySegmentsSize = (int)fileBlockRef.size() - tailSegmentBytesFromOffset;
        ObjectRef previousPath = ObjectRef.create(null);
        ObjectRef previousSegmentRef = ObjectRef.create(null);
        segmentRef.iterator().foreach((Function1 & Serializable)keyValue -> {
            PersistentSegmentMany$.$anonfun$parseSkipList$1(fileBlockRef, tailSegmentBytesFromOffset, tailManySegmentsSize, file, keyOrder, segmentIO, blockCacheMemorySweeper, keyValueMemorySweeper, previousPath, previousSegmentRef, skipList, keyValue);
            return BoxedUnit.UNIT;
        });
        return skipList;
    }

    private SegmentRef parseListSegment(DBFile file, Slice<Object> minKey, MaxKey<Slice<Object>> maxKey, BlockRefReader<SegmentBlock.Offset> fileBlockRef, KeyOrder<Slice<Object>> keyOrder, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, Option<MemorySweeper.Block> blockCacheMemorySweeper, SegmentIO segmentIO) {
        ReaderBase blockedReader = fileBlockRef.copy();
        int listSegmentSize = blockedReader.readUnsignedInt();
        Slice<Object> listSegment = blockedReader.read(listSegmentSize);
        BlockRefReader<SegmentBlock.Offset> listSegmentRef = BlockRefReader$.MODULE$.apply(listSegment, SegmentBlock$SegmentBlockOps$.MODULE$);
        return SegmentRef$.MODULE$.apply(file.path(), minKey, maxKey, listSegmentRef, segmentIO, (Option<UnblockedReader<ValuesBlock.Offset, ValuesBlock>>)None$.MODULE$, (Option<UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<HashIndexBlock.Offset, HashIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock>>)None$.MODULE$, (Option<SegmentFooterBlock>)None$.MODULE$, keyOrder, blockCacheMemorySweeper, keyValueMemorySweeper);
    }

    public PersistentSegmentMany apply(DBFile file, int createdInLevel, Slice<Object> minKey, MaxKey<Slice<Object>> maxKey, Option<MinMax<Slice<Object>>> minMaxFunctionId, int segmentSize, Option<Deadline> nearestPutDeadline, Cache<Error.Segment, BoxedUnit, SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>> segmentsCache, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<BlockCache.State> blockCache, FileSweeper.Enabled fileSweeper, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, SegmentIO segmentIO) {
        return new PersistentSegmentMany(file, createdInLevel, minKey, maxKey, minMaxFunctionId, segmentSize, nearestPutDeadline, segmentsCache, keyOrder, timeOrder, functionStore, blockCache, fileSweeper, keyValueMemorySweeper, segmentIO);
    }

    public Option<Tuple8<DBFile, Object, Slice<Object>, MaxKey<Slice<Object>>, Option<MinMax<Slice<Object>>>, Object, Option<Deadline>, Cache<Error.Segment, BoxedUnit, SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>>>> unapply(PersistentSegmentMany x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)x$0.file(), (Object)BoxesRunTime.boxToInteger((int)x$0.createdInLevel()), x$0.minKey(), x$0.maxKey(), x$0.minMaxFunctionId(), (Object)BoxesRunTime.boxToInteger((int)x$0.segmentSize()), x$0.nearestPutDeadline(), x$0.segmentsCache()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PersistentSegmentMany$.class);
    }

    public static final /* synthetic */ int $anonfun$apply$2(DBFile file$1, SegmentIO segmentIO$1, KeyOrder keyOrder$1, Option blockMemorySweeper$1, Option keyValueMemorySweeper$1, SkipList.Immutable skipList$1, int x0$1, TransientSegment.One x1$1) {
        int thisSegmentSize = x1$1.segmentSize();
        BlockRefReader<SegmentBlock.Offset> blockRef = BlockRefReader$.MODULE$.apply(file$1, x0$1, thisSegmentSize);
        SegmentRef ref = SegmentRef$.MODULE$.apply(file$1.path().resolve(new StringBuilder(5).append(".ref.").append(x0$1).toString()), x1$1.minKey(), x1$1.maxKey(), blockRef, segmentIO$1, x1$1.valuesUnblockedReader(), x1$1.sortedIndexUnblockedReader(), x1$1.hashIndexUnblockedReader(), x1$1.binarySearchUnblockedReader(), x1$1.bloomFilterUnblockedReader(), x1$1.footerUnblocked(), (KeyOrder<Slice<Object>>)keyOrder$1, (Option<MemorySweeper.Block>)blockMemorySweeper$1, (Option<MemorySweeper.KeyValue>)keyValueMemorySweeper$1);
        skipList$1.put(x1$1.minKey(), ref);
        return x0$1 + thisSegmentSize;
    }

    public static final /* synthetic */ void $anonfun$parseSkipList$1(BlockRefReader fileBlockRef$2, int tailSegmentBytesFromOffset$1, int tailManySegmentsSize$1, DBFile file$3, KeyOrder keyOrder$3, SegmentIO segmentIO$3, Option blockCacheMemorySweeper$2, Option keyValueMemorySweeper$3, ObjectRef previousPath$1, ObjectRef previousSegmentRef$1, SkipList.Immutable skipList$2, Persistent keyValue) {
        SegmentRef segmentRef;
        BlockRefReader<SegmentBlock.Offset> thisSegmentBlockRef = BlockRefReader$.MODULE$.apply((BlockRefReader<? extends BlockOffset>)fileBlockRef$2.copy(), tailSegmentBytesFromOffset$1, tailManySegmentsSize$1, SegmentBlock$SegmentBlockOps$.MODULE$);
        if (keyValue instanceof Persistent.Range) {
            Persistent.Range range = (Persistent.Range)keyValue;
            segmentRef = TransientSegmentSerialiser$.MODULE$.toSegmentRef(file$3.path(), thisSegmentBlockRef, range, (Option<UnblockedReader<ValuesBlock.Offset, ValuesBlock>>)None$.MODULE$, (Option<UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<HashIndexBlock.Offset, HashIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock>>)None$.MODULE$, (Option<SegmentFooterBlock>)None$.MODULE$, (KeyOrder<Slice<Object>>)keyOrder$3, segmentIO$3, (Option<MemorySweeper.Block>)blockCacheMemorySweeper$2, (Option<MemorySweeper.KeyValue>)keyValueMemorySweeper$3);
        } else if (keyValue instanceof Persistent.Put) {
            Persistent.Put put = (Persistent.Put)keyValue;
            segmentRef = TransientSegmentSerialiser$.MODULE$.toSegmentRef(file$3.path(), thisSegmentBlockRef, put, (Option<UnblockedReader<ValuesBlock.Offset, ValuesBlock>>)None$.MODULE$, (Option<UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<HashIndexBlock.Offset, HashIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>>)None$.MODULE$, (Option<UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock>>)None$.MODULE$, (Option<SegmentFooterBlock>)None$.MODULE$, (KeyOrder<Slice<Object>>)keyOrder$3, segmentIO$3, (Option<MemorySweeper.Block>)blockCacheMemorySweeper$2, (Option<MemorySweeper.KeyValue>)keyValueMemorySweeper$3);
        } else {
            if (keyValue instanceof Persistent.Fixed) {
                throw new Exception("Non put key-value written to List segment");
            }
            throw new MatchError((Object)keyValue);
        }
        Path path = (Path)previousPath$1.elem;
        Path path2 = segmentRef.path();
        SegmentRef segmentRef2 = !(path != null ? !((Object)path).equals(path2) : path2 != null) ? (SegmentRef)previousSegmentRef$1.elem : segmentRef;
        previousPath$1.elem = segmentRef2.path();
        previousSegmentRef$1.elem = segmentRef2;
        skipList$2.put(segmentRef2.minKey(), segmentRef2);
    }

    private PersistentSegmentMany$() {
    }
}

