/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Deadline;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import swaydb.Aggregator;
import swaydb.Error;
import swaydb.IO;
import swaydb.core.actor.FileSweeper;
import swaydb.core.actor.MemorySweeper;
import swaydb.core.data.KeyValue;
import swaydb.core.data.Memory;
import swaydb.core.data.Memory$Null$;
import swaydb.core.data.MemoryOption;
import swaydb.core.data.Persistent;
import swaydb.core.data.Time$;
import swaydb.core.data.Value;
import swaydb.core.data.Value$FromValue$Null$;
import swaydb.core.function.FunctionStore;
import swaydb.core.io.file.BlockCache;
import swaydb.core.io.file.DBFile;
import swaydb.core.io.file.DBFile$;
import swaydb.core.io.file.Effect$;
import swaydb.core.level.PathsDistributor;
import swaydb.core.segment.MemorySegment;
import swaydb.core.segment.PersistentSegment;
import swaydb.core.segment.PersistentSegmentMany;
import swaydb.core.segment.PersistentSegmentMany$;
import swaydb.core.segment.PersistentSegmentOne;
import swaydb.core.segment.PersistentSegmentOne$;
import swaydb.core.segment.Segment;
import swaydb.core.segment.Segment$Null$;
import swaydb.core.segment.SegmentAssigner$;
import swaydb.core.segment.SegmentIO;
import swaydb.core.segment.SegmentIO$;
import swaydb.core.segment.SegmentOption;
import swaydb.core.segment.SegmentRef;
import swaydb.core.segment.SegmentRefOption;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchIndexBlock;
import swaydb.core.segment.format.a.block.bloomfilter.BloomFilterBlock;
import swaydb.core.segment.format.a.block.hashindex.HashIndexBlock;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.segment.SegmentBlock;
import swaydb.core.segment.format.a.block.segment.SegmentBlock$;
import swaydb.core.segment.format.a.block.segment.data.TransientSegment;
import swaydb.core.segment.format.a.block.segment.footer.SegmentFooterBlock;
import swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock;
import swaydb.core.segment.format.a.block.values.ValuesBlock;
import swaydb.core.segment.merge.MergeStats;
import swaydb.core.segment.merge.MergeStats$;
import swaydb.core.segment.merge.MergeStats$Memory$;
import swaydb.core.segment.merge.SegmentGrouper$;
import swaydb.core.util.BlockCacheFileIDGenerator$;
import swaydb.core.util.Collections;
import swaydb.core.util.FiniteDurations$;
import swaydb.core.util.IDGenerator;
import swaydb.core.util.MinMax;
import swaydb.core.util.MinMax$;
import swaydb.core.util.SkipList;
import swaydb.core.util.SkipList$;
import swaydb.data.MaxKey;
import swaydb.data.config.IOAction;
import swaydb.data.config.IOStrategy;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.slice.SliceOption;
import swaydb.data.util.SomeOrNone;

public final class Segment$
implements LazyLogging {
    public static final Segment$ MODULE$ = new Segment$();
    private static final Iterable<Segment> emptyIterable;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        emptyIterable = (Iterable)package$.MODULE$.Iterable().empty();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Iterable<Segment> emptyIterable() {
        return emptyIterable;
    }

    /*
     * WARNING - void declaration
     */
    public Slice<MemorySegment> memory(int minSegmentSize, int maxKeyValueCountPerSegment, PathsDistributor pathsDistributor, long createdInLevel, MergeStats.Memory.Closed<Iterable> keyValues, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, FileSweeper.Enabled fileSweeper, IDGenerator idGenerator) {
        void from_evidence$6;
        if (keyValues.isEmpty()) {
            String throwable_message = "Empty key-values submitted to memory Segment.";
            Object var22_11 = null;
            throw new Exception(throwable_message);
        }
        ListBuffer segments = ListBuffer$.MODULE$.empty();
        ObjectRef skipList = ObjectRef.create(SkipList$.MODULE$.immutable(Slice.Null$.MODULE$, Memory$Null$.MODULE$, keyOrder));
        ObjectRef minMaxFunctionId = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef nearestDeadline = ObjectRef.create((Object)None$.MODULE$);
        BooleanRef hasRange = BooleanRef.create((boolean)false);
        BooleanRef hasPut = BooleanRef.create((boolean)false);
        IntRef currentSegmentSize = IntRef.create((int)0);
        IntRef currentSegmentKeyValuesCount = IntRef.create((int)0);
        ObjectRef minKey = ObjectRef.create(null);
        ObjectRef lastKeyValue = ObjectRef.create(null);
        ((IterableOnceOps)keyValues.keyValues()).foreach((Function1 & Serializable)keyValue -> {
            Segment$.$anonfun$memory$3(minKey, lastKeyValue, currentSegmentSize, currentSegmentKeyValuesCount, minSegmentSize, maxKeyValueCountPerSegment, hasPut, nearestDeadline, skipList, minMaxFunctionId, hasRange, pathsDistributor, idGenerator, createdInLevel, keyOrder, timeOrder, functionStore, fileSweeper, segments, keyValue);
            return BoxedUnit.UNIT;
        });
        if ((Memory)lastKeyValue.elem != null) {
            Memory.Fixed fixed;
            MaxKey.Range range;
            Memory.Range range2;
            long createSegment$1_segmentId_id = idGenerator.nextID();
            Path createSegment$1_path = pathsDistributor.next().resolve(new java.lang.StringBuilder(1).append(createSegment$1_segmentId_id).append(".").append("seg").toString());
            Slice slice = ((Slice)minKey.elem).unslice();
            Memory memory = (Memory)lastKeyValue.elem;
            if (memory instanceof Memory.Range) {
                range2 = (Memory.Range)memory;
                range = new MaxKey.Range((Object)range2.fromKey().unslice(), (Object)range2.toKey().unslice());
            } else if (memory instanceof Memory.Fixed) {
                fixed = (Memory.Fixed)memory;
                range = new MaxKey.Fixed((Object)fixed.key().unslice());
            } else {
                throw new MatchError((Object)memory);
            }
            MemorySegment createSegment$1_segment = new MemorySegment(createSegment$1_path, (Slice<Object>)slice, (MaxKey<Slice<Object>>)range, (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId.elem), currentSegmentSize.elem, hasRange.elem, hasPut.elem, (int)createdInLevel, (SkipList.Immutable)skipList.elem, (Option<Deadline>)((Option)nearestDeadline.elem), keyOrder, timeOrder, functionStore, fileSweeper);
            segments.$plus$eq((Object)createSegment$1_segment);
            skipList.elem = SkipList$.MODULE$.immutable(Slice.Null$.MODULE$, Memory$Null$.MODULE$, keyOrder);
            minMaxFunctionId.elem = None$.MODULE$;
            nearestDeadline.elem = None$.MODULE$;
            hasRange.elem = false;
            hasPut.elem = false;
            currentSegmentSize.elem = 0;
            currentSegmentKeyValuesCount.elem = 0;
            minKey.elem = null;
            lastKeyValue.elem = null;
            range = null;
            Object var26_23 = null;
            Object var27_28 = null;
            memory = null;
            range2 = null;
            fixed = null;
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(MemorySegment.class);
        int from_size = segments.size();
        return SliceCompanionBase.from$((SliceCompanionBase)Slice$.MODULE$, (Iterable)segments, (int)from_size, (ClassTag)from_evidence$6);
    }

    public Slice<PersistentSegment> persistent(PathsDistributor pathsDistributor, int createdInLevel, BloomFilterBlock.Config bloomFilterConfig, HashIndexBlock.Config hashIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, SortedIndexBlock.Config sortedIndexConfig, ValuesBlock.Config valuesConfig, SegmentBlock.Config segmentConfig, MergeStats.Persistent.Closed<Iterable> mergeStats, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, FileSweeper.Enabled fileSweeper, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, Option<BlockCache.State> blockCache, SegmentIO segmentIO, IDGenerator idGenerator) {
        Slice<TransientSegment> slice = SegmentBlock$.MODULE$.writeOneOrMany(mergeStats, createdInLevel, bloomFilterConfig, hashIndexConfig, binarySearchIndexConfig, sortedIndexConfig, valuesConfig, segmentConfig);
        return this.persistent(pathsDistributor, createdInLevel, segmentConfig.mmapReads(), segmentConfig.mmapWrites(), (Iterable<TransientSegment>)slice, keyOrder, timeOrder, functionStore, fileSweeper, keyValueMemorySweeper, blockCache, segmentIO, idGenerator);
    }

    /*
     * WARNING - void declaration
     */
    public Slice<PersistentSegment> persistent(PathsDistributor pathsDistributor, int createdInLevel, boolean mmapReads, boolean mmapWrites, Iterable<TransientSegment> segments2, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, FileSweeper.Enabled fileSweeper, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, Option<BlockCache.State> blockCache, SegmentIO segmentIO, IDGenerator idGenerator) {
        void IterableIOImplicit_evidence$8;
        IO.IterableIOImplicit iterableIOImplicit;
        ClassTag classTag = ClassTag$.MODULE$.apply(TransientSegment.class);
        Error.Segment$.ExceptionHandler$ IterableIOImplicit_evidence$7 = Error.Segment$.ExceptionHandler$.MODULE$;
        IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit(segments2, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        Object var18_15 = null;
        classTag = null;
        iterableIOImplicit = null;
        IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
        Function1 & Serializable x$5 = (Function1 & Serializable)segment -> {
            PersistentSegment persistentSegment;
            if (segment.isEmpty()) {
                String throwable_message = "Empty key-values submitted to persistent Segment.";
                Object var19_13 = null;
                throw new Exception(throwable_message);
            }
            long segmentId_id = idGenerator.nextID();
            Path path = pathsDistributor.next().resolve(new java.lang.StringBuilder(1).append(segmentId_id).append(".").append("seg").toString());
            Slice<Slice<Object>> x$3 = segment.segmentBytes();
            DBFile file = MODULE$.segmentFile(path, mmapReads, mmapWrites, x$3, segmentIO, fileSweeper, blockCache);
            if (segment instanceof TransientSegment.One) {
                TransientSegment.One one = (TransientSegment.One)segment;
                persistentSegment = PersistentSegmentOne$.MODULE$.apply(file, createdInLevel, one, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, blockCache, fileSweeper, segmentIO);
            } else if (segment instanceof TransientSegment.Many) {
                TransientSegment.Many many = (TransientSegment.Many)segment;
                persistentSegment = PersistentSegmentMany$.MODULE$.apply(file, createdInLevel, many, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, blockCache, fileSweeper, segmentIO);
            } else {
                throw new MatchError(segment);
            }
            return persistentSegment;
        };
        Function2 & Serializable x$6 = (Function2 & Serializable)(segments, x$2) -> {
            segments.foreach((Function1 & Serializable)segmentToDelete -> {
                Segment$.$anonfun$persistent$3(segmentToDelete);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        boolean x$7 = qual$1.mapRecover$default$3();
        return qual$1.mapRecover((Function1)x$5, (Function2)x$6, x$7, ClassTag$.MODULE$.apply(PersistentSegment.class));
    }

    private DBFile segmentFile(Path path, boolean mmapReads, boolean mmapWrites, Slice<Slice<Object>> segmentBytes, SegmentIO segmentIO, FileSweeper.Enabled fileSweeper, Option<BlockCache.State> blockCache) {
        if (mmapWrites && mmapReads) {
            IOStrategy x$3 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
            long x$4 = BlockCacheFileIDGenerator$.MODULE$.nextID();
            return DBFile$.MODULE$.mmapWriteAndRead(path, x$3, true, x$4, (Iterable<Slice<Object>>)segmentBytes, (FileSweeper)fileSweeper, blockCache);
        }
        if (mmapWrites && !mmapReads) {
            IOStrategy x$8 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
            long x$9 = BlockCacheFileIDGenerator$.MODULE$.nextID();
            DBFile file = DBFile$.MODULE$.mmapWriteAndRead(path, x$8, true, x$9, (Iterable<Slice<Object>>)segmentBytes, (FileSweeper)fileSweeper, blockCache);
            file.close();
            Path x$11 = file.path();
            IOStrategy x$12 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
            long x$13 = BlockCacheFileIDGenerator$.MODULE$.nextID();
            boolean bl = true;
            return DBFile$.MODULE$.channelRead(x$11, x$12, true, x$13, bl, fileSweeper, blockCache);
        }
        if (!mmapWrites && mmapReads) {
            Path x$16 = Effect$.MODULE$.write(path, (Iterable<Slice<Object>>)segmentBytes);
            IOStrategy x$17 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
            long x$18 = BlockCacheFileIDGenerator$.MODULE$.nextID();
            boolean bl = true;
            return DBFile$.MODULE$.mmapRead(x$16, x$17, true, x$18, bl, fileSweeper, blockCache);
        }
        Path x$21 = Effect$.MODULE$.write(path, (Iterable<Slice<Object>>)segmentBytes);
        IOStrategy x$22 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
        long x$23 = BlockCacheFileIDGenerator$.MODULE$.nextID();
        boolean bl = true;
        return DBFile$.MODULE$.channelRead(x$21, x$22, true, x$23, bl, fileSweeper, blockCache);
    }

    /*
     * WARNING - void declaration
     */
    public Slice<Segment> copyToPersist(Segment segment, int createdInLevel, PathsDistributor pathsDistributor, boolean removeDeletes, ValuesBlock.Config valuesConfig, SortedIndexBlock.Config sortedIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, HashIndexBlock.Config hashIndexConfig, BloomFilterBlock.Config bloomFilterConfig, SegmentBlock.Config segmentConfig, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, FileSweeper.Enabled fileSweeper, Option<BlockCache.State> blockCache, SegmentIO segmentIO, IDGenerator idGenerator) {
        Slice slice;
        if (segment instanceof PersistentSegment) {
            Slice slice2;
            PersistentSegment persistentSegment = (PersistentSegment)segment;
            long segmentId_id = idGenerator.nextID();
            Path nextPath = pathsDistributor.next().resolve(new java.lang.StringBuilder(1).append(segmentId_id).append(".").append("seg").toString());
            persistentSegment.copyTo(nextPath);
            try {
                void apply_evidence$7;
                Object[] objectArray = new PersistentSegment[1];
                byte x$2 = persistentSegment.formatId();
                int x$3 = persistentSegment.createdInLevel();
                long x$4 = persistentSegment.file().blockCacheFileId();
                Some x$5 = new Some((Object)persistentSegment);
                boolean x$6 = segmentConfig.mmapReads();
                boolean x$7 = segmentConfig.mmapWrites();
                Slice<Object> x$8 = persistentSegment.minKey();
                MaxKey<Slice<Object>> x$9 = persistentSegment.maxKey();
                int x$10 = persistentSegment.segmentSize();
                Option<MinMax<Slice<Object>>> x$11 = persistentSegment.minMaxFunctionId();
                Option<Deadline> x$12 = persistentSegment.nearestPutDeadline();
                boolean bl = true;
                objectArray[0] = this.apply(nextPath, x$2, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Option<PersistentSegment>)x$5, bl, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, fileSweeper, blockCache, segmentIO);
                ClassTag classTag = ClassTag$.MODULE$.apply(PersistentSegment.class);
                ArraySeq apply_data = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
                slice2 = SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)apply_data.toArray((ClassTag)apply_evidence$7), (ClassTag)apply_evidence$7);
                Object var39_35 = null;
                classTag = null;
            }
            catch (Exception exception) {
                block9: {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Failed to copyToPersist Segment {}", new Object[]{persistentSegment.path(), exception});
                    }
                    try {
                        Effect$.MODULE$.deleteIfExists(nextPath);
                    }
                    catch (Exception exception2) {
                        if (!this.logger().underlying().isErrorEnabled()) break block9;
                        this.logger().underlying().error(new java.lang.StringBuilder(43).append("Failed to delete copied persistent Segment ").append(persistentSegment.path()).toString(), (Throwable)exception2);
                    }
                }
                throw exception;
            }
            slice = slice2;
        } else if (segment instanceof MemorySegment) {
            MemorySegment memorySegment = (MemorySegment)segment;
            slice = this.copyToPersist((Iterable<Memory>)CollectionConverters$.MODULE$.CollectionHasAsScala(memorySegment.skipList().values()).asScala(), createdInLevel, pathsDistributor, removeDeletes, valuesConfig, sortedIndexConfig, binarySearchIndexConfig, hashIndexConfig, bloomFilterConfig, segmentConfig, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, fileSweeper, blockCache, segmentIO, idGenerator);
        } else {
            throw new MatchError((Object)segment);
        }
        return slice;
    }

    /*
     * WARNING - void declaration
     */
    public Slice<PersistentSegment> copyToPersist(Iterable<Memory> keyValues, int createdInLevel, PathsDistributor pathsDistributor, boolean removeDeletes, ValuesBlock.Config valuesConfig, SortedIndexBlock.Config sortedIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, HashIndexBlock.Config hashIndexConfig, BloomFilterBlock.Config bloomFilterConfig, SegmentBlock.Config segmentConfig, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, FileSweeper.Enabled fileSweeper, Option<BlockCache.State> blockCache, SegmentIO segmentIO, IDGenerator idGenerator) {
        MergeStats.Persistent.Builder builder;
        if (removeDeletes) {
            void persistent_converterOrNull;
            Function1 & Serializable intersect = (Function1 & Serializable)keyValue -> SegmentGrouper$.MODULE$.addLastLevel((KeyValue)keyValue);
            Builder persistent_builder = ListBuffer$.MODULE$.newBuilder();
            builder = new MergeStats.Persistent.Builder(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, false, false, persistent_builder, persistent_converterOrNull);
            Object var21_20 = null;
            intersect = null;
        } else {
            builder = MergeStats$.MODULE$.persistent(ListBuffer$.MODULE$.newBuilder(), Predef$.MODULE$.$conforms());
        }
        MergeStats.Persistent.Builder builder2 = builder;
        keyValues.foreach((Function1 & Serializable)from -> {
            builder2.add(from);
            return BoxedUnit.UNIT;
        });
        MergeStats.Persistent.Closed<Iterable> closedStats = builder2.close(sortedIndexConfig.enableAccessPositionIndex());
        return this.persistent(pathsDistributor, createdInLevel, bloomFilterConfig, hashIndexConfig, binarySearchIndexConfig, sortedIndexConfig, valuesConfig, segmentConfig, closedStats, keyOrder, timeOrder, functionStore, fileSweeper, keyValueMemorySweeper, blockCache, segmentIO, idGenerator);
    }

    public Slice<MemorySegment> copyToMemory(Segment segment, int createdInLevel, PathsDistributor pathsDistributor, boolean removeDeletes, int minSegmentSize, int maxKeyValueCountPerSegment, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, FileSweeper.Enabled fileSweeper, IDGenerator idGenerator) {
        return this.copyToMemory(segment.iterator(), pathsDistributor, removeDeletes, minSegmentSize, maxKeyValueCountPerSegment, createdInLevel, keyOrder, timeOrder, functionStore, fileSweeper, idGenerator);
    }

    public Slice<MemorySegment> copyToMemory(Iterator<KeyValue> keyValues, PathsDistributor pathsDistributor, boolean removeDeletes, int minSegmentSize, int maxKeyValueCountPerSegment, int createdInLevel, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, FileSweeper.Enabled fileSweeper, IDGenerator idGenerator) {
        MergeStats.Memory.Closed<Object> builder = new MergeStats.Memory.Closed<Object>(false, IterableOnceOps.to$((IterableOnceOps)new Iterator<Memory>(keyValues, removeDeletes){
            private Memory nextOne;
            private final Iterator fullIterator$1;
            private final boolean removeDeletes$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Memory> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Memory> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Memory> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Memory>, Iterator<Memory>> partition(Function1<Memory, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Memory, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Memory, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Memory, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Memory> filter(Function1<Memory, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Memory> filterNot(Function1<Memory, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Memory> filterImpl(Function1<Memory, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Memory> withFilter(Function1<Memory, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Memory, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Memory> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Memory> distinctBy(Function1<Memory, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Memory, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Memory, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Memory, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Memory> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Memory> takeWhile(Function1<Memory, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Memory> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Memory> dropWhile(Function1<Memory, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Memory>, Iterator<Memory>> span(Function1<Memory, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Memory> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Memory> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Memory, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Memory, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Memory>, Iterator<Memory>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<Memory> tapEach(Function1<Memory, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Memory> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Memory>, Iterator<Memory>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Memory, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Memory, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Memory, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Memory, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Memory> find(Function1<Memory, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Memory, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Memory, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Memory, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Memory, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Memory, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Memory, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Memory, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Memory, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Memory> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Memory> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Memory> maxByOption(Function1<Memory, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Memory> minByOption(Function1<Memory, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<Memory, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Memory, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Memory, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Memory, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Memory> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Memory> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Memory> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K$, V$> scala.collection.immutable.Map<K$, V$> toMap(.less.colon.less<Memory, Tuple2<K$, V$>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Memory> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Memory> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Memory> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Memory> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Memory, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private Memory nextOne() {
                return this.nextOne;
            }

            private void nextOne_$eq(Memory x$1) {
                this.nextOne = x$1;
            }

            public final boolean hasNext() {
                while (this.fullIterator$1.hasNext()) {
                    KeyValue nextKeyValue = (KeyValue)this.fullIterator$1.next();
                    Memory nextKeyValueOrNull = this.removeDeletes$1 ? SegmentGrouper$.MODULE$.addLastLevel(nextKeyValue) : nextKeyValue.toMemory();
                    if (nextKeyValueOrNull == null) continue;
                    this.nextOne_$eq(nextKeyValueOrNull);
                    return true;
                }
                return false;
            }

            public Memory next() {
                return this.nextOne();
            }
            {
                this.fullIterator$1 = fullIterator$1;
                this.removeDeletes$1 = removeDeletes$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }
        }, (Factory)IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Iterable())));
        long x$3 = createdInLevel;
        return this.memory(minSegmentSize, maxKeyValueCountPerSegment, pathsDistributor, x$3, builder, keyOrder, timeOrder, functionStore, fileSweeper, idGenerator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PersistentSegment apply(Path path, byte formatId, int createdInLevel, long blockCacheFileId, boolean mmapReads, boolean mmapWrites, Slice<Object> minKey, MaxKey<Slice<Object>> maxKey, int segmentSize, Option<MinMax<Slice<Object>>> minMaxFunctionId, Option<Deadline> nearestExpiryDeadline, Option<PersistentSegment> copiedFrom, boolean checkExists, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, FileSweeper.Enabled fileSweeper, Option<BlockCache.State> blockCache, SegmentIO segmentIO) {
        DBFile file;
        DBFile dBFile;
        if (mmapReads) {
            IOStrategy x$2 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
            dBFile = DBFile$.MODULE$.mmapRead(path, x$2, true, blockCacheFileId, checkExists, fileSweeper, blockCache);
        } else {
            IOStrategy x$7 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
            dBFile = file = DBFile$.MODULE$.channelRead(path, x$7, true, blockCacheFileId, checkExists, fileSweeper, blockCache);
        }
        if (formatId == PersistentSegmentOne$.MODULE$.formatId()) {
            PersistentSegment segment;
            boolean bl = false;
            Some some = null;
            if (copiedFrom instanceof Some) {
                bl = true;
                some = (Some)copiedFrom;
                PersistentSegment one = (PersistentSegment)some.value();
                if (one instanceof PersistentSegmentOne) {
                    PersistentSegmentOne persistentSegmentOne = (PersistentSegmentOne)one;
                    Option<UnblockedReader<ValuesBlock.Offset, ValuesBlock>> x$18 = persistentSegmentOne.ref().segmentBlockCache().cachedValuesSliceReader();
                    Option<UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock>> x$19 = persistentSegmentOne.ref().segmentBlockCache().cachedSortedIndexSliceReader();
                    Option<UnblockedReader<HashIndexBlock.Offset, HashIndexBlock>> x$20 = persistentSegmentOne.ref().segmentBlockCache().cachedHashIndexSliceReader();
                    Option<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>> x$21 = persistentSegmentOne.ref().segmentBlockCache().cachedBinarySearchIndexSliceReader();
                    Option<UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock>> x$22 = persistentSegmentOne.ref().segmentBlockCache().cachedBloomFilterSliceReader();
                    Option<SegmentFooterBlock> x$23 = persistentSegmentOne.ref().segmentBlockCache().cachedFooter();
                    return PersistentSegmentOne$.MODULE$.apply(file, createdInLevel, minKey, maxKey, minMaxFunctionId, segmentSize, nearestExpiryDeadline, x$18, x$19, x$20, x$21, x$22, x$23, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, blockCache, fileSweeper, segmentIO);
                }
            }
            if (bl && (segment = (PersistentSegment)some.value()) instanceof PersistentSegmentMany) {
                PersistentSegmentMany persistentSegmentMany = (PersistentSegmentMany)segment;
                throw new Exception(new java.lang.StringBuilder(39).append("Invalid copy. Copied as ").append(PersistentSegmentOne$.MODULE$.getClass().getSimpleName()).append(" but received ").append(persistentSegmentMany.getClass().getSimpleName()).append(".").toString());
            }
            if (!None$.MODULE$.equals(copiedFrom)) throw new MatchError(copiedFrom);
            None$ x$31 = None$.MODULE$;
            None$ x$32 = None$.MODULE$;
            None$ x$33 = None$.MODULE$;
            None$ x$34 = None$.MODULE$;
            None$ x$35 = None$.MODULE$;
            None$ x$36 = None$.MODULE$;
            return PersistentSegmentOne$.MODULE$.apply(file, createdInLevel, minKey, maxKey, minMaxFunctionId, segmentSize, nearestExpiryDeadline, (Option<UnblockedReader<ValuesBlock.Offset, ValuesBlock>>)x$31, (Option<UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock>>)x$32, (Option<UnblockedReader<HashIndexBlock.Offset, HashIndexBlock>>)x$33, (Option<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>>)x$34, (Option<UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock>>)x$35, (Option<SegmentFooterBlock>)x$36, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, blockCache, fileSweeper, segmentIO);
        }
        if (formatId != PersistentSegmentMany$.MODULE$.formatId()) throw new Exception(new java.lang.StringBuilder(26).append("Invalid segment formatId: ").append(formatId).toString());
        None$ x$44 = None$.MODULE$;
        return PersistentSegmentMany$.MODULE$.apply(file, segmentSize, createdInLevel, minKey, maxKey, minMaxFunctionId, nearestExpiryDeadline, (Option<SkipList.Immutable<SliceOption<Object>, SegmentRefOption, Slice<Object>, SegmentRef>>)x$44, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, blockCache, fileSweeper, segmentIO);
    }

    public PersistentSegment apply(Path path, boolean mmapReads, boolean checkExists, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore, Option<BlockCache.State> blockCache, Option<MemorySweeper.KeyValue> keyValueMemorySweeper, FileSweeper.Enabled fileSweeper) {
        PersistentSegment persistentSegment;
        DBFile dBFile;
        SegmentIO segmentIO = SegmentIO$.MODULE$.defaultSynchronisedStoredIfCompressed();
        Option blockCacheMemorySweeper = blockCache.map((Function1 & Serializable)x$3 -> x$3.sweeper());
        if (mmapReads) {
            IOStrategy x$2 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
            long x$32 = BlockCacheFileIDGenerator$.MODULE$.nextID();
            dBFile = DBFile$.MODULE$.mmapRead(path, x$2, false, x$32, checkExists, fileSweeper, blockCache);
        } else {
            IOStrategy x$7 = (IOStrategy)segmentIO.segmentBlockIO().apply((Object)IOAction.OpenResource$.MODULE$);
            long x$8 = BlockCacheFileIDGenerator$.MODULE$.nextID();
            dBFile = DBFile$.MODULE$.channelRead(path, x$7, false, x$8, checkExists, fileSweeper, blockCache);
        }
        DBFile file = dBFile;
        byte formatId = file.get(0);
        if (formatId == PersistentSegmentOne$.MODULE$.formatId()) {
            persistentSegment = PersistentSegmentOne$.MODULE$.apply(file, keyOrder, timeOrder, functionStore, blockCache, keyValueMemorySweeper, fileSweeper, segmentIO);
        } else if (formatId == PersistentSegmentMany$.MODULE$.formatId()) {
            persistentSegment = PersistentSegmentMany$.MODULE$.apply(file, keyOrder, timeOrder, functionStore, keyValueMemorySweeper, (Option<MemorySweeper.Block>)blockCacheMemorySweeper, blockCache, fileSweeper, segmentIO);
        } else {
            throw new Exception(new java.lang.StringBuilder(26).append("Invalid Segment formatId: ").append(formatId).toString());
        }
        PersistentSegment segment = persistentSegment;
        file.close();
        return segment;
    }

    public boolean apply$default$13() {
        return true;
    }

    public int segmentSizeForMerge(Segment segment) {
        int n;
        if (segment instanceof MemorySegment) {
            n = ((MemorySegment)segment).segmentSize();
        } else if (segment instanceof PersistentSegmentOne) {
            SegmentFooterBlock footer = ((PersistentSegmentOne)segment).ref().getFooter();
            n = footer.sortedIndexOffset().size() + BoxesRunTime.unboxToInt((Object)footer.valuesOffset().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        } else {
            throw new MatchError((Object)segment);
        }
        return n;
    }

    public boolean belongsTo(KeyValue keyValue, Segment segment, KeyOrder<Slice<Object>> keyOrder) {
        return keyOrder.mkOrderingOps(keyValue.key()).$greater$eq(segment.minKey()) && (segment.maxKey().inclusive() ? keyOrder.mkOrderingOps(keyValue.key()).$less$eq(segment.maxKey().maxKey()) : keyOrder.mkOrderingOps(keyValue.key()).$less(segment.maxKey().maxKey()));
    }

    public boolean overlaps(Slice<Object> minKey, Slice<Object> maxKey, boolean maxKeyInclusive, Segment segment, KeyOrder<Slice<Object>> keyOrder) {
        return SliceCompanionBase.intersects$((SliceCompanionBase)Slice$.MODULE$, (Tuple3)new Tuple3(minKey, maxKey, (Object)BoxesRunTime.boxToBoolean((boolean)maxKeyInclusive)), (Tuple3)new Tuple3(segment.minKey(), segment.maxKey().maxKey(), (Object)BoxesRunTime.boxToBoolean((boolean)segment.maxKey().inclusive())), keyOrder);
    }

    public boolean overlaps(Slice<Object> minKey, Slice<Object> maxKey, boolean maxKeyInclusive, Iterable<Segment> segments, KeyOrder<Slice<Object>> keyOrder) {
        return segments.exists((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Segment$.MODULE$.overlaps((Slice<Object>)minKey, (Slice<Object>)maxKey, maxKeyInclusive, segment, (KeyOrder<Slice<Object>>)keyOrder)));
    }

    public boolean overlaps(swaydb.core.map.Map<SliceOption<Object>, MemoryOption, Slice<Object>, Memory> map, Iterable<Segment> segments, KeyOrder<Slice<Object>> keyOrder) {
        return this.minMaxKey(map).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Segment$.$anonfun$overlaps$2(segments, keyOrder, x0$1)));
    }

    public boolean overlaps(Segment segment1, Segment segment2, KeyOrder<Slice<Object>> keyOrder) {
        return SliceCompanionBase.intersects$((SliceCompanionBase)Slice$.MODULE$, (Tuple3)new Tuple3(segment1.minKey(), segment1.maxKey().maxKey(), (Object)BoxesRunTime.boxToBoolean((boolean)segment1.maxKey().inclusive())), (Tuple3)new Tuple3(segment2.minKey(), segment2.maxKey().maxKey(), (Object)BoxesRunTime.boxToBoolean((boolean)segment2.maxKey().inclusive())), keyOrder);
    }

    public Tuple2<Iterable<Segment>, Iterable<Segment>> partitionOverlapping(Iterable<Segment> segments1, Iterable<Segment> segments2, KeyOrder<Slice<Object>> keyOrder) {
        return segments1.partition((Function1 & Serializable)segmentToWrite -> BoxesRunTime.boxToBoolean((boolean)segments2.exists((Function1 & Serializable)existingSegment -> BoxesRunTime.boxToBoolean((boolean)Segment$.MODULE$.overlaps(segmentToWrite, existingSegment, (KeyOrder<Slice<Object>>)keyOrder$5)))));
    }

    public Iterable<Segment> nonOverlapping(Iterable<Segment> segments1, Iterable<Segment> segments2, KeyOrder<Slice<Object>> keyOrder) {
        return this.nonOverlapping(segments1, segments2, segments1.size(), keyOrder);
    }

    public Iterable<Segment> nonOverlapping(Iterable<Segment> segments1, Iterable<Segment> segments2, int count, KeyOrder<Slice<Object>> keyOrder) {
        if (count == 0) {
            return (Iterable)package$.MODULE$.Iterable().empty();
        }
        ListBuffer resultSegments = ListBuffer$.MODULE$.empty();
        Iterator foreachBreak_iterator = new Collections.IterableImplicit<Segment>(segments1).swaydb$core$util$Collections$IterableImplicit$$items.iterator();
        boolean foreachBreak_break = false;
        while (foreachBreak_iterator.hasNext() && !foreachBreak_break) {
            Segment segment = (Segment)foreachBreak_iterator.next();
            foreachBreak_break = Segment$.$anonfun$nonOverlapping$1(segments2, keyOrder, resultSegments, count, segment);
        }
        return resultSegments;
    }

    public Iterable<Segment> overlaps(Iterable<Segment> segments1, Iterable<Segment> segments2, KeyOrder<Slice<Object>> keyOrder) {
        return (Iterable)segments1.filter((Function1 & Serializable)segment1 -> BoxesRunTime.boxToBoolean((boolean)segments2.exists((Function1 & Serializable)segment2 -> BoxesRunTime.boxToBoolean((boolean)Segment$.MODULE$.overlaps(segment1, segment2, (KeyOrder<Slice<Object>>)keyOrder$7)))));
    }

    public boolean overlaps(Segment segment, Iterable<Segment> segments2, KeyOrder<Slice<Object>> keyOrder) {
        return segments2.exists((Function1 & Serializable)segment2 -> BoxesRunTime.boxToBoolean((boolean)Segment$.MODULE$.overlaps(segment, segment2, (KeyOrder<Slice<Object>>)keyOrder)));
    }

    public boolean intersects(Iterable<Segment> segments1, Iterable<Segment> segments2) {
        if (segments1.isEmpty() || segments2.isEmpty()) {
            return false;
        }
        return segments1.exists((Function1 & Serializable)segment1 -> BoxesRunTime.boxToBoolean((boolean)segments2.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Segment$.$anonfun$intersects$2(segment1, x$5)))));
    }

    public boolean intersects(Segment segment, Iterable<Segment> segments2) {
        return segments2.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Segment$.$anonfun$intersects$3(segment, x$6)));
    }

    /*
     * WARNING - void declaration
     */
    public Slice<KeyValue> getAllKeyValues(Iterable<Segment> segments) {
        void newAggregator_evidence$11;
        Aggregator aggregator;
        void IterableIOImplicit_evidence$8;
        if (segments.isEmpty()) {
            ClassTag empty_evidence$1 = ClassTag$.MODULE$.Nothing();
            boolean bl = false;
            int empty_create_length = 0;
            return new Slice(empty_evidence$1.newArray(empty_create_length), 0, empty_create_length == 0 ? -1 : empty_create_length - 1, bl ? empty_create_length : 0, empty_evidence$1);
        }
        if (segments.size() == 1) {
            return ((Segment)segments.head()).toSlice();
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(Segment.class);
        Error.Segment$.ExceptionHandler$ IterableIOImplicit_evidence$7 = Error.Segment$.ExceptionHandler$.MODULE$;
        Object var12_6 = null;
        classTag = null;
        IO.IterableIOImplicit qual$1 = new IO.IterableIOImplicit(segments, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        boolean x$2 = qual$1.foldLeftRecover$default$2();
        Function2 x$3 = qual$1.foldLeftRecover$default$3();
        Function2 & Serializable x$4 = (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)Segment$.$anonfun$getAllKeyValues$1(BoxesRunTime.unboxToInt((Object)x0$1), x1$1));
        int totalKeyValues = BoxesRunTime.unboxToInt((Object)qual$1.foldLeftRecover((Object)BoxesRunTime.boxToInteger((int)0), x$2, x$3, (Function2)x$4));
        ClassTag classTag2 = ClassTag$.MODULE$.apply(KeyValue.class);
        Slice$ newAggregator_this = Slice$.MODULE$;
        Aggregator aggregator2 = aggregator = SliceCompanionBase.newAggregator$((SliceCompanionBase)newAggregator_this, (int)totalKeyValues, (ClassTag)newAggregator_evidence$11);
        Object var9_13 = null;
        classTag2 = null;
        aggregator = null;
        Aggregator aggregator3 = aggregator2;
        segments.foreach((Function1 & Serializable)segment -> {
            Segment$.$anonfun$getAllKeyValues$2(aggregator3, segment);
            return BoxedUnit.UNIT;
        });
        return (Slice)aggregator3.result();
    }

    /*
     * WARNING - void declaration
     */
    public Slice<Persistent> getAllKeyValuesRef(Iterable<SegmentRef> segments) {
        void newAggregator_evidence$11;
        Aggregator aggregator;
        void IterableIOImplicit_evidence$8;
        if (segments.isEmpty()) {
            ClassTag empty_evidence$1 = ClassTag$.MODULE$.Nothing();
            boolean bl = false;
            int empty_create_length = 0;
            return new Slice(empty_evidence$1.newArray(empty_create_length), 0, empty_create_length == 0 ? -1 : empty_create_length - 1, bl ? empty_create_length : 0, empty_evidence$1);
        }
        if (segments.size() == 1) {
            return ((SegmentRef)segments.head()).toSlice();
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(SegmentRef.class);
        Error.Segment$.ExceptionHandler$ IterableIOImplicit_evidence$7 = Error.Segment$.ExceptionHandler$.MODULE$;
        Object var12_6 = null;
        classTag = null;
        IO.IterableIOImplicit qual$1 = new IO.IterableIOImplicit(segments, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        boolean x$2 = qual$1.foldLeftRecover$default$2();
        Function2 x$3 = qual$1.foldLeftRecover$default$3();
        Function2 & Serializable x$4 = (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)Segment$.$anonfun$getAllKeyValuesRef$1(BoxesRunTime.unboxToInt((Object)x0$1), x1$1));
        int totalKeyValues = BoxesRunTime.unboxToInt((Object)qual$1.foldLeftRecover((Object)BoxesRunTime.boxToInteger((int)0), x$2, x$3, (Function2)x$4));
        ClassTag classTag2 = ClassTag$.MODULE$.apply(Persistent.class);
        Slice$ newAggregator_this = Slice$.MODULE$;
        Aggregator aggregator2 = aggregator = SliceCompanionBase.newAggregator$((SliceCompanionBase)newAggregator_this, (int)totalKeyValues, (ClassTag)newAggregator_evidence$11);
        Object var9_13 = null;
        classTag2 = null;
        aggregator = null;
        Aggregator aggregator3 = aggregator2;
        segments.foreach((Function1 & Serializable)segment -> {
            Segment$.$anonfun$getAllKeyValuesRef$2(aggregator3, segment);
            return BoxedUnit.UNIT;
        });
        return (Slice)aggregator3.result();
    }

    /*
     * WARNING - void declaration
     */
    public int deleteSegments(Iterable<Segment> segments) {
        void IterableIOImplicit_evidence$8;
        ClassTag classTag = ClassTag$.MODULE$.apply(Segment.class);
        Error.Segment$.ExceptionHandler$ IterableIOImplicit_evidence$7 = Error.Segment$.ExceptionHandler$.MODULE$;
        Object var5_3 = null;
        classTag = null;
        IO.IterableIOImplicit qual$1 = new IO.IterableIOImplicit(segments, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        Function2 x$3 = qual$1.foldLeftRecover$default$3();
        Function2 & Serializable x$4 = (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)Segment$.$anonfun$deleteSegments$1(BoxesRunTime.unboxToInt((Object)x0$1), x1$1));
        return BoxesRunTime.unboxToInt((Object)qual$1.foldLeftRecover((Object)BoxesRunTime.boxToInteger((int)0), false, x$3, (Function2)x$4));
    }

    public Slice<Memory> tempMinMaxKeyValues(Iterable<Segment> segments) {
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ClassTag create_evidence$3 = ClassTag$.MODULE$.apply(Memory.class);
        int create_length = segments.size() * 2;
        Object var3_3 = null;
        return (Slice)segments.foldLeft((Object)new Slice((Object)new Memory[create_length], 0, create_length == 0 ? -1 : create_length - 1, bl ? create_length : 0, create_evidence$3), (Function2 & Serializable)(x0$1, x1$1) -> {
            Slice slice;
            void add_value;
            SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)x0$1);
            Memory.Put put = new Memory.Put(x1$1.minKey(), (SliceOption<Object>)Slice.Null$.MODULE$, (Option<Deadline>)None$.MODULE$, Time$.MODULE$.empty());
            if (sliceImplicit == null) {
                throw null;
            }
            SliceCompanionBase.SliceImplicit add_this = sliceImplicit;
            add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value);
            Slice cfr_ignored_0 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            Object var8_3 = null;
            put = null;
            MaxKey<Slice<Object>> maxKey = x1$1.maxKey();
            if (maxKey instanceof MaxKey.Fixed) {
                Slice slice2;
                void add_value2;
                Slice maxKey2 = (Slice)((MaxKey.Fixed)maxKey).maxKey();
                SliceCompanionBase.SliceImplicit sliceImplicit2 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)x0$1);
                Memory.Put put2 = new Memory.Put((Slice<Object>)maxKey2, (SliceOption<Object>)Slice.Null$.MODULE$, (Option<Deadline>)None$.MODULE$, Time$.MODULE$.empty());
                if (sliceImplicit2 == null) {
                    throw null;
                }
                SliceCompanionBase.SliceImplicit add_this2 = sliceImplicit2;
                add_this2.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value2);
                Slice slice3 = slice2 = add_this2.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
                Object var10_7 = null;
                put2 = null;
                slice2 = null;
                slice = slice3;
            } else if (maxKey instanceof MaxKey.Range) {
                Slice slice4;
                void add_value3;
                MaxKey.Range range = (MaxKey.Range)maxKey;
                Slice fromKey = (Slice)range.fromKey();
                Slice maxKey3 = (Slice)range.maxKey();
                SliceCompanionBase.SliceImplicit sliceImplicit3 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)x0$1);
                Memory.Range range2 = new Memory.Range((Slice<Object>)fromKey, (Slice<Object>)maxKey3, Value$FromValue$Null$.MODULE$, new Value.Update((SliceOption<Object>)maxKey3, (Option<Deadline>)None$.MODULE$, Time$.MODULE$.empty()));
                if (sliceImplicit3 == null) {
                    throw null;
                }
                SliceCompanionBase.SliceImplicit add_this3 = sliceImplicit3;
                add_this3.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value3);
                Slice slice5 = slice4 = add_this3.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
                Object var13_14 = null;
                range2 = null;
                slice4 = null;
                slice = slice5;
            } else {
                throw new MatchError(maxKey);
            }
            return slice;
        });
    }

    public Slice<Memory> tempMinMaxKeyValues(swaydb.core.map.Map<SliceOption<Object>, MemoryOption, Slice<Object>, Memory> map) {
        return (Slice)((SomeOrNone)map.skipList().head()).mapS((Function1 & Serializable)memory -> new Memory.Put(memory.key(), (SliceOption<Object>)Slice.Null$.MODULE$, (Option<Deadline>)None$.MODULE$, Time$.MODULE$.empty())).flatMap((Function1 & Serializable)minKey -> ((SomeOrNone)map.skipList().last()).mapS((Function1 & Serializable)x0$1 -> {
            Memory memory;
            if (x0$1 instanceof Memory.Fixed) {
                Memory.Fixed fixed = (Memory.Fixed)x0$1;
                memory = new Memory.Put(fixed.key(), (SliceOption<Object>)Slice.Null$.MODULE$, (Option<Deadline>)None$.MODULE$, Time$.MODULE$.empty());
            } else if (x0$1 instanceof Memory.Range) {
                Memory.Range range = (Memory.Range)x0$1;
                Slice<Object> fromKey = range.fromKey();
                Slice<Object> toKey = range.toKey();
                memory = new Memory.Range(fromKey, toKey, Value$FromValue$Null$.MODULE$, new Value.Update((SliceOption<Object>)Slice.Null$.MODULE$, (Option<Deadline>)None$.MODULE$, Time$.MODULE$.empty()));
            } else {
                throw new MatchError(x0$1);
            }
            return memory;
        }).map((Function1 & Serializable)maxKey -> {
            ClassTag apply_evidence$7 = ClassTag$.MODULE$.apply(Memory.class);
            ArraySeq apply_data = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Memory[]{minKey, maxKey});
            return SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)apply_data.toArray(apply_evidence$7), (ClassTag)apply_evidence$7);
        })).getOrElse((Function0 & Serializable)() -> {
            boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
            ClassTag create_evidence$3 = ClassTag$.MODULE$.apply(Memory.class);
            int create_length = 0;
            return new Slice((Object)new Memory[create_length], 0, create_length == 0 ? -1 : create_length - 1, bl ? create_length : 0, create_evidence$3);
        });
    }

    public Option<Tuple3<Slice<Object>, Slice<Object>, Object>> minMaxKey(swaydb.core.map.Map<SliceOption<Object>, MemoryOption, Slice<Object>, Memory> map) {
        return ((SomeOrNone)map.skipList().head()).mapS((Function1 & Serializable)x$7 -> x$7.key()).flatMap((Function1 & Serializable)minKey -> ((SomeOrNone)map.skipList().last()).mapS((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 instanceof Memory.Fixed) {
                Memory.Fixed fixed = (Memory.Fixed)x0$1;
                tuple2 = new Tuple2(fixed.key(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else if (x0$1 instanceof Memory.Range) {
                Memory.Range range = (Memory.Range)x0$1;
                tuple2 = new Tuple2(range.toKey(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else {
                throw new MatchError(x0$1);
            }
            return tuple2;
        }).map((Function1 & Serializable)maxKey -> new Tuple3(minKey, maxKey._1(), (Object)BoxesRunTime.boxToBoolean((boolean)maxKey._2$mcZ$sp()))));
    }

    public Option<Tuple3<Slice<Object>, Slice<Object>, Object>> minMaxKey(Iterable<Segment> segment) {
        return segment.headOption().map((Function1 & Serializable)x$8 -> x$8.minKey()).flatMap((Function1 & Serializable)minKey -> segment.lastOption().map((Function1 & Serializable)x$9 -> x$9.maxKey()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 instanceof MaxKey.Fixed) {
                Slice maxKey = (Slice)((MaxKey.Fixed)x0$1).maxKey();
                tuple2 = new Tuple2((Object)maxKey, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else if (x0$1 instanceof MaxKey.Range) {
                Slice maxKey = (Slice)((MaxKey.Range)x0$1).maxKey();
                tuple2 = new Tuple2((Object)maxKey, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else {
                throw new MatchError(x0$1);
            }
            return tuple2;
        }).map((Function1 & Serializable)maxKey -> new Tuple3(minKey, maxKey._1(), (Object)BoxesRunTime.boxToBoolean((boolean)maxKey._2$mcZ$sp()))));
    }

    public Option<Tuple3<Slice<Object>, Slice<Object>, Object>> minMaxKey(Iterable<Segment> left, Iterable<Segment> right, KeyOrder<Slice<Object>> keyOrder) {
        return SliceCompanionBase.minMax$((SliceCompanionBase)Slice$.MODULE$, this.minMaxKey(left), this.minMaxKey(right), keyOrder);
    }

    public Option<Tuple3<Slice<Object>, Slice<Object>, Object>> minMaxKey(Iterable<Segment> left, swaydb.core.map.Map<SliceOption<Object>, MemoryOption, Slice<Object>, Memory> right, KeyOrder<Slice<Object>> keyOrder) {
        return SliceCompanionBase.minMax$((SliceCompanionBase)Slice$.MODULE$, this.minMaxKey(left), this.minMaxKey(right), keyOrder);
    }

    public boolean overlapsWithBusySegments(Iterable<Segment> inputSegments, Iterable<Segment> busySegments, Iterable<Segment> appendixSegments, KeyOrder<Slice<Object>> keyOrder) {
        if (busySegments.isEmpty()) {
            return false;
        }
        Iterable<Segment> assignments = SegmentAssigner$.MODULE$.assignMinMaxOnlyUnsafe(inputSegments, appendixSegments, keyOrder);
        return this.overlaps(busySegments, assignments, keyOrder).nonEmpty();
    }

    public boolean overlapsWithBusySegments(swaydb.core.map.Map<SliceOption<Object>, MemoryOption, Slice<Object>, Memory> map, Iterable<Segment> busySegments, Iterable<Segment> appendixSegments, KeyOrder<Slice<Object>> keyOrder) {
        if (busySegments.isEmpty()) {
            return false;
        }
        return BoxesRunTime.unboxToBoolean((Object)((SomeOrNone)map.skipList().head()).toOptionS().flatMap((Function1 & Serializable)head -> ((SomeOrNone)map.skipList().last()).toOptionS().map((Function1 & Serializable)last -> BoxesRunTime.boxToBoolean((boolean)Segment$.$anonfun$overlapsWithBusySegments$2(keyOrder, head, appendixSegments, busySegments, last)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public Option<Deadline> getNearestPutDeadline(Option<Deadline> deadline, KeyValue next) {
        Option<Deadline> option;
        if (next instanceof KeyValue.Put) {
            KeyValue.Put put = (KeyValue.Put)next;
            option = FiniteDurations$.MODULE$.getNearestDeadline(deadline, put.deadline());
        } else if (next instanceof KeyValue.Remove) {
            option = deadline;
        } else if (next instanceof KeyValue.Update) {
            option = deadline;
        } else if (next instanceof KeyValue.PendingApply) {
            option = deadline;
        } else if (next instanceof KeyValue.Function) {
            option = deadline;
        } else if (next instanceof KeyValue.Range) {
            Value.FromValueOption fromValueOption;
            Option<Deadline> option2;
            Value.FromValueOption fromValue;
            Tuple2<Value.FromValueOption, Value.RangeValue> tuple2 = ((KeyValue.Range)next).fetchFromAndRangeValueUnsafe();
            if (tuple2 != null && (fromValue = (Value.FromValueOption)tuple2._1()) instanceof Value.FromValue) {
                Value.FromValue fromValue2 = (Value.FromValue)fromValue;
                option2 = this.getNearestPutDeadline(deadline, fromValue2);
            } else if (tuple2 != null && Value$FromValue$Null$.MODULE$.equals(fromValueOption = (Value.FromValueOption)tuple2._1())) {
                option2 = deadline;
            } else {
                throw new MatchError(tuple2);
            }
            option = option2;
        } else {
            throw new MatchError((Object)next);
        }
        return option;
    }

    public Option<Deadline> getNearestPutDeadline(Option<Deadline> deadline, Memory keyValue) {
        Option<Deadline> option;
        if (keyValue instanceof Memory.Fixed) {
            Memory.Fixed fixed = (Memory.Fixed)keyValue;
            option = FiniteDurations$.MODULE$.getNearestDeadline(deadline, fixed.deadline());
        } else if (keyValue instanceof Memory.Range) {
            Option<Deadline> option2;
            Memory.Range range = (Memory.Range)keyValue;
            Value.RangeValue rangeValue = range.rangeValue();
            Value.FromValueOption fromValueOption = range.fromValue();
            Tuple2 tuple2 = new Tuple2((Object)fromValueOption, (Object)rangeValue);
            if (fromValueOption instanceof Value.FromValue) {
                Value.FromValue fromValue = (Value.FromValue)fromValueOption;
                Option<Deadline> fromValueDeadline = this.getNearestPutDeadline(deadline, fromValue);
                option2 = this.getNearestPutDeadline(fromValueDeadline, rangeValue);
            } else if (Value$FromValue$Null$.MODULE$.equals(fromValueOption)) {
                option2 = this.getNearestPutDeadline(deadline, rangeValue);
            } else {
                throw new MatchError((Object)tuple2);
            }
            option = option2;
        } else {
            throw new MatchError((Object)keyValue);
        }
        return option;
    }

    public Option<Deadline> getNearestPutDeadline(Option<Deadline> deadline, Value.FromValue keyValue) {
        Option<Deadline> option;
        if (keyValue instanceof Value.RangeValue) {
            option = deadline;
        } else if (keyValue instanceof Value.Put) {
            Value.Put put = (Value.Put)keyValue;
            option = FiniteDurations$.MODULE$.getNearestDeadline(deadline, put.deadline());
        } else {
            throw new MatchError((Object)keyValue);
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Option<Deadline> getNearestDeadline(Iterable<KeyValue> keyValues) {
        void IterableIOImplicit_evidence$8;
        IO.IterableIOImplicit iterableIOImplicit;
        ClassTag classTag = ClassTag$.MODULE$.apply(KeyValue.class);
        Error.Segment$.ExceptionHandler$ IterableIOImplicit_evidence$7 = Error.Segment$.ExceptionHandler$.MODULE$;
        IO.IterableIOImplicit iterableIOImplicit2 = iterableIOImplicit = new IO.IterableIOImplicit(keyValues, (IO.ExceptionHandler)IterableIOImplicit_evidence$7, (ClassTag)IterableIOImplicit_evidence$8);
        Object var7_3 = null;
        classTag = null;
        iterableIOImplicit = null;
        IO.IterableIOImplicit qual$1 = iterableIOImplicit2;
        Option x$1 = Option$.MODULE$.empty();
        boolean x$2 = qual$1.foldLeftRecover$default$2();
        Function2 x$3 = qual$1.foldLeftRecover$default$3();
        Function2 & Serializable x$4 = (Function2 & Serializable)(deadline, next) -> MODULE$.getNearestPutDeadline((Option<Deadline>)deadline, (KeyValue)next);
        return (Option)qual$1.foldLeftRecover((Object)x$1, x$2, x$3, (Function2)x$4);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SegmentOption getNearestDeadlineSegment(Segment previous, Segment next) {
        void var3_10;
        Option<Deadline> option = next.nearestPutDeadline();
        Option<Deadline> option2 = previous.nearestPutDeadline();
        Tuple2 tuple2 = new Tuple2(option2, option);
        if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option)) {
            Segment$Null$ segment$Null$ = Segment$Null$.MODULE$;
            return var3_10;
        } else if (option2 instanceof Some && None$.MODULE$.equals(option)) {
            Segment segment = previous;
            return var3_10;
        } else if (tuple2 != null && None$.MODULE$.equals(option2) && option instanceof Some) {
            Segment segment = next;
            return var3_10;
        } else {
            if (tuple2 == null || !(option2 instanceof Some)) throw new MatchError((Object)tuple2);
            Deadline previousDeadline = (Deadline)((Some)option2).value();
            if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
            Deadline nextDeadline = (Deadline)((Some)option).value();
            Segment segment = previousDeadline.$less((Object)nextDeadline) ? previous : next;
        }
        return var3_10;
    }

    public SegmentOption getNearestDeadlineSegment(Iterable<Segment> segments) {
        return (SegmentOption)segments.foldLeft((Object)Segment$Null$.MODULE$, (Function2 & Serializable)(x0$1, x1$1) -> (SegmentOption)x0$1.mapS((Function1 & Serializable)previous -> MODULE$.getNearestDeadlineSegment((Segment)previous, (Segment)x1$1)).getOrElse((Function0 & Serializable)() -> {
            if (x1$1.nearestPutDeadline().isDefined()) {
                return x1$1;
            }
            return Segment$Null$.MODULE$;
        }));
    }

    public Iterator<Memory> toMemoryIterator(Iterator<KeyValue> fullIterator, boolean removeDeletes) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public boolean hasOnlyOneSegment(Iterable<Segment> segments) {
        Iterator iterator = segments.iterator();
        if (iterator.hasNext()) {
            iterator.next();
            return !iterator.hasNext();
        }
        return false;
    }

    private static final void setClosed$1(ObjectRef skipList$1, KeyOrder keyOrder$1, ObjectRef minMaxFunctionId$1, ObjectRef nearestDeadline$1, BooleanRef hasRange$1, BooleanRef hasPut$1, IntRef currentSegmentSize$1, IntRef currentSegmentKeyValuesCount$1, ObjectRef minKey$1, ObjectRef lastKeyValue$1) {
        skipList$1.elem = SkipList$.MODULE$.immutable(Slice.Null$.MODULE$, Memory$Null$.MODULE$, keyOrder$1);
        minMaxFunctionId$1.elem = None$.MODULE$;
        nearestDeadline$1.elem = None$.MODULE$;
        hasRange$1.elem = false;
        hasPut$1.elem = false;
        currentSegmentSize$1.elem = 0;
        currentSegmentKeyValuesCount$1.elem = 0;
        minKey$1.elem = null;
        lastKeyValue$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$memory$1(ObjectRef nearestDeadline$1, Value.FromValue x0$1) {
        if (x0$1 instanceof Value.Put) {
            Value.Put put = (Value.Put)x0$1;
            nearestDeadline$1.elem = FiniteDurations$.MODULE$.getNearestDeadline((Option<Deadline>)((Option)nearestDeadline$1.elem), put.deadline());
            return;
        }
        if (x0$1 instanceof Value.RangeValue) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    private static final void put$1(Memory keyValue, BooleanRef hasPut$1, ObjectRef nearestDeadline$1, ObjectRef skipList$1, ObjectRef minMaxFunctionId$1, BooleanRef hasRange$1) {
        Memory memory = keyValue.unslice();
        if (memory instanceof Memory.Put) {
            Memory.Put put = (Memory.Put)memory;
            hasPut$1.elem = true;
            nearestDeadline$1.elem = FiniteDurations$.MODULE$.getNearestDeadline((Option<Deadline>)((Option)nearestDeadline$1.elem), put.deadline());
            ((SkipList.Immutable)skipList$1.elem).put(put.key(), put);
            return;
        }
        if (memory instanceof Memory.Update) {
            Memory.Update update = (Memory.Update)memory;
            ((SkipList.Immutable)skipList$1.elem).put(update.key(), update);
            return;
        }
        if (memory instanceof Memory.Function) {
            Memory.Function function = (Memory.Function)memory;
            minMaxFunctionId$1.elem = new Some(MinMax$.MODULE$.minMaxFunction(function, (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId$1.elem)));
            ((SkipList.Immutable)skipList$1.elem).put(function.key(), function);
            return;
        }
        if (memory instanceof Memory.PendingApply) {
            Memory.PendingApply pendingApply = (Memory.PendingApply)memory;
            minMaxFunctionId$1.elem = MinMax$.MODULE$.minMaxFunction(pendingApply.applies(), (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId$1.elem));
            ((SkipList.Immutable)skipList$1.elem).put(pendingApply.key(), pendingApply);
            return;
        }
        if (memory instanceof Memory.Remove) {
            Memory.Remove remove = (Memory.Remove)memory;
            ((SkipList.Immutable)skipList$1.elem).put(remove.key(), remove);
            return;
        }
        if (memory instanceof Memory.Range) {
            Memory.Range range = (Memory.Range)memory;
            hasRange$1.elem = true;
            range.fromValue().foreachS((Function1 & Serializable)x0$1 -> {
                Segment$.$anonfun$memory$1(nearestDeadline$1, x0$1);
                return BoxedUnit.UNIT;
            });
            minMaxFunctionId$1.elem = MinMax$.MODULE$.minMaxFunction(range, (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId$1.elem));
            hasPut$1.elem = hasPut$1.elem || range.fromValue().existsS((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isPut()));
            ((SkipList.Immutable)skipList$1.elem).put(range.key(), range);
            return;
        }
        throw new MatchError((Object)memory);
    }

    private static final void createSegment$1(PathsDistributor pathsDistributor$1, IDGenerator idGenerator$1, ObjectRef minKey$1, ObjectRef lastKeyValue$1, ObjectRef minMaxFunctionId$1, IntRef currentSegmentSize$1, BooleanRef hasRange$1, BooleanRef hasPut$1, long createdInLevel$1, ObjectRef skipList$1, ObjectRef nearestDeadline$1, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, FileSweeper.Enabled fileSweeper$1, ListBuffer segments$1, IntRef currentSegmentKeyValuesCount$1) {
        MaxKey.Range range;
        long segmentId_id = idGenerator$1.nextID();
        Path path = pathsDistributor$1.next().resolve(new java.lang.StringBuilder(1).append(segmentId_id).append(".").append("seg").toString());
        Slice slice = ((Slice)minKey$1.elem).unslice();
        Memory memory = (Memory)lastKeyValue$1.elem;
        if (memory instanceof Memory.Range) {
            Memory.Range range2 = (Memory.Range)memory;
            range = new MaxKey.Range((Object)range2.fromKey().unslice(), (Object)range2.toKey().unslice());
        } else if (memory instanceof Memory.Fixed) {
            Memory.Fixed fixed = (Memory.Fixed)memory;
            range = new MaxKey.Fixed((Object)fixed.key().unslice());
        } else {
            throw new MatchError((Object)memory);
        }
        MemorySegment segment = new MemorySegment(path, (Slice<Object>)slice, (MaxKey<Slice<Object>>)range, (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId$1.elem), currentSegmentSize$1.elem, hasRange$1.elem, hasPut$1.elem, (int)createdInLevel$1, (SkipList.Immutable)skipList$1.elem, (Option<Deadline>)((Option)nearestDeadline$1.elem), (KeyOrder<Slice<Object>>)keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, fileSweeper$1);
        segments$1.$plus$eq((Object)segment);
        skipList$1.elem = SkipList$.MODULE$.immutable(Slice.Null$.MODULE$, Memory$Null$.MODULE$, keyOrder$1);
        minMaxFunctionId$1.elem = None$.MODULE$;
        nearestDeadline$1.elem = None$.MODULE$;
        hasRange$1.elem = false;
        hasPut$1.elem = false;
        currentSegmentSize$1.elem = 0;
        currentSegmentKeyValuesCount$1.elem = 0;
        minKey$1.elem = null;
        lastKeyValue$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$memory$3(ObjectRef minKey$1, ObjectRef lastKeyValue$1, IntRef currentSegmentSize$1, IntRef currentSegmentKeyValuesCount$1, int minSegmentSize$1, int maxKeyValueCountPerSegment$1, BooleanRef hasPut$1, ObjectRef nearestDeadline$1, ObjectRef skipList$1, ObjectRef minMaxFunctionId$1, BooleanRef hasRange$1, PathsDistributor pathsDistributor$1, IDGenerator idGenerator$1, long createdInLevel$1, KeyOrder keyOrder$1, TimeOrder timeOrder$1, FunctionStore functionStore$1, FileSweeper.Enabled fileSweeper$1, ListBuffer segments$1, Memory keyValue) {
        Memory.Range range;
        Memory.Remove remove;
        Memory.PendingApply pendingApply;
        Memory.Function function;
        Memory.Update update;
        Memory.Put put;
        if ((Slice)minKey$1.elem == null) {
            minKey$1.elem = keyValue.key();
        }
        lastKeyValue$1.elem = keyValue;
        Memory memory = keyValue.unslice();
        if (memory instanceof Memory.Put) {
            put = (Memory.Put)memory;
            hasPut$1.elem = true;
            nearestDeadline$1.elem = FiniteDurations$.MODULE$.getNearestDeadline((Option<Deadline>)((Option)nearestDeadline$1.elem), put.deadline());
            ((SkipList.Immutable)skipList$1.elem).put(put.key(), put);
        } else if (memory instanceof Memory.Update) {
            update = (Memory.Update)memory;
            ((SkipList.Immutable)skipList$1.elem).put(update.key(), update);
        } else if (memory instanceof Memory.Function) {
            function = (Memory.Function)memory;
            minMaxFunctionId$1.elem = new Some(MinMax$.MODULE$.minMaxFunction(function, (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId$1.elem)));
            ((SkipList.Immutable)skipList$1.elem).put(function.key(), function);
        } else if (memory instanceof Memory.PendingApply) {
            pendingApply = (Memory.PendingApply)memory;
            minMaxFunctionId$1.elem = MinMax$.MODULE$.minMaxFunction(pendingApply.applies(), (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId$1.elem));
            ((SkipList.Immutable)skipList$1.elem).put(pendingApply.key(), pendingApply);
        } else if (memory instanceof Memory.Remove) {
            remove = (Memory.Remove)memory;
            ((SkipList.Immutable)skipList$1.elem).put(remove.key(), remove);
        } else if (memory instanceof Memory.Range) {
            range = (Memory.Range)memory;
            hasRange$1.elem = true;
            range.fromValue().foreachS((Function1 & Serializable)x0$1 -> {
                Segment$.$anonfun$memory$1(nearestDeadline$1, x0$1);
                return BoxedUnit.UNIT;
            });
            minMaxFunctionId$1.elem = MinMax$.MODULE$.minMaxFunction(range, (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId$1.elem));
            hasPut$1.elem = hasPut$1.elem || range.fromValue().existsS((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isPut()));
            ((SkipList.Immutable)skipList$1.elem).put(range.key(), range);
        } else {
            throw new MatchError((Object)memory);
        }
        memory = null;
        put = null;
        update = null;
        function = null;
        pendingApply = null;
        remove = null;
        range = null;
        currentSegmentSize$1.elem += MergeStats$Memory$.MODULE$.calculateSize(keyValue);
        ++currentSegmentKeyValuesCount$1.elem;
        if (currentSegmentSize$1.elem >= minSegmentSize$1 || currentSegmentKeyValuesCount$1.elem >= maxKeyValueCountPerSegment$1) {
            MaxKey.Range range2;
            long createSegment$1_segmentId_id = idGenerator$1.nextID();
            Path createSegment$1_path = pathsDistributor$1.next().resolve(new java.lang.StringBuilder(1).append(createSegment$1_segmentId_id).append(".").append("seg").toString());
            Slice slice = ((Slice)minKey$1.elem).unslice();
            Memory memory2 = (Memory)lastKeyValue$1.elem;
            if (memory2 instanceof Memory.Range) {
                Memory.Range range3 = (Memory.Range)memory2;
                range2 = new MaxKey.Range((Object)range3.fromKey().unslice(), (Object)range3.toKey().unslice());
            } else if (memory2 instanceof Memory.Fixed) {
                Memory.Fixed fixed = (Memory.Fixed)memory2;
                range2 = new MaxKey.Fixed((Object)fixed.key().unslice());
            } else {
                throw new MatchError((Object)memory2);
            }
            MemorySegment createSegment$1_segment = new MemorySegment(createSegment$1_path, (Slice<Object>)slice, (MaxKey<Slice<Object>>)range2, (Option<MinMax<Slice<Object>>>)((Option)minMaxFunctionId$1.elem), currentSegmentSize$1.elem, hasRange$1.elem, hasPut$1.elem, (int)createdInLevel$1, (SkipList.Immutable)skipList$1.elem, (Option<Deadline>)((Option)nearestDeadline$1.elem), (KeyOrder<Slice<Object>>)keyOrder$1, (TimeOrder<Slice<Object>>)timeOrder$1, functionStore$1, fileSweeper$1);
            segments$1.$plus$eq((Object)createSegment$1_segment);
            skipList$1.elem = SkipList$.MODULE$.immutable(Slice.Null$.MODULE$, Memory$Null$.MODULE$, keyOrder$1);
            minMaxFunctionId$1.elem = None$.MODULE$;
            nearestDeadline$1.elem = None$.MODULE$;
            hasRange$1.elem = false;
            hasPut$1.elem = false;
            currentSegmentSize$1.elem = 0;
            currentSegmentKeyValuesCount$1.elem = 0;
            minKey$1.elem = null;
            lastKeyValue$1.elem = null;
        }
    }

    public static final /* synthetic */ void $anonfun$persistent$3(PersistentSegment segmentToDelete) {
        try {
            segmentToDelete.delete();
            return;
        }
        catch (Exception exception) {
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new java.lang.StringBuilder(56).append("Failed to delete Segment '").append(segmentToDelete.path()).append("' in recover due to failed put").toString(), (Throwable)exception);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$overlaps$2(Iterable segments$2, KeyOrder keyOrder$4, Tuple3 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Slice minKey = (Slice)x0$1._1();
        Slice maxKey = (Slice)x0$1._2();
        boolean maxKeyInclusive = BoxesRunTime.unboxToBoolean((Object)x0$1._3());
        boolean bl = MODULE$.overlaps((Slice<Object>)minKey, (Slice<Object>)maxKey, maxKeyInclusive, (Iterable<Segment>)segments$2, (KeyOrder<Slice<Object>>)keyOrder$4);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$nonOverlapping$1(Iterable segments2$2, KeyOrder keyOrder$6, ListBuffer resultSegments$1, int count$1, Segment segment1) {
        if (!segments2$2.exists((Function1 & Serializable)segment2 -> BoxesRunTime.boxToBoolean((boolean)Segment$.MODULE$.overlaps(segment1, segment2, (KeyOrder<Slice<Object>>)keyOrder$6)))) {
            resultSegments$1.$plus$eq((Object)segment1);
        }
        return resultSegments$1.size() == count$1;
    }

    public static final /* synthetic */ boolean $anonfun$intersects$2(Segment segment1$3, Segment x$5) {
        Path path = x$5.path();
        Path path2 = segment1$3.path();
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$intersects$3(Segment segment$2, Segment x$6) {
        Path path = x$6.path();
        Path path2 = segment$2.path();
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public static final /* synthetic */ int $anonfun$getAllKeyValues$1(int x0$1, Segment x1$1) {
        return x1$1.getKeyValueCount() + x0$1;
    }

    public static final /* synthetic */ void $anonfun$getAllKeyValues$2(Aggregator aggregator$1, Segment segment) {
        segment.iterator().foreach((Function1 & Serializable)item -> {
            aggregator$1.add((Object)item);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$getAllKeyValuesRef$1(int x0$1, SegmentRef x1$1) {
        return x1$1.getKeyValueCount() + x0$1;
    }

    public static final /* synthetic */ void $anonfun$getAllKeyValuesRef$2(Aggregator aggregator$2, SegmentRef segment) {
        segment.iterator().foreach((Function1 & Serializable)item -> {
            aggregator$2.add((Object)item);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$deleteSegments$1(int x0$1, Segment x1$1) {
        x1$1.delete();
        return x0$1 + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$overlapsWithBusySegments$2(KeyOrder keyOrder$9, Memory head$1, Iterable appendixSegments$1, Iterable busySegments$1, Memory last) {
        Map<Segment, Slice<KeyValue>> map;
        if (keyOrder$9.equiv(head$1.key(), last.key())) {
            void apply_evidence$7;
            ClassTag classTag = ClassTag$.MODULE$.apply(Memory.class);
            ArraySeq apply_data = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Memory[]{head$1});
            Object var6_6 = null;
            classTag = null;
            map = SegmentAssigner$.MODULE$.assignUnsafe((Slice<KeyValue>)SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)apply_data.toArray((ClassTag)apply_evidence$7), (ClassTag)apply_evidence$7), (Iterable<Segment>)appendixSegments$1, (KeyOrder<Slice<Object>>)keyOrder$9);
        } else {
            void apply_evidence$7;
            ClassTag classTag = ClassTag$.MODULE$.apply(Memory.class);
            ArraySeq apply_data = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Memory[]{head$1, last});
            Object var8_8 = null;
            classTag = null;
            map = SegmentAssigner$.MODULE$.assignUnsafe((Slice<KeyValue>)SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)apply_data.toArray((ClassTag)apply_evidence$7), (ClassTag)apply_evidence$7), (Iterable<Segment>)appendixSegments$1, (KeyOrder<Slice<Object>>)keyOrder$9);
        }
        Map<Segment, Slice<KeyValue>> assignments = map;
        return MODULE$.overlaps((Iterable<Segment>)busySegments$1, (Iterable<Segment>)assignments.keys(), (KeyOrder<Slice<Object>>)keyOrder$9).nonEmpty();
    }

    private Segment$() {
    }

    public static final /* synthetic */ Object $anonfun$nonOverlapping$1$adapted(Iterable segments2$2, KeyOrder keyOrder$6, ListBuffer resultSegments$1, int count$1, Segment segment1) {
        return BoxesRunTime.boxToBoolean((boolean)Segment$.$anonfun$nonOverlapping$1(segments2$2, keyOrder$6, resultSegments$1, count$1, segment1));
    }
}

