/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment;

import java.io.Serializable;
import java.nio.file.Path;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import swaydb.core.actor.MemorySweeper;
import swaydb.core.data.KeyValue;
import swaydb.core.data.KeyValue$Range$;
import swaydb.core.data.Memory;
import swaydb.core.data.Persistent;
import swaydb.core.data.Persistent$Null$;
import swaydb.core.data.PersistentOption;
import swaydb.core.function.FunctionStore;
import swaydb.core.segment.SegmentIO;
import swaydb.core.segment.SegmentReadState;
import swaydb.core.segment.SegmentReadState$;
import swaydb.core.segment.SegmentReadState$Null$;
import swaydb.core.segment.SegmentReadStateOption;
import swaydb.core.segment.SegmentRef;
import swaydb.core.segment.SegmentSearcher;
import swaydb.core.segment.ThreadReadState;
import swaydb.core.segment.format.a.block.Block;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchIndexBlock;
import swaydb.core.segment.format.a.block.bloomfilter.BloomFilterBlock;
import swaydb.core.segment.format.a.block.hashindex.HashIndexBlock;
import swaydb.core.segment.format.a.block.reader.BlockRefReader;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.segment.SegmentBlock;
import swaydb.core.segment.format.a.block.segment.SegmentBlock$;
import swaydb.core.segment.format.a.block.segment.SegmentBlockCache;
import swaydb.core.segment.format.a.block.segment.data.TransientSegment;
import swaydb.core.segment.format.a.block.segment.footer.SegmentFooterBlock;
import swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock;
import swaydb.core.segment.format.a.block.values.ValuesBlock;
import swaydb.core.segment.merge.MergeStats;
import swaydb.core.segment.merge.MergeStats$;
import swaydb.core.segment.merge.SegmentGrouper$;
import swaydb.core.segment.merge.SegmentMerger$;
import swaydb.core.util.MinMax$;
import swaydb.core.util.SkipList;
import swaydb.core.util.SkipList$;
import swaydb.data.MaxKey;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.TimeOrder;
import swaydb.data.slice.Slice;
import swaydb.data.slice.SliceOption;

public final class SegmentRef$ {
    public static final SegmentRef$ MODULE$ = new SegmentRef$();

    public SegmentRef apply(Path path, Slice<Object> minKey, MaxKey<Slice<Object>> maxKey, BlockRefReader<SegmentBlock.Offset> blockRef, SegmentIO segmentIO, Option<UnblockedReader<ValuesBlock.Offset, ValuesBlock>> valuesReaderCacheable, Option<UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock>> sortedIndexReaderCacheable, Option<UnblockedReader<HashIndexBlock.Offset, HashIndexBlock>> hashIndexReaderCacheable, Option<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>> binarySearchIndexReaderCacheable, Option<UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock>> bloomFilterReaderCacheable, Option<SegmentFooterBlock> footerCacheable, KeyOrder<Slice<Object>> keyOrder, Option<MemorySweeper.Block> blockCacheMemorySweeper, Option<MemorySweeper.KeyValue> keyValueMemorySweeper) {
        SegmentBlockCache segmentBlockCache;
        Option skipList = keyValueMemorySweeper.map((Function1 & Serializable)sweeper -> {
            SkipList skipList;
            Option<Object> option = sweeper.maxKeyValuesPerSegment();
            if (option instanceof Some) {
                int maxKeyValuesPerSegment = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                skipList = SkipList$.MODULE$.concurrent(maxKeyValuesPerSegment, Slice.Null$.MODULE$, Persistent$Null$.MODULE$, keyOrder);
            } else if (None$.MODULE$.equals(option)) {
                skipList = SkipList$.MODULE$.concurrent(Slice.Null$.MODULE$, Persistent$Null$.MODULE$, keyOrder);
            } else {
                throw new MatchError(option);
            }
            return skipList;
        });
        SegmentBlockCache segmentBlockCache2 = segmentBlockCache = new SegmentBlockCache(path, segmentIO, blockRef, valuesReaderCacheable, sortedIndexReaderCacheable, hashIndexReaderCacheable, binarySearchIndexReaderCacheable, bloomFilterReaderCacheable, footerCacheable, blockCacheMemorySweeper);
        segmentBlockCache = null;
        SegmentBlockCache segmentBlockCache3 = segmentBlockCache2;
        return new SegmentRef(path, maxKey, minKey, (Option<SkipList<SliceOption<Object>, PersistentOption, Slice<Object>, Persistent>>)skipList, segmentBlockCache3, keyValueMemorySweeper);
    }

    public PersistentOption bestStartForGetOrHigherSearch(Slice<Object> key, SegmentReadStateOption segmentState, PersistentOption floorFromSkipList, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent> persistentKeyOrder) {
        if (segmentState.isSomeS()) {
            return this.bestStartForGetOrHigherSearch(key, ((SegmentReadState)segmentState.getS()).foundKeyValue(), floorFromSkipList, keyOrder, persistentKeyOrder);
        }
        return floorFromSkipList;
    }

    public PersistentOption bestStartForGetOrHigherSearch(Slice<Object> key, Persistent keyValueFromState, PersistentOption floorFromSkipList, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent> persistentKeyOrder) {
        if (floorFromSkipList.isNoneS()) {
            if (keyOrder.lteq(keyValueFromState.getS().key(), key)) {
                return keyValueFromState;
            }
            return Persistent$Null$.MODULE$;
        }
        return MinMax$.MODULE$.minFavourLeft(keyValueFromState.getS(), floorFromSkipList.getS(), persistentKeyOrder);
    }

    public PersistentOption bestEndForLowerSearch(Slice<Object> key, SegmentReadStateOption segmentState, PersistentOption ceilingFromSkipList, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent> persistentKeyOrder) {
        if (segmentState.isSomeS() && ((SegmentReadState)segmentState.getS()).foundLowerKeyValue().isSomeS()) {
            return this.bestEndForLowerSearch(key, (Persistent)((SegmentReadState)segmentState.getS()).foundLowerKeyValue().getS(), ceilingFromSkipList, keyOrder, persistentKeyOrder);
        }
        return ceilingFromSkipList;
    }

    public PersistentOption bestEndForLowerSearch(Slice<Object> key, Persistent lowerKeyValueFromState, PersistentOption ceilingFromSkipList, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent> persistentKeyOrder) {
        if (ceilingFromSkipList.isNoneS()) {
            if (keyOrder.gteq(lowerKeyValueFromState.getS().key(), key)) {
                return lowerKeyValueFromState;
            }
            return Persistent$Null$.MODULE$;
        }
        return MinMax$.MODULE$.minFavourLeft(lowerKeyValueFromState.getS(), ceilingFromSkipList.getS(), persistentKeyOrder);
    }

    public PersistentOption get(Slice<Object> key, ThreadReadState threadState, SegmentRef segmentRef, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent.Partial> partialKeyOrder, KeyOrder<Persistent> persistentKeyOrder, SegmentSearcher segmentSearcher) {
        MaxKey.Range range;
        PersistentOption persistentOption;
        Slice maxKey;
        MaxKey<Slice<Object>> maxKey2 = segmentRef.maxKey();
        if (maxKey2 instanceof MaxKey.Fixed && keyOrder.gt(key, (Object)(maxKey = (Slice)((MaxKey.Fixed)maxKey2).maxKey()))) {
            persistentOption = Persistent$Null$.MODULE$;
        } else if (maxKey2 instanceof MaxKey.Range && keyOrder.gteq(key, (range = (MaxKey.Range)maxKey2).maxKey())) {
            persistentOption = Persistent$Null$.MODULE$;
        } else {
            PersistentOption persistentOption2;
            Persistent$Null$ getFromState;
            Persistent$Null$ persistent$Null$;
            SegmentFooterBlock footer = segmentRef.segmentBlockCache().getFooter();
            SegmentReadStateOption segmentStateOptional = threadState.getSegmentState(segmentRef.path());
            if (footer.hasRange() && segmentStateOptional.isSomeS()) {
                Persistent.Range range2;
                Persistent persistent = ((SegmentReadState)segmentStateOptional.getS()).foundKeyValue();
                PersistentOption persistentOption3 = persistent != null && keyOrder.equiv(persistent.key(), key) ? persistent : (persistent instanceof Persistent.Range && KeyValue$Range$.MODULE$.contains(range2 = (Persistent.Range)persistent, key, keyOrder) ? range2 : Persistent$Null$.MODULE$);
                persistent$Null$ = persistentOption3;
            } else {
                persistent$Null$ = getFromState = Persistent$Null$.MODULE$;
            }
            if (getFromState.isSomeS()) {
                persistentOption2 = (PersistentOption)getFromState.getS();
            } else {
                Persistent.Range range3;
                PersistentOption persistentOption4;
                Persistent persistent;
                Persistent$Null$ persistent$Null$2;
                PersistentOption persistentOption5 = persistent$Null$2 = segmentRef.skipList().isDefined() ? (PersistentOption)((SkipList)segmentRef.skipList().get()).floor(key) : Persistent$Null$.MODULE$;
                if (persistent$Null$2 instanceof Persistent && keyOrder.equiv((persistent = (Persistent)((Object)persistent$Null$2)).key(), key)) {
                    persistentOption4 = persistent;
                } else if (persistent$Null$2 instanceof Persistent.Range && KeyValue$Range$.MODULE$.contains(range3 = (Persistent.Range)((Object)persistent$Null$2), key, keyOrder)) {
                    persistentOption4 = range3;
                } else {
                    PersistentOption persistentOption6;
                    if (footer.hasRange() || segmentRef.mightContain(key)) {
                        Persistent$Null$ sequentialRead;
                        PersistentOption bestStart2 = this.bestStartForGetOrHigherSearch(key, segmentStateOptional, (PersistentOption)persistent$Null$2, keyOrder, persistentKeyOrder);
                        PersistentOption persistentOption7 = sequentialRead = segmentStateOptional.isNoneS() || ((SegmentReadState)segmentStateOptional.getS()).isSequential() ? (PersistentOption)segmentSearcher.searchSequential(key, bestStart2, segmentRef.segmentBlockCache().createSortedIndexReader(), segmentRef.segmentBlockCache().createValuesReaderOrNull(), keyOrder, partialKeyOrder).onSomeSideEffectS((Function1 & Serializable)found -> {
                            SegmentRef$.$anonfun$get$2(segmentRef, key, segmentStateOptional, threadState, found);
                            return BoxedUnit.UNIT;
                        }) : Persistent$Null$.MODULE$;
                        if (sequentialRead.isSomeS()) {
                            persistentOption6 = sequentialRead;
                        } else {
                            Persistent$Null$ persistent$Null$3;
                            Persistent$Null$ persistent$Null$4 = persistent$Null$3 = segmentRef.skipList().isDefined() ? (PersistentOption)((SkipList)segmentRef.skipList().get()).higher(key) : Persistent$Null$.MODULE$;
                            persistent$Null$3 = null;
                            Persistent$Null$ higher = persistent$Null$4;
                            if (bestStart2.existsS((Function1 & Serializable)bestStart -> BoxesRunTime.boxToBoolean((boolean)higher.existsS((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SegmentRef$.$anonfun$get$5(bestStart, x$3)))))) {
                                persistentOption6 = Persistent$Null$.MODULE$;
                            } else {
                                Function0 & Serializable x$3 = (Function0 & Serializable)() -> higher;
                                JFunction0.mcI.sp & Serializable x$4 = (JFunction0.mcI.sp & Serializable)() -> footer.keyValueCount();
                                UnblockedReader<HashIndexBlock.Offset, HashIndexBlock> x$5 = segmentRef.segmentBlockCache().createHashIndexReaderOrNull();
                                Function0 & Serializable x$6 = (Function0 & Serializable)() -> segmentRef.segmentBlockCache().createBinarySearchIndexReaderOrNull();
                                UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> x$7 = segmentRef.segmentBlockCache().createSortedIndexReader();
                                UnblockedReader<ValuesBlock.Offset, ValuesBlock> x$8 = segmentRef.segmentBlockCache().createValuesReaderOrNull();
                                boolean x$9 = footer.hasRange();
                                persistentOption6 = (PersistentOption)segmentSearcher.searchRandom(key, bestStart2, (Function0<PersistentOption>)x$3, x$5, (Function0<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>>)x$6, x$7, x$8, x$9, (Function0<Object>)x$4, keyOrder, partialKeyOrder).onSideEffectS((Function1 & Serializable)found -> {
                                    SegmentRef$.$anonfun$get$9(segmentRef, key, bestStart2, segmentStateOptional, threadState, found);
                                    return BoxedUnit.UNIT;
                                });
                            }
                        }
                    } else {
                        persistentOption6 = Persistent$Null$.MODULE$;
                    }
                    persistentOption4 = persistentOption6;
                }
                persistentOption2 = persistentOption4;
            }
            persistentOption = persistentOption2;
        }
        return persistentOption;
    }

    public PersistentOption higher(Slice<Object> key, ThreadReadState threadState, SegmentRef segmentRef, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent> persistentKeyOrder, KeyOrder<Persistent.Partial> partialKeyOrder, SegmentSearcher segmentSearcher) {
        Slice maxKey;
        PersistentOption persistentOption;
        Slice maxKey2;
        MaxKey<Slice<Object>> maxKey3 = segmentRef.maxKey();
        if (maxKey3 instanceof MaxKey.Fixed && keyOrder.gteq(key, (Object)(maxKey2 = (Slice)((MaxKey.Fixed)maxKey3).maxKey()))) {
            persistentOption = Persistent$Null$.MODULE$;
        } else if (maxKey3 instanceof MaxKey.Range && keyOrder.gteq(key, (Object)(maxKey = (Slice)((MaxKey.Range)maxKey3).maxKey()))) {
            persistentOption = Persistent$Null$.MODULE$;
        } else {
            PersistentOption persistentOption2;
            if (keyOrder.lt(key, segmentRef.minKey())) {
                persistentOption2 = this.get(segmentRef.minKey(), threadState, segmentRef, keyOrder, partialKeyOrder, persistentKeyOrder, segmentSearcher);
            } else {
                SegmentReadStateOption segmentStateOptional = threadState.getSegmentState(segmentRef.path());
                if (segmentStateOptional.isSomeS() && keyOrder.lteq(((SegmentReadState)segmentStateOptional.getS()).forKey(), key) && keyOrder.gt(((SegmentReadState)segmentStateOptional.getS()).foundKeyValue().key(), key)) {
                    persistentOption2 = ((SegmentReadState)segmentStateOptional.getS()).foundKeyValue();
                } else {
                    Persistent$Null$ higherFromState;
                    Persistent$Null$ persistent$Null$;
                    SegmentBlockCache blockCache = segmentRef.segmentBlockCache();
                    if (blockCache.getFooter().hasRange() && segmentStateOptional.isSomeS()) {
                        Persistent.Range range;
                        Persistent persistent = ((SegmentReadState)segmentStateOptional.getS()).foundKeyValue();
                        PersistentOption persistentOption3 = persistent instanceof Persistent.Range && KeyValue$Range$.MODULE$.contains(range = (Persistent.Range)persistent, key, keyOrder) ? range : Persistent$Null$.MODULE$;
                        persistent$Null$ = persistentOption3;
                    } else {
                        persistent$Null$ = higherFromState = Persistent$Null$.MODULE$;
                    }
                    if (higherFromState.isSomeS()) {
                        persistentOption2 = (PersistentOption)higherFromState.getS();
                    } else {
                        Persistent.Range range;
                        Persistent.Range range2;
                        Persistent$Null$ persistent$Null$2;
                        PersistentOption persistentOption4 = persistent$Null$2 = segmentRef.skipList().isDefined() ? (PersistentOption)((SkipList)segmentRef.skipList().get()).floor(key) : Persistent$Null$.MODULE$;
                        if (persistent$Null$2 instanceof Persistent.Range && KeyValue$Range$.MODULE$.contains(range2 = (Persistent.Range)((Object)persistent$Null$2), key, keyOrder)) {
                            range = range2;
                        } else {
                            PersistentOption persistentOption5;
                            Persistent.Range range3;
                            Persistent$Null$ persistent$Null$3;
                            PersistentOption persistentOption6 = persistent$Null$3 = segmentRef.skipList().isDefined() ? (PersistentOption)((SkipList)segmentRef.skipList().get()).higher(key) : Persistent$Null$.MODULE$;
                            if (persistent$Null$3 instanceof Persistent.Range && KeyValue$Range$.MODULE$.contains(range3 = (Persistent.Range)((Object)persistent$Null$3), key, keyOrder)) {
                                persistentOption5 = range3;
                            } else {
                                PersistentOption persistentOption7;
                                Persistent$Null$ inMemorySeek;
                                Persistent$Null$ persistent$Null$4;
                                if (persistent$Null$2.isSomeS() && persistent$Null$3.isSomeS() && ((Persistent)persistent$Null$2.getS()).nextIndexOffset() == ((Persistent)persistent$Null$3.getS()).indexOffset()) {
                                    SegmentReadState$.MODULE$.updateOnSuccessSequentialRead(segmentRef.path(), key, segmentStateOptional, threadState, (Persistent)persistent$Null$3.getS());
                                    persistent$Null$4 = persistent$Null$3;
                                } else {
                                    persistent$Null$4 = inMemorySeek = Persistent$Null$.MODULE$;
                                }
                                if (inMemorySeek.isSomeS()) {
                                    persistentOption7 = inMemorySeek;
                                } else {
                                    PersistentOption bestStart = this.bestStartForGetOrHigherSearch(key, segmentStateOptional, (PersistentOption)persistent$Null$2, keyOrder, persistentKeyOrder);
                                    Persistent$Null$ sequentialSeek = segmentStateOptional.isNoneS() || ((SegmentReadState)segmentStateOptional.getS()).isSequential() ? (PersistentOption)segmentSearcher.searchHigherSequentially(key, bestStart, blockCache.createSortedIndexReader(), blockCache.createValuesReaderOrNull(), keyOrder, partialKeyOrder).onSomeSideEffectS((Function1 & Serializable)found -> {
                                        SegmentRef$.$anonfun$higher$3(segmentRef, key, segmentStateOptional, threadState, found);
                                        return BoxedUnit.UNIT;
                                    }) : Persistent$Null$.MODULE$;
                                    persistentOption7 = sequentialSeek.isSomeS() ? sequentialSeek : (PersistentOption)segmentSearcher.searchHigherRandomly(key, bestStart, persistent$Null$3, (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> segmentRef.getFooter().keyValueCount(), (Function0<UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>>)(Function0 & Serializable)() -> blockCache.createBinarySearchIndexReaderOrNull(), blockCache.createSortedIndexReader(), blockCache.createValuesReaderOrNull(), keyOrder, partialKeyOrder).onSideEffectS((Function1 & Serializable)optional -> {
                                        SegmentRef$.$anonfun$higher$6(segmentRef, key, bestStart, segmentStateOptional, threadState, optional);
                                        return BoxedUnit.UNIT;
                                    });
                                }
                                persistentOption5 = persistentOption7;
                            }
                            range = persistentOption5;
                        }
                        persistentOption2 = range;
                    }
                }
            }
            persistentOption = persistentOption2;
        }
        return persistentOption;
    }

    private PersistentOption lower(Slice<Object> key, PersistentOption start, PersistentOption end, int keyValueCount, Path path, SegmentReadStateOption segmentStateOptional, ThreadReadState threadState, SegmentRef segmentRef, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent> persistentKeyOrder, KeyOrder<Persistent.Partial> partialKeyOrder, SegmentSearcher segmentSearcher) {
        UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndexReader = segmentRef.segmentBlockCache().createSortedIndexReader();
        PersistentOption endKeyValue = end.isNoneS() && sortedIndexReader.block().enableAccessPositionIndex() ? this.get(key, threadState, segmentRef, keyOrder, partialKeyOrder, persistentKeyOrder, segmentSearcher) : end;
        return (PersistentOption)segmentSearcher.searchLower(key, start, endKeyValue, keyValueCount, segmentRef.segmentBlockCache().createBinarySearchIndexReaderOrNull(), sortedIndexReader, segmentRef.segmentBlockCache().createValuesReaderOrNull(), keyOrder, partialKeyOrder).onSideEffectS((Function1 & Serializable)optional -> {
            optional.foreachS((Function1 & Serializable)found -> {
                SegmentRef$.$anonfun$lower$2(segmentStateOptional$3, threadState$3, path$1, key$3, segmentRef$3, found);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private PersistentOption bestEndForLowerSearch(Slice<Object> key, SegmentReadStateOption segmentState, ThreadReadState readState, SegmentRef segmentRef, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent> persistentKeyOrder) {
        if (segmentRef == null) {
            throw null;
        }
        return this.bestEndForLowerSearch(key, segmentState, segmentRef.skipList().isDefined() ? (PersistentOption)((SkipList)segmentRef.skipList().get()).ceiling(key) : Persistent$Null$.MODULE$, keyOrder, persistentKeyOrder);
    }

    public PersistentOption lower(Slice<Object> key, ThreadReadState threadState, SegmentRef segmentRef, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent> persistentKeyOrder, KeyOrder<Persistent.Partial> partialKeyOrder, SegmentSearcher segmentSearcher) {
        Slice fromKey;
        PersistentOption persistentOption;
        Slice maxKey;
        if (keyOrder.lteq(key, segmentRef.minKey())) {
            return Persistent$Null$.MODULE$;
        }
        MaxKey<Slice<Object>> maxKey2 = segmentRef.maxKey();
        if (maxKey2 instanceof MaxKey.Fixed && keyOrder.gt(key, (Object)(maxKey = (Slice)((MaxKey.Fixed)maxKey2).maxKey()))) {
            persistentOption = this.get((Slice<Object>)maxKey, threadState, segmentRef, keyOrder, partialKeyOrder, persistentKeyOrder, segmentSearcher);
        } else if (maxKey2 instanceof MaxKey.Range && keyOrder.gt(key, (Object)(fromKey = (Slice)((MaxKey.Range)maxKey2).fromKey()))) {
            persistentOption = this.get((Slice<Object>)fromKey, threadState, segmentRef, keyOrder, partialKeyOrder, persistentKeyOrder, segmentSearcher);
        } else {
            PersistentOption persistentOption2;
            SegmentReadStateOption segmentStateOption = threadState.getSegmentState(segmentRef.path());
            if (segmentStateOption.isSomeS() && ((SegmentReadState)segmentStateOption.getS()).foundLowerKeyValue().isSomeS() && keyOrder.gteq(((SegmentReadState)segmentStateOption.getS()).forKey(), key) && keyOrder.lt(((Persistent.Partial)((SegmentReadState)segmentStateOption.getS()).foundLowerKeyValue().getS()).key(), key)) {
                persistentOption2 = ((SegmentReadState)segmentStateOption.getS()).foundLowerKeyValue();
            } else {
                Persistent$Null$ lowerFromState;
                Persistent$Null$ persistent$Null$;
                SegmentFooterBlock footer = segmentRef.segmentBlockCache().getFooter();
                if (footer.hasRange() && segmentStateOption.isSomeS()) {
                    Persistent.Range range;
                    Persistent persistent = ((SegmentReadState)segmentStateOption.getS()).foundKeyValue();
                    PersistentOption persistentOption3 = persistent instanceof Persistent.Range && KeyValue$Range$.MODULE$.containsLower(range = (Persistent.Range)persistent, key, keyOrder) ? range : Persistent$Null$.MODULE$;
                    persistent$Null$ = persistentOption3;
                } else {
                    persistent$Null$ = lowerFromState = Persistent$Null$.MODULE$;
                }
                if (lowerFromState.isSomeS()) {
                    persistentOption2 = (PersistentOption)lowerFromState.getS();
                } else {
                    PersistentOption persistentOption4;
                    Persistent$Null$ persistent$Null$2;
                    PersistentOption persistentOption5 = persistent$Null$2 = segmentRef.skipList().isDefined() ? (PersistentOption)((SkipList)segmentRef.skipList().get()).lower(key) : Persistent$Null$.MODULE$;
                    if (persistent$Null$2 instanceof Persistent) {
                        Persistent persistent;
                        Persistent persistent2 = (Persistent)((Object)persistent$Null$2);
                        if (persistent2.nextIndexOffset() == -1) {
                            persistent = persistent2;
                        } else {
                            Persistent.Range range;
                            Persistent.Range range2;
                            if (persistent2 instanceof Persistent.Range && KeyValue$Range$.MODULE$.containsLower(range2 = (Persistent.Range)persistent2, key, keyOrder)) {
                                range = range2;
                            } else {
                                PersistentOption persistentOption6;
                                PersistentOption persistentOption7 = this.bestEndForLowerSearch(key, segmentStateOption, threadState, segmentRef, keyOrder, persistentKeyOrder);
                                if (persistentOption7 instanceof Persistent.Range) {
                                    Persistent.Range range3 = (Persistent.Range)persistentOption7;
                                    persistentOption6 = KeyValue$Range$.MODULE$.containsLower(range3, key, keyOrder) ? range3 : (persistent2.nextIndexOffset() == range3.indexOffset() ? persistent2 : this.lower(key, persistent2, range3, footer.keyValueCount(), segmentRef.path(), segmentStateOption, threadState, segmentRef, keyOrder, persistentKeyOrder, partialKeyOrder, segmentSearcher));
                                } else if (persistentOption7 instanceof Persistent.Fixed) {
                                    Persistent.Fixed fixed = (Persistent.Fixed)persistentOption7;
                                    persistentOption6 = persistent2.nextIndexOffset() == fixed.indexOffset() ? persistent2 : this.lower(key, persistent2, fixed, footer.keyValueCount(), segmentRef.path(), segmentStateOption, threadState, segmentRef, keyOrder, persistentKeyOrder, partialKeyOrder, segmentSearcher);
                                } else if (Persistent$Null$.MODULE$.equals(persistentOption7)) {
                                    persistentOption6 = this.lower(key, persistent2, Persistent$Null$.MODULE$, footer.keyValueCount(), segmentRef.path(), segmentStateOption, threadState, segmentRef, keyOrder, persistentKeyOrder, partialKeyOrder, segmentSearcher);
                                } else {
                                    throw new MatchError((Object)persistentOption7);
                                }
                                range = persistentOption6;
                            }
                            persistent = range;
                        }
                        persistentOption4 = persistent;
                    } else if (Persistent$Null$.MODULE$.equals(persistent$Null$2)) {
                        persistentOption4 = this.lower(key, Persistent$Null$.MODULE$, this.bestEndForLowerSearch(key, segmentStateOption, threadState, segmentRef, keyOrder, persistentKeyOrder), footer.keyValueCount(), segmentRef.path(), segmentStateOption, threadState, segmentRef, keyOrder, persistentKeyOrder, partialKeyOrder, segmentSearcher);
                    } else {
                        throw new MatchError((Object)persistent$Null$2);
                    }
                    persistentOption2 = persistentOption4;
                }
            }
            persistentOption = persistentOption2;
        }
        return persistentOption;
    }

    public Slice<TransientSegment> put(SegmentRef ref, Slice<KeyValue> newKeyValues, boolean removeDeletes, int createdInLevel, ValuesBlock.Config valuesConfig, SortedIndexBlock.Config sortedIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, HashIndexBlock.Config hashIndexConfig, BloomFilterBlock.Config bloomFilterConfig, SegmentBlock.Config segmentConfig, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore) {
        return this.put(ref.getKeyValueCount(), ref.iterator(), newKeyValues, removeDeletes, createdInLevel, valuesConfig, sortedIndexConfig, binarySearchIndexConfig, hashIndexConfig, bloomFilterConfig, segmentConfig, keyOrder, timeOrder, functionStore);
    }

    public Slice<TransientSegment> put(int oldKeyValuesCount, Iterator<Persistent> oldKeyValues, Slice<KeyValue> newKeyValues, boolean removeDeletes, int createdInLevel, ValuesBlock.Config valuesConfig, SortedIndexBlock.Config sortedIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, HashIndexBlock.Config hashIndexConfig, BloomFilterBlock.Config bloomFilterConfig, SegmentBlock.Config segmentConfig, KeyOrder<Slice<Object>> keyOrder, TimeOrder<Slice<Object>> timeOrder, FunctionStore functionStore) {
        MergeStats.Persistent.Builder<Memory, Iterable> builder = MergeStats$.MODULE$.persistent(ListBuffer$.MODULE$.newBuilder(), Predef$.MODULE$.$conforms());
        SegmentMerger$.MODULE$.merge(newKeyValues, oldKeyValuesCount, oldKeyValues, builder, removeDeletes, keyOrder, timeOrder, functionStore);
        MergeStats.Persistent.Closed<Iterable> closed = builder.close(sortedIndexConfig.enableAccessPositionIndex());
        return SegmentBlock$.MODULE$.writeOneOrMany(closed, createdInLevel, bloomFilterConfig, hashIndexConfig, binarySearchIndexConfig, sortedIndexConfig, valuesConfig, segmentConfig);
    }

    public Slice<TransientSegment> refresh(SegmentRef ref, boolean removeDeletes, int createdInLevel, ValuesBlock.Config valuesConfig, SortedIndexBlock.Config sortedIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, HashIndexBlock.Config hashIndexConfig, BloomFilterBlock.Config bloomFilterConfig, SegmentBlock.Config segmentConfig) {
        SegmentFooterBlock footer = ref.getFooter();
        if (footer.createdInLevel() == createdInLevel) {
            Iterator<Persistent> iterator = ref.iterator();
            return this.refreshForSameLevel(ref.segmentBlockCache().getSortedIndex(), ref.segmentBlockCache().getValues(), iterator, footer.keyValueCount(), removeDeletes, createdInLevel, valuesConfig, sortedIndexConfig, binarySearchIndexConfig, hashIndexConfig, bloomFilterConfig, segmentConfig);
        }
        return this.refreshForNewLevel(ref.iterator(), removeDeletes, createdInLevel, valuesConfig, sortedIndexConfig, binarySearchIndexConfig, hashIndexConfig, bloomFilterConfig, segmentConfig);
    }

    public Slice<TransientSegment> refreshForSameLevel(SortedIndexBlock sortedIndexBlock, Option<ValuesBlock> valuesBlock, Iterator<Persistent> iterator, int keyValuesCount, boolean removeDeletes, int createdInLevel, ValuesBlock.Config valuesConfig, SortedIndexBlock.Config sortedIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, HashIndexBlock.Config hashIndexConfig, BloomFilterBlock.Config bloomFilterConfig, SegmentBlock.Config segmentConfig) {
        int n;
        int n2;
        Option<Block.CompressionInfo> option = sortedIndexBlock.compressionInfo();
        if (option instanceof Some) {
            n2 = ((Block.CompressionInfo)((Some)option).value()).decompressedLength();
        } else if (None$.MODULE$.equals(option)) {
            n2 = sortedIndexBlock.offset().size();
        } else {
            throw new MatchError(option);
        }
        if (valuesBlock instanceof Some) {
            int n3;
            ValuesBlock valuesBlock2 = (ValuesBlock)((Some)valuesBlock).value();
            Option<Block.CompressionInfo> option2 = valuesBlock2.compressionInfo();
            if (option2 instanceof Some) {
                n3 = ((Block.CompressionInfo)((Some)option2).value()).decompressedLength();
            } else if (None$.MODULE$.equals(option2)) {
                n3 = valuesBlock2.offset().size();
            } else {
                throw new MatchError(option2);
            }
            n = n3;
        } else if (None$.MODULE$.equals(valuesBlock)) {
            n = 0;
        } else {
            throw new MatchError(valuesBlock);
        }
        Iterable keyValues = (Iterable)IterableOnceOps.to$((IterableOnceOps)new Iterator<Memory>(iterator, removeDeletes){
            private Memory nextOne;
            private final Iterator fullIterator$1;
            private final boolean removeDeletes$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Memory> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Memory> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Memory> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Memory>, Iterator<Memory>> partition(Function1<Memory, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Memory, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Memory, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Memory, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Memory> filter(Function1<Memory, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Memory> filterNot(Function1<Memory, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Memory> filterImpl(Function1<Memory, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Memory> withFilter(Function1<Memory, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Memory, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Memory> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Memory> distinctBy(Function1<Memory, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Memory, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Memory, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Memory, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Memory> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Memory> takeWhile(Function1<Memory, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Memory> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Memory> dropWhile(Function1<Memory, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Memory>, Iterator<Memory>> span(Function1<Memory, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Memory> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Memory> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Memory, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Memory, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Memory>, Iterator<Memory>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<Memory> tapEach(Function1<Memory, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Memory> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Memory>, Iterator<Memory>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Memory, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Memory, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Memory, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Memory, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Memory> find(Function1<Memory, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Memory, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Memory, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Memory, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Memory, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Memory, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Memory, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Memory, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Memory, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Memory> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Memory> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Memory> maxByOption(Function1<Memory, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Memory> minByOption(Function1<Memory, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<Memory, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Memory, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Memory, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Memory, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Memory> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Memory> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Memory> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K$, V$> Map<K$, V$> toMap(.less.colon.less<Memory, Tuple2<K$, V$>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Memory> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Memory> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Memory> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Memory> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Memory, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private Memory nextOne() {
                return this.nextOne;
            }

            private void nextOne_$eq(Memory x$1) {
                this.nextOne = x$1;
            }

            public final boolean hasNext() {
                while (this.fullIterator$1.hasNext()) {
                    KeyValue nextKeyValue = (KeyValue)this.fullIterator$1.next();
                    Memory nextKeyValueOrNull = this.removeDeletes$1 ? SegmentGrouper$.MODULE$.addLastLevel(nextKeyValue) : nextKeyValue.toMemory();
                    if (nextKeyValueOrNull == null) continue;
                    this.nextOne_$eq(nextKeyValueOrNull);
                    return true;
                }
                return false;
            }

            public Memory next() {
                return this.nextOne();
            }
            {
                this.fullIterator$1 = fullIterator$1;
                this.removeDeletes$1 = removeDeletes$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }
        }, (Factory)IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Iterable()));
        MergeStats.Persistent.Closed<Iterable> mergeStats = new MergeStats.Persistent.Closed<Iterable>(false, keyValuesCount, keyValues, n2, n);
        return SegmentBlock$.MODULE$.writeOneOrMany(mergeStats, createdInLevel, bloomFilterConfig, hashIndexConfig, binarySearchIndexConfig, sortedIndexConfig, valuesConfig, segmentConfig);
    }

    public Slice<TransientSegment> refreshForNewLevel(Iterator<Persistent> keyValues, boolean removeDeletes, int createdInLevel, ValuesBlock.Config valuesConfig, SortedIndexBlock.Config sortedIndexConfig, BinarySearchIndexBlock.Config binarySearchIndexConfig, HashIndexBlock.Config hashIndexConfig, BloomFilterBlock.Config bloomFilterConfig, SegmentBlock.Config segmentConfig) {
        Iterable memoryKeyValues = (Iterable)IterableOnceOps.to$((IterableOnceOps)new /* invalid duplicate definition of identical inner class */, (Factory)IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Iterable()));
        MergeStats.Persistent.Closed<ListBuffer> builder = MergeStats$.MODULE$.persistentBuilder(memoryKeyValues, Predef$.MODULE$.$conforms()).close(sortedIndexConfig.enableAccessPositionIndex());
        return SegmentBlock$.MODULE$.writeOneOrMany(builder, createdInLevel, bloomFilterConfig, hashIndexConfig, binarySearchIndexConfig, sortedIndexConfig, valuesConfig, segmentConfig);
    }

    public static final /* synthetic */ PersistentOption $anonfun$get$1(Slice key$1, SkipList x$1) {
        return (PersistentOption)x$1.floor(key$1);
    }

    public static final /* synthetic */ void $anonfun$get$2(SegmentRef segmentRef$1, Slice key$1, SegmentReadStateOption segmentStateOptional$1, ThreadReadState threadState$1, Persistent found) {
        SegmentReadState$.MODULE$.updateOnSuccessSequentialRead(segmentRef$1.path(), (Slice<Object>)key$1, segmentStateOptional$1, threadState$1, found);
        segmentRef$1.swaydb$core$segment$SegmentRef$$addToSkipList(found);
    }

    public static final /* synthetic */ PersistentOption $anonfun$get$3(Slice key$1, SkipList x$2) {
        return (PersistentOption)x$2.higher(key$1);
    }

    public static final /* synthetic */ boolean $anonfun$get$5(Persistent bestStart$1, Persistent x$3) {
        return x$3.indexOffset() == bestStart$1.nextIndexOffset();
    }

    public static final /* synthetic */ void $anonfun$get$9(SegmentRef segmentRef$1, Slice key$1, PersistentOption bestStart$2, SegmentReadStateOption segmentStateOptional$1, ThreadReadState threadState$1, PersistentOption found) {
        SegmentReadState$.MODULE$.updateAfterRandomRead(segmentRef$1.path(), (Slice<Object>)key$1, bestStart$2, segmentStateOptional$1, threadState$1, found);
        found.foreachS((Function1 & Serializable)keyValue -> {
            segmentRef$1.swaydb$core$segment$SegmentRef$$addToSkipList(keyValue);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ PersistentOption $anonfun$higher$1(Slice key$2, SkipList x$4) {
        return (PersistentOption)x$4.floor(key$2);
    }

    public static final /* synthetic */ PersistentOption $anonfun$higher$2(Slice key$2, SkipList x$5) {
        return (PersistentOption)x$5.higher(key$2);
    }

    public static final /* synthetic */ void $anonfun$higher$3(SegmentRef segmentRef$2, Slice key$2, SegmentReadStateOption segmentStateOptional$2, ThreadReadState threadState$2, Persistent found) {
        SegmentReadState$.MODULE$.updateOnSuccessSequentialRead(segmentRef$2.path(), (Slice<Object>)key$2, segmentStateOptional$2, threadState$2, found);
        segmentRef$2.swaydb$core$segment$SegmentRef$$addToSkipList(found);
    }

    public static final /* synthetic */ void $anonfun$higher$6(SegmentRef segmentRef$2, Slice key$2, PersistentOption bestStart$3, SegmentReadStateOption segmentStateOptional$2, ThreadReadState threadState$2, PersistentOption optional) {
        SegmentReadState$.MODULE$.updateAfterRandomRead(segmentRef$2.path(), (Slice<Object>)key$2, bestStart$3, segmentStateOptional$2, threadState$2, optional);
        optional.foreachS((Function1 & Serializable)keyValue -> {
            segmentRef$2.swaydb$core$segment$SegmentRef$$addToSkipList(keyValue);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$lower$2(SegmentReadStateOption segmentStateOptional$3, ThreadReadState threadState$3, Path path$1, Slice key$3, SegmentRef segmentRef$3, Persistent found) {
        if (SegmentReadState$Null$.MODULE$.equals(segmentStateOptional$3)) {
            threadState$3.setSegmentState(path$1, new SegmentReadState((Slice<Object>)key$3, found, found, true));
        } else if (segmentStateOptional$3 instanceof SegmentReadState) {
            ((SegmentReadState)segmentStateOptional$3).foundLowerKeyValue_$eq(found);
        } else {
            throw new MatchError((Object)segmentStateOptional$3);
        }
        segmentRef$3.swaydb$core$segment$SegmentRef$$addToSkipList(found);
    }

    public static final /* synthetic */ PersistentOption $anonfun$bestEndForLowerSearch$1(Slice key$4, SkipList x$6) {
        return (PersistentOption)x$6.ceiling(key$4);
    }

    public static final /* synthetic */ PersistentOption $anonfun$lower$3(Slice key$5, SkipList x$7) {
        return (PersistentOption)x$7.lower(key$5);
    }

    private SegmentRef$() {
    }
}

