/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment.format.a.block;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import swaydb.Exception;
import swaydb.compression.CompressionInternal;
import swaydb.compression.DecompressorInternal;
import swaydb.compression.DecompressorInternal$;
import swaydb.core.segment.format.a.block.Block;
import swaydb.core.segment.format.a.block.BlockOffset;
import swaydb.core.segment.format.a.block.BlockOps;
import swaydb.core.segment.format.a.block.reader.BlockRefReader;
import swaydb.core.segment.format.a.block.reader.BlockRefReader$;
import swaydb.core.segment.format.a.block.reader.BlockedReader;
import swaydb.core.segment.format.a.block.reader.BlockedReader$;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.reader.UnblockedReader$;
import swaydb.core.segment.format.a.block.segment.data.ClosedBlocksWithFooter;
import swaydb.core.segment.format.a.block.segment.data.TransientSegment;
import swaydb.core.util.Collections;
import swaydb.data.slice.ReaderBase;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.slice.SliceReader;
import swaydb.data.util.ByteSizeOf$;
import swaydb.data.util.Bytez;
import swaydb.data.util.Bytez$;

public final class Block$
implements LazyLogging {
    public static final Block$ MODULE$ = new Block$();
    private static final byte uncompressedBlockId;
    private static final byte compressedBlockID;
    private static final int headerSizeWithCompression;
    private static final int headerSizeNoCompression;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        uncompressedBlockId = (byte)0;
        compressedBlockID = (byte)1;
        headerSizeWithCompression = ByteSizeOf$.MODULE$.byte() + ByteSizeOf$.MODULE$.byte() + ByteSizeOf$.MODULE$.byte() + ByteSizeOf$.MODULE$.varInt();
        headerSizeNoCompression = ByteSizeOf$.MODULE$.byte() + ByteSizeOf$.MODULE$.byte();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public byte uncompressedBlockId() {
        return uncompressedBlockId;
    }

    public byte compressedBlockID() {
        return compressedBlockID;
    }

    private int headerSizeWithCompression() {
        return headerSizeWithCompression;
    }

    private int headerSizeNoCompression() {
        return headerSizeNoCompression;
    }

    public int minimumHeaderSize(boolean hasCompression) {
        if (hasCompression) {
            return this.headerSizeWithCompression();
        }
        return this.headerSizeNoCompression();
    }

    /*
     * WARNING - void declaration
     */
    public Block.CompressionResult compress(Slice<Object> bytes, Seq<CompressionInternal> compressions, String blockName) {
        Block.CompressionResult compressionResult;
        Tuple2 tuple2;
        None$ none$;
        Function1 & Serializable intersect = (Function1 & Serializable)x$1 -> x$1.compressor().compress(bytes);
        Collections.IterableImplicit<CompressionInternal> untilSome_this = new Collections.IterableImplicit<CompressionInternal>((Iterable<CompressionInternal>)compressions);
        Object object = new Object();
        try {
            void untilSome_f;
            untilSome_this.swaydb$core$util$Collections$IterableImplicit$$items.foreach(arg_0 -> Collections.IterableImplicit.$anonfun$untilSome$1$adapted((Function1)untilSome_f, object, arg_0));
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl untilSome_ex) {
            if (untilSome_ex.key() == object) {
                none$ = (Option)untilSome_ex.value();
            }
            throw untilSome_ex;
        }
        Object var11_5 = null;
        intersect = null;
        object = null;
        Object var14_8 = null;
        None$ none$2 = none$;
        if (none$2 instanceof Some && (tuple2 = (Tuple2)((Some)none$2).value()) != null) {
            void addUnsignedInt_int;
            void addUnsignedInt_int2;
            void add_value;
            void create_evidence$3;
            Slice compressedBytes = (Slice)tuple2._1();
            CompressionInternal compression = (CompressionInternal)tuple2._2();
            boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
            ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
            int create_length = 127;
            byteManifest = null;
            Slice header = new Slice(create_evidence$3.newArray(create_length), 0, create_length == 0 ? -1 : create_length - 1, bl ? create_length : 0, (ClassTag)create_evidence$3);
            header.moveWritePosition(1);
            SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)header);
            Byte by = BoxesRunTime.boxToByte((byte)this.compressedBlockID());
            if (sliceImplicit == null) {
                throw null;
            }
            SliceCompanionBase.SliceImplicit add_this = sliceImplicit;
            add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value);
            Slice cfr_ignored_0 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            Object var17_18 = null;
            by = null;
            SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)header);
            int n = compression.decompressor().id();
            if (byteSliceImplicits == null) {
                throw null;
            }
            SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this = byteSliceImplicits;
            Slice addUnsignedInt_writeUnsignedInt_slice = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int2, (Slice)addUnsignedInt_writeUnsignedInt_slice);
            Slice cfr_ignored_1 = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var19_20 = null;
            Object var21_21 = null;
            SliceCompanionBase.ByteSliceImplicits byteSliceImplicits2 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)header);
            int n2 = bytes.size();
            if (byteSliceImplicits2 == null) {
                throw null;
            }
            SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this2 = byteSliceImplicits2;
            Slice addUnsignedInt_writeUnsignedInt_slice2 = addUnsignedInt_this2.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int, (Slice)addUnsignedInt_writeUnsignedInt_slice2);
            Slice cfr_ignored_2 = addUnsignedInt_this2.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var22_23 = null;
            Object var24_24 = null;
            compressionResult = new Block.CompressionResult((Option<Slice<Object>>)new Some((Object)compressedBytes), (Slice<Object>)header);
        } else if (None$.MODULE$.equals(none$2)) {
            void add_value;
            void create_evidence$3;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace(compressions.isEmpty() ? new StringBuilder(69).append("No compression strategies provided for ").append(blockName).append(". Storing ").append(bytes.size()).append(".bytes uncompressed.").toString() : new StringBuilder(105).append("Unable to satisfy compression requirement from ").append(compressions.size()).append(" compression strategies for ").append(blockName).append(". Storing ").append(bytes.size()).append(".bytes uncompressed.").toString());
            }
            boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
            ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
            int create_length = 127;
            byteManifest = null;
            Slice header = new Slice(create_evidence$3.newArray(create_length), 0, create_length == 0 ? -1 : create_length - 1, bl ? create_length : 0, (ClassTag)create_evidence$3);
            header.moveWritePosition(1);
            SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)header);
            Byte by = BoxesRunTime.boxToByte((byte)this.uncompressedBlockId());
            if (sliceImplicit == null) {
                throw null;
            }
            SliceCompanionBase.SliceImplicit add_this = sliceImplicit;
            add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value);
            Slice cfr_ignored_3 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            Object var27_31 = null;
            by = null;
            compressionResult = new Block.CompressionResult((Option<Slice<Object>>)None$.MODULE$, (Slice<Object>)header);
        } else {
            throw new MatchError((Object)none$2);
        }
        return compressionResult;
    }

    /*
     * WARNING - void declaration
     */
    public TransientSegment.One block(ClosedBlocksWithFooter blocks, Seq<CompressionInternal> compressions, String blockName) {
        void apply_evidence$7;
        if (compressions.isEmpty()) {
            void add_value;
            void addUnsignedInt_int;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("No compression strategies provided for Segment level compression for {}. Storing {}.bytes uncompressed.", new Object[]{blockName, BoxesRunTime.boxToInteger((int)blocks.segmentSize())});
            }
            SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, blocks.segmentHeader());
            boolean bl = true;
            if (byteSliceImplicits == null) {
                throw null;
            }
            SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this = byteSliceImplicits;
            Slice addUnsignedInt_writeUnsignedInt_slice = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int, (Slice)addUnsignedInt_writeUnsignedInt_slice);
            Slice cfr_ignored_0 = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var8_5 = null;
            Object var10_6 = null;
            SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, blocks.segmentHeader());
            Byte by = BoxesRunTime.boxToByte((byte)this.uncompressedBlockId());
            if (sliceImplicit == null) {
                throw null;
            }
            SliceCompanionBase.SliceImplicit add_this = sliceImplicit;
            add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value);
            Slice cfr_ignored_1 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            Object var11_8 = null;
            by = null;
            Slice segmentBytes = (Slice)blocks.segmentBytes().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Slice<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object = x1.nonEmpty() ? x1.close() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Slice<Object> x1) {
                    boolean bl = x1.nonEmpty();
                    return bl;
                }
            });
            return new TransientSegment.One(blocks.minKey(), blocks.maxKey(), (Slice<Slice<Object>>)segmentBytes, blocks.functionMinMax(), blocks.nearestDeadline(), blocks.valuesUnblockedReader(), blocks.sortedIndexClosedState(), blocks.sortedIndexUnblockedReader(), blocks.hashIndexUnblockedReader(), blocks.binarySearchUnblockedReader(), blocks.bloomFilterUnblockedReader(), blocks.footerUnblocked());
        }
        Slice<Object> uncompressedSegmentBytes = blocks.flattenSegmentBytes();
        Block.CompressionResult compressionResult = this.compress(uncompressedSegmentBytes, compressions, blockName);
        Slice compressedOrUncompressedSegmentBytes = (Slice)compressionResult.compressedBytes().getOrElse((Function0 & Serializable)() -> uncompressedSegmentBytes);
        compressionResult.fixHeaderSize();
        ClassTag classTag = ClassTag$.MODULE$.apply(Slice.class);
        ArraySeq apply_data = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Slice[]{compressionResult.headerBytes().close(), compressedOrUncompressedSegmentBytes});
        Object var13_14 = null;
        classTag = null;
        return new TransientSegment.One(blocks.minKey(), blocks.maxKey(), (Slice<Slice<Object>>)SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)apply_data.toArray((ClassTag)apply_evidence$7), (ClassTag)apply_evidence$7), blocks.functionMinMax(), blocks.nearestDeadline(), blocks.valuesUnblockedReader(), blocks.sortedIndexClosedState(), blocks.sortedIndexUnblockedReader(), blocks.hashIndexUnblockedReader(), blocks.binarySearchUnblockedReader(), blocks.bloomFilterUnblockedReader(), blocks.footerUnblocked());
    }

    private Option<Block.CompressionInfo> readCompressionInfo(int formatID, int headerSize, ReaderBase reader) {
        if (formatID == this.compressedBlockID()) {
            DecompressorInternal decompressor = DecompressorInternal$.MODULE$.apply(reader.readUnsignedInt());
            int decompressedLength = reader.readUnsignedInt();
            return new Some((Object)new Block.CompressionInfo(decompressor, decompressedLength));
        }
        if (formatID == this.uncompressedBlockId()) {
            return None$.MODULE$;
        }
        String message = new StringBuilder(34).append("Invalid formatID: ").append(formatID).append(". Expected: ").append(this.uncompressedBlockId()).append(" or ").append(this.compressedBlockID()).toString();
        throw new Exception.InvalidDataId(formatID, message);
    }

    /*
     * WARNING - void declaration
     */
    public <O extends BlockOffset> Block.Header<O> readHeader(BlockRefReader<O> reader, BlockOps<O, ?> blockOps) {
        void var5_5;
        void var4_4;
        Tuple2<Object, Object> tuple2 = reader.readUnsignedIntWithByteSize();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int headerSize = tuple2._1$mcI$sp();
        int headerSizeByteSize = tuple2._2$mcI$sp();
        int n = 0;
        Slice<Object> apply_slice = reader.read((int)var4_4);
        Object var10_7 = null;
        SliceReader headerReader = new SliceReader(apply_slice, n);
        byte formatID = headerReader.get();
        Option<Block.CompressionInfo> compressionInfo = this.readCompressionInfo(formatID, (int)var4_4, (ReaderBase)headerReader);
        void actualHeaderSize = var4_4 + var5_5;
        return new Block.Header<O>(compressionInfo, (ReaderBase)headerReader, (int)actualHeaderSize, blockOps.createOffset(reader.offset().start() + actualHeaderSize, reader.offset().size() - actualHeaderSize));
    }

    public <O extends BlockOffset, B extends Block<O>> UnblockedReader<O, B> unblock(Slice<Object> bytes, BlockOps<O, B> blockOps) {
        return this.unblock(BlockRefReader$.MODULE$.apply(bytes, blockOps), false, blockOps);
    }

    public <O extends BlockOffset, B extends Block<O>> UnblockedReader<O, B> unblock(BlockRefReader<O> ref, boolean readAllIfUncompressed, BlockOps<O, B> blockOps) {
        return this.unblock(BlockedReader$.MODULE$.apply(ref, blockOps), readAllIfUncompressed, blockOps);
    }

    public <O extends BlockOffset, B extends Block<O>> UnblockedReader<O, B> unblock(BlockedReader<O, B> reader, boolean readAllIfUncompressed, BlockOps<O, B> blockOps) {
        UnblockedReader<O, B> unblockedReader;
        Option<Block.CompressionInfo> option = reader.block().compressionInfo();
        if (option instanceof Some) {
            Block.CompressionInfo compressionInfo = (Block.CompressionInfo)((Some)option).value();
            Slice<Object> compressedBytes = reader.readFullBlock();
            Slice decompressedBytes = compressionInfo.decompressor().decompress(compressedBytes, compressionInfo.decompressedLength());
            if (decompressedBytes.size() != compressionInfo.decompressedLength()) {
                String throwable_message = new StringBuilder(52).append("Decompressed bytes size (").append(decompressedBytes.size()).append(") != decompressedLength (").append(compressionInfo.decompressedLength()).append(").").toString();
                Object var11_9 = null;
                throw new Exception(throwable_message);
            }
            B x$2 = blockOps.updateBlockOffset(reader.block(), 0, decompressedBytes.size());
            unblockedReader = UnblockedReader$.MODULE$.apply(x$2, (Slice<Object>)decompressedBytes);
        } else if (None$.MODULE$.equals(option)) {
            UnblockedReader<O, B> unblockedReader2 = UnblockedReader$.MODULE$.fromUncompressed(reader);
            unblockedReader = readAllIfUncompressed ? unblockedReader2.readAllAndGetReader(blockOps) : unblockedReader2;
        } else {
            throw new MatchError(option);
        }
        return unblockedReader;
    }

    public <O extends BlockOffset, B extends Block<O>> boolean unblock$default$2() {
        return false;
    }

    private Block$() {
    }
}

