/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment.format.a.block.binarysearch;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import swaydb.compression.CompressionInternal;
import swaydb.core.data.Persistent;
import swaydb.core.data.Persistent$Null$;
import swaydb.core.data.Persistent$Partial$Null$;
import swaydb.core.data.PersistentOption;
import swaydb.core.segment.format.a.block.Block;
import swaydb.core.segment.format.a.block.Block$;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchEntryFormat;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchEntryFormat$;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchIndexBlock;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchIndexBlock$State$;
import swaydb.core.segment.format.a.block.binarysearch.BinarySearchLowerResult;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.reader.UnblockedReader$;
import swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock;
import swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock$;
import swaydb.core.segment.format.a.block.values.ValuesBlock;
import swaydb.core.util.MinMax$;
import swaydb.data.order.KeyOrder;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.util.Bytez;
import swaydb.data.util.Bytez$;
import swaydb.data.util.Maybe;
import swaydb.data.util.SomeOrNoneCovariant;

public final class BinarySearchIndexBlock$
implements Serializable {
    public static final BinarySearchIndexBlock$ MODULE$ = new BinarySearchIndexBlock$();
    private static final String blockName = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(MODULE$.getClass().getSimpleName()), 1);

    public String blockName() {
        return blockName;
    }

    public Option<BinarySearchIndexBlock.State> init(SortedIndexBlock.State sortedIndexState, BinarySearchIndexBlock.Config binarySearchConfig) {
        if (!binarySearchConfig.enabled() || sortedIndexState.uncompressedPrefixCount() < binarySearchConfig.minimumNumberOfKeys() || sortedIndexState.normaliseIndex() || !sortedIndexState.hasPrefixCompression() && binarySearchConfig.searchSortedIndexDirectlyIfPossible() && sortedIndexState.isPreNormalised()) {
            return None$.MODULE$;
        }
        return BinarySearchIndexBlock$State$.MODULE$.apply(binarySearchConfig.format(), ((SortedIndexBlock.SecondaryIndexEntry)sortedIndexState.secondaryIndexEntries().last()).indexOffset(), sortedIndexState.largestUncompressedMergedKeySize(), sortedIndexState.uncompressedPrefixCount(), binarySearchConfig.fullIndex(), binarySearchConfig.minimumNumberOfKeys(), binarySearchConfig.compressions());
    }

    public int optimalBytesRequired(int largestIndexOffset, int largestMergedKeySize, int valuesCount, int minimNumberOfKeysForBinarySearchIndex, int bytesToAllocatedPerEntryMaybe, BinarySearchEntryFormat format) {
        if (valuesCount < minimNumberOfKeysForBinarySearchIndex) {
            return 0;
        }
        Integer MaybeImplicits_value = BoxesRunTime.boxToInteger((int)bytesToAllocatedPerEntryMaybe);
        Object var9_7 = null;
        Maybe.MaybeImplicits getOrElse_this = new Maybe.MaybeImplicits((Object)MaybeImplicits_value);
        Object object = getOrElse_this.swaydb$data$util$Maybe$MaybeImplicits$$value == null ? BoxesRunTime.boxToInteger((int)format.bytesToAllocatePerEntry(largestIndexOffset, largestMergedKeySize)) : getOrElse_this.swaydb$data$util$Maybe$MaybeImplicits$$value;
        Object object2 = object;
        Object var7_8 = null;
        object = null;
        return BoxesRunTime.unboxToInt((Object)object2) * valuesCount;
    }

    /*
     * WARNING - void declaration
     */
    public Option<BinarySearchIndexBlock.State> close(BinarySearchIndexBlock.State state, int uncompressedKeyValuesCount) {
        if (state.compressibleBytes().isEmpty()) {
            return None$.MODULE$;
        }
        if (state.hasMinimumKeys()) {
            void addBoolean_boolean;
            void addInt_int;
            void addUnsignedInt_int;
            void addByte_value;
            int apply__uncompressedSize = state.compressibleBytes().size();
            Block.CompressionResult compressionResult = Block$.MODULE$.compress(state.compressibleBytes(), (Seq<CompressionInternal>)((Seq)state.compressions().apply((Object)new /* Unavailable Anonymous Inner Class!! */)), this.blockName());
            compressionResult.compressedBytes().foreach((Function1 & Serializable)x$7 -> {
                state.compressibleBytes_$eq((Slice<Object>)x$7);
                return BoxedUnit.UNIT;
            });
            SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
            byte by = state.format().id();
            if (byteSliceImplicits == null) {
                throw null;
            }
            SliceCompanionBase.ByteSliceImplicits addByte_this = byteSliceImplicits;
            addByte_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice.insert((Object)BoxesRunTime.boxToByte((byte)addByte_value));
            Slice cfr_ignored_0 = addByte_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var4_6 = null;
            SliceCompanionBase.ByteSliceImplicits byteSliceImplicits2 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
            int n = state.writtenValues();
            if (byteSliceImplicits2 == null) {
                throw null;
            }
            SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this = byteSliceImplicits2;
            Slice addUnsignedInt_writeUnsignedInt_slice = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int, (Slice)addUnsignedInt_writeUnsignedInt_slice);
            Slice cfr_ignored_1 = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var6_8 = null;
            Object var8_9 = null;
            SliceCompanionBase.ByteSliceImplicits byteSliceImplicits3 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
            int n2 = state.bytesPerValue();
            if (byteSliceImplicits3 == null) {
                throw null;
            }
            SliceCompanionBase.ByteSliceImplicits addInt_this = byteSliceImplicits3;
            Slice addInt_writeInt_slice = addInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Bytez.writeInt$((Bytez)Bytez$.MODULE$, (int)addInt_int, (Slice)addInt_writeInt_slice);
            Slice cfr_ignored_2 = addInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var9_11 = null;
            Object var11_12 = null;
            state.isFullIndex_$eq(state.writtenValues() == uncompressedKeyValuesCount);
            SliceCompanionBase.ByteSliceImplicits byteSliceImplicits4 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
            boolean bl = state.isFullIndex();
            if (byteSliceImplicits4 == null) {
                throw null;
            }
            SliceCompanionBase.ByteSliceImplicits addBoolean_this = byteSliceImplicits4;
            addBoolean_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice.insert((Object)(addBoolean_boolean != false ? BoxesRunTime.boxToByte((byte)((byte)1)) : BoxesRunTime.boxToByte((byte)((byte)0))));
            Slice cfr_ignored_3 = addBoolean_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var12_14 = null;
            compressionResult.fixHeaderSize();
            state.header_$eq(compressionResult.headerBytes());
            return new Some((Object)state);
        }
        return None$.MODULE$;
    }

    public UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock> unblockedReader(BinarySearchIndexBlock.State closedState) {
        BinarySearchIndexBlock block = new BinarySearchIndexBlock(closedState.format(), new BinarySearchIndexBlock.Offset(0, closedState.cacheableBytes().size()), closedState.writtenValues(), 0, closedState.bytesPerValue(), closedState.isFullIndex(), (Option<Block.CompressionInfo>)None$.MODULE$);
        return UnblockedReader$.MODULE$.apply(block, (Slice<Object>)closedState.cacheableBytes().close());
    }

    public BinarySearchIndexBlock read(Block.Header<BinarySearchIndexBlock.Offset> header) {
        byte formatId = header.headerReader().get();
        BinarySearchEntryFormat format = (BinarySearchEntryFormat)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])BinarySearchEntryFormat$.MODULE$.formats()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)BinarySearchIndexBlock$.$anonfun$read$1(formatId, x$8))).getOrElse((Function0 & Serializable)() -> {
            String throws_message = new StringBuilder(32).append("Invalid binary search formatId: ").append(formatId).toString();
            throw new Exception(throws_message);
        });
        int valuesCount = header.headerReader().readUnsignedInt();
        int bytesPerValue = header.headerReader().readInt();
        boolean isFullIndex = header.headerReader().readBoolean();
        return new BinarySearchIndexBlock(format, header.offset(), valuesCount, header.headerSize(), bytesPerValue, isFullIndex, header.compressionInfo());
    }

    public void write(SortedIndexBlock.SecondaryIndexEntry entry, BinarySearchIndexBlock.State state) {
        this.write(entry.indexOffset(), entry.mergedKey(), entry.keyType(), state);
    }

    public void write(int indexOffset, Slice<Object> mergedKey, byte keyType, BinarySearchIndexBlock.State state) {
        if (indexOffset != state.previouslyWritten()) {
            int writePosition = state.compressibleBytes().currentWritePosition();
            state.format().write(indexOffset, mergedKey, keyType, state.compressibleBytes());
            int missedBytes = state.bytesPerValue() - (state.compressibleBytes().currentWritePosition() - writePosition);
            if (missedBytes > 0) {
                state.compressibleBytes().moveWritePosition(state.compressibleBytes().currentWritePosition() + missedBytes);
            }
            state.incrementWrittenValuesCount();
            state.previouslyWritten_$eq(indexOffset);
        }
    }

    public int getSortedIndexAccessPosition(Persistent keyValue, boolean isFullIndex, int valuesCount, int n) {
        if (keyValue.sortedIndexAccessPosition() <= 0 || !isFullIndex && keyValue.sortedIndexAccessPosition() > valuesCount) {
            return n;
        }
        return keyValue.sortedIndexAccessPosition() - 1;
    }

    public int getStartPosition(PersistentOption lowestKeyValue, boolean isFullIndex, int valuesCount) {
        int n;
        if (lowestKeyValue instanceof Persistent) {
            Persistent persistent = (Persistent)lowestKeyValue;
            n = this.getSortedIndexAccessPosition(persistent, isFullIndex, valuesCount, 0);
        } else if (Persistent$Null$.MODULE$.equals(lowestKeyValue)) {
            n = 0;
        } else {
            throw new MatchError((Object)lowestKeyValue);
        }
        return n;
    }

    public int getEndPosition(PersistentOption highestKeyValue, boolean isFullIndex, int valuesCount) {
        int n;
        if (highestKeyValue instanceof Persistent) {
            Persistent persistent = (Persistent)highestKeyValue;
            n = this.getSortedIndexAccessPosition(persistent, isFullIndex, valuesCount, valuesCount - 1);
        } else if (Persistent$Null$.MODULE$.equals(highestKeyValue)) {
            n = valuesCount - 1;
        } else {
            throw new MatchError((Object)highestKeyValue);
        }
        return n;
    }

    public Persistent.PartialOption binarySearchMatchOrLower(Slice<Object> key, PersistentOption lowest, PersistentOption highest, Function0<Object> keyValuesCount, UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock> binarySearchIndex, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndex, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesOrNull, KeyOrder<Persistent.Partial> order, KeyOrder<Slice<Object>> keyOrder) {
        boolean isFullIndex = binarySearchIndex == null || binarySearchIndex.block().isFullIndex();
        int valuesCount = binarySearchIndex == null ? keyValuesCount.apply$mcI$sp() : binarySearchIndex.block().valuesCount();
        int bytesPerValue = binarySearchIndex == null ? sortedIndex.block().segmentMaxIndexEntrySize() : binarySearchIndex.block().bytesPerValue();
        int start = this.getStartPosition(lowest, isFullIndex, valuesCount);
        int end = this.getEndPosition(highest, isFullIndex, valuesCount);
        Persistent.PartialOption knownLowest = Persistent$Partial$Null$.MODULE$;
        while (start <= end) {
            Persistent.Partial partial;
            int mid = start + (end - start) / 2;
            int offset = mid * bytesPerValue;
            Persistent.Partial partial2 = partial = binarySearchIndex == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(offset, sortedIndex, valuesOrNull).matchMutateForBinarySearch(key, keyOrder) : binarySearchIndex.block().format().read(offset, binarySearchIndex.block().bytesPerValue(), binarySearchIndex, sortedIndex, valuesOrNull).matchMutateForBinarySearch(key, keyOrder);
            if (partial.isBinarySearchMatched()) {
                return partial;
            }
            if (partial.isBinarySearchBehind()) {
                start = mid + 1;
                knownLowest = partial;
                continue;
            }
            if (partial.isBinarySearchAhead()) {
                end = mid - 1;
                continue;
            }
            throw new Exception("Invalid binarySearch mutated flags");
        }
        return MinMax$.MODULE$.maxFavourLeftC(knownLowest, lowest.asPartial(), order);
    }

    private BinarySearchLowerResult.Some binarySearchLower(boolean fetchLeft, Slice<Object> key, PersistentOption lowest, PersistentOption highest, Function0<Object> keyValuesCount, UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock> binarySearchIndex, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndex, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesOrNull, KeyOrder<Slice<Object>> keyOrder, KeyOrder<Persistent.Partial> partialOrder) {
        boolean isFullIndex = binarySearchIndex == null || binarySearchIndex.block().isFullIndex();
        int valuesCount = binarySearchIndex == null ? keyValuesCount.apply$mcI$sp() : binarySearchIndex.block().valuesCount();
        int bytesPerValue = binarySearchIndex == null ? sortedIndex.block().segmentMaxIndexEntrySize() : binarySearchIndex.block().bytesPerValue();
        int end = this.getEndPosition(highest, isFullIndex, valuesCount);
        if (fetchLeft) {
            return this.hop$1(end - 1, end - 1, lowest.asPartial(), Persistent$Partial$Null$.MODULE$, fetchLeft, key, lowest, highest, keyValuesCount, binarySearchIndex, sortedIndex, valuesOrNull, keyOrder, partialOrder, bytesPerValue);
        }
        int start = this.getStartPosition(lowest, isFullIndex, valuesCount);
        return this.hop$1(start, end, lowest.asPartial(), Persistent$Partial$Null$.MODULE$, fetchLeft, key, lowest, highest, keyValuesCount, binarySearchIndex, sortedIndex, valuesOrNull, keyOrder, partialOrder, bytesPerValue);
    }

    public Persistent.PartialOption search(Slice<Object> key, PersistentOption lowest, PersistentOption highest, Function0<Object> keyValuesCount, UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock> binarySearchIndexReaderOrNull, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndexReader, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesReaderOrNull, KeyOrder<Slice<Object>> ordering, KeyOrder<Persistent.Partial> partialKeyOrder) {
        PersistentOption startFrom;
        Persistent.Partial partial;
        Persistent.PartialOption partialOption;
        block11: {
            if (sortedIndexReader.block().isBinarySearchable()) {
                Persistent.Partial partial2;
                Persistent.PartialOption partialOption2;
                block10: {
                    UnblockedReader binarySearchMatchOrLower_binarySearchIndex = null;
                    boolean binarySearchMatchOrLower_isFullIndex = true;
                    int binarySearchMatchOrLower_valuesCount = binarySearchMatchOrLower_binarySearchIndex == null ? keyValuesCount.apply$mcI$sp() : ((BinarySearchIndexBlock)binarySearchMatchOrLower_binarySearchIndex.block()).valuesCount();
                    int binarySearchMatchOrLower_bytesPerValue = binarySearchMatchOrLower_binarySearchIndex == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : ((BinarySearchIndexBlock)binarySearchMatchOrLower_binarySearchIndex.block()).bytesPerValue();
                    int binarySearchMatchOrLower_start = this.getStartPosition(lowest, binarySearchMatchOrLower_isFullIndex, binarySearchMatchOrLower_valuesCount);
                    int binarySearchMatchOrLower_end = this.getEndPosition(highest, binarySearchMatchOrLower_isFullIndex, binarySearchMatchOrLower_valuesCount);
                    Persistent.PartialOption binarySearchMatchOrLower_knownLowest = Persistent$Partial$Null$.MODULE$;
                    while (binarySearchMatchOrLower_start <= binarySearchMatchOrLower_end) {
                        Persistent.Partial binarySearchMatchOrLower_partial;
                        int binarySearchMatchOrLower_mid = binarySearchMatchOrLower_start + (binarySearchMatchOrLower_end - binarySearchMatchOrLower_start) / 2;
                        int binarySearchMatchOrLower_offset = binarySearchMatchOrLower_mid * binarySearchMatchOrLower_bytesPerValue;
                        Persistent.Partial partial3 = binarySearchMatchOrLower_partial = binarySearchMatchOrLower_binarySearchIndex == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(binarySearchMatchOrLower_offset, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering) : ((BinarySearchIndexBlock)binarySearchMatchOrLower_binarySearchIndex.block()).format().read(binarySearchMatchOrLower_offset, ((BinarySearchIndexBlock)binarySearchMatchOrLower_binarySearchIndex.block()).bytesPerValue(), binarySearchMatchOrLower_binarySearchIndex, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering);
                        if (binarySearchMatchOrLower_partial.isBinarySearchMatched()) {
                            partialOption2 = binarySearchMatchOrLower_partial;
                            break block10;
                        }
                        if (binarySearchMatchOrLower_partial.isBinarySearchBehind()) {
                            binarySearchMatchOrLower_start = binarySearchMatchOrLower_mid + 1;
                            binarySearchMatchOrLower_knownLowest = binarySearchMatchOrLower_partial;
                            continue;
                        }
                        if (binarySearchMatchOrLower_partial.isBinarySearchAhead()) {
                            binarySearchMatchOrLower_end = binarySearchMatchOrLower_mid - 1;
                            continue;
                        }
                        throw new Exception("Invalid binarySearch mutated flags");
                    }
                    partialOption2 = MinMax$.MODULE$.maxFavourLeftC(binarySearchMatchOrLower_knownLowest, lowest.asPartial(), partialKeyOrder);
                }
                Persistent.PartialOption partialOption3 = partialOption2;
                Object var17_10 = null;
                Object var23_16 = null;
                Object var26_19 = null;
                partialOption2 = null;
                Persistent.PartialOption partialOption4 = partialOption3;
                Persistent.PartialOption partialOption5 = partialOption4 instanceof Persistent.Partial && (partial2 = (Persistent.Partial)partialOption4).isBinarySearchMatched() ? partial2 : Persistent$Partial$Null$.MODULE$;
                return partialOption5;
            }
            if (binarySearchIndexReaderOrNull == null) {
                return SortedIndexBlock$.MODULE$.seekAndMatch(key, Persistent$Null$.MODULE$, sortedIndexReader, valuesReaderOrNull, ordering).asPartial();
            }
            boolean binarySearchMatchOrLower_isFullIndex = binarySearchIndexReaderOrNull.block().isFullIndex();
            int binarySearchMatchOrLower_valuesCount = binarySearchIndexReaderOrNull == null ? keyValuesCount.apply$mcI$sp() : binarySearchIndexReaderOrNull.block().valuesCount();
            int binarySearchMatchOrLower_bytesPerValue = binarySearchIndexReaderOrNull == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : binarySearchIndexReaderOrNull.block().bytesPerValue();
            int binarySearchMatchOrLower_start = this.getStartPosition(lowest, binarySearchMatchOrLower_isFullIndex, binarySearchMatchOrLower_valuesCount);
            int binarySearchMatchOrLower_end = this.getEndPosition(highest, binarySearchMatchOrLower_isFullIndex, binarySearchMatchOrLower_valuesCount);
            Persistent.PartialOption binarySearchMatchOrLower_knownLowest = Persistent$Partial$Null$.MODULE$;
            while (binarySearchMatchOrLower_start <= binarySearchMatchOrLower_end) {
                Persistent.Partial binarySearchMatchOrLower_partial;
                int binarySearchMatchOrLower_mid = binarySearchMatchOrLower_start + (binarySearchMatchOrLower_end - binarySearchMatchOrLower_start) / 2;
                int binarySearchMatchOrLower_offset = binarySearchMatchOrLower_mid * binarySearchMatchOrLower_bytesPerValue;
                Persistent.Partial partial4 = binarySearchMatchOrLower_partial = binarySearchIndexReaderOrNull == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(binarySearchMatchOrLower_offset, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering) : binarySearchIndexReaderOrNull.block().format().read(binarySearchMatchOrLower_offset, binarySearchIndexReaderOrNull.block().bytesPerValue(), binarySearchIndexReaderOrNull, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering);
                if (binarySearchMatchOrLower_partial.isBinarySearchMatched()) {
                    partialOption = binarySearchMatchOrLower_partial;
                    break block11;
                }
                if (binarySearchMatchOrLower_partial.isBinarySearchBehind()) {
                    binarySearchMatchOrLower_start = binarySearchMatchOrLower_mid + 1;
                    binarySearchMatchOrLower_knownLowest = binarySearchMatchOrLower_partial;
                    continue;
                }
                if (binarySearchMatchOrLower_partial.isBinarySearchAhead()) {
                    binarySearchMatchOrLower_end = binarySearchMatchOrLower_mid - 1;
                    continue;
                }
                throw new Exception("Invalid binarySearch mutated flags");
            }
            partialOption = MinMax$.MODULE$.maxFavourLeftC(binarySearchMatchOrLower_knownLowest, lowest.asPartial(), partialKeyOrder);
        }
        Persistent.PartialOption partialOption6 = partialOption;
        Object var33_29 = null;
        Object var36_32 = null;
        partialOption = null;
        Persistent.PartialOption partialOption7 = partialOption6;
        Persistent.PartialOption partialOption8 = partialOption7 instanceof Persistent.Partial && (partial = (Persistent.Partial)partialOption7).isBinarySearchMatched() ? partial : (binarySearchIndexReaderOrNull.block().isFullIndex() && !sortedIndexReader.block().hasPrefixCompression() ? Persistent$Partial$Null$.MODULE$ : ((startFrom = partialOption7.toPersistentOptional()).isNoneS() || startFrom.existsS((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.hasMore())) ? SortedIndexBlock$.MODULE$.seekAndMatch(key, startFrom, sortedIndexReader, valuesReaderOrNull, ordering).asPartial() : Persistent$Partial$Null$.MODULE$));
        return partialOption8;
    }

    public PersistentOption searchHigher(Slice<Object> key, PersistentOption start, PersistentOption end, Function0<Object> keyValuesCount, UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock> binarySearchIndexReaderOrNull, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndexReader, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesReaderOrNull, KeyOrder<Slice<Object>> ordering, KeyOrder<Persistent.Partial> partialKeyOrder) {
        Persistent.PartialOption partialOption;
        Persistent.PartialOption partialOption2;
        Persistent.Partial partial;
        Persistent.PartialOption partialOption3;
        Object var37_32;
        Object var34_29;
        Persistent.PartialOption partialOption4;
        Persistent.PartialOption partialOption5;
        Persistent.PartialOption partialOption6;
        Persistent.Partial partial2;
        Persistent.PartialOption partialOption7;
        Object var27_19;
        Object var24_16;
        Object var18_10;
        Persistent.PartialOption partialOption8;
        if (sortedIndexReader.block().isBinarySearchable()) {
            block12: {
                UnblockedReader search_binarySearchMatchOrLower_binarySearchIndex = null;
                boolean search_binarySearchMatchOrLower_isFullIndex = true;
                int search_binarySearchMatchOrLower_valuesCount = search_binarySearchMatchOrLower_binarySearchIndex == null ? keyValuesCount.apply$mcI$sp() : ((BinarySearchIndexBlock)search_binarySearchMatchOrLower_binarySearchIndex.block()).valuesCount();
                int search_binarySearchMatchOrLower_bytesPerValue = search_binarySearchMatchOrLower_binarySearchIndex == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : ((BinarySearchIndexBlock)search_binarySearchMatchOrLower_binarySearchIndex.block()).bytesPerValue();
                int search_binarySearchMatchOrLower_start = this.getStartPosition(start, search_binarySearchMatchOrLower_isFullIndex, search_binarySearchMatchOrLower_valuesCount);
                int search_binarySearchMatchOrLower_end = this.getEndPosition(end, search_binarySearchMatchOrLower_isFullIndex, search_binarySearchMatchOrLower_valuesCount);
                Persistent.PartialOption search_binarySearchMatchOrLower_knownLowest = Persistent$Partial$Null$.MODULE$;
                while (search_binarySearchMatchOrLower_start <= search_binarySearchMatchOrLower_end) {
                    Persistent.Partial search_binarySearchMatchOrLower_partial;
                    int search_binarySearchMatchOrLower_mid = search_binarySearchMatchOrLower_start + (search_binarySearchMatchOrLower_end - search_binarySearchMatchOrLower_start) / 2;
                    int search_binarySearchMatchOrLower_offset = search_binarySearchMatchOrLower_mid * search_binarySearchMatchOrLower_bytesPerValue;
                    Persistent.Partial partial3 = search_binarySearchMatchOrLower_partial = search_binarySearchMatchOrLower_binarySearchIndex == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(search_binarySearchMatchOrLower_offset, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering) : ((BinarySearchIndexBlock)search_binarySearchMatchOrLower_binarySearchIndex.block()).format().read(search_binarySearchMatchOrLower_offset, ((BinarySearchIndexBlock)search_binarySearchMatchOrLower_binarySearchIndex.block()).bytesPerValue(), search_binarySearchMatchOrLower_binarySearchIndex, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering);
                    if (search_binarySearchMatchOrLower_partial.isBinarySearchMatched()) {
                        partialOption8 = search_binarySearchMatchOrLower_partial;
                        break block12;
                    }
                    if (search_binarySearchMatchOrLower_partial.isBinarySearchBehind()) {
                        search_binarySearchMatchOrLower_start = search_binarySearchMatchOrLower_mid + 1;
                        search_binarySearchMatchOrLower_knownLowest = search_binarySearchMatchOrLower_partial;
                        continue;
                    }
                    if (search_binarySearchMatchOrLower_partial.isBinarySearchAhead()) {
                        search_binarySearchMatchOrLower_end = search_binarySearchMatchOrLower_mid - 1;
                        continue;
                    }
                    throw new Exception("Invalid binarySearch mutated flags");
                }
                partialOption8 = MinMax$.MODULE$.maxFavourLeftC(search_binarySearchMatchOrLower_knownLowest, start.asPartial(), partialKeyOrder);
            }
            Persistent.PartialOption partialOption9 = partialOption8;
            var18_10 = null;
            var24_16 = null;
            var27_19 = null;
            partialOption8 = null;
            partialOption7 = partialOption9;
            partialOption6 = partialOption7 instanceof Persistent.Partial && (partial2 = (Persistent.Partial)partialOption7).isBinarySearchMatched() ? partial2 : Persistent$Partial$Null$.MODULE$;
            partialOption5 = partialOption6;
        } else if (binarySearchIndexReaderOrNull == null) {
            partialOption5 = SortedIndexBlock$.MODULE$.seekAndMatch(key, Persistent$Null$.MODULE$, sortedIndexReader, valuesReaderOrNull, ordering).asPartial();
        } else {
            PersistentOption search_startFrom;
            block13: {
                boolean search_binarySearchMatchOrLower_isFullIndex = binarySearchIndexReaderOrNull.block().isFullIndex();
                int search_binarySearchMatchOrLower_valuesCount = binarySearchIndexReaderOrNull == null ? keyValuesCount.apply$mcI$sp() : binarySearchIndexReaderOrNull.block().valuesCount();
                int search_binarySearchMatchOrLower_bytesPerValue = binarySearchIndexReaderOrNull == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : binarySearchIndexReaderOrNull.block().bytesPerValue();
                int search_binarySearchMatchOrLower_start = this.getStartPosition(start, search_binarySearchMatchOrLower_isFullIndex, search_binarySearchMatchOrLower_valuesCount);
                int search_binarySearchMatchOrLower_end = this.getEndPosition(end, search_binarySearchMatchOrLower_isFullIndex, search_binarySearchMatchOrLower_valuesCount);
                Persistent.PartialOption search_binarySearchMatchOrLower_knownLowest = Persistent$Partial$Null$.MODULE$;
                while (search_binarySearchMatchOrLower_start <= search_binarySearchMatchOrLower_end) {
                    Persistent.Partial search_binarySearchMatchOrLower_partial;
                    int search_binarySearchMatchOrLower_mid = search_binarySearchMatchOrLower_start + (search_binarySearchMatchOrLower_end - search_binarySearchMatchOrLower_start) / 2;
                    int search_binarySearchMatchOrLower_offset = search_binarySearchMatchOrLower_mid * search_binarySearchMatchOrLower_bytesPerValue;
                    Persistent.Partial partial4 = search_binarySearchMatchOrLower_partial = binarySearchIndexReaderOrNull == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(search_binarySearchMatchOrLower_offset, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering) : binarySearchIndexReaderOrNull.block().format().read(search_binarySearchMatchOrLower_offset, binarySearchIndexReaderOrNull.block().bytesPerValue(), binarySearchIndexReaderOrNull, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering);
                    if (search_binarySearchMatchOrLower_partial.isBinarySearchMatched()) {
                        partialOption4 = search_binarySearchMatchOrLower_partial;
                        break block13;
                    }
                    if (search_binarySearchMatchOrLower_partial.isBinarySearchBehind()) {
                        search_binarySearchMatchOrLower_start = search_binarySearchMatchOrLower_mid + 1;
                        search_binarySearchMatchOrLower_knownLowest = search_binarySearchMatchOrLower_partial;
                        continue;
                    }
                    if (search_binarySearchMatchOrLower_partial.isBinarySearchAhead()) {
                        search_binarySearchMatchOrLower_end = search_binarySearchMatchOrLower_mid - 1;
                        continue;
                    }
                    throw new Exception("Invalid binarySearch mutated flags");
                }
                partialOption4 = MinMax$.MODULE$.maxFavourLeftC(search_binarySearchMatchOrLower_knownLowest, start.asPartial(), partialKeyOrder);
            }
            Persistent.PartialOption partialOption10 = partialOption4;
            var34_29 = null;
            var37_32 = null;
            partialOption4 = null;
            partialOption3 = partialOption10;
            partialOption2 = partialOption3 instanceof Persistent.Partial && (partial = (Persistent.Partial)partialOption3).isBinarySearchMatched() ? partial : (binarySearchIndexReaderOrNull.block().isFullIndex() && !sortedIndexReader.block().hasPrefixCompression() ? Persistent$Partial$Null$.MODULE$ : ((search_startFrom = partialOption3.toPersistentOptional()).isNoneS() || search_startFrom.existsS((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.hasMore())) ? SortedIndexBlock$.MODULE$.seekAndMatch(key, search_startFrom, sortedIndexReader, valuesReaderOrNull, ordering).asPartial() : Persistent$Partial$Null$.MODULE$));
            partialOption5 = partialOption2;
        }
        Persistent.PartialOption partialOption11 = partialOption = partialOption5;
        partialOption2 = null;
        partialOption6 = null;
        partialOption7 = null;
        partial2 = null;
        partialOption3 = null;
        partial = null;
        Object var17_37 = null;
        var18_10 = null;
        var24_16 = null;
        var27_19 = null;
        partialOption8 = null;
        var34_29 = null;
        var37_32 = null;
        partialOption4 = null;
        partialOption = null;
        Persistent.PartialOption startFrom = partialOption11;
        return SortedIndexBlock$.MODULE$.matchOrSeekHigher(key, startFrom.toPersistentOptional(), sortedIndexReader, valuesReaderOrNull, ordering);
    }

    private PersistentOption resolveLowerFromBinarySearch(Slice<Object> key, PersistentOption lower, PersistentOption got2, PersistentOption end2, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndexReader, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesReaderOrNull, KeyOrder<Slice<Object>> ordering) {
        PersistentOption next = end2.existsS((Function1 & Serializable)end -> BoxesRunTime.boxToBoolean((boolean)lower.existsS((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)BinarySearchIndexBlock$.$anonfun$resolveLowerFromBinarySearch$2(end, x$10))))) ? end2 : (got2.existsS((Function1 & Serializable)got -> BoxesRunTime.boxToBoolean((boolean)lower.existsS((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)BinarySearchIndexBlock$.$anonfun$resolveLowerFromBinarySearch$4(got, x$11))))) ? got2 : Persistent$Null$.MODULE$);
        return SortedIndexBlock$.MODULE$.matchOrSeekLower(key, lower, next, sortedIndexReader, valuesReaderOrNull, ordering);
    }

    /*
     * WARNING - void declaration
     */
    public PersistentOption searchLower(Slice<Object> key, PersistentOption start, PersistentOption end2, int keyValuesCount, UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock> binarySearchIndexReaderOrNull, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndexReader, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesReaderOrNull, KeyOrder<Slice<Object>> ordering, KeyOrder<Persistent.Partial> partialOrdering) {
        BinarySearchLowerResult.Some some;
        BinarySearchLowerResult.Some some2;
        JFunction0.mcI.sp & Serializable intersect;
        block62: {
            BinarySearchLowerResult.Some some3;
            BinarySearchLowerResult.Some some4;
            Persistent.Partial.Range range;
            BinarySearchLowerResult.Some some5;
            Persistent.Partial.Range range2;
            Persistent.Partial.Fixed fixed;
            BinarySearchLowerResult.Some some6;
            BinarySearchLowerResult.Some some7;
            Persistent.PartialOption partialOption;
            Persistent$Partial$Null$ persistent$Partial$Null$;
            block56: {
                block57: {
                    void binarySearchLower_keyValuesCount;
                    int binarySearchLower_end;
                    int binarySearchLower_bytesPerValue;
                    int binarySearchLower_valuesCount;
                    boolean binarySearchLower_isFullIndex;
                    boolean binarySearchLower_fetchLeft;
                    block61: {
                        BinarySearchLowerResult.Some some8;
                        Persistent.Partial.Range range3;
                        BinarySearchLowerResult.Some some9;
                        Persistent.Partial.Range range4;
                        Persistent.Partial.Fixed fixed2;
                        Persistent.PartialOption partialOption2;
                        Persistent$Partial$Null$ persistent$Partial$Null$2;
                        block54: {
                            block55: {
                                block58: {
                                    BinarySearchLowerResult.Some some10;
                                    JFunction0.mcI.sp & Serializable intersect2;
                                    Object var14_10;
                                    block60: {
                                        BinarySearchLowerResult.Some some11;
                                        Persistent.Partial.Range range5;
                                        BinarySearchLowerResult.Some some12;
                                        Persistent.Partial.Range range6;
                                        Persistent.Partial.Fixed fixed3;
                                        Persistent.PartialOption partialOption3;
                                        Persistent$Partial$Null$ persistent$Partial$Null$3;
                                        block52: {
                                            block53: {
                                                void binarySearchLower_keyValuesCount2;
                                                int binarySearchLower_end2;
                                                int binarySearchLower_bytesPerValue2;
                                                int binarySearchLower_valuesCount2;
                                                void binarySearchLower_binarySearchIndex;
                                                boolean binarySearchLower_isFullIndex2;
                                                boolean binarySearchLower_fetchLeft2;
                                                block59: {
                                                    BinarySearchLowerResult.Some some13;
                                                    Persistent.Partial.Range range7;
                                                    BinarySearchLowerResult.Some some14;
                                                    Persistent.Partial.Range range8;
                                                    Persistent.Partial.Fixed fixed4;
                                                    Persistent.PartialOption partialOption4;
                                                    Persistent$Partial$Null$ persistent$Partial$Null$4;
                                                    block50: {
                                                        block51: {
                                                            if (!sortedIndexReader.block().isBinarySearchable()) break block58;
                                                            var14_10 = null;
                                                            intersect2 = (JFunction0.mcI.sp & Serializable)() -> keyValuesCount;
                                                            binarySearchLower_fetchLeft2 = sortedIndexReader.block().enableAccessPositionIndex() && end2.existsS((Function1 & Serializable)end -> BoxesRunTime.boxToBoolean((boolean)ordering.equiv((Object)key, end.key())));
                                                            binarySearchLower_isFullIndex2 = true;
                                                            binarySearchLower_valuesCount2 = binarySearchLower_binarySearchIndex == null ? keyValuesCount : ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).valuesCount();
                                                            binarySearchLower_bytesPerValue2 = binarySearchLower_binarySearchIndex == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).bytesPerValue();
                                                            binarySearchLower_end2 = this.getEndPosition(end2, binarySearchLower_isFullIndex2, binarySearchLower_valuesCount2);
                                                            if (!binarySearchLower_fetchLeft2) break block59;
                                                            persistent$Partial$Null$4 = Persistent$Partial$Null$.MODULE$;
                                                            partialOption4 = start.asPartial();
                                                            int n = binarySearchLower_end2 - 1;
                                                            int hop$1_start = binarySearchLower_end2 - 1;
                                                            while (true) {
                                                                Persistent.Partial hop$1_partial;
                                                                Persistent.Partial hop$1_knownMatch;
                                                                Persistent.Partial hop$1_knownLowest;
                                                                int hop$1_end;
                                                                int hop$1_mid = hop$1_start + (hop$1_end - hop$1_start) / 2;
                                                                if (hop$1_start > hop$1_end || hop$1_mid < 0) {
                                                                    if (binarySearchLower_fetchLeft2 && hop$1_knownLowest.isNoneC()) {
                                                                        boolean hop$1_binarySearchLower_fetchLeft = false;
                                                                        boolean hop$1_binarySearchLower_isFullIndex = binarySearchLower_binarySearchIndex == null || ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).isFullIndex();
                                                                        int hop$1_binarySearchLower_valuesCount = binarySearchLower_binarySearchIndex == null ? keyValuesCount : ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).valuesCount();
                                                                        int hop$1_binarySearchLower_bytesPerValue = binarySearchLower_binarySearchIndex == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).bytesPerValue();
                                                                        int hop$1_binarySearchLower_end = this.getEndPosition(end2, hop$1_binarySearchLower_isFullIndex, hop$1_binarySearchLower_valuesCount);
                                                                        if (hop$1_binarySearchLower_fetchLeft) {
                                                                            some10 = this.hop$1(hop$1_binarySearchLower_end - 1, hop$1_binarySearchLower_end - 1, start.asPartial(), Persistent$Partial$Null$.MODULE$, hop$1_binarySearchLower_fetchLeft, key, start, end2, (Function0)binarySearchLower_keyValuesCount2, (UnblockedReader)binarySearchLower_binarySearchIndex, sortedIndexReader, valuesReaderOrNull, ordering, partialOrdering, hop$1_binarySearchLower_bytesPerValue);
                                                                        } else {
                                                                            int hop$1_binarySearchLower_start = this.getStartPosition(start, hop$1_binarySearchLower_isFullIndex, hop$1_binarySearchLower_valuesCount);
                                                                            some10 = this.hop$1(hop$1_binarySearchLower_start, hop$1_binarySearchLower_end, start.asPartial(), Persistent$Partial$Null$.MODULE$, hop$1_binarySearchLower_fetchLeft, key, start, end2, (Function0)binarySearchLower_keyValuesCount2, (UnblockedReader)binarySearchLower_binarySearchIndex, sortedIndexReader, valuesReaderOrNull, ordering, partialOrdering, hop$1_binarySearchLower_bytesPerValue);
                                                                        }
                                                                    } else {
                                                                        Persistent.PartialOption hop$1_lower = (Persistent.PartialOption)MinMax$.MODULE$.maxFavourLeftC(hop$1_knownLowest, (SomeOrNoneCovariant)start.getOrElseS((Function0 & Serializable)() -> Persistent$Partial$Null$.MODULE$), partialOrdering);
                                                                        some10 = new BinarySearchLowerResult.Some(hop$1_lower, hop$1_knownMatch);
                                                                    }
                                                                    break block50;
                                                                }
                                                                int hop$1_offset = hop$1_mid * binarySearchLower_bytesPerValue2;
                                                                Persistent.Partial partial = hop$1_partial = binarySearchLower_binarySearchIndex == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(hop$1_offset, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering) : ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).format().read(hop$1_offset, ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).bytesPerValue(), (UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>)binarySearchLower_binarySearchIndex, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering);
                                                                if (hop$1_partial.isBinarySearchMatched()) {
                                                                    if (hop$1_partial instanceof Persistent.Partial.Fixed) {
                                                                        hop$1_knownMatch = fixed4 = (Persistent.Partial.Fixed)hop$1_partial;
                                                                        hop$1_end = hop$1_mid - 1;
                                                                        hop$1_start = hop$1_mid - 1;
                                                                        continue;
                                                                    }
                                                                    if (hop$1_partial instanceof Persistent.Partial.Range) {
                                                                        range8 = (Persistent.Partial.Range)hop$1_partial;
                                                                        if (!ordering.gt(key, range8.fromKey())) {
                                                                            hop$1_knownMatch = range8;
                                                                            hop$1_end = hop$1_mid - 1;
                                                                            hop$1_start = hop$1_mid - 1;
                                                                            continue;
                                                                        }
                                                                    } else {
                                                                        throw new MatchError((Object)hop$1_partial);
                                                                    }
                                                                    some14 = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range8);
                                                                    some10 = some14;
                                                                    break block50;
                                                                }
                                                                if (hop$1_partial.isBinarySearchBehind()) {
                                                                    hop$1_knownLowest = hop$1_partial;
                                                                    hop$1_start = hop$1_mid + 1;
                                                                    continue;
                                                                }
                                                                if (!hop$1_partial.isBinarySearchAhead()) break block51;
                                                                if (hop$1_partial instanceof Persistent.Partial.Range && ordering.gt(key, (range7 = (Persistent.Partial.Range)hop$1_partial).fromKey())) break;
                                                                hop$1_end = hop$1_mid - 1;
                                                            }
                                                            some13 = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range7);
                                                            some10 = some13;
                                                            break block50;
                                                        }
                                                        throw new Exception("Invalid binary search mutated flags");
                                                    }
                                                    partialOption4 = null;
                                                    persistent$Partial$Null$4 = null;
                                                    some13 = null;
                                                    some14 = null;
                                                    Object var33_33 = null;
                                                    Object var35_23 = null;
                                                    fixed4 = null;
                                                    range8 = null;
                                                    range7 = null;
                                                    break block60;
                                                }
                                                persistent$Partial$Null$3 = Persistent$Partial$Null$.MODULE$;
                                                partialOption3 = start.asPartial();
                                                int n = binarySearchLower_end2;
                                                int hop$1_start = this.getStartPosition(start, binarySearchLower_isFullIndex2, binarySearchLower_valuesCount2);
                                                while (true) {
                                                    Persistent.Partial hop$1_partial;
                                                    Persistent.Partial hop$1_knownMatch;
                                                    Persistent.Partial hop$1_knownLowest;
                                                    int hop$1_end;
                                                    int hop$1_mid = hop$1_start + (hop$1_end - hop$1_start) / 2;
                                                    if (hop$1_start > hop$1_end || hop$1_mid < 0) {
                                                        if (binarySearchLower_fetchLeft2 && hop$1_knownLowest.isNoneC()) {
                                                            boolean hop$1_binarySearchLower_fetchLeft = false;
                                                            boolean hop$1_binarySearchLower_isFullIndex = binarySearchLower_binarySearchIndex == null || ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).isFullIndex();
                                                            int hop$1_binarySearchLower_valuesCount = binarySearchLower_binarySearchIndex == null ? keyValuesCount : ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).valuesCount();
                                                            int hop$1_binarySearchLower_bytesPerValue = binarySearchLower_binarySearchIndex == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).bytesPerValue();
                                                            int hop$1_binarySearchLower_end = this.getEndPosition(end2, hop$1_binarySearchLower_isFullIndex, hop$1_binarySearchLower_valuesCount);
                                                            if (hop$1_binarySearchLower_fetchLeft) {
                                                                some10 = this.hop$1(hop$1_binarySearchLower_end - 1, hop$1_binarySearchLower_end - 1, start.asPartial(), Persistent$Partial$Null$.MODULE$, hop$1_binarySearchLower_fetchLeft, key, start, end2, (Function0)binarySearchLower_keyValuesCount2, (UnblockedReader)binarySearchLower_binarySearchIndex, sortedIndexReader, valuesReaderOrNull, ordering, partialOrdering, hop$1_binarySearchLower_bytesPerValue);
                                                            } else {
                                                                int hop$1_binarySearchLower_start = this.getStartPosition(start, hop$1_binarySearchLower_isFullIndex, hop$1_binarySearchLower_valuesCount);
                                                                some10 = this.hop$1(hop$1_binarySearchLower_start, hop$1_binarySearchLower_end, start.asPartial(), Persistent$Partial$Null$.MODULE$, hop$1_binarySearchLower_fetchLeft, key, start, end2, (Function0)binarySearchLower_keyValuesCount2, (UnblockedReader)binarySearchLower_binarySearchIndex, sortedIndexReader, valuesReaderOrNull, ordering, partialOrdering, hop$1_binarySearchLower_bytesPerValue);
                                                            }
                                                        } else {
                                                            Persistent.PartialOption hop$1_lower = (Persistent.PartialOption)MinMax$.MODULE$.maxFavourLeftC(hop$1_knownLowest, (SomeOrNoneCovariant)start.getOrElseS((Function0 & Serializable)() -> Persistent$Partial$Null$.MODULE$), partialOrdering);
                                                            some10 = new BinarySearchLowerResult.Some(hop$1_lower, hop$1_knownMatch);
                                                        }
                                                        break block52;
                                                    }
                                                    int hop$1_offset = hop$1_mid * binarySearchLower_bytesPerValue2;
                                                    Persistent.Partial partial = hop$1_partial = binarySearchLower_binarySearchIndex == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(hop$1_offset, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering) : ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).format().read(hop$1_offset, ((BinarySearchIndexBlock)binarySearchLower_binarySearchIndex.block()).bytesPerValue(), (UnblockedReader<BinarySearchIndexBlock.Offset, BinarySearchIndexBlock>)binarySearchLower_binarySearchIndex, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering);
                                                    if (hop$1_partial.isBinarySearchMatched()) {
                                                        if (hop$1_partial instanceof Persistent.Partial.Fixed) {
                                                            hop$1_knownMatch = fixed3 = (Persistent.Partial.Fixed)hop$1_partial;
                                                            hop$1_end = hop$1_mid - 1;
                                                            hop$1_start = hop$1_mid - 1;
                                                            continue;
                                                        }
                                                        if (hop$1_partial instanceof Persistent.Partial.Range) {
                                                            range6 = (Persistent.Partial.Range)hop$1_partial;
                                                            if (!ordering.gt(key, range6.fromKey())) {
                                                                hop$1_knownMatch = range6;
                                                                hop$1_end = hop$1_mid - 1;
                                                                hop$1_start = hop$1_mid - 1;
                                                                continue;
                                                            }
                                                        } else {
                                                            throw new MatchError((Object)hop$1_partial);
                                                        }
                                                        some12 = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range6);
                                                        some10 = some12;
                                                        break block52;
                                                    }
                                                    if (hop$1_partial.isBinarySearchBehind()) {
                                                        hop$1_knownLowest = hop$1_partial;
                                                        hop$1_start = hop$1_mid + 1;
                                                        continue;
                                                    }
                                                    if (!hop$1_partial.isBinarySearchAhead()) break block53;
                                                    if (hop$1_partial instanceof Persistent.Partial.Range && ordering.gt(key, (range5 = (Persistent.Partial.Range)hop$1_partial).fromKey())) break;
                                                    hop$1_end = hop$1_mid - 1;
                                                }
                                                some11 = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range5);
                                                some10 = some11;
                                                break block52;
                                            }
                                            throw new Exception("Invalid binary search mutated flags");
                                        }
                                        partialOption3 = null;
                                        persistent$Partial$Null$3 = null;
                                        some11 = null;
                                        some12 = null;
                                        Object var52_52 = null;
                                        Object var54_42 = null;
                                        fixed3 = null;
                                        range6 = null;
                                        range5 = null;
                                    }
                                    intersect2 = null;
                                    var14_10 = null;
                                    BinarySearchLowerResult.Some result = some10;
                                    if (result.lower().isNoneC() && result.matched().isNoneC()) {
                                        return Persistent$Null$.MODULE$;
                                    }
                                    return this.resolveLowerFromBinarySearch(key, result.lower().toPersistentOptional(), result.matched().toPersistentOptional(), end2, sortedIndexReader, valuesReaderOrNull, ordering);
                                }
                                if (binarySearchIndexReaderOrNull == null) {
                                    return SortedIndexBlock$.MODULE$.seekLowerAndMatch(key, start, sortedIndexReader, valuesReaderOrNull, ordering);
                                }
                                intersect = (JFunction0.mcI.sp & Serializable)() -> keyValuesCount;
                                binarySearchLower_fetchLeft = sortedIndexReader.block().enableAccessPositionIndex() && end2.existsS((Function1 & Serializable)end -> BoxesRunTime.boxToBoolean((boolean)ordering.equiv((Object)key, end.key())));
                                binarySearchLower_isFullIndex = binarySearchIndexReaderOrNull.block().isFullIndex();
                                binarySearchLower_valuesCount = binarySearchIndexReaderOrNull == null ? keyValuesCount : binarySearchIndexReaderOrNull.block().valuesCount();
                                binarySearchLower_bytesPerValue = binarySearchIndexReaderOrNull == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : binarySearchIndexReaderOrNull.block().bytesPerValue();
                                binarySearchLower_end = this.getEndPosition(end2, binarySearchLower_isFullIndex, binarySearchLower_valuesCount);
                                if (!binarySearchLower_fetchLeft) break block61;
                                persistent$Partial$Null$2 = Persistent$Partial$Null$.MODULE$;
                                partialOption2 = start.asPartial();
                                int n = binarySearchLower_end - 1;
                                int hop$1_start = binarySearchLower_end - 1;
                                while (true) {
                                    Persistent.Partial hop$1_partial;
                                    Persistent.Partial hop$1_knownMatch;
                                    Persistent.Partial hop$1_knownLowest;
                                    int hop$1_end;
                                    int hop$1_mid = hop$1_start + (hop$1_end - hop$1_start) / 2;
                                    if (hop$1_start > hop$1_end || hop$1_mid < 0) {
                                        if (binarySearchLower_fetchLeft && hop$1_knownLowest.isNoneC()) {
                                            boolean hop$1_binarySearchLower_fetchLeft = false;
                                            boolean hop$1_binarySearchLower_isFullIndex = binarySearchIndexReaderOrNull == null || binarySearchIndexReaderOrNull.block().isFullIndex();
                                            int hop$1_binarySearchLower_valuesCount = binarySearchIndexReaderOrNull == null ? keyValuesCount : binarySearchIndexReaderOrNull.block().valuesCount();
                                            int hop$1_binarySearchLower_bytesPerValue = binarySearchIndexReaderOrNull == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : binarySearchIndexReaderOrNull.block().bytesPerValue();
                                            int hop$1_binarySearchLower_end = this.getEndPosition(end2, hop$1_binarySearchLower_isFullIndex, hop$1_binarySearchLower_valuesCount);
                                            if (hop$1_binarySearchLower_fetchLeft) {
                                                some2 = this.hop$1(hop$1_binarySearchLower_end - 1, hop$1_binarySearchLower_end - 1, start.asPartial(), Persistent$Partial$Null$.MODULE$, hop$1_binarySearchLower_fetchLeft, key, start, end2, (Function0)binarySearchLower_keyValuesCount, binarySearchIndexReaderOrNull, sortedIndexReader, valuesReaderOrNull, ordering, partialOrdering, hop$1_binarySearchLower_bytesPerValue);
                                            } else {
                                                int hop$1_binarySearchLower_start = this.getStartPosition(start, hop$1_binarySearchLower_isFullIndex, hop$1_binarySearchLower_valuesCount);
                                                some2 = this.hop$1(hop$1_binarySearchLower_start, hop$1_binarySearchLower_end, start.asPartial(), Persistent$Partial$Null$.MODULE$, hop$1_binarySearchLower_fetchLeft, key, start, end2, (Function0)binarySearchLower_keyValuesCount, binarySearchIndexReaderOrNull, sortedIndexReader, valuesReaderOrNull, ordering, partialOrdering, hop$1_binarySearchLower_bytesPerValue);
                                            }
                                        } else {
                                            Persistent.PartialOption hop$1_lower = (Persistent.PartialOption)MinMax$.MODULE$.maxFavourLeftC(hop$1_knownLowest, (SomeOrNoneCovariant)start.getOrElseS((Function0 & Serializable)() -> Persistent$Partial$Null$.MODULE$), partialOrdering);
                                            some2 = new BinarySearchLowerResult.Some(hop$1_lower, hop$1_knownMatch);
                                        }
                                        break block54;
                                    }
                                    int hop$1_offset = hop$1_mid * binarySearchLower_bytesPerValue;
                                    Persistent.Partial partial = hop$1_partial = binarySearchIndexReaderOrNull == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(hop$1_offset, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering) : binarySearchIndexReaderOrNull.block().format().read(hop$1_offset, binarySearchIndexReaderOrNull.block().bytesPerValue(), binarySearchIndexReaderOrNull, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering);
                                    if (hop$1_partial.isBinarySearchMatched()) {
                                        if (hop$1_partial instanceof Persistent.Partial.Fixed) {
                                            hop$1_knownMatch = fixed2 = (Persistent.Partial.Fixed)hop$1_partial;
                                            hop$1_end = hop$1_mid - 1;
                                            hop$1_start = hop$1_mid - 1;
                                            continue;
                                        }
                                        if (hop$1_partial instanceof Persistent.Partial.Range) {
                                            range4 = (Persistent.Partial.Range)hop$1_partial;
                                            if (!ordering.gt(key, range4.fromKey())) {
                                                hop$1_knownMatch = range4;
                                                hop$1_end = hop$1_mid - 1;
                                                hop$1_start = hop$1_mid - 1;
                                                continue;
                                            }
                                        } else {
                                            throw new MatchError((Object)hop$1_partial);
                                        }
                                        some9 = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range4);
                                        some2 = some9;
                                        break block54;
                                    }
                                    if (hop$1_partial.isBinarySearchBehind()) {
                                        hop$1_knownLowest = hop$1_partial;
                                        hop$1_start = hop$1_mid + 1;
                                        continue;
                                    }
                                    if (!hop$1_partial.isBinarySearchAhead()) break block55;
                                    if (hop$1_partial instanceof Persistent.Partial.Range && ordering.gt(key, (range3 = (Persistent.Partial.Range)hop$1_partial).fromKey())) break;
                                    hop$1_end = hop$1_mid - 1;
                                }
                                some8 = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range3);
                                some2 = some8;
                                break block54;
                            }
                            throw new Exception("Invalid binary search mutated flags");
                        }
                        partialOption2 = null;
                        persistent$Partial$Null$2 = null;
                        some8 = null;
                        some9 = null;
                        Object var71_78 = null;
                        Object var73_68 = null;
                        fixed2 = null;
                        range4 = null;
                        range3 = null;
                        break block62;
                    }
                    persistent$Partial$Null$ = Persistent$Partial$Null$.MODULE$;
                    partialOption = start.asPartial();
                    int n = binarySearchLower_end;
                    int hop$1_start = this.getStartPosition(start, binarySearchLower_isFullIndex, binarySearchLower_valuesCount);
                    while (true) {
                        Persistent.Partial hop$1_partial;
                        Persistent.Partial hop$1_knownMatch;
                        Persistent.Partial hop$1_knownLowest;
                        int hop$1_end;
                        int hop$1_mid = hop$1_start + (hop$1_end - hop$1_start) / 2;
                        if (hop$1_start > hop$1_end || hop$1_mid < 0) {
                            if (binarySearchLower_fetchLeft && hop$1_knownLowest.isNoneC()) {
                                BinarySearchLowerResult.Some some15;
                                boolean hop$1_binarySearchLower_fetchLeft = false;
                                boolean hop$1_binarySearchLower_isFullIndex = binarySearchIndexReaderOrNull == null || binarySearchIndexReaderOrNull.block().isFullIndex();
                                int hop$1_binarySearchLower_valuesCount = binarySearchIndexReaderOrNull == null ? keyValuesCount : binarySearchIndexReaderOrNull.block().valuesCount();
                                int hop$1_binarySearchLower_bytesPerValue = binarySearchIndexReaderOrNull == null ? sortedIndexReader.block().segmentMaxIndexEntrySize() : binarySearchIndexReaderOrNull.block().bytesPerValue();
                                int hop$1_binarySearchLower_end = this.getEndPosition(end2, hop$1_binarySearchLower_isFullIndex, hop$1_binarySearchLower_valuesCount);
                                if (hop$1_binarySearchLower_fetchLeft) {
                                    some15 = this.hop$1(hop$1_binarySearchLower_end - 1, hop$1_binarySearchLower_end - 1, start.asPartial(), Persistent$Partial$Null$.MODULE$, hop$1_binarySearchLower_fetchLeft, key, start, end2, (Function0)binarySearchLower_keyValuesCount, binarySearchIndexReaderOrNull, sortedIndexReader, valuesReaderOrNull, ordering, partialOrdering, hop$1_binarySearchLower_bytesPerValue);
                                } else {
                                    int hop$1_binarySearchLower_start = this.getStartPosition(start, hop$1_binarySearchLower_isFullIndex, hop$1_binarySearchLower_valuesCount);
                                    some15 = this.hop$1(hop$1_binarySearchLower_start, hop$1_binarySearchLower_end, start.asPartial(), Persistent$Partial$Null$.MODULE$, hop$1_binarySearchLower_fetchLeft, key, start, end2, (Function0)binarySearchLower_keyValuesCount, binarySearchIndexReaderOrNull, sortedIndexReader, valuesReaderOrNull, ordering, partialOrdering, hop$1_binarySearchLower_bytesPerValue);
                                }
                                some6 = some7 = some15;
                                some7 = null;
                            } else {
                                Persistent.PartialOption hop$1_lower = (Persistent.PartialOption)MinMax$.MODULE$.maxFavourLeftC(hop$1_knownLowest, (SomeOrNoneCovariant)start.getOrElseS((Function0 & Serializable)() -> Persistent$Partial$Null$.MODULE$), partialOrdering);
                                some6 = new BinarySearchLowerResult.Some(hop$1_lower, hop$1_knownMatch);
                            }
                            break block56;
                        }
                        int hop$1_offset = hop$1_mid * binarySearchLower_bytesPerValue;
                        Persistent.Partial partial = hop$1_partial = binarySearchIndexReaderOrNull == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(hop$1_offset, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering) : binarySearchIndexReaderOrNull.block().format().read(hop$1_offset, binarySearchIndexReaderOrNull.block().bytesPerValue(), binarySearchIndexReaderOrNull, sortedIndexReader, valuesReaderOrNull).matchMutateForBinarySearch(key, ordering);
                        if (hop$1_partial.isBinarySearchMatched()) {
                            if (hop$1_partial instanceof Persistent.Partial.Fixed) {
                                hop$1_knownMatch = fixed = (Persistent.Partial.Fixed)hop$1_partial;
                                hop$1_end = hop$1_mid - 1;
                                hop$1_start = hop$1_mid - 1;
                                continue;
                            }
                            if (hop$1_partial instanceof Persistent.Partial.Range) {
                                range2 = (Persistent.Partial.Range)hop$1_partial;
                                if (!ordering.gt(key, range2.fromKey())) {
                                    hop$1_knownMatch = range2;
                                    hop$1_end = hop$1_mid - 1;
                                    hop$1_start = hop$1_mid - 1;
                                    continue;
                                }
                            } else {
                                throw new MatchError((Object)hop$1_partial);
                            }
                            some5 = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range2);
                            some6 = some5;
                            break block56;
                        }
                        if (hop$1_partial.isBinarySearchBehind()) {
                            hop$1_knownLowest = hop$1_partial;
                            hop$1_start = hop$1_mid + 1;
                            continue;
                        }
                        if (!hop$1_partial.isBinarySearchAhead()) break block57;
                        if (hop$1_partial instanceof Persistent.Partial.Range && ordering.gt(key, (range = (Persistent.Partial.Range)hop$1_partial).fromKey())) break;
                        hop$1_end = hop$1_mid - 1;
                    }
                    some4 = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range);
                    some6 = some4;
                    break block56;
                }
                throw new Exception("Invalid binary search mutated flags");
            }
            some2 = some3 = some6;
            partialOption = null;
            persistent$Partial$Null$ = null;
            some4 = null;
            some5 = null;
            Object var90_98 = null;
            Object var92_87 = null;
            fixed = null;
            range2 = null;
            range = null;
            some7 = null;
            some3 = null;
        }
        BinarySearchLowerResult.Some some16 = some = some2;
        intersect = null;
        some = null;
        BinarySearchLowerResult.Some result = some16;
        return this.resolveLowerFromBinarySearch(key, result.lower().toPersistentOptional(), result.matched().toPersistentOptional(), end2, sortedIndexReader, valuesReaderOrNull, ordering);
    }

    public BinarySearchIndexBlock apply(BinarySearchEntryFormat format, BinarySearchIndexBlock.Offset offset, int valuesCount, int headerSize, int bytesPerValue, boolean isFullIndex, Option<Block.CompressionInfo> compressionInfo) {
        return new BinarySearchIndexBlock(format, offset, valuesCount, headerSize, bytesPerValue, isFullIndex, compressionInfo);
    }

    public Option<Tuple7<BinarySearchEntryFormat, BinarySearchIndexBlock.Offset, Object, Object, Object, Object, Option<Block.CompressionInfo>>> unapply(BinarySearchIndexBlock x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.format(), (Object)x$0.offset(), (Object)BoxesRunTime.boxToInteger((int)x$0.valuesCount()), (Object)BoxesRunTime.boxToInteger((int)x$0.headerSize()), (Object)BoxesRunTime.boxToInteger((int)x$0.bytesPerValue()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isFullIndex()), x$0.compressionInfo()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BinarySearchIndexBlock$.class);
    }

    public static final /* synthetic */ int $anonfun$optimalBytesRequired$1(BinarySearchEntryFormat format$1, int largestIndexOffset$1, int largestMergedKeySize$1) {
        return format$1.bytesToAllocatePerEntry(largestIndexOffset$1, largestMergedKeySize$1);
    }

    public static final /* synthetic */ boolean $anonfun$read$1(byte formatId$1, BinarySearchEntryFormat x$8) {
        return x$8.id() == formatId$1;
    }

    private final BinarySearchLowerResult.Some hop$1(int start, int end, Persistent.PartialOption knownLowest, Persistent.PartialOption knownMatch, boolean fetchLeft$1, Slice key$1, PersistentOption lowest$1, PersistentOption highest$1, Function0 keyValuesCount$1, UnblockedReader binarySearchIndex$1, UnblockedReader sortedIndex$1, UnblockedReader valuesOrNull$1, KeyOrder keyOrder$1, KeyOrder partialOrder$1, int bytesPerValue$1) {
        block10: {
            Persistent.Partial.Range range;
            while (true) {
                Persistent.Partial partial;
                int mid = start + (end - start) / 2;
                if (start > end || mid < 0) {
                    if (fetchLeft$1 && knownLowest.isNoneC()) {
                        boolean binarySearchLower_fetchLeft = false;
                        boolean binarySearchLower_isFullIndex = binarySearchIndex$1 == null || ((BinarySearchIndexBlock)binarySearchIndex$1.block()).isFullIndex();
                        int binarySearchLower_valuesCount = binarySearchIndex$1 == null ? keyValuesCount$1.apply$mcI$sp() : ((BinarySearchIndexBlock)binarySearchIndex$1.block()).valuesCount();
                        int binarySearchLower_bytesPerValue = binarySearchIndex$1 == null ? ((SortedIndexBlock)sortedIndex$1.block()).segmentMaxIndexEntrySize() : ((BinarySearchIndexBlock)binarySearchIndex$1.block()).bytesPerValue();
                        int binarySearchLower_end = this.getEndPosition(highest$1, binarySearchLower_isFullIndex, binarySearchLower_valuesCount);
                        if (binarySearchLower_fetchLeft) {
                            return this.hop$1(binarySearchLower_end - 1, binarySearchLower_end - 1, lowest$1.asPartial(), Persistent$Partial$Null$.MODULE$, binarySearchLower_fetchLeft, key$1, lowest$1, highest$1, keyValuesCount$1, binarySearchIndex$1, sortedIndex$1, valuesOrNull$1, keyOrder$1, partialOrder$1, binarySearchLower_bytesPerValue);
                        }
                        int binarySearchLower_start = this.getStartPosition(lowest$1, binarySearchLower_isFullIndex, binarySearchLower_valuesCount);
                        return this.hop$1(binarySearchLower_start, binarySearchLower_end, lowest$1.asPartial(), Persistent$Partial$Null$.MODULE$, binarySearchLower_fetchLeft, key$1, lowest$1, highest$1, keyValuesCount$1, binarySearchIndex$1, sortedIndex$1, valuesOrNull$1, keyOrder$1, partialOrder$1, binarySearchLower_bytesPerValue);
                    }
                    Persistent.PartialOption lower = (Persistent.PartialOption)MinMax$.MODULE$.maxFavourLeftC(knownLowest, (SomeOrNoneCovariant)lowest$1.getOrElseS((Function0 & Serializable)() -> Persistent$Partial$Null$.MODULE$), partialOrder$1);
                    return new BinarySearchLowerResult.Some(lower, knownMatch);
                }
                int offset = mid * bytesPerValue$1;
                Persistent.Partial partial2 = partial = binarySearchIndex$1 == null ? SortedIndexBlock$.MODULE$.readPartialKeyValue(offset, sortedIndex$1, valuesOrNull$1).matchMutateForBinarySearch((Slice<Object>)key$1, (KeyOrder<Slice<Object>>)keyOrder$1) : ((BinarySearchIndexBlock)binarySearchIndex$1.block()).format().read(offset, ((BinarySearchIndexBlock)binarySearchIndex$1.block()).bytesPerValue(), binarySearchIndex$1, sortedIndex$1, valuesOrNull$1).matchMutateForBinarySearch((Slice<Object>)key$1, (KeyOrder<Slice<Object>>)keyOrder$1);
                if (partial.isBinarySearchMatched()) {
                    Persistent.Partial.Range range2;
                    if (partial instanceof Persistent.Partial.Fixed) {
                        Persistent.Partial.Fixed fixed = (Persistent.Partial.Fixed)partial;
                        knownMatch = fixed;
                        end = mid - 1;
                        start = mid - 1;
                        continue;
                    }
                    if (partial instanceof Persistent.Partial.Range) {
                        range2 = (Persistent.Partial.Range)partial;
                        if (!keyOrder$1.gt((Object)key$1, range2.fromKey())) {
                            knownMatch = range2;
                            end = mid - 1;
                            start = mid - 1;
                            continue;
                        }
                    } else {
                        throw new MatchError((Object)partial);
                    }
                    BinarySearchLowerResult.Some some = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range2);
                    return some;
                }
                if (partial.isBinarySearchBehind()) {
                    knownLowest = partial;
                    start = mid + 1;
                    continue;
                }
                if (!partial.isBinarySearchAhead()) break block10;
                if (partial instanceof Persistent.Partial.Range && keyOrder$1.gt((Object)key$1, (range = (Persistent.Partial.Range)partial).fromKey())) break;
                end = mid - 1;
            }
            BinarySearchLowerResult.Some some = new BinarySearchLowerResult.Some(Persistent$Partial$Null$.MODULE$, range);
            return some;
        }
        throw new Exception("Invalid binary search mutated flags");
    }

    public static final /* synthetic */ boolean $anonfun$resolveLowerFromBinarySearch$2(Persistent end$1, Persistent x$10) {
        return x$10.nextIndexOffset() == end$1.indexOffset();
    }

    public static final /* synthetic */ boolean $anonfun$resolveLowerFromBinarySearch$4(Persistent got$1, Persistent x$11) {
        return x$11.nextIndexOffset() == got$1.indexOffset();
    }

    private BinarySearchIndexBlock$() {
    }
}

