/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment.format.a.block.bloomfilter;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import swaydb.compression.CompressionInternal;
import swaydb.core.segment.format.a.block.Block;
import swaydb.core.segment.format.a.block.Block$;
import swaydb.core.segment.format.a.block.bloomfilter.BloomFilterBlock;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.reader.UnblockedReader$;
import swaydb.core.util.MurmurHash3Generic$;
import swaydb.data.config.UncompressedBlockInfo;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.util.ByteSizeOf$;
import swaydb.data.util.Bytez;
import swaydb.data.util.Bytez$;

public final class BloomFilterBlock$
implements LazyLogging,
Serializable {
    public static final BloomFilterBlock$ MODULE$ = new BloomFilterBlock$();
    private static final String blockName;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        blockName = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(MODULE$.getClass().getSimpleName()), 1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String blockName() {
        return blockName;
    }

    public int optimalSize(int numberOfKeys, double falsePositiveRate, boolean hasCompression, Function1<Object, Object> updateMaxProbe, int minimumNumberOfKeys) {
        if (falsePositiveRate <= 0.0 || numberOfKeys < minimumNumberOfKeys || numberOfKeys <= 0) {
            return 0;
        }
        return this.optimalNumberOfBits(numberOfKeys, falsePositiveRate);
    }

    private BloomFilterBlock.State apply(int numberOfKeys, double falsePositiveRate, Function1<Object, Object> updateMaxProbe, Function1<UncompressedBlockInfo, Seq<CompressionInternal>> compressions) {
        Slice slice;
        Slice slice2;
        Slice slice3;
        int numberOfBits = this.optimalNumberOfBits(numberOfKeys, falsePositiveRate);
        long optimalNumberOfProbes_numberOfBits = numberOfBits;
        int optimalNumberOfProbes_optimal = numberOfKeys <= 0 || optimalNumberOfProbes_numberOfBits <= 0L ? 0 : (int)package$.MODULE$.ceil((double)(optimalNumberOfProbes_numberOfBits / (long)numberOfKeys) * package$.MODULE$.log(2.0));
        int maxProbe = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(updateMaxProbe.apply$mcII$sp(optimalNumberOfProbes_optimal)), 1);
        boolean hasCompression = ((IterableOnceOps)compressions.apply((Object)new /* Unavailable Anonymous Inner Class!! */)).nonEmpty();
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ManifestFactory.ByteManifest create_evidence$3 = ClassTag$.MODULE$.Byte();
        Slice slice4 = slice3 = new Slice(create_evidence$3.newArray(numberOfBits), 0, numberOfBits == 0 ? -1 : numberOfBits - 1, bl ? numberOfBits : 0, (ClassTag)create_evidence$3);
        slice3 = null;
        Slice slice5 = slice2 = slice4;
        slice2 = null;
        Slice slice6 = slice = slice5;
        Object var10_11 = null;
        slice = null;
        Slice bytes = slice6;
        return new BloomFilterBlock.State(numberOfBits, maxProbe, (Slice<Object>)bytes, (Slice<Object>)bytes, (Slice<Object>)Slice$.MODULE$.emptyBytes(), (Function1<UncompressedBlockInfo, Seq<CompressionInternal>>)(hasCompression ? compressions : (Function1 & Serializable)x$6 -> (Seq)Seq$.MODULE$.empty()));
    }

    public int optimalNumberOfBits(int numberOfKeys, double falsePositiveRate) {
        if (numberOfKeys <= 0 || falsePositiveRate <= 0.0) {
            return 0;
        }
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)package$.MODULE$.ceil((double)(-1 * numberOfKeys) * package$.MODULE$.log(falsePositiveRate) / package$.MODULE$.log(2.0) / package$.MODULE$.log(2.0))), ByteSizeOf$.MODULE$.long());
    }

    public int optimalNumberOfProbes(int numberOfKeys, long numberOfBits, Function1<Object, Object> update) {
        int optimal = numberOfKeys <= 0 || numberOfBits <= 0L ? 0 : (int)package$.MODULE$.ceil((double)(numberOfBits / (long)numberOfKeys) * package$.MODULE$.log(2.0));
        return update.apply$mcII$sp(optimal);
    }

    /*
     * WARNING - void declaration
     */
    public Option<BloomFilterBlock.State> close(BloomFilterBlock.State state) {
        void addUnsignedInt_int;
        void addUnsignedInt_int2;
        if (state.compressibleBytes().isEmpty()) {
            return None$.MODULE$;
        }
        int apply__uncompressedSize = state.compressibleBytes().size();
        Block.CompressionResult compressionResult = Block$.MODULE$.compress(state.compressibleBytes(), (Seq<CompressionInternal>)((Seq)state.compressions().apply((Object)new /* Unavailable Anonymous Inner Class!! */)), this.blockName());
        compressionResult.compressedBytes().foreach((Function1 & Serializable)x$7 -> {
            state.compressibleBytes_$eq((Slice<Object>)x$7);
            return BoxedUnit.UNIT;
        });
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        int n = state.numberOfBits();
        if (byteSliceImplicits == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this = byteSliceImplicits;
        Slice addUnsignedInt_writeUnsignedInt_slice = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int2, (Slice)addUnsignedInt_writeUnsignedInt_slice);
        Slice cfr_ignored_0 = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var3_5 = null;
        Object var5_6 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits2 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        int n2 = state.maxProbe();
        if (byteSliceImplicits2 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this2 = byteSliceImplicits2;
        Slice addUnsignedInt_writeUnsignedInt_slice2 = addUnsignedInt_this2.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int, (Slice)addUnsignedInt_writeUnsignedInt_slice2);
        Slice cfr_ignored_1 = addUnsignedInt_this2.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var6_8 = null;
        Object var8_9 = null;
        compressionResult.fixHeaderSize();
        state.header_$eq(compressionResult.headerBytes());
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("BloomFilter stats: allocatedSpace: {}. actualSpace: {}. maxProbe: {}", new Object[]{BoxesRunTime.boxToInteger((int)state.numberOfBits()), BoxesRunTime.boxToInteger((int)state.compressibleBytes().size()), BoxesRunTime.boxToInteger((int)state.maxProbe())});
        }
        return new Some((Object)state);
    }

    public UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock> unblockedReader(BloomFilterBlock.State closedState) {
        BloomFilterBlock block = new BloomFilterBlock(new BloomFilterBlock.Offset(0, closedState.cacheableBytes().size()), closedState.maxProbe(), closedState.numberOfBits(), 0, (Option<Block.CompressionInfo>)None$.MODULE$);
        return UnblockedReader$.MODULE$.apply(block, (Slice<Object>)closedState.cacheableBytes().close());
    }

    public BloomFilterBlock read(Block.Header<BloomFilterBlock.Offset> header) {
        int numberOfBits = header.headerReader().readUnsignedInt();
        int maxProbe = header.headerReader().readUnsignedInt();
        BloomFilterBlock.Offset x$1 = header.offset();
        int x$2 = header.headerSize();
        Option<Block.CompressionInfo> x$5 = header.compressionInfo();
        return new BloomFilterBlock(x$1, maxProbe, numberOfBits, x$2, x$5);
    }

    public Option<BloomFilterBlock.State> init(int numberOfKeys, double falsePositiveRate, Function1<Object, Object> updateMaxProbe, Function1<UncompressedBlockInfo, Seq<CompressionInternal>> compressions) {
        Slice slice;
        Slice slice2;
        Slice slice3;
        if (numberOfKeys <= 0 || falsePositiveRate <= 0.0 || falsePositiveRate >= 1.0) {
            return None$.MODULE$;
        }
        int apply_numberOfBits = this.optimalNumberOfBits(numberOfKeys, falsePositiveRate);
        long apply_optimalNumberOfProbes_numberOfBits = apply_numberOfBits;
        int apply_optimalNumberOfProbes_optimal = numberOfKeys <= 0 || apply_optimalNumberOfProbes_numberOfBits <= 0L ? 0 : (int)package$.MODULE$.ceil((double)(apply_optimalNumberOfProbes_numberOfBits / (long)numberOfKeys) * package$.MODULE$.log(2.0));
        int apply_maxProbe = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(updateMaxProbe.apply$mcII$sp(apply_optimalNumberOfProbes_optimal)), 1);
        boolean apply_hasCompression = ((IterableOnceOps)compressions.apply((Object)new /* Unavailable Anonymous Inner Class!! */)).nonEmpty();
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ManifestFactory.ByteManifest apply_create_evidence$3 = ClassTag$.MODULE$.Byte();
        Slice slice4 = slice3 = new Slice(apply_create_evidence$3.newArray(apply_numberOfBits), 0, apply_numberOfBits == 0 ? -1 : apply_numberOfBits - 1, bl ? apply_numberOfBits : 0, (ClassTag)apply_create_evidence$3);
        slice3 = null;
        Slice slice5 = slice2 = slice4;
        slice2 = null;
        Slice slice6 = slice = slice5;
        Object var10_11 = null;
        slice = null;
        Slice apply_bytes = slice6;
        Object var9_15 = null;
        return new Some((Object)new BloomFilterBlock.State(apply_numberOfBits, apply_maxProbe, (Slice<Object>)apply_bytes, (Slice<Object>)apply_bytes, (Slice<Object>)Slice$.MODULE$.emptyBytes(), (Function1<UncompressedBlockInfo, Seq<CompressionInternal>>)(apply_hasCompression ? compressions : (Function1 & Serializable)x$6 -> (Seq)Seq$.MODULE$.empty())));
    }

    /*
     * WARNING - void declaration
     */
    public void add(Slice<Object> key, BloomFilterBlock.State state) {
        long hash = MurmurHash3Generic$.MODULE$.murmurhash3_x64_64(key, 0, key.size(), 0);
        long hash1 = hash >>> 32;
        long hash2 = hash << 32 >> 32;
        for (int probe = 0; probe < state.maxProbe(); ++probe) {
            void addLong_long;
            SliceCompanionBase.ByteSliceImplicits addLong_this;
            SliceCompanionBase.ByteSliceImplicits readLong_this;
            long hashIndex = (hash1 + (long)probe * hash2 & Long.MAX_VALUE) % (long)state.numberOfBits();
            int offset = (int)((hashIndex >>> 6) * 8L);
            if (SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)state.compressibleBytes().take(offset, ByteSizeOf$.MODULE$.long())) == null) {
                throw null;
            }
            long l = Bytez.readLong$((Bytez)Bytez$.MODULE$, (Slice)readLong_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice);
            Object var13_9 = null;
            if ((l & 1L << (int)hashIndex) != 0L) continue;
            state.compressibleBytes().moveWritePosition(offset);
            long l2 = l | 1L << (int)hashIndex;
            if (SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, state.compressibleBytes()) == null) {
                throw null;
            }
            Slice addLong_writeLong_slice = addLong_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Bytez.writeLong$((Bytez)Bytez$.MODULE$, (long)addLong_long, (Slice)addLong_writeLong_slice);
            Slice cfr_ignored_0 = addLong_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var16_11 = null;
            Object var19_13 = null;
        }
    }

    public boolean mightContain(Slice<Object> key, UnblockedReader<BloomFilterBlock.Offset, BloomFilterBlock> reader) {
        long hash = MurmurHash3Generic$.MODULE$.murmurhash3_x64_64(key, 0, key.size(), 0);
        long hash1 = hash >>> 32;
        long hash2 = hash << 32 >> 32;
        for (int probe = 0; probe < reader.block().maxProbe(); ++probe) {
            long hashIndex = (hash1 + (long)probe * hash2 & Long.MAX_VALUE) % (long)reader.block().numberOfBits();
            int position = (int)((hashIndex >>> 6) * 8L);
            if (reader.block().offset().size() - position < ByteSizeOf$.MODULE$.long()) {
                return false;
            }
            if ((reader.moveTo(position).readLong() & 1L << (int)hashIndex) != 0L) continue;
            return false;
        }
        return true;
    }

    public BloomFilterBlock apply(BloomFilterBlock.Offset offset, int maxProbe, int numberOfBits, int headerSize, Option<Block.CompressionInfo> compressionInfo) {
        return new BloomFilterBlock(offset, maxProbe, numberOfBits, headerSize, compressionInfo);
    }

    public Option<Tuple5<BloomFilterBlock.Offset, Object, Object, Object, Option<Block.CompressionInfo>>> unapply(BloomFilterBlock x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.offset(), (Object)BoxesRunTime.boxToInteger((int)x$0.maxProbe()), (Object)BoxesRunTime.boxToInteger((int)x$0.numberOfBits()), (Object)BoxesRunTime.boxToInteger((int)x$0.headerSize()), x$0.compressionInfo()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BloomFilterBlock$.class);
    }

    private BloomFilterBlock$() {
    }
}

