/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment.format.a.block.hashindex;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple10;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichLong$;
import swaydb.compression.CompressionInternal;
import swaydb.core.data.Persistent;
import swaydb.core.data.Persistent$Partial$Null$;
import swaydb.core.segment.format.a.block.Block;
import swaydb.core.segment.format.a.block.Block$;
import swaydb.core.segment.format.a.block.hashindex.HashIndexBlock;
import swaydb.core.segment.format.a.block.hashindex.HashIndexEntryFormat;
import swaydb.core.segment.format.a.block.hashindex.HashIndexEntryFormat$;
import swaydb.core.segment.format.a.block.hashindex.HashIndexEntryFormat$CopyKey$;
import swaydb.core.segment.format.a.block.hashindex.HashIndexEntryFormat$Reference$;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.reader.UnblockedReader$;
import swaydb.core.segment.format.a.block.sortedindex.SortedIndexBlock;
import swaydb.core.segment.format.a.block.values.ValuesBlock;
import swaydb.core.util.Bytes$;
import swaydb.core.util.CRC32$;
import swaydb.data.config.RandomKeyIndex;
import swaydb.data.order.KeyOrder;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.util.ByteSizeOf$;
import swaydb.data.util.Bytez;
import swaydb.data.util.Bytez$;

public final class HashIndexBlock$
implements LazyLogging,
Serializable {
    public static final HashIndexBlock$ MODULE$ = new HashIndexBlock$();
    private static final String blockName;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        blockName = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(MODULE$.getClass().getSimpleName()), 1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String blockName() {
        return blockName;
    }

    public Option<HashIndexBlock.State> init(SortedIndexBlock.State sortedIndexState, HashIndexBlock.Config hashIndexConfig) {
        Slice slice;
        Slice slice2;
        Slice slice3;
        if (sortedIndexState.uncompressedPrefixCount() < hashIndexConfig.minimumNumberOfKeys()) {
            return None$.MODULE$;
        }
        int writeAbleLargestValueSize = hashIndexConfig.format().bytesToAllocatePerEntry(((SortedIndexBlock.SecondaryIndexEntry)sortedIndexState.secondaryIndexEntries().last()).indexOffset(), sortedIndexState.largestUncompressedMergedKeySize());
        int x$1 = sortedIndexState.uncompressedPrefixCount();
        int x$2 = hashIndexConfig.minimumNumberOfKeys();
        Function1<RandomKeyIndex.RequiredSpace, Object> x$4 = hashIndexConfig.allocateSpace();
        HashIndexEntryFormat x$5 = hashIndexConfig.format();
        int optimalBytes = this.optimalBytesRequired(x$1, x$2, writeAbleLargestValueSize, x$5, x$4);
        if (optimalBytes < ByteSizeOf$.MODULE$.int()) {
            return None$.MODULE$;
        }
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ManifestFactory.ByteManifest create_evidence$3 = ClassTag$.MODULE$.Byte();
        Slice slice4 = slice3 = new Slice(create_evidence$3.newArray(optimalBytes), 0, optimalBytes == 0 ? -1 : optimalBytes - 1, bl ? optimalBytes : 0, (ClassTag)create_evidence$3);
        slice3 = null;
        Slice slice5 = slice2 = slice4;
        slice2 = null;
        Slice slice6 = slice = slice5;
        Object var11_10 = null;
        slice = null;
        Slice bytes = slice6;
        HashIndexBlock.State state = new HashIndexBlock.State(0, sortedIndexState.prefixCompressedCount(), hashIndexConfig.format(), hashIndexConfig.minimumNumberOfKeys(), hashIndexConfig.minimumNumberOfHits(), writeAbleLargestValueSize, CRC32$.MODULE$.disabledCRC(), hashIndexConfig.maxProbe(), (Slice<Object>)bytes, (Slice<Object>)bytes, null, hashIndexConfig.compressions());
        return new Some((Object)state);
    }

    public int optimalBytesRequired(int keyCounts, int minimumNumberOfKeys, int writeAbleLargestValueSize, HashIndexEntryFormat format, Function1<RandomKeyIndex.RequiredSpace, Object> allocateSpace) {
        if (keyCounts < minimumNumberOfKeys) {
            return 0;
        }
        int requiredSpace = keyCounts * (writeAbleLargestValueSize + 1);
        try {
            return BoxesRunTime.unboxToInt((Object)allocateSpace.apply((Object)new /* Unavailable Anonymous Inner Class!! */));
        }
        catch (Exception exception) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Custom allocate space calculation for HashIndex returned failure.\n              |Using the default requiredSpace instead. Please check your implementation to ensure it's not throwing exception.\n            ")), (Throwable)exception);
            }
            return requiredSpace;
        }
    }

    public long minimumCRCToWrite(HashIndexBlock.State state) {
        if (state.minimumCRC() == CRC32$.MODULE$.disabledCRC()) {
            return 0L;
        }
        return state.minimumCRC();
    }

    /*
     * WARNING - void declaration
     */
    public Option<HashIndexBlock.State> close(HashIndexBlock.State state) {
        void addUnsignedInt_int;
        void addUnsignedLong_long;
        void addUnsignedInt_int2;
        void addUnsignedInt_int3;
        void addUnsignedInt_int4;
        void addByte_value;
        if (state.compressibleBytes().isEmpty() || !state.hasMinimumHits()) {
            return None$.MODULE$;
        }
        int apply__uncompressedSize = state.compressibleBytes().size();
        Block.CompressionResult compressionResult = Block$.MODULE$.compress(state.compressibleBytes(), (Seq<CompressionInternal>)((Seq)state.compressions().apply((Object)new /* Unavailable Anonymous Inner Class!! */)), this.blockName());
        int allocatedBytes = state.compressibleBytes().allocatedSize();
        compressionResult.compressedBytes().foreach((Function1 & Serializable)x$8 -> {
            state.compressibleBytes_$eq((Slice<Object>)x$8);
            return BoxedUnit.UNIT;
        });
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        byte by = state.format().id();
        if (byteSliceImplicits == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addByte_this = byteSliceImplicits;
        addByte_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice.insert((Object)BoxesRunTime.boxToByte((byte)addByte_value));
        Slice cfr_ignored_0 = addByte_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var4_6 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits2 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        if (byteSliceImplicits2 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addInt_this = byteSliceImplicits2;
        Slice addInt_writeInt_slice = addInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeInt$((Bytez)Bytez$.MODULE$, (int)allocatedBytes, (Slice)addInt_writeInt_slice);
        Slice cfr_ignored_1 = addInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var6_7 = null;
        Object var7_8 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits3 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        int n = state.maxProbe();
        if (byteSliceImplicits3 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this = byteSliceImplicits3;
        Slice addUnsignedInt_writeUnsignedInt_slice = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int4, (Slice)addUnsignedInt_writeUnsignedInt_slice);
        Slice cfr_ignored_2 = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var8_10 = null;
        Object var10_11 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits4 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        int n2 = state.hit();
        if (byteSliceImplicits4 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this2 = byteSliceImplicits4;
        Slice addUnsignedInt_writeUnsignedInt_slice2 = addUnsignedInt_this2.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int3, (Slice)addUnsignedInt_writeUnsignedInt_slice2);
        Slice cfr_ignored_3 = addUnsignedInt_this2.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var11_13 = null;
        Object var13_14 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits5 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        int n3 = state.miss();
        if (byteSliceImplicits5 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this3 = byteSliceImplicits5;
        Slice addUnsignedInt_writeUnsignedInt_slice3 = addUnsignedInt_this3.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int2, (Slice)addUnsignedInt_writeUnsignedInt_slice3);
        Slice cfr_ignored_4 = addUnsignedInt_this3.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var14_16 = null;
        Object var16_17 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits6 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        long l = this.minimumCRCToWrite(state);
        if (byteSliceImplicits6 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedLong_this = byteSliceImplicits6;
        Slice addUnsignedLong_writeUnsignedLong_slice = addUnsignedLong_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedLong$((Bytez)Bytez$.MODULE$, (long)addUnsignedLong_long, (Slice)addUnsignedLong_writeUnsignedLong_slice);
        Slice cfr_ignored_5 = addUnsignedLong_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var17_19 = null;
        Object var20_20 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits7 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, compressionResult.headerBytes());
        int n4 = state.writeAbleLargestValueSize();
        if (byteSliceImplicits7 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this4 = byteSliceImplicits7;
        Slice addUnsignedInt_writeUnsignedInt_slice4 = addUnsignedInt_this4.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int, (Slice)addUnsignedInt_writeUnsignedInt_slice4);
        Slice cfr_ignored_6 = addUnsignedInt_this4.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var21_22 = null;
        Object var23_23 = null;
        compressionResult.fixHeaderSize();
        state.header_$eq(compressionResult.headerBytes());
        return new Some((Object)state);
    }

    public UnblockedReader<HashIndexBlock.Offset, HashIndexBlock> unblockedReader(HashIndexBlock.State closedState) {
        HashIndexBlock block = new HashIndexBlock(new HashIndexBlock.Offset(0, closedState.cacheableBytes().size()), (Option<Block.CompressionInfo>)None$.MODULE$, closedState.maxProbe(), closedState.format(), this.minimumCRCToWrite(closedState), closedState.hit(), closedState.miss(), closedState.writeAbleLargestValueSize(), 0, closedState.cacheableBytes().allocatedSize());
        return UnblockedReader$.MODULE$.apply(block, (Slice<Object>)closedState.cacheableBytes().close());
    }

    public HashIndexBlock read(Block.Header<HashIndexBlock.Offset> header) {
        byte formatId = header.headerReader().get();
        HashIndexEntryFormat format = (HashIndexEntryFormat)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])HashIndexEntryFormat$.MODULE$.formats()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)HashIndexBlock$.$anonfun$read$1(formatId, x$9))).getOrElse((Function0 & Serializable)() -> {
            String throws_message = new StringBuilder(28).append("Invalid HashIndex formatId: ").append(formatId).toString();
            throw new Exception(throws_message);
        });
        int allocatedBytes = header.headerReader().readInt();
        int maxProbe = header.headerReader().readUnsignedInt();
        int hit = header.headerReader().readUnsignedInt();
        int miss = header.headerReader().readUnsignedInt();
        long minimumCRC = header.headerReader().readUnsignedLong();
        int largestValueSize = header.headerReader().readUnsignedInt();
        return new HashIndexBlock(header.offset(), header.compressionInfo(), maxProbe, format, minimumCRC, hit, miss, largestValueSize, header.headerSize(), allocatedBytes);
    }

    private int adjustHash(int hash, int hashMaxOffset) {
        return Math.abs(hash) % hashMaxOffset;
    }

    public boolean write(SortedIndexBlock.SecondaryIndexEntry entry, HashIndexBlock.State state) {
        boolean bl;
        HashIndexEntryFormat hashIndexEntryFormat = state.format();
        if (HashIndexEntryFormat$Reference$.MODULE$.equals(hashIndexEntryFormat)) {
            bl = this.writeReference(entry.indexOffset(), entry.unmergedKey(), entry.mergedKey(), entry.keyType(), state);
        } else if (HashIndexEntryFormat$CopyKey$.MODULE$.equals(hashIndexEntryFormat)) {
            bl = this.writeCopy(entry.indexOffset(), entry.unmergedKey(), entry.mergedKey(), entry.keyType(), state);
        } else {
            throw new MatchError((Object)hashIndexEntryFormat);
        }
        return bl;
    }

    public boolean writeReference(int indexOffset, Slice<Object> hashKey, Slice<Object> mergedKey, byte keyType, HashIndexBlock.State state) {
        mergedKey.size();
        int n = Bytes$.MODULE$.sizeOfUnsignedInt(indexOffset + 1);
        int hash = hashKey.hashCode();
        int hash1 = hash >>> 32;
        int hash2 = hash << 32 >> 32;
        if (state.compressibleBytes().allocatedSize() == 0) {
            return false;
        }
        return this.doWrite$1(0, state, hash1, hash2, n, indexOffset, mergedKey, keyType);
    }

    public Persistent.PartialOption searchReference(Slice<Object> key, UnblockedReader<HashIndexBlock.Offset, HashIndexBlock> hashIndexReader, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndexReader, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesReaderOrNull, KeyOrder<Slice<Object>> keyOrder) {
        int hash = key.hashCode();
        int hash1 = hash >>> 32;
        int hash2 = hash << 32 >> 32;
        HashIndexBlock block = hashIndexReader.block();
        return this.doFind$1(0, block, hash1, hash2, hashIndexReader, sortedIndexReader, valuesReaderOrNull, key, keyOrder);
    }

    public boolean writeCopy(int indexOffset, Slice<Object> hashKey, Slice<Object> mergedKey, byte keyType, HashIndexBlock.State state) {
        int hash = hashKey.hashCode();
        int hash1 = hash >>> 32;
        int hash2 = hash << 32 >> 32;
        int requiredSpace = state.format().bytesToAllocatePerEntry(indexOffset, mergedKey.size());
        if (state.compressibleBytes().allocatedSize() == 0) {
            return false;
        }
        return this.doWrite$2(0, state, hash1, hash2, requiredSpace, indexOffset, mergedKey, keyType);
    }

    public Persistent.PartialOption searchCopy(Slice<Object> key, UnblockedReader<HashIndexBlock.Offset, HashIndexBlock> hasIndexReader, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndexReader, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesReaderOrNull, KeyOrder<Slice<Object>> keyOrder) {
        int hash = key.hashCode();
        int hash1 = hash >>> 32;
        int hash2 = hash << 32 >> 32;
        HashIndexBlock block = hasIndexReader.block();
        return this.doFind$2(0, block, hash1, hash2, hasIndexReader, sortedIndexReader, valuesReaderOrNull, key, keyOrder);
    }

    public Persistent.PartialOption search(Slice<Object> key, UnblockedReader<HashIndexBlock.Offset, HashIndexBlock> hashIndexReader, UnblockedReader<SortedIndexBlock.Offset, SortedIndexBlock> sortedIndexReader, UnblockedReader<ValuesBlock.Offset, ValuesBlock> valuesReaderOrNull, KeyOrder<Slice<Object>> keyOrder) {
        if (hashIndexReader.block().format().isCopy()) {
            return this.searchCopy(key, hashIndexReader, sortedIndexReader, valuesReaderOrNull, keyOrder);
        }
        return this.searchReference(key, hashIndexReader, sortedIndexReader, valuesReaderOrNull, keyOrder);
    }

    public HashIndexBlock apply(HashIndexBlock.Offset offset, Option<Block.CompressionInfo> compressionInfo, int maxProbe, HashIndexEntryFormat format, long minimumCRC, int hit, int miss, int writeAbleLargestValueSize, int headerSize, int allocatedBytes) {
        return new HashIndexBlock(offset, compressionInfo, maxProbe, format, minimumCRC, hit, miss, writeAbleLargestValueSize, headerSize, allocatedBytes);
    }

    public Option<Tuple10<HashIndexBlock.Offset, Option<Block.CompressionInfo>, Object, HashIndexEntryFormat, Object, Object, Object, Object, Object, Object>> unapply(HashIndexBlock x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple10((Object)x$0.offset(), x$0.compressionInfo(), (Object)BoxesRunTime.boxToInteger((int)x$0.maxProbe()), (Object)x$0.format(), (Object)BoxesRunTime.boxToLong((long)x$0.minimumCRC()), (Object)BoxesRunTime.boxToInteger((int)x$0.hit()), (Object)BoxesRunTime.boxToInteger((int)x$0.miss()), (Object)BoxesRunTime.boxToInteger((int)x$0.writeAbleLargestValueSize()), (Object)BoxesRunTime.boxToInteger((int)x$0.headerSize()), (Object)BoxesRunTime.boxToInteger((int)x$0.allocatedBytes())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HashIndexBlock$.class);
    }

    public static final /* synthetic */ boolean $anonfun$read$1(byte formatId$1, HashIndexEntryFormat x$9) {
        return x$9.id() == formatId$1;
    }

    public static final /* synthetic */ boolean $anonfun$writeReference$1(byte x$10) {
        return x$10 == 0;
    }

    private final boolean doWrite$1(int probe, HashIndexBlock.State state$2, int hash1$1, int hash2$1, int requiredSpace$1, int indexOffset$1, Slice mergedKey$1, byte keyType$1) {
        while (true) {
            if (probe >= state$2.maxProbe()) {
                state$2.miss_$eq(state$2.miss() + 1);
                return false;
            }
            int adjustHash_hashMaxOffset = state$2.hashMaxOffset();
            int n = Math.abs(hash1$1 + probe * hash2$1) % adjustHash_hashMaxOffset;
            if (state$2.compressibleBytes().take(n, requiredSpace$1 + 2).forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)HashIndexBlock$.$anonfun$writeReference$1(BoxesRunTime.unboxToByte((Object)x$10))))) {
                state$2.compressibleBytes().moveWritePosition(n + 1);
                HashIndexEntryFormat$Reference$.MODULE$.write(indexOffset$1, (Slice<Object>)mergedKey$1, keyType$1, state$2.compressibleBytes());
                state$2.hit_$eq(state$2.hit() + 1);
                return true;
            }
            ++probe;
        }
    }

    private final Persistent.PartialOption doFind$1(int probe, HashIndexBlock block$1, int hash1$2, int hash2$2, UnblockedReader hashIndexReader$1, UnblockedReader sortedIndexReader$1, UnblockedReader valuesReaderOrNull$1, Slice key$1, KeyOrder keyOrder$1) {
        while (probe < block$1.maxProbe()) {
            int adjustHash_hashMaxOffset = block$1.hashMaxOffset();
            int n = Math.abs(hash1$2 + probe * hash2$2) % adjustHash_hashMaxOffset;
            Slice<Object> possibleValueBytes = hashIndexReader$1.moveTo(n).read(block$1.bytesToReadPerIndex());
            if (possibleValueBytes.isEmpty() || BoxesRunTime.unboxToByte((Object)possibleValueBytes.head()) != Bytes$.MODULE$.zero()) {
                ++probe;
                continue;
            }
            Slice entry = possibleValueBytes.dropHead();
            Persistent.Partial partialKeyValueOrNull = block$1.format().readOrNull((Slice<Object>)entry, hashIndexReader$1, sortedIndexReader$1, valuesReaderOrNull$1);
            if (partialKeyValueOrNull == null) {
                ++probe;
                continue;
            }
            if (partialKeyValueOrNull.matchForHashIndex((Slice<Object>)key$1, (KeyOrder<Slice<Object>>)keyOrder$1)) {
                return partialKeyValueOrNull;
            }
            ++probe;
        }
        return Persistent$Partial$Null$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$writeCopy$1(byte x$11) {
        return x$11 == 0;
    }

    private final boolean doWrite$2(int probe, HashIndexBlock.State state$3, int hash1$3, int hash2$3, int requiredSpace$2, int indexOffset$2, Slice mergedKey$2, byte keyType$2) {
        while (true) {
            if (probe >= state$3.maxProbe()) {
                state$3.miss_$eq(state$3.miss() + 1);
                return false;
            }
            int adjustHash_hashMaxOffset = state$3.hashMaxOffset();
            int n = Math.abs(hash1$3 + probe * hash2$3) % adjustHash_hashMaxOffset;
            if (state$3.compressibleBytes().take(n, requiredSpace$2 + 1).forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)HashIndexBlock$.$anonfun$writeCopy$1(BoxesRunTime.unboxToByte((Object)x$11))))) {
                state$3.compressibleBytes().moveWritePosition(n);
                long crc = HashIndexEntryFormat$CopyKey$.MODULE$.write(indexOffset$2, (Slice<Object>)mergedKey$2, keyType$2, state$3.compressibleBytes());
                if (state$3.minimumCRC() == CRC32$.MODULE$.disabledCRC()) {
                    state$3.minimumCRC_$eq(crc);
                } else {
                    long setMinimumCRC_x$1 = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(crc), state$3.minimumCRC());
                    state$3.minimumCRC_$eq(setMinimumCRC_x$1);
                }
                state$3.hit_$eq(state$3.hit() + 1);
                return true;
            }
            ++probe;
        }
    }

    private final Persistent.PartialOption doFind$2(int probe, HashIndexBlock block$2, int hash1$4, int hash2$4, UnblockedReader hasIndexReader$1, UnblockedReader sortedIndexReader$2, UnblockedReader valuesReaderOrNull$2, Slice key$2, KeyOrder keyOrder$2) {
        while (probe < block$2.maxProbe()) {
            int adjustHash_hashMaxOffset = block$2.hashMaxOffset();
            int n = Math.abs(hash1$4 + probe * hash2$4) % adjustHash_hashMaxOffset;
            Slice<Object> entry = hasIndexReader$1.moveTo(n).read(block$2.writeAbleLargestValueSize());
            if (entry.isEmpty() || entry.size() == 1) {
                ++probe;
                continue;
            }
            Persistent.Partial partialKeyValueOrNull = block$2.format().readOrNull(entry, hasIndexReader$1, sortedIndexReader$2, valuesReaderOrNull$2);
            if (partialKeyValueOrNull == null) {
                ++probe;
                continue;
            }
            if (partialKeyValueOrNull.matchForHashIndex((Slice<Object>)key$2, (KeyOrder<Slice<Object>>)keyOrder$2)) {
                return partialKeyValueOrNull;
            }
            ++probe;
        }
        return Persistent$Partial$Null$.MODULE$;
    }

    private HashIndexBlock$() {
    }
}

