/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment.format.a.block.reader;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import scala.Function2;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;
import swaydb.IO;
import swaydb.core.segment.format.a.block.Block;
import swaydb.core.segment.format.a.block.BlockOffset;
import swaydb.core.segment.format.a.block.BlockOps;
import swaydb.core.segment.format.a.block.reader.BlockReader;
import swaydb.core.segment.format.a.block.reader.BlockReader$;
import swaydb.core.segment.format.a.block.reader.BlockReaderBase;
import swaydb.core.segment.format.a.block.reader.BlockRefReader;
import swaydb.core.segment.format.a.block.reader.BlockedReader$;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.segment.SegmentBlock;
import swaydb.data.slice.Reader;
import swaydb.data.slice.ReaderBase;
import swaydb.data.slice.Slice;
import swaydb.data.slice.SliceOption;

@ScalaSignature(bytes="\u0006\u0005\u0005MtA\u0002\u000b\u0016\u0011\u0003y2E\u0002\u0004&+!\u0005qD\n\u0005\u0006[\u0005!\ta\f\u0005\u0006a\u0005!\t!\r\u0005\u0007a\u0005!\t!!\b\t\rA\nA\u0011AA \r\u0015)S\u0003A\u00105\u0011%1bA!b\u0001\n\u0003)\u0012\b\u0003\u0005C\r\t\u0005\t\u0015!\u0003;\u0011!AbA!b\u0001\n\u0003\u0019\u0005\u0002C,\u0007\u0005\u0003\u0005\u000b\u0011\u0002#\t\u000b52A\u0011\u0002-\t\u000fq3!\u0019!C\u0001;\"1aL\u0002Q\u0001\nACqa\u0018\u0004C\u0002\u0013\u0005\u0003\r\u0003\u0004i\r\u0001\u0006I!\u0019\u0005\u0006S\u001a!\tE\u001b\u0005\u0006S\u001a!\t\u0005\u001d\u0005\u0006k\u001a!\tA\u001e\u0005\u0006{\u001a!\tE`\u0001\u000e\u00052|7m[3e%\u0016\fG-\u001a:\u000b\u0005Y9\u0012A\u0002:fC\u0012,'O\u0003\u0002\u00193\u0005)!\r\\8dW*\u0011!dG\u0001\u0002C*\u0011A$H\u0001\u0007M>\u0014X.\u0019;\u000b\u0005yy\u0012aB:fO6,g\u000e\u001e\u0006\u0003A\u0005\nAaY8sK*\t!%\u0001\u0004to\u0006LHM\u0019\t\u0003I\u0005i\u0011!\u0006\u0002\u000e\u00052|7m[3e%\u0016\fG-\u001a:\u0014\u0005\u00059\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0013!B1qa2LX#\u0002\u001a\u0002\u0002\u0005\u0015A#B\u001a\u0002\f\u00055\u0001#\u0002\u0013\u0007\u007f\u0006\rQcA\u001bR\rN\u0019aa\n\u001c\u0011\u0005\u0011:\u0014B\u0001\u001d\u0016\u0005=\u0011En\\2l%\u0016\fG-\u001a:CCN,W#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014!B:mS\u000e,'BA \"\u0003\u0011!\u0017\r^1\n\u0005\u0005c$A\u0002*fC\u0012,'/A\u0004sK\u0006$WM\u001d\u0011\u0016\u0003\u0011\u0003\"!\u0012$\r\u0001\u0011)qI\u0002b\u0001\u0011\n\t!)\u0005\u0002J\u0019B\u0011\u0001FS\u0005\u0003\u0017&\u0012qAT8uQ&tw\rE\u0002N\u001dBk\u0011aF\u0005\u0003\u001f^\u0011QA\u00117pG.\u0004\"!R)\u0005\u000bI3!\u0019A*\u0003\u0003=\u000b\"!\u0013+\u0011\u00055+\u0016B\u0001,\u0018\u0005-\u0011En\\2l\u001f\u001a47/\u001a;\u0002\r\tdwnY6!)\rI&l\u0017\t\u0005I\u0019\u0001F\tC\u0003\u0017\u0017\u0001\u0007!\bC\u0003\u0019\u0017\u0001\u0007A)\u0001\u0004pM\u001a\u001cX\r^\u000b\u0002!\u00069qN\u001a4tKR\u0004\u0013!B:uCR,W#A1\u0011\u0005\t,gB\u0001\u0013d\u0013\t!W#A\u0006CY>\u001c7NU3bI\u0016\u0014\u0018B\u00014h\u0005\u0015\u0019F/\u0019;f\u0015\t!W#\u0001\u0004ti\u0006$X\rI\u0001\u0007[>4X\rV8\u0015\u0005e[\u0007\"\u00027\u0011\u0001\u0004i\u0017a\u00038foB{7/\u001b;j_:\u0004\"\u0001\u000b8\n\u0005=L#\u0001\u0002'p]\u001e$\"!W9\t\u000b1\f\u0002\u0019\u0001:\u0011\u0005!\u001a\u0018B\u0001;*\u0005\rIe\u000e^\u0001\u0014e\u0016\fG-\u00117m\u0003:$w)\u001a;SK\u0006$WM\u001d\u000b\u0002oR\u0011\u0011\f\u001f\u0005\u0006sJ\u0001\u001dA_\u0001\tE2|7m[(qgB!Qj\u001f)E\u0013\taxC\u0001\u0005CY>\u001c7n\u00149t\u0003\u0011\u0019w\u000e]=\u0015\u0003e\u00032!RA\u0001\t\u0015\u00116A1\u0001T!\r)\u0015Q\u0001\u0003\u0007\u000f\u000e\u0011\r!a\u0002\u0012\u0007%\u000bI\u0001E\u0002N\u001d~Da\u0001G\u0002A\u0002\u0005\r\u0001bBA\b\u0007\u0001\u0007\u0011\u0011C\u0001\u0006Ef$Xm\u001d\t\u0006w\u0005M\u0011qC\u0005\u0004\u0003+a$!B*mS\u000e,\u0007c\u0001\u0015\u0002\u001a%\u0019\u00111D\u0015\u0003\t\tKH/Z\u000b\u0007\u0003?\t9#a\u000b\u0015\t\u0005\u0005\u0012Q\u0007\u000b\u0005\u0003G\t\t\u0004\u0005\u0004%\r\u0005\u0015\u0012\u0011\u0006\t\u0004\u000b\u0006\u001dB!\u0002*\u0005\u0005\u0004\u0019\u0006cA#\u0002,\u00111q\t\u0002b\u0001\u0003[\t2!SA\u0018!\u0011ie*!\n\t\re$\u00019AA\u001a!\u0019i50!\n\u0002*!9\u0011q\u0007\u0003A\u0002\u0005e\u0012a\u0001:fMB)A%a\u000f\u0002&%\u0019\u0011QH\u000b\u0003\u001d\tcwnY6SK\u001a\u0014V-\u00193feV1\u0011\u0011IA$\u0003\u0017\"b!a\u0011\u0002R\u0005M\u0003C\u0002\u0013\u0007\u0003\u000b\nI\u0005E\u0002F\u0003\u000f\"QAU\u0003C\u0002M\u00032!RA&\t\u00199UA1\u0001\u0002NE\u0019\u0011*a\u0014\u0011\t5s\u0015Q\t\u0005\u00071\u0015\u0001\r!!\u0013\t\rY)\u0001\u0019AA+!\u001d!\u0013qKA.\u0003[J1!!\u0017\u0016\u0005=)fN\u00197pG.,GMU3bI\u0016\u0014\b\u0003BA/\u0003OrA!a\u0018\u0002d5\u0011\u0011\u0011\r\u0006\u0003=]IA!!\u001a\u0002b\u0005a1+Z4nK:$(\t\\8dW&!\u0011\u0011NA6\u0005\u0019yeMZ:fi*!\u0011QMA1!\u0011\ty&a\u001c\n\t\u0005E\u0014\u0011\r\u0002\r'\u0016<W.\u001a8u\u00052|7m\u001b")
public class BlockedReader<O extends BlockOffset, B extends Block<O>>
implements BlockReaderBase {
    private final Reader reader;
    private final B block;
    private final O offset;
    private final BlockReader.State state;
    private boolean isFile;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <O extends BlockOffset, B extends Block<O>> BlockedReader<O, B> apply(B b, UnblockedReader<SegmentBlock.Offset, SegmentBlock> unblockedReader) {
        return BlockedReader$.MODULE$.apply(b, unblockedReader);
    }

    public static <O extends BlockOffset, B extends Block<O>> BlockedReader<O, B> apply(BlockRefReader<O> blockRefReader, BlockOps<O, B> blockOps) {
        return BlockedReader$.MODULE$.apply(blockRefReader, blockOps);
    }

    public static <O extends BlockOffset, B extends Block<O>> BlockedReader<O, B> apply(B b, Slice<Object> slice) {
        return BlockedReader$.MODULE$.apply(b, slice);
    }

    @Override
    public Path path() {
        return BlockReaderBase.path$(this);
    }

    @Override
    public long size() {
        return BlockReaderBase.size$(this);
    }

    @Override
    public boolean hasMore() {
        return BlockReaderBase.hasMore$(this);
    }

    @Override
    public boolean hasAtLeast(long atLeastSize) {
        return BlockReaderBase.hasAtLeast$(this, atLeastSize);
    }

    @Override
    public int getPosition() {
        return BlockReaderBase.getPosition$(this);
    }

    @Override
    public byte get() {
        return BlockReaderBase.get$(this);
    }

    @Override
    public Slice<Object> read(int size) {
        return BlockReaderBase.read$(this, size);
    }

    @Override
    public Slice<Object> readFullBlock() {
        return BlockReaderBase.readFullBlock$(this);
    }

    @Override
    public SliceOption<Object> readFullBlockOrNone() {
        return BlockReaderBase.readFullBlockOrNone$(this);
    }

    @Override
    public Slice<Object> readRemaining() {
        return BlockReaderBase.readRemaining$(this);
    }

    public Slice<Object> read(long size) {
        return ReaderBase.read$((ReaderBase)this, (long)size);
    }

    public ReaderBase skip(long skip) {
        return ReaderBase.skip$((ReaderBase)this, (long)skip);
    }

    public boolean readBoolean() {
        return ReaderBase.readBoolean$((ReaderBase)this);
    }

    public int readInt() {
        return ReaderBase.readInt$((ReaderBase)this);
    }

    public int readInt(boolean unsigned) {
        return ReaderBase.readInt$((ReaderBase)this, (boolean)unsigned);
    }

    public int readUnsignedInt() {
        return ReaderBase.readUnsignedInt$((ReaderBase)this);
    }

    public Tuple2<Object, Object> readUnsignedIntWithByteSize() {
        return ReaderBase.readUnsignedIntWithByteSize$((ReaderBase)this);
    }

    public int readNonZeroUnsignedInt() {
        return ReaderBase.readNonZeroUnsignedInt$((ReaderBase)this);
    }

    public int readNonZeroStrictUnsignedInt() {
        return ReaderBase.readNonZeroStrictUnsignedInt$((ReaderBase)this);
    }

    public Tuple2<Object, Object> readNonZeroUnsignedIntWithByteSize() {
        return ReaderBase.readNonZeroUnsignedIntWithByteSize$((ReaderBase)this);
    }

    public Slice<Object> readUnsignedIntSized() {
        return ReaderBase.readUnsignedIntSized$((ReaderBase)this);
    }

    public int readSignedInt() {
        return ReaderBase.readSignedInt$((ReaderBase)this);
    }

    public long readLong() {
        return ReaderBase.readLong$((ReaderBase)this);
    }

    public long readUnsignedLong() {
        return ReaderBase.readUnsignedLong$((ReaderBase)this);
    }

    public long readSignedLong() {
        return ReaderBase.readSignedLong$((ReaderBase)this);
    }

    public String readRemainingAsString(Charset charset) {
        return ReaderBase.readRemainingAsString$((ReaderBase)this, (Charset)charset);
    }

    public Charset readRemainingAsString$default$1() {
        return ReaderBase.readRemainingAsString$default$1$((ReaderBase)this);
    }

    public String readString(int size, Charset charset) {
        return ReaderBase.readString$((ReaderBase)this, (int)size, (Charset)charset);
    }

    public Charset readString$default$2() {
        return ReaderBase.readString$default$2$((ReaderBase)this);
    }

    public long remaining() {
        return ReaderBase.remaining$((ReaderBase)this);
    }

    public ReaderBase reset() {
        return ReaderBase.reset$((ReaderBase)this);
    }

    public final <E, R> IO<E, R> foldLeftIO(R result, Function2<R, ReaderBase, IO<E, R>> f, IO.ExceptionHandler<E> evidence$1) {
        return ReaderBase.foldLeftIO$((ReaderBase)this, result, f, evidence$1);
    }

    public final <R> R foldLeft(R result, Function2<R, ReaderBase, R> f) {
        return (R)ReaderBase.foldLeft$((ReaderBase)this, result, f);
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public void swaydb$core$segment$format$a$block$reader$BlockReaderBase$_setter_$isFile_$eq(boolean x$1) {
        this.isFile = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Reader reader() {
        return this.reader;
    }

    public B block() {
        return this.block;
    }

    public O offset() {
        return this.offset;
    }

    @Override
    public BlockReader.State state() {
        return this.state;
    }

    public BlockedReader<O, B> moveTo(long newPosition) {
        this.state().moveTo((int)newPosition);
        return this;
    }

    public BlockedReader<O, B> moveTo(int newPosition) {
        this.state().moveTo(newPosition);
        return this;
    }

    public BlockedReader<O, B> readAllAndGetReader(BlockOps<O, B> blockOps) {
        Slice<Object> bytes = this.readFullBlock();
        B x$2 = blockOps.updateBlockOffset(this.block(), 0, bytes.size());
        return BlockedReader$.MODULE$.apply(x$2, bytes);
    }

    public BlockedReader<O, B> copy() {
        return new BlockedReader<O, B>(this.reader().copy(), this.block());
    }

    public BlockedReader(Reader reader, B block) {
        this.reader = reader;
        this.block = block;
        LazyLogging.$init$((LazyLogging)this);
        BlockReaderBase.$init$(this);
        this.offset = block.offset();
        this.state = BlockReader$.MODULE$.apply((BlockOffset)this.offset(), reader);
        Statics.releaseFence();
    }
}

