/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment.format.a.block.reader;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;
import swaydb.IO;
import swaydb.core.io.reader.FileReader;
import swaydb.core.segment.format.a.block.Block;
import swaydb.core.segment.format.a.block.Block$;
import swaydb.core.segment.format.a.block.BlockOffset;
import swaydb.core.segment.format.a.block.BlockOps;
import swaydb.core.segment.format.a.block.reader.BlockReader;
import swaydb.core.segment.format.a.block.reader.BlockReader$;
import swaydb.core.segment.format.a.block.reader.BlockReaderBase;
import swaydb.core.segment.format.a.block.reader.BlockedReader;
import swaydb.core.segment.format.a.block.reader.UnblockedReader$;
import swaydb.core.segment.format.a.block.reader.UnblockedReaderOption;
import swaydb.data.slice.Reader;
import swaydb.data.slice.ReaderBase;
import swaydb.data.slice.Slice;
import swaydb.data.slice.SliceOption;
import swaydb.data.slice.SliceReader;

@ScalaSignature(bytes="\u0006\u0005\tMsAB\u0014)\u0011\u0003\u0011dG\u0002\u00049Q!\u0005!'\u000f\u0005\u0006\u0001\u0006!\tAQ\u0004\u0006\u0007\u0006A)\t\u0012\u0004\u0006\r\u0006A)i\u0012\u0005\u0006\u0001\u0012!\t!\u0018\u0005\u0006=\u0012!\te\u0018\u0005\bG\u0012\t\t\u0011\"\u0011e\u0011\u001diG!!A\u0005\u00029DqA\u001d\u0003\u0002\u0002\u0013\u00051\u000fC\u0004z\t\u0005\u0005I\u0011\t>\t\u0013\u0005\rA!!A\u0005\u0002\u0005\u0015\u0001\"CA\u0005\t\u0005\u0005I\u0011IA\u0006\u0011%\ti\u0001BA\u0001\n\u0003\ny\u0001C\u0005\u0002\u0012\u0011\t\t\u0011\"\u0003\u0002\u0014!9\u00111D\u0001\u0005\u0002\u0005u\u0001bBAj\u0003\u0011\u0005\u0011Q\u001b\u0005\b\u00037\u000bA\u0011AA}\u0011\u001d\t\u0019.\u0001C\u0001\u0005+AqAa\u000f\u0002\t\u0003\u0011iD\u0002\u00049Q\u0001\u0011\u0014Q\u0005\u0005\nWQ\u0011)\u0019!C\u0001\u0003#B!\"a\u0015\u0015\u0005\u0003\u0005\u000b\u0011BA\"\u0011)ICC!b\u0001\n\u0003A\u0013Q\u000b\u0005\u000b\u0003O\"\"\u0011!Q\u0001\n\u0005]\u0003B\u0002!\u0015\t\u0013\tI\u0007C\u0005\u0002rQ\u0011\r\u0011\"\u0001\u0002t!A\u0011Q\u000f\u000b!\u0002\u0013\t\t\u0004C\u0003_)\u0011\u0005s\fC\u0005\u0002xQ\u0011\r\u0011\"\u0011\u0002z!A\u0011\u0011\u0012\u000b!\u0002\u0013\tY\b\u0003\u0005\u0002\fR\u0011\r\u0011\"\u0001`\u0011\u001d\ti\t\u0006Q\u0001\n\u0001Dq!a$\u0015\t\u0003\t\t\n\u0003\u0004\u0002\u001aR!\tA\u001c\u0005\b\u00037#B\u0011IAO\u0011\u001d\tY\n\u0006C\u0001\u0003SCq!!,\u0015\t\u0003\ty\u000bC\u0004\u0002>R!\t!a0\u0002\u001fUs'\r\\8dW\u0016$'+Z1eKJT!!\u000b\u0016\u0002\rI,\u0017\rZ3s\u0015\tYC&A\u0003cY>\u001c7N\u0003\u0002.]\u0005\t\u0011M\u0003\u00020a\u00051am\u001c:nCRT!!\r\u001a\u0002\u000fM,w-\\3oi*\u00111\u0007N\u0001\u0005G>\u0014XMC\u00016\u0003\u0019\u0019x/Y=eEB\u0011q'A\u0007\u0002Q\tyQK\u001c2m_\u000e\\W\r\u001a*fC\u0012,'o\u0005\u0002\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002m\u0005!a*\u001e7m!\t)E!D\u0001\u0002\u0005\u0011qU\u000f\u001c7\u0014\u000b\u0011Q\u0004JT)\u0011\t]J5jS\u0005\u0003\u0015\"\u0012Q#\u00168cY>\u001c7.\u001a3SK\u0006$WM](qi&|g\u000e\u0005\u0002<\u0019&\u0011Q\n\u0010\u0002\b\u001d>$\b.\u001b8h!\tYt*\u0003\u0002Qy\t9\u0001K]8ek\u000e$\bC\u0001*[\u001d\t\u0019\u0006L\u0004\u0002U/6\tQK\u0003\u0002W\u0003\u00061AH]8pizJ\u0011!P\u0005\u00033r\nq\u0001]1dW\u0006<W-\u0003\u0002\\9\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011\f\u0010\u000b\u0002\t\u00061\u0011n\u001d(p]\u0016,\u0012\u0001\u0019\t\u0003w\u0005L!A\u0019\u001f\u0003\u000f\t{w\u000e\\3b]\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fA\u0001\\1oO*\t!.\u0001\u0003kCZ\f\u0017B\u00017h\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\tq\u000e\u0005\u0002<a&\u0011\u0011\u000f\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0003i^\u0004\"aO;\n\u0005Yd$aA!os\"9\u00010CA\u0001\u0002\u0004y\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001|!\rax\u0010^\u0007\u0002{*\u0011a\u0010P\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0001{\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0001\u0017q\u0001\u0005\bq.\t\t\u00111\u0001u\u0003!A\u0017m\u001d5D_\u0012,G#A8\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!Z\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003+\u00012AZA\f\u0013\r\tIb\u001a\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b\u0015l\u0007\u000f^=\u0016\r\u0005}\u00111YAd)\u0011\t\t#!5\u0015\t\u0005\r\u0012Q\u001a\t\u0007oQ\t\t-!2\u0016\r\u0005\u001d\u0012QGA#'\u0019!\"(!\u000b\u00020A\u0019q'a\u000b\n\u0007\u00055\u0002FA\bCY>\u001c7NU3bI\u0016\u0014()Y:f!\u00199\u0014*!\r\u0002DA!\u00111GA\u001b\u0019\u0001!q!a\u000e\u0015\u0005\u0004\tIDA\u0001P#\rY\u00151\b\t\u0005\u0003{\ty$D\u0001+\u0013\r\t\tE\u000b\u0002\f\u00052|7m[(gMN,G\u000f\u0005\u0003\u00024\u0005\u0015CaBA$)\t\u0007\u0011\u0011\n\u0002\u0002\u0005F\u00191*a\u0013\u0011\r\u0005u\u0012QJA\u0019\u0013\r\tyE\u000b\u0002\u0006\u00052|7m[\u000b\u0003\u0003\u0007\naA\u00197pG.\u0004SCAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nQa\u001d7jG\u0016T1!!\u00195\u0003\u0011!\u0017\r^1\n\t\u0005\u0015\u00141\f\u0002\u0007%\u0016\fG-\u001a:\u0002\u000fI,\u0017\rZ3sAQ1\u00111NA7\u0003_\u0002ba\u000e\u000b\u00022\u0005\r\u0003BB\u0016\u001a\u0001\u0004\t\u0019\u0005\u0003\u0004*3\u0001\u0007\u0011qK\u0001\u0007_\u001a47/\u001a;\u0016\u0005\u0005E\u0012aB8gMN,G\u000fI\u0001\u0006gR\fG/Z\u000b\u0003\u0003w\u0002B!! \u0002\u0004:\u0019q'a \n\u0007\u0005\u0005\u0005&A\u0006CY>\u001c7NU3bI\u0016\u0014\u0018\u0002BAC\u0003\u000f\u0013Qa\u0015;bi\u0016T1!!!)\u0003\u0019\u0019H/\u0019;fA\u0005i\u0001.Y:CY>\u001c7nQ1dQ\u0016\fa\u0002[1t\u00052|7m[\"bG\",\u0007%A\u0005cY>\u001c7nU5{KV\u0011\u00111\u0013\t\u0005w\u0005Uu.C\u0002\u0002\u0018r\u0012aa\u00149uS>t\u0017aH;oI\u0016\u0014H._5oO\u0006\u0013(/Y=TSj,wJ\u001d*fC\u0012,'oU5{K\u00061Qn\u001c<f)>$B!a\u001b\u0002 \"9\u0011\u0011U\u0012A\u0002\u0005\r\u0016a\u00038foB{7/\u001b;j_:\u00042aOAS\u0013\r\t9\u000b\u0010\u0002\u0005\u0019>tw\r\u0006\u0003\u0002l\u0005-\u0006BBAQI\u0001\u0007q.A\nsK\u0006$\u0017\t\u001c7B]\u0012<U\r\u001e*fC\u0012,'\u000f\u0006\u0002\u00022R!\u00111NAZ\u0011\u001d\t),\na\u0002\u0003o\u000b\u0001B\u00197pG.|\u0005o\u001d\t\t\u0003{\tI,!\r\u0002D%\u0019\u00111\u0018\u0016\u0003\u0011\tcwnY6PaN\fAaY8qsR\u0011\u00111\u000e\t\u0005\u0003g\t\u0019\rB\u0004\u00028=\u0011\r!!\u000f\u0011\t\u0005M\u0012q\u0019\u0003\b\u0003\u000fz!\u0019AAe#\rY\u00151\u001a\t\u0007\u0003{\ti%!1\t\u000f\u0005Uv\u0002q\u0001\u0002PBA\u0011QHA]\u0003\u0003\f)\r\u0003\u0004,\u001f\u0001\u0007\u0011QY\u0001\u0006CB\u0004H._\u000b\u0007\u0003/\fi.!9\u0015\r\u0005e\u0017q]Au!\u00199D#a7\u0002`B!\u00111GAo\t\u001d\t9\u0004\u0005b\u0001\u0003s\u0001B!a\r\u0002b\u00129\u0011q\t\tC\u0002\u0005\r\u0018cA&\u0002fB1\u0011QHA'\u00037Daa\u000b\tA\u0002\u0005}\u0007bBAv!\u0001\u0007\u0011Q^\u0001\u0006Ef$Xm\u001d\t\u0007\u00033\ny/a=\n\t\u0005E\u00181\f\u0002\u0006'2L7-\u001a\t\u0004w\u0005U\u0018bAA|y\t!!)\u001f;f+\u0019\tYPa\u0001\u0003\bQ1\u0011Q B\t\u0005'!B!a@\u0003\u000eA1q\u0007\u0006B\u0001\u0005\u000b\u0001B!a\r\u0003\u0004\u00119\u0011qG\tC\u0002\u0005e\u0002\u0003BA\u001a\u0005\u000f!q!a\u0012\u0012\u0005\u0004\u0011I!E\u0002L\u0005\u0017\u0001b!!\u0010\u0002N\t\u0005\u0001bBA[#\u0001\u000f!q\u0002\t\t\u0003{\tIL!\u0001\u0003\u0006!9\u0011\u0011O\tA\u0002\t\u0005\u0001BB\u0015\u0012\u0001\u0004\ty0\u0006\u0004\u0003\u0018\t}!1\u0005\u000b\u0007\u00053\u0011iCa\u000e\u0015\t\tm!\u0011\u0006\t\u0007oQ\u0011iB!\t\u0011\t\u0005M\"q\u0004\u0003\b\u0003o\u0011\"\u0019AA\u001d!\u0011\t\u0019Da\t\u0005\u000f\u0005\u001d#C1\u0001\u0003&E\u00191Ja\n\u0011\r\u0005u\u0012Q\nB\u000f\u0011\u001d\t)L\u0005a\u0002\u0005W\u0001\u0002\"!\u0010\u0002:\nu!\u0011\u0005\u0005\b\u0005_\u0011\u0002\u0019\u0001B\u0019\u00035\u0011Gn\\2lK\u0012\u0014V-\u00193feB9qGa\r\u0003\u001e\t\u0005\u0012b\u0001B\u001bQ\ti!\t\\8dW\u0016$'+Z1eKJDaA!\u000f\u0013\u0001\u0004\u0001\u0017!\u0006:fC\u0012\fE\u000e\\%g+:\u001cw.\u001c9sKN\u001cX\rZ\u0001\u0011MJ|W.\u00168d_6\u0004(/Z:tK\u0012,bAa\u0010\u0003F\t%C\u0003\u0002B!\u0005\u001f\u0002ba\u000e\u000b\u0003D\t\u001d\u0003\u0003BA\u001a\u0005\u000b\"q!a\u000e\u0014\u0005\u0004\tI\u0004\u0005\u0003\u00024\t%CaBA$'\t\u0007!1J\t\u0004\u0017\n5\u0003CBA\u001f\u0003\u001b\u0012\u0019\u0005C\u0004\u00030M\u0001\rA!\u0015\u0011\u000f]\u0012\u0019Da\u0011\u0003H\u0001")
public class UnblockedReader<O extends BlockOffset, B extends Block<O>>
implements BlockReaderBase,
UnblockedReaderOption<O, B> {
    private final B block;
    private final Reader reader;
    private final O offset;
    private final BlockReader.State state;
    private final boolean hasBlockCache;
    private boolean isFile;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <O extends BlockOffset, B extends Block<O>> UnblockedReader<O, B> fromUncompressed(BlockedReader<O, B> blockedReader) {
        return UnblockedReader$.MODULE$.fromUncompressed(blockedReader);
    }

    public static <O extends BlockOffset, B extends Block<O>> UnblockedReader<O, B> apply(BlockedReader<O, B> blockedReader, boolean bl, BlockOps<O, B> blockOps) {
        return Block$.MODULE$.unblock(blockedReader, bl, blockOps);
    }

    public static <O extends BlockOffset, B extends Block<O>> UnblockedReader<O, B> apply(B b, Slice<Object> slice) {
        return UnblockedReader$.MODULE$.apply(b, slice);
    }

    public static <O extends BlockOffset, B extends Block<O>> UnblockedReader<O, B> empty(B b, BlockOps<O, B> blockOps) {
        return UnblockedReader$.MODULE$.empty(b, blockOps);
    }

    @Override
    public boolean isSome() {
        return UnblockedReaderOption.isSome$(this);
    }

    @Override
    public Path path() {
        return BlockReaderBase.path$(this);
    }

    @Override
    public long size() {
        return BlockReaderBase.size$(this);
    }

    @Override
    public boolean hasMore() {
        return BlockReaderBase.hasMore$(this);
    }

    @Override
    public boolean hasAtLeast(long atLeastSize) {
        return BlockReaderBase.hasAtLeast$(this, atLeastSize);
    }

    @Override
    public int getPosition() {
        return BlockReaderBase.getPosition$(this);
    }

    @Override
    public byte get() {
        return BlockReaderBase.get$(this);
    }

    @Override
    public Slice<Object> read(int size) {
        return BlockReaderBase.read$(this, size);
    }

    @Override
    public Slice<Object> readFullBlock() {
        return BlockReaderBase.readFullBlock$(this);
    }

    @Override
    public SliceOption<Object> readFullBlockOrNone() {
        return BlockReaderBase.readFullBlockOrNone$(this);
    }

    @Override
    public Slice<Object> readRemaining() {
        return BlockReaderBase.readRemaining$(this);
    }

    public Slice<Object> read(long size) {
        return ReaderBase.read$((ReaderBase)this, (long)size);
    }

    public ReaderBase skip(long skip) {
        return ReaderBase.skip$((ReaderBase)this, (long)skip);
    }

    public boolean readBoolean() {
        return ReaderBase.readBoolean$((ReaderBase)this);
    }

    public int readInt() {
        return ReaderBase.readInt$((ReaderBase)this);
    }

    public int readInt(boolean unsigned) {
        return ReaderBase.readInt$((ReaderBase)this, (boolean)unsigned);
    }

    public int readUnsignedInt() {
        return ReaderBase.readUnsignedInt$((ReaderBase)this);
    }

    public Tuple2<Object, Object> readUnsignedIntWithByteSize() {
        return ReaderBase.readUnsignedIntWithByteSize$((ReaderBase)this);
    }

    public int readNonZeroUnsignedInt() {
        return ReaderBase.readNonZeroUnsignedInt$((ReaderBase)this);
    }

    public int readNonZeroStrictUnsignedInt() {
        return ReaderBase.readNonZeroStrictUnsignedInt$((ReaderBase)this);
    }

    public Tuple2<Object, Object> readNonZeroUnsignedIntWithByteSize() {
        return ReaderBase.readNonZeroUnsignedIntWithByteSize$((ReaderBase)this);
    }

    public Slice<Object> readUnsignedIntSized() {
        return ReaderBase.readUnsignedIntSized$((ReaderBase)this);
    }

    public int readSignedInt() {
        return ReaderBase.readSignedInt$((ReaderBase)this);
    }

    public long readLong() {
        return ReaderBase.readLong$((ReaderBase)this);
    }

    public long readUnsignedLong() {
        return ReaderBase.readUnsignedLong$((ReaderBase)this);
    }

    public long readSignedLong() {
        return ReaderBase.readSignedLong$((ReaderBase)this);
    }

    public String readRemainingAsString(Charset charset) {
        return ReaderBase.readRemainingAsString$((ReaderBase)this, (Charset)charset);
    }

    public Charset readRemainingAsString$default$1() {
        return ReaderBase.readRemainingAsString$default$1$((ReaderBase)this);
    }

    public String readString(int size, Charset charset) {
        return ReaderBase.readString$((ReaderBase)this, (int)size, (Charset)charset);
    }

    public Charset readString$default$2() {
        return ReaderBase.readString$default$2$((ReaderBase)this);
    }

    public long remaining() {
        return ReaderBase.remaining$((ReaderBase)this);
    }

    public ReaderBase reset() {
        return ReaderBase.reset$((ReaderBase)this);
    }

    public final <E, R> IO<E, R> foldLeftIO(R result, Function2<R, ReaderBase, IO<E, R>> f, IO.ExceptionHandler<E> evidence$1) {
        return ReaderBase.foldLeftIO$((ReaderBase)this, result, f, evidence$1);
    }

    public final <R> R foldLeft(R result, Function2<R, ReaderBase, R> f) {
        return (R)ReaderBase.foldLeft$((ReaderBase)this, result, f);
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public void swaydb$core$segment$format$a$block$reader$BlockReaderBase$_setter_$isFile_$eq(boolean x$1) {
        this.isFile = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public B block() {
        return this.block;
    }

    @Override
    public Reader reader() {
        return this.reader;
    }

    public O offset() {
        return this.offset;
    }

    @Override
    public boolean isNone() {
        return false;
    }

    @Override
    public BlockReader.State state() {
        return this.state;
    }

    public boolean hasBlockCache() {
        return this.hasBlockCache;
    }

    public Option<Object> blockSize() {
        None$ none$;
        Reader reader = this.reader();
        if (reader instanceof FileReader) {
            none$ = ((FileReader)reader).file().blockSize();
        } else if (reader instanceof SliceReader) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)reader);
        }
        return none$;
    }

    public int underlyingArraySizeOrReaderSize() {
        int n;
        Reader reader = this.reader();
        if (reader instanceof FileReader) {
            n = (int)((FileReader)reader).size();
        } else if (reader instanceof SliceReader) {
            n = ((SliceReader)reader).slice().underlyingArraySize();
        } else {
            throw new MatchError((Object)reader);
        }
        return n;
    }

    public UnblockedReader<O, B> moveTo(long newPosition) {
        this.state().moveTo((int)newPosition);
        return this;
    }

    public UnblockedReader<O, B> moveTo(int newPosition) {
        this.state().moveTo(newPosition);
        return this;
    }

    public UnblockedReader<O, B> readAllAndGetReader(BlockOps<O, B> blockOps) {
        Slice<Object> bytes = this.readFullBlock();
        B x$2 = blockOps.updateBlockOffset(this.block(), 0, bytes.size());
        return UnblockedReader$.MODULE$.apply(x$2, bytes);
    }

    public UnblockedReader<O, B> copy() {
        return new UnblockedReader<O, B>(this.block(), this.reader().copy());
    }

    public UnblockedReader(B block, Reader reader) {
        this.block = block;
        this.reader = reader;
        LazyLogging.$init$((LazyLogging)this);
        BlockReaderBase.$init$(this);
        this.offset = block.offset();
        this.state = BlockReader$.MODULE$.apply((BlockOffset)this.offset(), reader);
        this.hasBlockCache = this.blockSize().isDefined();
        Statics.releaseFence();
    }
}

