/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.segment.format.a.block.values;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import swaydb.Error;
import swaydb.IO;
import swaydb.compression.CompressionInternal;
import swaydb.core.data.Memory;
import swaydb.core.segment.format.a.block.Block;
import swaydb.core.segment.format.a.block.Block$;
import swaydb.core.segment.format.a.block.reader.UnblockedReader;
import swaydb.core.segment.format.a.block.reader.UnblockedReader$;
import swaydb.core.segment.format.a.block.values.ValuesBlock;
import swaydb.core.segment.format.a.block.values.ValuesBlock$Offset$;
import swaydb.core.segment.format.a.block.values.ValuesBlock$ValuesBlockOps$;
import swaydb.core.segment.format.a.entry.writer.EntryWriter;
import swaydb.core.segment.merge.MergeStats;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;

public final class ValuesBlock$
implements Serializable {
    public static final ValuesBlock$ MODULE$ = new ValuesBlock$();
    private static final String blockName = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(MODULE$.getClass().getSimpleName()), 1);
    private static final ValuesBlock empty = new ValuesBlock(ValuesBlock$Offset$.MODULE$.zero(), 0, (Option<Block.CompressionInfo>)None$.MODULE$);
    private static final UnblockedReader<ValuesBlock.Offset, ValuesBlock> emptyUnblocked = UnblockedReader$.MODULE$.empty(MODULE$.empty(), ValuesBlock$ValuesBlockOps$.MODULE$);
    private static final IO<Error.Segment, UnblockedReader<ValuesBlock.Offset, ValuesBlock>> emptyUnblockedIO = new IO.Right(MODULE$.emptyUnblocked(), (IO.ExceptionHandler)Error.Segment$.ExceptionHandler$.MODULE$);

    public String blockName() {
        return blockName;
    }

    public ValuesBlock empty() {
        return empty;
    }

    public UnblockedReader<ValuesBlock.Offset, ValuesBlock> emptyUnblocked() {
        return emptyUnblocked;
    }

    public IO<Error.Segment, UnblockedReader<ValuesBlock.Offset, ValuesBlock>> emptyUnblockedIO() {
        return emptyUnblockedIO;
    }

    public IO.Left<Error.Segment, Nothing$> valuesBlockNotInitialised() {
        return new IO.Left((Object)Error.Fatal$.MODULE$.apply("Value block not initialised."), (IO.ExceptionHandler)Error.Fatal$.ExceptionHandler$.MODULE$);
    }

    public Option<ValuesBlock.State> init(MergeStats.Persistent.Closed<Iterable> keyValues, ValuesBlock.Config valuesConfig, EntryWriter.Builder builder) {
        int totalValuesSize = keyValues.totalValuesSize();
        if (totalValuesSize > 0) {
            Slice slice;
            Slice slice2;
            Slice slice3;
            boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
            ManifestFactory.ByteManifest create_evidence$3 = ClassTag$.MODULE$.Byte();
            Slice slice4 = slice3 = new Slice(create_evidence$3.newArray(totalValuesSize), 0, totalValuesSize == 0 ? -1 : totalValuesSize - 1, bl ? totalValuesSize : 0, (ClassTag)create_evidence$3);
            slice3 = null;
            Slice slice5 = slice2 = slice4;
            slice2 = null;
            Slice slice6 = slice = slice5;
            Object var7_6 = null;
            slice = null;
            Slice bytes = slice6;
            ValuesBlock.State state = new ValuesBlock.State((Slice<Object>)bytes, (Slice<Object>)bytes, null, valuesConfig.compressions(), builder);
            return new Some((Object)state);
        }
        return None$.MODULE$;
    }

    public ValuesBlock.State init(Slice<Object> bytes, ValuesBlock.Config valuesConfig, EntryWriter.Builder builder) {
        return new ValuesBlock.State(bytes, bytes, null, valuesConfig.compressions(), builder);
    }

    public void write(Memory keyValue, ValuesBlock.State state) {
        if (state.builder().isValueFullyCompressed()) {
            state.builder().isValueFullyCompressed_$eq(false);
            return;
        }
        keyValue.value().foreachC(arg_0 -> ValuesBlock$.$anonfun$write$1(SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, state.compressibleBytes()), arg_0));
    }

    public ValuesBlock.State close(ValuesBlock.State state) {
        int apply__uncompressedSize = state.compressibleBytes().size();
        Block.CompressionResult compressionResult = Block$.MODULE$.compress(state.compressibleBytes(), (Seq<CompressionInternal>)((Seq)state.compressions().apply((Object)new /* Unavailable Anonymous Inner Class!! */)), this.blockName());
        compressionResult.compressedBytes().foreach((Function1 & Serializable)x$4 -> {
            state.compressibleBytes_$eq((Slice<Object>)x$4);
            return BoxedUnit.UNIT;
        });
        compressionResult.fixHeaderSize();
        state.header_$eq(compressionResult.headerBytes());
        return state;
    }

    public UnblockedReader<ValuesBlock.Offset, ValuesBlock> unblockedReader(ValuesBlock.State closedState) {
        ValuesBlock block = new ValuesBlock(new ValuesBlock.Offset(0, closedState.cacheableBytes().size()), 0, (Option<Block.CompressionInfo>)None$.MODULE$);
        return UnblockedReader$.MODULE$.apply(block, (Slice<Object>)closedState.cacheableBytes().close());
    }

    public ValuesBlock read(Block.Header<ValuesBlock.Offset> header) {
        return new ValuesBlock(header.offset(), header.headerSize(), header.compressionInfo());
    }

    public Option<Slice<Object>> read(int fromOffset, int length, UnblockedReader<ValuesBlock.Offset, ValuesBlock> reader) {
        if (length == 0) {
            return None$.MODULE$;
        }
        if (fromOffset < 0) {
            String throwable_message = new StringBuilder(36).append("Cannot read from negative offset '").append(fromOffset).append("'.").toString();
            Object var5_4 = null;
            throw new Exception(throwable_message);
        }
        Slice<Object> slice = reader.moveTo(fromOffset).read(length);
        if (slice.size() != length) {
            String throwable_message = new StringBuilder(35).append("Read value bytes != expected. ").append(slice.size()).append(" != ").append(length).append(".").toString();
            Object var6_6 = null;
            throw new Exception(throwable_message);
        }
        return new Some(slice);
    }

    public ValuesBlock apply(ValuesBlock.Offset offset, int headerSize, Option<Block.CompressionInfo> compressionInfo) {
        return new ValuesBlock(offset, headerSize, compressionInfo);
    }

    public Option<Tuple3<ValuesBlock.Offset, Object, Option<Block.CompressionInfo>>> unapply(ValuesBlock x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.offset(), (Object)BoxesRunTime.boxToInteger((int)x$0.headerSize()), x$0.compressionInfo()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ValuesBlock$.class);
    }

    public static final /* synthetic */ Slice $anonfun$write$1(SliceCompanionBase.SliceImplicit eta$0$1$1, Slice values) {
        return eta$0$1$1.addAll(values);
    }

    private ValuesBlock$() {
    }
}

