/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.util;

import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.ArraySeq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import swaydb.OK;
import swaydb.OK$;
import swaydb.core.data.KeyValue;
import swaydb.data.slice.ReaderBase;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;
import swaydb.data.slice.SliceReader;
import swaydb.data.util.Bytez;
import swaydb.data.util.Bytez$;

public final class Bytes$
implements Bytez {
    public static final Bytes$ MODULE$ = new Bytes$();
    private static final byte zero = (byte)0;
    private static final byte one = (byte)1;

    public void writeInt(int n, Slice<Object> slice) {
        Bytez.writeInt$((Bytez)this, (int)n, slice);
    }

    public int readInt(ReaderBase reader) {
        return Bytez.readInt$((Bytez)this, (ReaderBase)reader);
    }

    public int readInt(Slice<Object> bytes) {
        return Bytez.readInt$((Bytez)this, bytes);
    }

    public void writeLong(long l, Slice<Object> slice) {
        Bytez.writeLong$((Bytez)this, (long)l, slice);
    }

    public long readLong(Slice<Object> bytes) {
        return Bytez.readLong$((Bytez)this, bytes);
    }

    public long readLong(ReaderBase reader) {
        return Bytez.readLong$((Bytez)this, (ReaderBase)reader);
    }

    public boolean readBoolean(ReaderBase reader) {
        return Bytez.readBoolean$((Bytez)this, (ReaderBase)reader);
    }

    public String readString(ReaderBase reader, Charset charset) {
        return Bytez.readString$((Bytez)this, (ReaderBase)reader, (Charset)charset);
    }

    public String readString(int size, ReaderBase reader, Charset charset) {
        return Bytez.readString$((Bytez)this, (int)size, (ReaderBase)reader, (Charset)charset);
    }

    public String readString(Slice<Object> slice, Charset charset) {
        return Bytez.readString$((Bytez)this, slice, (Charset)charset);
    }

    public Slice<Object> writeString(String string, Slice<Object> bytes, Charset charsets) {
        return Bytez.writeString$((Bytez)this, (String)string, bytes, (Charset)charsets);
    }

    public void writeSignedInt(int x, Slice<Object> slice) {
        Bytez.writeSignedInt$((Bytez)this, (int)x, slice);
    }

    public int readSignedInt(ReaderBase reader) {
        return Bytez.readSignedInt$((Bytez)this, (ReaderBase)reader);
    }

    public int readSignedInt(Slice<Object> slice) {
        return Bytez.readSignedInt$((Bytez)this, slice);
    }

    public void writeUnsignedInt(int n, Slice<Object> slice) {
        Bytez.writeUnsignedInt$((Bytez)this, (int)n, slice);
    }

    public Slice<Object> writeUnsignedIntNonZero(int n) {
        return Bytez.writeUnsignedIntNonZero$((Bytez)this, (int)n);
    }

    public void writeUnsignedIntNonZero(int n, Slice<Object> slice) {
        Bytez.writeUnsignedIntNonZero$((Bytez)this, (int)n, slice);
    }

    public int readUnsignedIntNonZero(Slice<Object> slice) {
        return Bytez.readUnsignedIntNonZero$((Bytez)this, slice);
    }

    public int readUnsignedIntNonZero(ReaderBase reader) {
        return Bytez.readUnsignedIntNonZero$((Bytez)this, (ReaderBase)reader);
    }

    public int readUnsignedIntNonZeroStrict(ReaderBase reader) {
        return Bytez.readUnsignedIntNonZeroStrict$((Bytez)this, (ReaderBase)reader);
    }

    public Tuple2<Object, Object> readUnsignedIntNonZeroWithByteSize(Slice<Object> slice) {
        return Bytez.readUnsignedIntNonZeroWithByteSize$((Bytez)this, slice);
    }

    public Tuple2<Object, Object> readUnsignedIntNonZeroWithByteSize(ReaderBase reader) {
        return Bytez.readUnsignedIntNonZeroWithByteSize$((Bytez)this, (ReaderBase)reader);
    }

    public Slice<Object> writeUnsignedIntReversed(int n) {
        return Bytez.writeUnsignedIntReversed$((Bytez)this, (int)n);
    }

    public int readUnsignedInt(ReaderBase reader) {
        return Bytez.readUnsignedInt$((Bytez)this, (ReaderBase)reader);
    }

    public int readUnsignedInt(SliceReader sliceReader) {
        return Bytez.readUnsignedInt$((Bytez)this, (SliceReader)sliceReader);
    }

    public int readUnsignedInt(Slice<Object> slice) {
        return Bytez.readUnsignedInt$((Bytez)this, slice);
    }

    public Tuple2<Object, Object> readUnsignedIntWithByteSize(Slice<Object> slice) {
        return Bytez.readUnsignedIntWithByteSize$((Bytez)this, slice);
    }

    public Tuple2<Object, Object> readUnsignedIntWithByteSize(ReaderBase reader) {
        return Bytez.readUnsignedIntWithByteSize$((Bytez)this, (ReaderBase)reader);
    }

    public Tuple2<Object, Object> readUnsignedIntWithByteSize(SliceReader reader) {
        return Bytez.readUnsignedIntWithByteSize$((Bytez)this, (SliceReader)reader);
    }

    public Tuple2<Object, Object> readLastUnsignedInt(Slice<Object> slice) {
        return Bytez.readLastUnsignedInt$((Bytez)this, slice);
    }

    public void writeSignedLong(long l, Slice<Object> slice) {
        Bytez.writeSignedLong$((Bytez)this, (long)l, slice);
    }

    public long readSignedLong(ReaderBase reader) {
        return Bytez.readSignedLong$((Bytez)this, (ReaderBase)reader);
    }

    public long readSignedLong(Slice<Object> slice) {
        return Bytez.readSignedLong$((Bytez)this, slice);
    }

    public void writeUnsignedLong(long l, Slice<Object> slice) {
        Bytez.writeUnsignedLong$((Bytez)this, (long)l, slice);
    }

    public long readUnsignedLong(ReaderBase reader) {
        return Bytez.readUnsignedLong$((Bytez)this, (ReaderBase)reader);
    }

    public long readUnsignedLong(Slice<Object> slice) {
        return Bytez.readUnsignedLong$((Bytez)this, slice);
    }

    public Tuple2<Object, Object> readUnsignedLongWithByteSize(Slice<Object> slice) {
        return Bytez.readUnsignedLongWithByteSize$((Bytez)this, slice);
    }

    public byte zero() {
        return zero;
    }

    public byte one() {
        return one;
    }

    public int commonPrefixBytesCount(Slice<Object> previous, Slice<Object> next) {
        int i;
        int min = Math.min(previous.size(), next.size());
        for (i = 0; i < min && BoxesRunTime.unboxToByte((Object)previous.apply(i)) == BoxesRunTime.unboxToByte((Object)next.apply(i)); ++i) {
        }
        return i;
    }

    public Slice<Object> commonPrefixBytes(Slice<Object> previous, Slice<Object> next) {
        int commonBytes = this.commonPrefixBytesCount(previous, next);
        if (previous.size() <= next.size()) {
            return next.take(commonBytes);
        }
        return previous.take(commonBytes);
    }

    public Option<Tuple2<Object, Slice<Object>>> compress(Slice<Object> key, KeyValue previous, int minimumCommonBytes) {
        return this.compress(previous.key(), key, minimumCommonBytes);
    }

    public Option<Tuple2<Object, Slice<Object>>> compress(Slice<Object> previous, Slice<Object> next, int minimumCommonBytes) {
        int commonBytes = this.commonPrefixBytesCount(previous, next);
        if (commonBytes < minimumCommonBytes) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)commonBytes), (Object)next.drop(commonBytes)));
    }

    public Option<OK> compressFull(Option<Slice<Object>> previous2, Slice<Object> next) {
        return previous2.flatMap((Function1 & Serializable)previous -> MODULE$.compressFull((Slice<Object>)previous, next));
    }

    public Option<OK> compressFull(Slice<Object> previous, Slice<Object> next) {
        if (previous.size() < next.size()) {
            return None$.MODULE$;
        }
        return this.compress(previous, next, next.size()).map((Function1 & Serializable)x$1 -> OK$.MODULE$.instance());
    }

    public Option<OK> compressExact(Slice<Object> previous, Slice<Object> next) {
        if (previous.size() != next.size()) {
            return None$.MODULE$;
        }
        return this.compressFull(previous, next);
    }

    public Slice<Object> decompress(Slice<Object> previous, Slice<Object> next, int commonBytes) {
        int i;
        Slice missingCommonBytes = previous.slice(0, commonBytes - 1);
        byte[] fullKey = new byte[commonBytes + next.size()];
        for (i = 0; i < commonBytes; ++i) {
            fullKey[i] = BoxesRunTime.unboxToByte((Object)missingCommonBytes.apply(i));
        }
        int x = 0;
        while (x < next.size()) {
            fullKey[i] = BoxesRunTime.unboxToByte((Object)next.apply(x));
            ++x;
            ++i;
        }
        ManifestFactory.ByteManifest apply_evidence$4 = ClassTag$.MODULE$.Byte();
        return SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)fullKey, (ClassTag)apply_evidence$4);
    }

    public int sizeOfUnsignedInt(int n) {
        if (n < 0) {
            return 5;
        }
        if (n < 128) {
            return 1;
        }
        if (n < 16384) {
            return 2;
        }
        if (n < 0x200000) {
            return 3;
        }
        if (n < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public int sizeOfUnsignedLong(long l) {
        if (l < 0L) {
            return 10;
        }
        if (l < 128L) {
            return 1;
        }
        if (l < 16384L) {
            return 2;
        }
        if (l < 0x200000L) {
            return 3;
        }
        if (l < 0x10000000L) {
            return 4;
        }
        if (l < 0x800000000L) {
            return 5;
        }
        if (l < 0x40000000000L) {
            return 6;
        }
        if (l < 0x2000000000000L) {
            return 7;
        }
        if (l < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public Slice<Object> compressJoin(Slice<Object> left, Slice<Object> right) {
        return this.compressJoin(left, right, (Slice<Object>)Slice$.MODULE$.emptyBytes());
    }

    /*
     * WARNING - void declaration
     */
    public Slice<Object> compressJoin(Slice<Object> left, Slice<Object> right, byte tail) {
        void apply_evidence$7;
        ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
        ArraySeq apply_data = ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{tail});
        Object var4_5 = null;
        byteManifest = null;
        return this.compressJoin(left, right, (Slice<Object>)SliceCompanionBase.apply$((SliceCompanionBase)Slice$.MODULE$, (Object)apply_data.toArray((ClassTag)apply_evidence$7), (ClassTag)apply_evidence$7));
    }

    /*
     * WARNING - void declaration
     */
    public Slice<Object> compressJoin(Slice<Object> left, Slice<Object> right, Slice<Object> tail) {
        void addAll_values;
        void writeUnsignedIntReversed_int;
        Slice slice;
        void addUnsignedInt_int;
        Slice slice2;
        Slice slice3;
        Slice slice4;
        Slice rightWithoutCommonBytes;
        int commonBytes = this.commonPrefixBytesCount(left, right);
        Slice slice5 = rightWithoutCommonBytes = commonBytes != 0 ? right.drop(commonBytes) : right;
        if (rightWithoutCommonBytes.isEmpty()) {
            void addAll_values2;
            void writeUnsignedIntReversed_int2;
            Slice slice6;
            Slice slice7;
            Slice slice8;
            void create_evidence$3;
            Slice slice9;
            boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
            ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
            int create_length = left.size() + this.sizeOfUnsignedInt(commonBytes) + this.sizeOfUnsignedInt(left.size()) + tail.size();
            Slice slice10 = slice9 = new Slice(create_evidence$3.newArray(create_length), 0, create_length == 0 ? -1 : create_length - 1, bl ? create_length : 0, (ClassTag)create_evidence$3);
            slice9 = null;
            Slice slice11 = slice8 = slice10;
            slice8 = null;
            Slice slice12 = slice7 = slice11;
            byteManifest = null;
            slice7 = null;
            Slice compressedSlice = slice12;
            SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
            if (sliceImplicit == null) {
                throw null;
            }
            SliceCompanionBase.SliceImplicit addAll_this = sliceImplicit;
            if (left.nonEmpty()) {
                addAll_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll(left);
            }
            Slice cfr_ignored_0 = addAll_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            Object var12_13 = null;
            SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
            if (byteSliceImplicits == null) {
                throw null;
            }
            SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this = byteSliceImplicits;
            Slice addUnsignedInt_writeUnsignedInt_slice = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)commonBytes, (Slice)addUnsignedInt_writeUnsignedInt_slice);
            Slice cfr_ignored_1 = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
            Object var13_14 = null;
            Object var14_15 = null;
            SliceCompanionBase.SliceImplicit sliceImplicit2 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
            int n = left.size();
            Bytez$ writeUnsignedIntReversed_this = Bytez$.MODULE$;
            Slice slice13 = slice6 = Bytez.writeUnsignedIntReversed$((Bytez)writeUnsignedIntReversed_this, (int)writeUnsignedIntReversed_int2);
            Object var31_17 = null;
            slice6 = null;
            Slice slice14 = slice13;
            if (sliceImplicit2 == null) {
                throw null;
            }
            SliceCompanionBase.SliceImplicit addAll_this2 = sliceImplicit2;
            if (addAll_values2.nonEmpty()) {
                addAll_this2.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll((Iterable)addAll_values2);
            }
            Slice cfr_ignored_2 = addAll_this2.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            Object var15_20 = null;
            slice14 = null;
            SliceCompanionBase.SliceImplicit sliceImplicit3 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
            if (sliceImplicit3 == null) {
                throw null;
            }
            SliceCompanionBase.SliceImplicit addAll_this3 = sliceImplicit3;
            if (tail.nonEmpty()) {
                addAll_this3.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll(tail);
            }
            return addAll_this3.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
        }
        int size = left.size() + this.sizeOfUnsignedInt(commonBytes) + this.sizeOfUnsignedInt(rightWithoutCommonBytes.size()) + rightWithoutCommonBytes.size() + this.sizeOfUnsignedInt(left.size()) + tail.size();
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ManifestFactory.ByteManifest create_evidence$3 = ClassTag$.MODULE$.Byte();
        Slice slice15 = slice4 = new Slice(create_evidence$3.newArray(size), 0, size == 0 ? -1 : size - 1, bl ? size : 0, (ClassTag)create_evidence$3);
        slice4 = null;
        Slice slice16 = slice3 = slice15;
        slice3 = null;
        Slice slice17 = slice2 = slice16;
        Object var18_24 = null;
        slice2 = null;
        Slice compressedSlice = slice17;
        SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
        if (sliceImplicit == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit addAll_this = sliceImplicit;
        if (left.nonEmpty()) {
            addAll_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll(left);
        }
        Slice cfr_ignored_3 = addAll_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
        Object var20_29 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
        if (byteSliceImplicits == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this = byteSliceImplicits;
        Slice addUnsignedInt_writeUnsignedInt_slice = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)commonBytes, (Slice)addUnsignedInt_writeUnsignedInt_slice);
        Slice cfr_ignored_4 = addUnsignedInt_this.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var21_30 = null;
        Object var22_31 = null;
        SliceCompanionBase.ByteSliceImplicits byteSliceImplicits2 = SliceCompanionBase.ByteSliceImplicits$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
        int n = rightWithoutCommonBytes.size();
        if (byteSliceImplicits2 == null) {
            throw null;
        }
        SliceCompanionBase.ByteSliceImplicits addUnsignedInt_this2 = byteSliceImplicits2;
        Slice addUnsignedInt_writeUnsignedInt_slice2 = addUnsignedInt_this2.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Bytez.writeUnsignedInt$((Bytez)Bytez$.MODULE$, (int)addUnsignedInt_int, (Slice)addUnsignedInt_writeUnsignedInt_slice2);
        Slice cfr_ignored_5 = addUnsignedInt_this2.swaydb$data$slice$SliceCompanionBase$ByteSliceImplicits$$slice;
        Object var23_33 = null;
        Object var25_34 = null;
        SliceCompanionBase.SliceImplicit sliceImplicit4 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
        if (sliceImplicit4 == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit addAll_this4 = sliceImplicit4;
        if (rightWithoutCommonBytes.nonEmpty()) {
            addAll_this4.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll((Iterable)rightWithoutCommonBytes);
        }
        Slice cfr_ignored_6 = addAll_this4.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
        Object var26_35 = null;
        SliceCompanionBase.SliceImplicit sliceImplicit5 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
        int n2 = left.size();
        Bytez$ writeUnsignedIntReversed_this = Bytez$.MODULE$;
        Slice slice18 = slice = Bytez.writeUnsignedIntReversed$((Bytez)writeUnsignedIntReversed_this, (int)writeUnsignedIntReversed_int);
        Object var35_37 = null;
        slice = null;
        Slice slice19 = slice18;
        if (sliceImplicit5 == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit addAll_this5 = sliceImplicit5;
        if (addAll_values.nonEmpty()) {
            addAll_this5.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll((Iterable)addAll_values);
        }
        Slice cfr_ignored_7 = addAll_this5.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
        Object var27_40 = null;
        slice19 = null;
        SliceCompanionBase.SliceImplicit sliceImplicit6 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)compressedSlice);
        if (sliceImplicit6 == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit addAll_this6 = sliceImplicit6;
        if (tail.nonEmpty()) {
            addAll_this6.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll(tail);
        }
        return addAll_this6.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Slice<Object>, Slice<Object>> decompressJoin(Slice<Object> bytes) {
        Slice<Object> slice;
        void var5_7;
        void var4_6;
        SliceReader sliceReader;
        int n = 0;
        SliceReader sliceReader2 = sliceReader = new SliceReader(bytes, n);
        sliceReader = null;
        SliceReader reader = sliceReader2;
        Tuple2 tuple2 = Bytez.readLastUnsignedInt$((Bytez)Bytez$.MODULE$, bytes);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int leftBytesSize = tuple2._1$mcI$sp();
        int lastBytesRead = tuple2._2$mcI$sp();
        Slice<Object> left = reader.read((int)var4_6);
        int commonBytes = reader.readUnsignedInt();
        if (!reader.hasAtLeast((long)(var5_7 + true)) && commonBytes == var4_6) {
            slice = left;
        } else {
            int rightSize = reader.readUnsignedInt();
            Slice right = reader.read(rightSize);
            slice = this.decompress(left, (Slice<Object>)right, commonBytes);
        }
        Slice<Object> right = slice;
        return new Tuple2((Object)left, (Object)right);
    }

    /*
     * WARNING - void declaration
     */
    public Slice<Object> normalise(Slice<Object> bytes, int toSize) {
        void add_value;
        Slice slice;
        Slice slice2;
        Slice slice3;
        Predef$.MODULE$.assert(bytes.size() < toSize, (Function0 & Serializable)() -> new StringBuilder(24).append("bytes.size(").append(bytes.size()).append(") >= toSize(").append(toSize).append(")").toString());
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ManifestFactory.ByteManifest create_evidence$3 = ClassTag$.MODULE$.Byte();
        Slice slice4 = slice3 = new Slice(create_evidence$3.newArray(toSize), 0, toSize == 0 ? -1 : toSize - 1, bl ? toSize : 0, (ClassTag)create_evidence$3);
        slice3 = null;
        Slice slice5 = slice2 = slice4;
        slice2 = null;
        Slice slice6 = slice = slice5;
        Object var5_4 = null;
        slice = null;
        Slice finalSlice = slice6;
        for (int zeroesToAdd = toSize - bytes.size() - 1; zeroesToAdd > 0; --zeroesToAdd) {
            void add_value2;
            SliceCompanionBase.SliceImplicit add_this;
            Byte by = BoxesRunTime.boxToByte((byte)this.zero());
            if (SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)finalSlice) == null) {
                throw null;
            }
            add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value2);
            Slice cfr_ignored_0 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            Object var7_10 = null;
            by = null;
        }
        SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)finalSlice);
        Byte by = BoxesRunTime.boxToByte((byte)this.one());
        if (sliceImplicit == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit add_this = sliceImplicit;
        add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value);
        Slice cfr_ignored_1 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
        Object var9_13 = null;
        by = null;
        SliceCompanionBase.SliceImplicit sliceImplicit2 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)finalSlice);
        if (sliceImplicit2 == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit addAll_this = sliceImplicit2;
        if (bytes.nonEmpty()) {
            addAll_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll(bytes);
        }
        return addAll_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
    }

    /*
     * WARNING - void declaration
     */
    public Slice<Object> normalise(Slice<Object> appendHeader, Slice<Object> bytes, int toSize) {
        void add_value;
        Slice slice;
        Slice slice2;
        void create_evidence$3;
        Slice slice3;
        Predef$.MODULE$.assert(appendHeader.size() + bytes.size() < toSize, (Function0 & Serializable)() -> new StringBuilder(46).append("appendHeader.size(").append(appendHeader.size()).append(") + bytes.size(").append(bytes.size()).append(") >= toSize(").append(toSize).append(")").toString());
        boolean bl = SliceCompanionBase.create$default$2$((SliceCompanionBase)Slice$.MODULE$);
        ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
        int create_length = appendHeader.size() + toSize;
        Slice slice4 = slice3 = new Slice(create_evidence$3.newArray(create_length), 0, create_length == 0 ? -1 : create_length - 1, bl ? create_length : 0, (ClassTag)create_evidence$3);
        slice3 = null;
        Slice slice5 = slice2 = slice4;
        slice2 = null;
        Slice slice6 = slice = slice5;
        byteManifest = null;
        slice = null;
        Slice finalSlice = slice6;
        SliceCompanionBase.SliceImplicit sliceImplicit = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)finalSlice);
        if (sliceImplicit == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit addAll_this = sliceImplicit;
        if (appendHeader.nonEmpty()) {
            addAll_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll(appendHeader);
        }
        Slice cfr_ignored_0 = addAll_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
        Object var9_11 = null;
        for (int zeroesToAdd = toSize - appendHeader.size() - bytes.size() - 1; zeroesToAdd > 0; --zeroesToAdd) {
            void add_value2;
            SliceCompanionBase.SliceImplicit add_this;
            Byte by = BoxesRunTime.boxToByte((byte)this.zero());
            if (SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)finalSlice) == null) {
                throw null;
            }
            add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value2);
            Slice cfr_ignored_1 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
            Object var10_13 = null;
            by = null;
        }
        SliceCompanionBase.SliceImplicit sliceImplicit2 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)finalSlice);
        Byte by = BoxesRunTime.boxToByte((byte)this.one());
        if (sliceImplicit2 == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit add_this = sliceImplicit2;
        add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insert((Object)add_value);
        Slice cfr_ignored_2 = add_this.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
        Object var12_16 = null;
        by = null;
        SliceCompanionBase.SliceImplicit sliceImplicit3 = SliceCompanionBase.SliceImplicit$((SliceCompanionBase)Slice$.MODULE$, (Slice)finalSlice);
        if (sliceImplicit3 == null) {
            throw null;
        }
        SliceCompanionBase.SliceImplicit addAll_this2 = sliceImplicit3;
        if (bytes.nonEmpty()) {
            addAll_this2.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice.insertAll(bytes);
        }
        return addAll_this2.swaydb$data$slice$SliceCompanionBase$SliceImplicit$$slice;
    }

    public Slice<Object> deNormalise(Slice<Object> bytes) {
        return bytes.drop(BoxesRunTime.unboxToInt((Object)bytes.indexOf((Object)BoxesRunTime.boxToByte((byte)this.one())).get()) + 1);
    }

    private Bytes$() {
    }
}

