/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.util;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import swaydb.core.data.KeyValue;
import swaydb.core.data.Memory;
import swaydb.core.data.Value;
import swaydb.core.data.Value$FromValue$Null$;
import swaydb.core.function.FunctionStore$;
import swaydb.core.util.MinMax;
import swaydb.data.slice.Slice;
import swaydb.data.util.SomeOrNone;
import swaydb.data.util.SomeOrNoneCovariant;

public final class MinMax$
implements Serializable {
    public static final MinMax$ MODULE$ = new MinMax$();

    public MinMax.MinMaxByteImplicits MinMaxByteImplicits(MinMax<Slice<Object>> minMax) {
        return new MinMax.MinMaxByteImplicits(minMax);
    }

    private <T> T minimum(T left, T right, Ordering<T> ordering) {
        if (ordering.compare(left, right) <= 0) {
            return left;
        }
        return right;
    }

    private <T> T maximum(T left, T right, Ordering<T> ordering) {
        if (ordering.compare(left, right) >= 0) {
            return left;
        }
        return right;
    }

    private <T> Option<T> pickOne(Option<T> someKey1, Option<T> someKey2, Function2<T, T, T> condition) {
        Option<T> option;
        if (someKey1 instanceof Some) {
            Some some;
            Object key1 = ((Some)someKey1).value();
            if (someKey2 instanceof Some) {
                Object key2 = ((Some)someKey2).value();
                some = new Some(condition.apply(key1, key2));
            } else if (None$.MODULE$.equals(someKey2)) {
                some = someKey1;
            } else {
                throw new MatchError(someKey2);
            }
            option = some;
        } else if (None$.MODULE$.equals(someKey1)) {
            option = someKey2;
        } else {
            throw new MatchError(someKey1);
        }
        return option;
    }

    public <T> Option<T> minFavourLeft(Option<T> left, Option<T> right, Ordering<T> ordering) {
        Option<T> option;
        if (left instanceof Some) {
            Some some;
            Object pickOne_key1 = ((Some)left).value();
            if (right instanceof Some) {
                Object pickOne_key2 = ((Some)right).value();
                some = new Some(MinMax$.MODULE$.minimum(pickOne_key1, pickOne_key2, ordering));
            } else if (None$.MODULE$.equals(right)) {
                some = left;
            } else {
                throw new MatchError(right);
            }
            option = some;
        } else if (None$.MODULE$.equals(left)) {
            option = right;
        } else {
            throw new MatchError(left);
        }
        return option;
    }

    public <T> Option<T> maxFavourLeft(Option<T> left, Option<T> right, Ordering<T> ordering) {
        Option<T> option;
        if (left instanceof Some) {
            Some some;
            Object pickOne_key1 = ((Some)left).value();
            if (right instanceof Some) {
                Object pickOne_key2 = ((Some)right).value();
                some = new Some(MinMax$.MODULE$.maximum(pickOne_key1, pickOne_key2, ordering));
            } else if (None$.MODULE$.equals(right)) {
                some = left;
            } else {
                throw new MatchError(right);
            }
            option = some;
        } else if (None$.MODULE$.equals(left)) {
            option = right;
        } else {
            throw new MatchError(left);
        }
        return option;
    }

    public <T> T maxFavourLeft(T left, Option<T> right, Ordering<T> ordering) {
        Object object;
        if (right instanceof Some) {
            Object right2 = ((Some)right).value();
            object = this.maximum(left, right2, ordering);
        } else if (None$.MODULE$.equals(right)) {
            object = left;
        } else {
            throw new MatchError(right);
        }
        return object;
    }

    public <T> T minFavourLeft(T left, T right, Ordering<T> ordering) {
        return this.minimum(left, right, ordering);
    }

    public <T> T maxFavourLeft(T left, T right, Ordering<T> ordering) {
        return this.maximum(left, right, ordering);
    }

    public <T extends SomeOrNoneCovariant<T, SOME>, SOME extends T> T maxFavourLeftC(T left, T right, Ordering<SOME> ordering) {
        if (left.isNoneC()) {
            return right;
        }
        if (right.isNoneC()) {
            return left;
        }
        return (T)((SomeOrNoneCovariant)this.maximum(left.getC(), right.getC(), ordering));
    }

    public <T extends SomeOrNoneCovariant<T, SOME>, SOME extends T> T minFavourLeftC(T left, T right, Ordering<SOME> ordering) {
        if (left.isNoneC()) {
            return right;
        }
        if (right.isNoneC()) {
            return left;
        }
        return (T)((SomeOrNoneCovariant)this.minimum(left.getC(), right.getC(), ordering));
    }

    public <T extends SomeOrNone<T, SOME>, SOME extends T> T maxFavourLeftS(T left, T right, Ordering<SOME> ordering) {
        if (left.isNoneS()) {
            return right;
        }
        if (right.isNoneS()) {
            return left;
        }
        return (T)((SomeOrNone)this.maximum(left.getS(), right.getS(), ordering));
    }

    public <T extends SomeOrNone<T, SOME>, SOME extends T> T minFavourLeftS(T left, T right, Ordering<SOME> ordering) {
        if (left.isNoneS()) {
            return right;
        }
        if (right.isNoneS()) {
            return left;
        }
        return (T)((SomeOrNone)this.minimum(left.getS(), right.getS(), ordering));
    }

    public <T> T maxFavourLeft(Option<T> left, T right, Ordering<T> ordering) {
        Object object;
        if (left instanceof Some) {
            Object left2 = ((Some)left).value();
            object = this.maximum(left2, right, ordering);
        } else if (None$.MODULE$.equals(left)) {
            object = right;
        } else {
            throw new MatchError(left);
        }
        return object;
    }

    public <T> boolean contains(T key, MinMax<T> minMax, Ordering<T> order) {
        boolean bl;
        Option<T> option = minMax.max();
        if (option instanceof Some) {
            Object maxValue = ((Some)option).value();
            bl = order.mkOrderingOps(key).$greater$eq(minMax.min()) && order.mkOrderingOps(key).$less$eq(maxValue);
        } else if (None$.MODULE$.equals(option)) {
            bl = order.equiv(key, minMax.min());
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public Option<MinMax<Slice<Object>>> minMaxFunction(Option<Value> function2, Option<MinMax<Slice<Object>>> current) {
        return function2.flatMap((Function1 & Serializable)function -> MODULE$.minMaxFunction((Value)function, current)).orElse((Function0 & Serializable)() -> current);
    }

    public Option<MinMax<Slice<Object>>> minMaxFunction(Value function, Option<MinMax<Slice<Object>>> current) {
        Option<MinMax<Slice<Object>>> option;
        boolean bl = function instanceof Value.Remove ? true : (function instanceof Value.Update ? true : function instanceof Value.Put);
        if (bl) {
            option = current;
        } else if (function instanceof Value.Function) {
            Value.Function function2 = (Value.Function)function;
            option = new Option<MinMax<Slice<Object>>>(this.minMaxFunction(function2, current));
        } else if (function instanceof Value.PendingApply) {
            Slice<Value.Apply> applies = ((Value.PendingApply)function).applies();
            option = this.minMaxFunction(applies, current);
        } else {
            throw new MatchError((Object)function);
        }
        return option;
    }

    public MinMax<Slice<Object>> minMaxFunction(Value.Function function, Option<MinMax<Slice<Object>>> current) {
        return this.minMax(current, function.function(), FunctionStore$.MODULE$.order());
    }

    public MinMax<Slice<Object>> minMaxFunction(Memory.Function function, Option<MinMax<Slice<Object>>> current) {
        return this.minMax(current, function.function(), FunctionStore$.MODULE$.order());
    }

    public MinMax<Slice<Object>> minMaxFunction(KeyValue.Function function, Option<MinMax<Slice<Object>>> current) {
        return this.minMax(current, function.getOrFetchFunction(), FunctionStore$.MODULE$.order());
    }

    public Option<MinMax<Slice<Object>>> minMaxFunction(Memory.Range range, Option<MinMax<Slice<Object>>> current) {
        return this.minMaxFunction(range.fromValue(), range.rangeValue(), current);
    }

    public Option<MinMax<Slice<Object>>> minMaxFunction(Value.FromValueOption fromValue, Value.RangeValue rangeValue, Option<MinMax<Slice<Object>>> current) {
        Option<MinMax<Slice<Object>>> option;
        if (Value$FromValue$Null$.MODULE$.equals(fromValue)) {
            option = current;
        } else if (fromValue instanceof Value.FromValue) {
            Value.FromValue fromValue2 = (Value.FromValue)fromValue;
            option = this.minMaxFunction(fromValue2, current);
        } else {
            throw new MatchError((Object)fromValue);
        }
        return this.minMaxFunction(rangeValue, option);
    }

    /*
     * WARNING - void declaration
     */
    public Option<MinMax<Slice<Object>>> minMaxFunction(KeyValue.Range range, Option<MinMax<Slice<Object>>> current) {
        void var5_5;
        void var4_4;
        Tuple2<Value.FromValueOption, Value.RangeValue> tuple2 = range.fetchFromAndRangeValueUnsafe();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Value.FromValueOption fromValue = (Value.FromValueOption)tuple2._1();
        Value.RangeValue rangeValue = (Value.RangeValue)tuple2._2();
        return this.minMaxFunction((Value.FromValueOption)var4_4, (Value.RangeValue)var5_5, current);
    }

    public Option<MinMax<Slice<Object>>> minMaxFunction(Slice<Value> functions, Option<MinMax<Slice<Object>>> current) {
        Option option;
        while ((option = functions.headOption()) instanceof Some) {
            Value function = (Value)((Some)option).value();
            current = this.minMaxFunction(function, current);
            functions = functions.dropHead();
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        return current;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Option<MinMax<T>> minMax(Option<MinMax<T>> left, Option<MinMax<T>> right, Ordering<T> order) {
        Tuple2 tuple2 = new Tuple2(left, right);
        if (left instanceof Some) {
            MinMax left2 = (MinMax)((Some)left).value();
            if (right instanceof Some) {
                MinMax right2 = (MinMax)((Some)right).value();
                MinMax minMaxLeft = this.minMax(left2, right2.min(), order);
                return right2.max().map((Function1 & Serializable)x$2 -> MODULE$.minMax(minMaxLeft, x$2, order)).orElse((Function0 & Serializable)() -> new Some((Object)minMaxLeft));
            }
        }
        if (None$.MODULE$.equals(left) && right instanceof Some) {
            return (Some)right;
        }
        if (tuple2 != null && left instanceof Some) {
            Some some = (Some)left;
            if (None$.MODULE$.equals(right)) {
                return some;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        if (!None$.MODULE$.equals(left)) throw new MatchError((Object)tuple2);
        if (!None$.MODULE$.equals(right)) throw new MatchError((Object)tuple2);
        return None$.MODULE$;
    }

    public <T> MinMax<T> minMax(Option<MinMax<T>> current, T next, Ordering<T> order) {
        MinMax<T> minMax;
        if (current instanceof Some) {
            MinMax currentMinMax = (MinMax)((Some)current).value();
            minMax = this.minMax(currentMinMax, next, order);
        } else if (None$.MODULE$.equals(current)) {
            minMax = new MinMax<T>(next, None$.MODULE$);
        } else {
            throw new MatchError(current);
        }
        return minMax;
    }

    public <T> MinMax<T> minMax(MinMax<T> current, T next, Ordering<T> order) {
        int minCompare = order.compare(next, current.min());
        if (minCompare == 0) {
            return new MinMax<T>(next, current.max());
        }
        if (minCompare < 0) {
            return new MinMax<T>(next, current.max().orElse((Function0 & Serializable)() -> new Some(current.min())));
        }
        if (current.max().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MinMax$.$anonfun$minMax$4(order, next, x$3)))) {
            Some x$1 = new Some(next);
            T x$2 = current.copy$default$1();
            return current.copy(x$2, (Option<T>)x$1);
        }
        return current;
    }

    public <T> MinMax<T> apply(T min, Option<T> max) {
        return new MinMax<T>(min, max);
    }

    public <T> Option<Tuple2<T, Option<T>>> unapply(MinMax<T> x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.min(), x$0.max()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MinMax$.class);
    }

    public static final /* synthetic */ boolean $anonfun$minMax$4(Ordering order$2, Object next$1, Object x$3) {
        return order$2.mkOrderingOps(x$3).$less$eq(next$1);
    }

    private MinMax$() {
    }
}

