/*
 * Decompiled with CFR 0.152.
 */
package swaydb.core.util;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import swaydb.IO;
import swaydb.core.segment.Segment;
import swaydb.core.util.ReserveRange;
import swaydb.data.Reserve$;
import swaydb.data.order.KeyOrder;
import swaydb.data.slice.Slice;
import swaydb.data.slice.Slice$;
import swaydb.data.slice.SliceCompanionBase;

public final class ReserveRange$
implements LazyLogging {
    public static final ReserveRange$ MODULE$ = new ReserveRange$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public <T> ReserveRange.State<T> create() {
        return new ReserveRange.State(ListBuffer$.MODULE$.empty());
    }

    public <T> Option<T> get(Slice<Object> from, Slice<Object> to, ReserveRange.State<T> state, KeyOrder<Slice<Object>> ordering) {
        synchronized (state) {
            Option option = state.ranges().find((Function1 & Serializable)range -> BoxesRunTime.boxToBoolean((boolean)ReserveRange$.$anonfun$get$1(ordering, from, to, range))).flatMap((Function1 & Serializable)x$1 -> x$1.reserve().info());
            return option;
        }
    }

    public <T> Option<T> reserveOrGet(Slice<Object> from, Slice<Object> to, boolean toInclusive, T info, ReserveRange.State<T> state, KeyOrder<Slice<Object>> ordering) {
        synchronized (state) {
            None$ none$;
            IO<ReserveRange.Range<T>, Slice<Object>> iO = this.reserveOrGetRange(from, to, toInclusive, info, state, ordering);
            if (iO instanceof IO.Left) {
                none$ = ((ReserveRange.Range)((IO.Left)iO).value()).reserve().info();
            } else if (iO instanceof IO.Right) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError(iO);
            }
            return none$;
        }
    }

    public <T> IO<Promise<BoxedUnit>, Slice<Object>> reserveOrListen(Slice<Object> from, Slice<Object> to, boolean toInclusive, T info, ReserveRange.State<T> state, KeyOrder<Slice<Object>> ordering) {
        synchronized (state) {
            IO.Right right;
            IO<ReserveRange.Range<T>, Slice<Object>> iO = this.reserveOrGetRange(from, to, toInclusive, info, state, ordering);
            if (iO instanceof IO.Left) {
                ReserveRange.Range range = (ReserveRange.Range)((IO.Left)iO).value();
                Promise promise = Promise$.MODULE$.apply();
                range.reserve().savePromise(promise);
                right = new IO.Left((Object)promise, (IO.ExceptionHandler)IO.ExceptionHandler$.PromiseUnit$.MODULE$);
            } else if (iO instanceof IO.Right) {
                Slice value = (Slice)((IO.Right)iO).value();
                right = new IO.Right((Object)value, (IO.ExceptionHandler)IO.ExceptionHandler$.PromiseUnit$.MODULE$);
            } else {
                throw new MatchError(iO);
            }
            return right;
        }
    }

    public <T> void free(Slice<Object> from, ReserveRange.State<T> state, KeyOrder<Slice<Object>> ordering) {
        synchronized (state) {
            state.ranges().find((Function1 & Serializable)range -> BoxesRunTime.boxToBoolean((boolean)ordering.equiv((Object)from, range.from()))).foreach((Function1 & Serializable)range -> {
                ReserveRange$.$anonfun$free$2(state, range);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public <T> boolean isUnreserved(Slice<Object> from, Slice<Object> to, boolean toInclusive, ReserveRange.State<T> state, KeyOrder<Slice<Object>> ordering) {
        return state.ranges().forall((Function1 & Serializable)range -> BoxesRunTime.boxToBoolean((boolean)ReserveRange$.$anonfun$isUnreserved$1(from, to, toInclusive, ordering, range)));
    }

    public <T> boolean isUnreserved(Segment segment, ReserveRange.State<T> state, KeyOrder<Slice<Object>> ordering) {
        return this.isUnreserved(segment.minKey(), (Slice<Object>)((Slice)segment.maxKey().maxKey()), segment.maxKey().inclusive(), state, ordering);
    }

    private <T> IO<ReserveRange.Range<T>, Slice<Object>> reserveOrGetRange(Slice<Object> from, Slice<Object> to, boolean toInclusive, T info, ReserveRange.State<T> state, KeyOrder<Slice<Object>> ordering) {
        Product product;
        synchronized (state) {
            product = (Product)state.ranges().find((Function1 & Serializable)range -> BoxesRunTime.boxToBoolean((boolean)ReserveRange$.$anonfun$reserveOrGetRange$1(from, to, toInclusive, ordering, range))).map((Function1 & Serializable)x$2 -> new IO.Left(x$2, new IO.ExceptionHandler<ReserveRange.Range<T>>(){

                public Option recover(Object f) {
                    return IO.ExceptionHandler.recover$((IO.ExceptionHandler)this, (Object)f);
                }

                public Throwable toException(ReserveRange.Range<T> f) {
                    throw new UnsupportedOperationException("Exception on Range");
                }

                public ReserveRange.Range<T> toError(Throwable e) {
                    throw e;
                }
            })).getOrElse((Function0 & Serializable)() -> {
                state.ranges().$plus$eq(new ReserveRange.Range(from, to, toInclusive, Reserve$.MODULE$.busy(info, "ReserveRange")));
                int waitingCount = state.ranges().size();
                if (waitingCount >= 100 && MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("Too many listeners: {}", (Object)BoxesRunTime.boxToInteger((int)waitingCount));
                }
                return new IO.Right((Object)from, new /* invalid duplicate definition of identical inner class */);
            });
        }
        return (IO)product;
    }

    public static final /* synthetic */ boolean $anonfun$get$1(KeyOrder ordering$1, Slice from$1, Slice to$1, ReserveRange.Range range) {
        return ordering$1.equiv((Object)from$1, range.from()) && ordering$1.equiv((Object)to$1, range.to());
    }

    public static final /* synthetic */ void $anonfun$free$2(ReserveRange.State state$1, ReserveRange.Range range) {
        state$1.ranges().$minus$eq((Object)range);
        Reserve$.MODULE$.setFree(range.reserve());
    }

    public static final /* synthetic */ boolean $anonfun$isUnreserved$1(Slice from$3, Slice to$2, boolean toInclusive$1, KeyOrder ordering$3, ReserveRange.Range range) {
        return !SliceCompanionBase.intersects$((SliceCompanionBase)Slice$.MODULE$, (Tuple3)new Tuple3(range.from(), range.to(), (Object)BoxesRunTime.boxToBoolean((boolean)range.toInclusive())), (Tuple3)new Tuple3((Object)from$3, (Object)to$2, (Object)BoxesRunTime.boxToBoolean((boolean)toInclusive$1)), (Ordering)ordering$3);
    }

    public static final /* synthetic */ boolean $anonfun$reserveOrGetRange$1(Slice from$4, Slice to$3, boolean toInclusive$2, KeyOrder ordering$4, ReserveRange.Range range) {
        return SliceCompanionBase.intersects$((SliceCompanionBase)Slice$.MODULE$, (Tuple3)new Tuple3((Object)from$4, (Object)to$3, (Object)BoxesRunTime.boxToBoolean((boolean)toInclusive$2)), (Tuple3)new Tuple3(range.from(), range.to(), (Object)BoxesRunTime.boxToBoolean((boolean)range.toInclusive())), (Ordering)ordering$4);
    }

    private ReserveRange$() {
    }
}

