/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.api;

import io.syndesis.verifier.api.Verifier;
import io.syndesis.verifier.api.VerifierResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentVerifier
implements Verifier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class<? extends ComponentVerifierExtension> verifierExtensionClass;
    private final String defaultComponentScheme;
    private volatile ComponentVerifierExtension verifierExtension;

    public ComponentVerifier() {
        this(null, ComponentVerifierExtension.class);
    }

    public ComponentVerifier(String componentScheme) {
        this(componentScheme, ComponentVerifierExtension.class);
    }

    public ComponentVerifier(Class<? extends ComponentVerifierExtension> verifierExtensionClass) {
        this(null, verifierExtensionClass);
    }

    public ComponentVerifier(String componentScheme, Class<? extends ComponentVerifierExtension> verifierExtensionClass) {
        this.defaultComponentScheme = componentScheme;
        this.verifierExtensionClass = verifierExtensionClass;
    }

    @Override
    public List<VerifierResponse> verify(CamelContext context, String connectorId, Map<String, Object> params) {
        String scheme = this.getConnectorAction().orElse(connectorId);
        ComponentVerifierExtension verifier = this.getComponentVerifierExtension(context, scheme);
        if (verifier == null) {
            return Collections.singletonList(this.createUnsupportedResponse(scheme));
        }
        this.customize(params);
        ArrayList<VerifierResponse> resp = new ArrayList<VerifierResponse>();
        for (Verifier.Scope scope : Verifier.Scope.values()) {
            try {
                ComponentVerifierExtension.Result result = verifier.verify(this.toComponentScope(scope), params);
                resp.add(this.toVerifierResponse(result));
                this.log.info("PING: {} === {}", (Object)scheme, (Object)result.getStatus());
                if (result.getStatus() == ComponentVerifierExtension.Result.Status.ERROR) {
                    this.log.error("{} --> ", (Object)scheme);
                    for (ComponentVerifierExtension.VerificationError error : result.getErrors()) {
                        this.log.error("   {} : {}", (Object)error.getCode(), (Object)error.getDescription());
                    }
                }
                if (result.getStatus() != ComponentVerifierExtension.Result.Status.ERROR && result.getStatus() != ComponentVerifierExtension.Result.Status.UNSUPPORTED) continue;
                break;
            }
            catch (Exception exp) {
                resp.add(this.toExceptionResponse(exp, scope, params.keySet()));
                this.log.error("Exception during verify with params {} and scope {} : {}", new Object[]{params, scope, exp.getMessage(), exp});
            }
        }
        return resp;
    }

    protected Optional<String> getConnectorAction() {
        return Optional.ofNullable(this.defaultComponentScheme);
    }

    protected void customize(Map<String, Object> params) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentVerifierExtension getComponentVerifierExtension(CamelContext context, String scheme) {
        if (this.verifierExtension == null) {
            ComponentVerifier componentVerifier = this;
            synchronized (componentVerifier) {
                if (this.verifierExtension == null) {
                    Component component = context.getComponent(scheme, true, false);
                    if (component == null) {
                        this.log.error("Component {} does not exist", (Object)scheme);
                    } else {
                        this.verifierExtension = component.getExtension(this.verifierExtensionClass).orElse(null);
                        if (this.verifierExtension == null) {
                            this.log.warn("Component {} does not support verifier extension", (Object)scheme);
                        }
                    }
                }
            }
        }
        return this.verifierExtension;
    }

    private ComponentVerifierExtension.Scope toComponentScope(Verifier.Scope scope) {
        switch (scope) {
            case CONNECTIVITY: {
                return ComponentVerifierExtension.Scope.CONNECTIVITY;
            }
            case PARAMETERS: {
                return ComponentVerifierExtension.Scope.PARAMETERS;
            }
        }
        throw new IllegalArgumentException("Unknown scope value " + (Object)((Object)scope));
    }

    private VerifierResponse createUnsupportedResponse(String connectorId) {
        return new VerifierResponse.Builder(Verifier.Status.UNSUPPORTED, Verifier.Scope.PARAMETERS).error("internal-error", String.format("No action %s used for the verification known", connectorId)).build();
    }

    private VerifierResponse toVerifierResponse(ComponentVerifierExtension.Result result) {
        VerifierResponse.Builder builder = new VerifierResponse.Builder(result.getStatus().name(), result.getScope().name());
        if (result.getErrors() != null) {
            for (ComponentVerifierExtension.VerificationError error : result.getErrors()) {
                builder.withError(error.getCode().getName()).description(error.getDescription()).parameters(error.getParameterKeys()).attributes(error.getDetails().entrySet().stream().collect(Collectors.toMap(e -> ((ComponentVerifierExtension.VerificationError.Attribute)e.getKey()).name(), e -> e.getValue()))).endError();
            }
        }
        return builder.build();
    }

    private VerifierResponse toExceptionResponse(Exception exp, Verifier.Scope scope, Set<String> params) {
        VerifierResponse.Builder builder = new VerifierResponse.Builder(Verifier.Status.ERROR, scope);
        return builder.withError(ComponentVerifierExtension.VerificationError.StandardCode.EXCEPTION.name()).description(exp.getMessage()).parameters(params).attributes(this.extractExceptionDetails(exp)).endError().build();
    }

    private Map<String, Object> extractExceptionDetails(Exception exp) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put(ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS.name(), exp.getClass().getName());
        details.put(ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE.name(), exp);
        return details;
    }
}

