/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.syndesis.verifier.api.Verifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonDeserialize
public class VerifierResponse {
    private Verifier.Scope scope;
    private Verifier.Status status;
    private List<Error> errors;

    private VerifierResponse(Verifier.Status status, Verifier.Scope scope) {
        this.status = status;
        this.scope = scope;
    }

    private VerifierResponse(String status, String scope) {
        this(Verifier.Status.valueOf(status.toUpperCase()), Verifier.Scope.valueOf(scope.toUpperCase()));
    }

    public Verifier.Scope getScope() {
        return this.scope;
    }

    public Verifier.Status getStatus() {
        return this.status;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static class Builder {
        private VerifierResponse resp;

        public Builder(String status, String scope) {
            this.resp = new VerifierResponse(status, scope);
        }

        public Builder(Verifier.Status status, Verifier.Scope scope) {
            this.resp = new VerifierResponse(status, scope);
        }

        public Builder error(String code, String description) {
            if (this.resp.errors == null) {
                this.resp.errors = new ArrayList();
            }
            Error error = new Error();
            error.code = code;
            error.description = description;
            this.resp.errors.add(error);
            return this;
        }

        public ErrorBuilder withError(String code) {
            return new ErrorBuilder(code);
        }

        public VerifierResponse build() {
            return this.resp;
        }

        public class ErrorBuilder {
            Error error = new Error();

            ErrorBuilder(String code) {
                this.error.code = code;
            }

            public ErrorBuilder description(String desc) {
                this.error.description = desc;
                return this;
            }

            public ErrorBuilder parameters(Set<String> params) {
                if (params != null) {
                    this.error.parameters = new HashSet<String>(params);
                }
                return this;
            }

            public ErrorBuilder attributes(Map<String, Object> attributes) {
                if (attributes != null) {
                    this.error.attributes = new HashMap<String, Object>(attributes);
                }
                return this;
            }

            public Builder endError() {
                if (Builder.this.resp.errors == null) {
                    Builder.this.resp.errors = new ArrayList();
                }
                Builder.this.resp.errors.add(this.error);
                this.error = new Error();
                return Builder.this;
            }
        }
    }

    public static class Error {
        String code;
        String description;
        Set<String> parameters;
        Map<String, Object> attributes;

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getParameters() {
            return this.parameters;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }
}

