/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.support.maven;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.Dereferencing;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.java.inspect.ClassInspectionService;
import io.atlasmap.java.v2.JavaClass;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.v2.CollectionType;
import io.syndesis.common.model.DataShape;
import io.syndesis.common.model.DataShapeKinds;
import io.syndesis.common.model.action.ConnectorAction;
import io.syndesis.common.model.action.ConnectorDescriptor;
import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.util.Json;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;

@Mojo(name="generate-connector-inspections", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateConnectorInspectionsMojo
extends AbstractMojo {
    private static final String CONNECTORS_META_PATH = "META-INF/syndesis/connector/";
    private static final String CONNECTOR_SCHEMA_FILE = "connector-schema.json";
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(readonly=true, defaultValue="${project.build.directory}/classes")
    private String output;
    @Parameter(defaultValue="${project.build.directory}/classes/META-INF/syndesis")
    private File inspectionsOutputDir;
    private JsonSchema jsonSchema;

    public GenerateConnectorInspectionsMojo() throws MojoExecutionException {
        this.initJsonSchema();
    }

    private void initJsonSchema() throws MojoExecutionException {
        if (this.jsonSchema != null) {
            return;
        }
        InputStream schemaStream = null;
        try {
            schemaStream = ((Object)((Object)this)).getClass().getResourceAsStream("/connector-schema.json");
            if (schemaStream == null) {
                throw new IOException("Schema Initialisation Error: file not available");
            }
            LoadingConfiguration loadingConfiguration = LoadingConfiguration.newBuilder().dereferencing(Dereferencing.INLINE).freeze();
            JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(loadingConfiguration).freeze();
            JsonNode schemaObject = Json.reader().readTree(schemaStream);
            this.jsonSchema = factory.getJsonSchema(schemaObject);
        }
        catch (ProcessingException | IOException ex) {
            throw new MojoExecutionException("Schema Initialisation Error", (Exception)ex);
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.inspectionsOutputDir.exists() && !this.inspectionsOutputDir.mkdirs()) {
            throw new MojoFailureException("Unable to create output directory at: " + this.inspectionsOutputDir);
        }
        try {
            File root = new File(this.output, CONNECTORS_META_PATH);
            if (root.exists()) {
                File[] files = root.listFiles((dir, name) -> name.endsWith(".json"));
                if (files == null) {
                    return;
                }
                for (File file : files) {
                    List<ConnectorAction> actions;
                    JsonNode jsonNode = this.validateWithSchema(file);
                    Connector connector = (Connector)Json.convertValue((Object)jsonNode, Connector.class);
                    if (!connector.getId().isPresent() || (actions = this.generateInspections(connector)).isEmpty()) continue;
                    Json.writer().writeValue(file, (Object)new Connector.Builder().createFrom(connector).actions(actions).build());
                }
            }
        }
        catch (IOException | ClassNotFoundException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to generate inspections", (Exception)e);
        }
    }

    public JsonNode validateWithSchema(File jsonFile) throws MojoExecutionException {
        FileInputStream jsonStream = null;
        try {
            jsonStream = new FileInputStream(jsonFile);
            JsonNode jsonNode = Json.reader().readTree((InputStream)jsonStream);
            ProcessingReport report = this.jsonSchema.validate(jsonNode, true);
            if (!report.isSuccess()) {
                for (ProcessingMessage processingMessage : report) {
                    this.getLog().warn((CharSequence)processingMessage.toString());
                }
                throw new MojoExecutionException("Validation of json file " + jsonFile.getName() + " failed, see previous logs");
            }
            JsonNode jsonNode2 = jsonNode;
            return jsonNode2;
        }
        catch (ProcessingException | IOException ex) {
            throw new MojoExecutionException("Failure to validate json file " + jsonFile.getName(), (Exception)ex);
        }
        finally {
            if (jsonStream != null) {
                try {
                    ((InputStream)jsonStream).close();
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
    }

    private List<ConnectorAction> generateInspections(Connector connector) throws IOException, DependencyResolutionRequiredException, ClassNotFoundException {
        ArrayList<ConnectorAction> actions = new ArrayList<ConnectorAction>();
        for (ConnectorAction action : connector.getActions()) {
            Optional<DataShape> inputDataShape = action.getDescriptor().getInputDataShape();
            Optional<DataShape> outputDataShape = action.getDescriptor().getOutputDataShape();
            if (inputDataShape.isPresent()) {
                inputDataShape = Optional.of(this.generateInspections(connector, (DataShape)inputDataShape.get()));
            }
            if (outputDataShape.isPresent()) {
                outputDataShape = Optional.of(this.generateInspections(connector, (DataShape)outputDataShape.get()));
            }
            if (inputDataShape.isPresent() || outputDataShape.isPresent()) {
                ConnectorDescriptor descriptor = new ConnectorDescriptor.Builder().createFrom(action.getDescriptor()).inputDataShape(inputDataShape).outputDataShape(outputDataShape).build();
                action = new ConnectorAction.Builder().createFrom(action).descriptor(descriptor).build();
            }
            actions.add(action);
        }
        return actions;
    }

    private DataShape generateInspections(Connector connector, DataShape shape) throws IOException, DependencyResolutionRequiredException, ClassNotFoundException {
        if (DataShapeKinds.JAVA != shape.getKind() || StringUtils.isEmpty((String)shape.getType())) {
            return shape;
        }
        this.getLog().info((CharSequence)("Generating inspections for connector: " + (String)connector.getId().get() + ", and type: " + shape.getType()));
        List elements = this.project.getRuntimeClasspathElements();
        URL[] classpath = new URL[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            classpath[i] = new File((String)elements.get(i)).toURI().toURL();
        }
        return GenerateConnectorInspectionsMojo.generateInspections(classpath, shape);
    }

    public static DataShape generateInspections(URL[] classpath, DataShape shape) throws IOException, ClassNotFoundException {
        JavaClass c = GenerateConnectorInspectionsMojo.inspect(classpath, shape);
        ArrayList<DataShape> variants = new ArrayList<DataShape>(shape.getVariants().size());
        for (DataShape s : shape.getVariants()) {
            variants.add(GenerateConnectorInspectionsMojo.generateInspections(classpath, s));
        }
        String inspection = io.atlasmap.v2.Json.mapper().writer((PrettyPrinter)null).writeValueAsString((Object)c);
        return new DataShape.Builder().createFrom(shape).specification(inspection).variants(variants).compress().build();
    }

    public static JavaClass inspect(URL[] classpath, DataShape shape) throws IOException, ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            return AccessController.doPrivileged(() -> {
                try (URLClassLoader loader = new URLClassLoader(classpath, tccl);){
                    ClassInspectionService inspector = new ClassInspectionService();
                    inspector.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
                    Class<?> clazz = loader.loadClass(shape.getType());
                    CollectionType collectionClazz = shape.getCollectionType().map(CollectionType::fromValue).orElse(CollectionType.NONE);
                    String collectionClazzName = shape.getCollectionClassName().orElse(null);
                    JavaClass javaClass = inspector.inspectClass((ClassLoader)loader, clazz, collectionClazz, collectionClazzName);
                    return javaClass;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cause;
            }
            throw new IllegalStateException(e);
        }
    }
}

