/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.support.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.v2.Json;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlSchemaInspector;
import io.atlasmap.xml.v2.XmlDocument;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-resource-inspections", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateResourceInspectionsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    @Parameter
    private String resourcesProcessorClass;
    @Parameter(required=true)
    private String inputDirectory;
    @Parameter
    private String outputDirectory;
    private Path outputDir;
    final ObjectMapper mapper = Json.mapper();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path inputDir = FileSystems.getDefault().getPath(this.inputDirectory, new String[0]);
        if (!Files.isDirectory(inputDir, new LinkOption[0])) {
            throw new MojoExecutionException("inputDirectory " + this.inputDirectory + " must be an existing directory");
        }
        this.outputDir = FileSystems.getDefault().getPath(this.outputDirectory, new String[0]);
        try {
            Files.createDirectories(this.outputDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed creating directory " + this.outputDir, (Exception)e);
        }
        try (DirectoryStream<Path> files = Files.newDirectoryStream(inputDir, "*.xsd");){
            for (Path file : files) {
                Path out = this.outputDir.resolve(file.getFileName());
                Files.copy(file, out, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed copying files from " + inputDir + " to " + this.outputDir, (Exception)e);
        }
        BiConsumer<Path, Path> resourcesProcessor = this.newResourcesProcessor();
        if (resourcesProcessor != null) {
            this.getLog().info((CharSequence)("Processing files with " + this.resourcesProcessorClass));
            resourcesProcessor.accept(inputDir, this.outputDir);
        } else {
            this.getLog().info((CharSequence)"The resourcesProcessorClass parameter not specified");
        }
        try {
            DirectoryStream<Path> files = Files.newDirectoryStream(this.outputDir, "*.xsd");
            Object object = null;
            try {
                for (Path file : files) {
                    this.generateInspection(file);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (files != null) {
                    GenerateResourceInspectionsMojo.$closeResource((Throwable)object, files);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot generate inspections in " + this.outputDir, (Exception)e);
        }
    }

    private void generateInspection(Path xsdFile) throws IOException {
        String inspection;
        XmlSchemaInspector inspector = new XmlSchemaInspector();
        try {
            inspector.inspect(xsdFile.toFile());
        }
        catch (XmlInspectionException e) {
            throw new IOException("Cannot inspect schema " + xsdFile, e);
        }
        XmlDocument xmlDocument = inspector.getXmlDocument();
        try {
            inspection = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)xmlDocument);
        }
        catch (JsonProcessingException e) {
            throw new IOException("Cannot serialize inspected " + xsdFile + " to json", e);
        }
        Files.delete(xsdFile);
        Path xsdFileName = xsdFile.getFileName();
        if (xsdFileName == null) {
            throw new IllegalArgumentException("Given path doesn't point to a file: " + xsdFile);
        }
        String jsonFileName = xsdFileName.toString().replace(".xsd", ".json");
        Path jsonFile = this.outputDir.resolve(jsonFileName);
        try (OutputStream jsonOut = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            IOUtils.write((String)inspection, (OutputStream)jsonOut, (Charset)StandardCharsets.UTF_8);
            this.getLog().info((CharSequence)("Generated " + jsonFile));
        }
    }

    private BiConsumer<Path, Path> newResourcesProcessor() throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)this.resourcesProcessorClass)) {
            return null;
        }
        try {
            Class<?> aClass = this.getClassLoader(this.project).loadClass(this.resourcesProcessorClass);
            return (BiConsumer)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to instantiate resourcesProcessorClass: " + this.resourcesProcessorClass, e);
        }
    }

    private ClassLoader getClassLoader(MavenProject project) throws DependencyResolutionRequiredException, MalformedURLException {
        List classpathElements = project.getCompileClasspathElements();
        classpathElements.add(project.getBuild().getOutputDirectory());
        classpathElements.add(project.getBuild().getTestOutputDirectory());
        URL[] urls = new URL[classpathElements.size()];
        for (int i = 0; i < classpathElements.size(); ++i) {
            urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
        }
        return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

