/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.syndesis.integration.component.proxy.ImmutableComponent;
import io.syndesis.integration.component.proxy.ImmutableComponentDefinition;
import io.syndesis.integration.component.proxy.ImmutableProperty;
import io.syndesis.integration.component.proxy.ImmutablePropertyRelation;
import io.syndesis.integration.component.proxy.ImmutableWhen;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.catalog.CamelCatalog;
import org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableComponentDefinition.Builder.class)
@JsonIgnoreProperties(value={"connectorProperties"})
@Value.Immutable
@Value.Style(builder="new")
public interface ComponentDefinition {
    @JsonProperty(value="component")
    public Component getComponent();

    @JsonProperty(value="componentProperties")
    @Value.Default
    default public Map<String, Property> getComponentProperties() {
        return Collections.emptyMap();
    }

    @JsonProperty(value="properties")
    @Value.Default
    default public Map<String, Property> getEndpointProperties() {
        return Collections.emptyMap();
    }

    @JsonIgnore
    public static ComponentDefinition forScheme(CamelCatalog catalog, String scheme) throws IOException {
        String json = catalog.componentJSonSchema(scheme);
        return (ComponentDefinition)new ObjectMapper().registerModule((Module)new Jdk8Module()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(json, ComponentDefinition.class);
    }

    @JsonDeserialize(builder=ImmutableProperty.Builder.class)
    @Value.Immutable
    @Value.Style(builder="new")
    public static interface Property {
        public Optional<String> getDisplayName();

        public Optional<String> getKind();

        public Optional<String> getGroup();

        public Optional<String> getRequired();

        public Optional<String> getType();

        public Optional<String> getJavaType();

        public Optional<String> getDeprecated();

        public Optional<String> getSecret();

        public Optional<String> getDescription();

        public Optional<String> getControlHint();

        public Optional<String> getLabelHint();

        public Optional<String> getPlaceholder();

        public Optional<String> getName();

        public Optional<String> getDefaultValue();

        public Optional<String> getEnums();

        public Optional<String> getPrefix();

        public Optional<String> getMultiValue();

        public Optional<String> getEnumValues();
    }

    @JsonDeserialize(builder=ImmutablePropertyRelation.Builder.class)
    @Value.Immutable
    @Value.Style(builder="new")
    public static interface PropertyRelation {
        public String getAction();

        public List<When> getWhen();
    }

    @JsonDeserialize(builder=ImmutableWhen.Builder.class)
    @Value.Immutable
    @Value.Style(builder="new")
    public static interface When {
        public String getId();

        public String getValue();
    }

    @JsonDeserialize(builder=ImmutableComponent.Builder.class)
    @Value.Immutable
    @Value.Style(builder="new")
    public static interface Component {
        public String getKind();

        public String getScheme();

        public String getSyntax();

        public String getTitle();

        public String getDescription();

        public String getLabel();

        public String getDeprecated();

        public String getConsumerOnly();

        public String getProducerOnly();

        public String getJavaType();

        public String getGroupId();

        public String getArtifactId();

        public String getVersion();

        public Optional<String> getAlternativeSyntax();

        public Optional<String> getAlternativeSchemes();

        public Optional<String> getFirstVersion();
    }
}

