/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.syndesis.integration.component.proxy.ComponentDefinition;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableComponent
implements ComponentDefinition.Component {
    private final String kind;
    private final String scheme;
    private final String syntax;
    private final String title;
    private final String description;
    private final String label;
    private final String deprecated;
    private final String consumerOnly;
    private final String producerOnly;
    private final String javaType;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String alternativeSyntax;
    private final String alternativeSchemes;
    private final String firstVersion;

    private ImmutableComponent(String kind, String scheme, String syntax, String title, String description, String label, String deprecated, String consumerOnly, String producerOnly, String javaType, String groupId, String artifactId, String version, String alternativeSyntax, String alternativeSchemes, String firstVersion) {
        this.kind = kind;
        this.scheme = scheme;
        this.syntax = syntax;
        this.title = title;
        this.description = description;
        this.label = label;
        this.deprecated = deprecated;
        this.consumerOnly = consumerOnly;
        this.producerOnly = producerOnly;
        this.javaType = javaType;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.alternativeSyntax = alternativeSyntax;
        this.alternativeSchemes = alternativeSchemes;
        this.firstVersion = firstVersion;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="scheme")
    public String getScheme() {
        return this.scheme;
    }

    @Override
    @JsonProperty(value="syntax")
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty(value="deprecated")
    public String getDeprecated() {
        return this.deprecated;
    }

    @Override
    @JsonProperty(value="consumerOnly")
    public String getConsumerOnly() {
        return this.consumerOnly;
    }

    @Override
    @JsonProperty(value="producerOnly")
    public String getProducerOnly() {
        return this.producerOnly;
    }

    @Override
    @JsonProperty(value="javaType")
    public String getJavaType() {
        return this.javaType;
    }

    @Override
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="artifactId")
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="alternativeSyntax")
    public Optional<String> getAlternativeSyntax() {
        return Optional.ofNullable(this.alternativeSyntax);
    }

    @Override
    @JsonProperty(value="alternativeSchemes")
    public Optional<String> getAlternativeSchemes() {
        return Optional.ofNullable(this.alternativeSchemes);
    }

    @Override
    @JsonProperty(value="firstVersion")
    public Optional<String> getFirstVersion() {
        return Optional.ofNullable(this.firstVersion);
    }

    public final ImmutableComponent withKind(String value) {
        if (this.kind.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "kind");
        return new ImmutableComponent(newValue, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withScheme(String value) {
        if (this.scheme.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "scheme");
        return new ImmutableComponent(this.kind, newValue, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withSyntax(String value) {
        if (this.syntax.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "syntax");
        return new ImmutableComponent(this.kind, this.scheme, newValue, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withTitle(String value) {
        if (this.title.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "title");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, newValue, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withDescription(String value) {
        if (this.description.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "description");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, newValue, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withLabel(String value) {
        if (this.label.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "label");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, newValue, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withDeprecated(String value) {
        if (this.deprecated.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "deprecated");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, newValue, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withConsumerOnly(String value) {
        if (this.consumerOnly.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "consumerOnly");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, newValue, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withProducerOnly(String value) {
        if (this.producerOnly.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "producerOnly");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, newValue, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withJavaType(String value) {
        if (this.javaType.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "javaType");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, newValue, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withGroupId(String value) {
        if (this.groupId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "groupId");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, newValue, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withArtifactId(String value) {
        if (this.artifactId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "artifactId");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, newValue, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withVersion(String value) {
        if (this.version.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "version");
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, newValue, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withAlternativeSyntax(String value) {
        String newValue = Objects.requireNonNull(value, "alternativeSyntax");
        if (Objects.equals(this.alternativeSyntax, newValue)) {
            return this;
        }
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, newValue, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withAlternativeSyntax(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.alternativeSyntax, value)) {
            return this;
        }
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, value, this.alternativeSchemes, this.firstVersion);
    }

    public final ImmutableComponent withAlternativeSchemes(String value) {
        String newValue = Objects.requireNonNull(value, "alternativeSchemes");
        if (Objects.equals(this.alternativeSchemes, newValue)) {
            return this;
        }
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, newValue, this.firstVersion);
    }

    public final ImmutableComponent withAlternativeSchemes(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.alternativeSchemes, value)) {
            return this;
        }
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, value, this.firstVersion);
    }

    public final ImmutableComponent withFirstVersion(String value) {
        String newValue = Objects.requireNonNull(value, "firstVersion");
        if (Objects.equals(this.firstVersion, newValue)) {
            return this;
        }
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, newValue);
    }

    public final ImmutableComponent withFirstVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.firstVersion, value)) {
            return this;
        }
        return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComponent && this.equalTo((ImmutableComponent)another);
    }

    private boolean equalTo(ImmutableComponent another) {
        return this.kind.equals(another.kind) && this.scheme.equals(another.scheme) && this.syntax.equals(another.syntax) && this.title.equals(another.title) && this.description.equals(another.description) && this.label.equals(another.label) && this.deprecated.equals(another.deprecated) && this.consumerOnly.equals(another.consumerOnly) && this.producerOnly.equals(another.producerOnly) && this.javaType.equals(another.javaType) && this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId) && this.version.equals(another.version) && Objects.equals(this.alternativeSyntax, another.alternativeSyntax) && Objects.equals(this.alternativeSchemes, another.alternativeSchemes) && Objects.equals(this.firstVersion, another.firstVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.kind.hashCode();
        h += (h << 5) + this.scheme.hashCode();
        h += (h << 5) + this.syntax.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.deprecated.hashCode();
        h += (h << 5) + this.consumerOnly.hashCode();
        h += (h << 5) + this.producerOnly.hashCode();
        h += (h << 5) + this.javaType.hashCode();
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + Objects.hashCode(this.alternativeSyntax);
        h += (h << 5) + Objects.hashCode(this.alternativeSchemes);
        h += (h << 5) + Objects.hashCode(this.firstVersion);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Component{");
        builder.append("kind=").append(this.kind);
        builder.append(", ");
        builder.append("scheme=").append(this.scheme);
        builder.append(", ");
        builder.append("syntax=").append(this.syntax);
        builder.append(", ");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("label=").append(this.label);
        builder.append(", ");
        builder.append("deprecated=").append(this.deprecated);
        builder.append(", ");
        builder.append("consumerOnly=").append(this.consumerOnly);
        builder.append(", ");
        builder.append("producerOnly=").append(this.producerOnly);
        builder.append(", ");
        builder.append("javaType=").append(this.javaType);
        builder.append(", ");
        builder.append("groupId=").append(this.groupId);
        builder.append(", ");
        builder.append("artifactId=").append(this.artifactId);
        builder.append(", ");
        builder.append("version=").append(this.version);
        if (this.alternativeSyntax != null) {
            builder.append(", ");
            builder.append("alternativeSyntax=").append(this.alternativeSyntax);
        }
        if (this.alternativeSchemes != null) {
            builder.append(", ");
            builder.append("alternativeSchemes=").append(this.alternativeSchemes);
        }
        if (this.firstVersion != null) {
            builder.append(", ");
            builder.append("firstVersion=").append(this.firstVersion);
        }
        return builder.append("}").toString();
    }

    public static ImmutableComponent copyOf(ComponentDefinition.Component instance) {
        if (instance instanceof ImmutableComponent) {
            return (ImmutableComponent)instance;
        }
        return new Builder().from(instance).build();
    }

    public static final class Builder {
        private static final long INIT_BIT_KIND = 1L;
        private static final long INIT_BIT_SCHEME = 2L;
        private static final long INIT_BIT_SYNTAX = 4L;
        private static final long INIT_BIT_TITLE = 8L;
        private static final long INIT_BIT_DESCRIPTION = 16L;
        private static final long INIT_BIT_LABEL = 32L;
        private static final long INIT_BIT_DEPRECATED = 64L;
        private static final long INIT_BIT_CONSUMER_ONLY = 128L;
        private static final long INIT_BIT_PRODUCER_ONLY = 256L;
        private static final long INIT_BIT_JAVA_TYPE = 512L;
        private static final long INIT_BIT_GROUP_ID = 1024L;
        private static final long INIT_BIT_ARTIFACT_ID = 2048L;
        private static final long INIT_BIT_VERSION = 4096L;
        private long initBits = 8191L;
        private String kind;
        private String scheme;
        private String syntax;
        private String title;
        private String description;
        private String label;
        private String deprecated;
        private String consumerOnly;
        private String producerOnly;
        private String javaType;
        private String groupId;
        private String artifactId;
        private String version;
        private String alternativeSyntax;
        private String alternativeSchemes;
        private String firstVersion;

        public final Builder from(ComponentDefinition.Component instance) {
            Optional<String> firstVersionOptional;
            Optional<String> alternativeSchemesOptional;
            Objects.requireNonNull(instance, "instance");
            this.kind(instance.getKind());
            this.scheme(instance.getScheme());
            this.syntax(instance.getSyntax());
            this.title(instance.getTitle());
            this.description(instance.getDescription());
            this.label(instance.getLabel());
            this.deprecated(instance.getDeprecated());
            this.consumerOnly(instance.getConsumerOnly());
            this.producerOnly(instance.getProducerOnly());
            this.javaType(instance.getJavaType());
            this.groupId(instance.getGroupId());
            this.artifactId(instance.getArtifactId());
            this.version(instance.getVersion());
            Optional<String> alternativeSyntaxOptional = instance.getAlternativeSyntax();
            if (alternativeSyntaxOptional.isPresent()) {
                this.alternativeSyntax(alternativeSyntaxOptional);
            }
            if ((alternativeSchemesOptional = instance.getAlternativeSchemes()).isPresent()) {
                this.alternativeSchemes(alternativeSchemesOptional);
            }
            if ((firstVersionOptional = instance.getFirstVersion()).isPresent()) {
                this.firstVersion(firstVersionOptional);
            }
            return this;
        }

        @JsonProperty(value="kind")
        public final Builder kind(String kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="scheme")
        public final Builder scheme(String scheme) {
            this.scheme = Objects.requireNonNull(scheme, "scheme");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="syntax")
        public final Builder syntax(String syntax) {
            this.syntax = Objects.requireNonNull(syntax, "syntax");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="deprecated")
        public final Builder deprecated(String deprecated) {
            this.deprecated = Objects.requireNonNull(deprecated, "deprecated");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="consumerOnly")
        public final Builder consumerOnly(String consumerOnly) {
            this.consumerOnly = Objects.requireNonNull(consumerOnly, "consumerOnly");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="producerOnly")
        public final Builder producerOnly(String producerOnly) {
            this.producerOnly = Objects.requireNonNull(producerOnly, "producerOnly");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="javaType")
        public final Builder javaType(String javaType) {
            this.javaType = Objects.requireNonNull(javaType, "javaType");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="groupId")
        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="artifactId")
        public final Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="version")
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder alternativeSyntax(String alternativeSyntax) {
            this.alternativeSyntax = Objects.requireNonNull(alternativeSyntax, "alternativeSyntax");
            return this;
        }

        @JsonProperty(value="alternativeSyntax")
        public final Builder alternativeSyntax(Optional<String> alternativeSyntax) {
            this.alternativeSyntax = alternativeSyntax.orElse(null);
            return this;
        }

        public final Builder alternativeSchemes(String alternativeSchemes) {
            this.alternativeSchemes = Objects.requireNonNull(alternativeSchemes, "alternativeSchemes");
            return this;
        }

        @JsonProperty(value="alternativeSchemes")
        public final Builder alternativeSchemes(Optional<String> alternativeSchemes) {
            this.alternativeSchemes = alternativeSchemes.orElse(null);
            return this;
        }

        public final Builder firstVersion(String firstVersion) {
            this.firstVersion = Objects.requireNonNull(firstVersion, "firstVersion");
            return this;
        }

        @JsonProperty(value="firstVersion")
        public final Builder firstVersion(Optional<String> firstVersion) {
            this.firstVersion = firstVersion.orElse(null);
            return this;
        }

        public ImmutableComponent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableComponent(this.kind, this.scheme, this.syntax, this.title, this.description, this.label, this.deprecated, this.consumerOnly, this.producerOnly, this.javaType, this.groupId, this.artifactId, this.version, this.alternativeSyntax, this.alternativeSchemes, this.firstVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("kind");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scheme");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("syntax");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("deprecated");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("consumerOnly");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("producerOnly");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("javaType");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("artifactId");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build Component, some of required attributes are not set " + attributes;
        }
    }
}

