/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.syndesis.integration.component.proxy.ComponentDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(value={"connectorProperties"})
public final class ImmutableComponentDefinition
implements ComponentDefinition {
    private final ComponentDefinition.Component component;
    private final Map<String, ComponentDefinition.Property> componentProperties;
    private final Map<String, ComponentDefinition.Property> endpointProperties;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableComponentDefinition(Builder builder) {
        this.component = builder.component;
        if (builder.componentPropertiesIsSet()) {
            this.initShim.componentProperties(ImmutableComponentDefinition.createUnmodifiableMap(false, false, builder.componentProperties));
        }
        if (builder.endpointPropertiesIsSet()) {
            this.initShim.endpointProperties(ImmutableComponentDefinition.createUnmodifiableMap(false, false, builder.endpointProperties));
        }
        this.componentProperties = this.initShim.getComponentProperties();
        this.endpointProperties = this.initShim.getEndpointProperties();
        this.initShim = null;
    }

    private ImmutableComponentDefinition(ComponentDefinition.Component component, Map<String, ComponentDefinition.Property> componentProperties, Map<String, ComponentDefinition.Property> endpointProperties) {
        this.component = component;
        this.componentProperties = componentProperties;
        this.endpointProperties = endpointProperties;
        this.initShim = null;
    }

    private Map<String, ComponentDefinition.Property> getComponentPropertiesInitialize() {
        return ComponentDefinition.super.getComponentProperties();
    }

    private Map<String, ComponentDefinition.Property> getEndpointPropertiesInitialize() {
        return ComponentDefinition.super.getEndpointProperties();
    }

    @Override
    @JsonProperty(value="component")
    public ComponentDefinition.Component getComponent() {
        return this.component;
    }

    @Override
    @JsonProperty(value="componentProperties")
    public Map<String, ComponentDefinition.Property> getComponentProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getComponentProperties() : this.componentProperties;
    }

    @Override
    @JsonProperty(value="properties")
    public Map<String, ComponentDefinition.Property> getEndpointProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEndpointProperties() : this.endpointProperties;
    }

    public final ImmutableComponentDefinition withComponent(ComponentDefinition.Component value) {
        if (this.component == value) {
            return this;
        }
        ComponentDefinition.Component newValue = Objects.requireNonNull(value, "component");
        return new ImmutableComponentDefinition(newValue, this.componentProperties, this.endpointProperties);
    }

    public final ImmutableComponentDefinition withComponentProperties(Map<String, ? extends ComponentDefinition.Property> entries) {
        if (this.componentProperties == entries) {
            return this;
        }
        Map<String, ComponentDefinition.Property> newValue = ImmutableComponentDefinition.createUnmodifiableMap(true, false, entries);
        return new ImmutableComponentDefinition(this.component, newValue, this.endpointProperties);
    }

    public final ImmutableComponentDefinition withEndpointProperties(Map<String, ? extends ComponentDefinition.Property> entries) {
        if (this.endpointProperties == entries) {
            return this;
        }
        Map<String, ComponentDefinition.Property> newValue = ImmutableComponentDefinition.createUnmodifiableMap(true, false, entries);
        return new ImmutableComponentDefinition(this.component, this.componentProperties, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComponentDefinition && this.equalTo((ImmutableComponentDefinition)another);
    }

    private boolean equalTo(ImmutableComponentDefinition another) {
        return this.component.equals(another.component) && this.componentProperties.equals(another.componentProperties) && this.endpointProperties.equals(another.endpointProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.component.hashCode();
        h += (h << 5) + this.componentProperties.hashCode();
        h += (h << 5) + this.endpointProperties.hashCode();
        return h;
    }

    public String toString() {
        return "ComponentDefinition{component=" + this.component + ", componentProperties=" + this.componentProperties + ", endpointProperties=" + this.endpointProperties + "}";
    }

    public static ImmutableComponentDefinition copyOf(ComponentDefinition instance) {
        if (instance instanceof ImmutableComponentDefinition) {
            return (ImmutableComponentDefinition)instance;
        }
        return new Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @JsonIgnoreProperties(value={"connectorProperties"})
    public static final class Builder {
        private static final long INIT_BIT_COMPONENT = 1L;
        private static final long OPT_BIT_COMPONENT_PROPERTIES = 1L;
        private static final long OPT_BIT_ENDPOINT_PROPERTIES = 2L;
        private long initBits = 1L;
        private long optBits;
        private ComponentDefinition.Component component;
        private Map<String, ComponentDefinition.Property> componentProperties = new LinkedHashMap<String, ComponentDefinition.Property>();
        private Map<String, ComponentDefinition.Property> endpointProperties = new LinkedHashMap<String, ComponentDefinition.Property>();

        public final Builder from(ComponentDefinition instance) {
            Objects.requireNonNull(instance, "instance");
            this.component(instance.getComponent());
            this.putAllComponentProperties(instance.getComponentProperties());
            this.putAllEndpointProperties(instance.getEndpointProperties());
            return this;
        }

        @JsonProperty(value="component")
        public final Builder component(ComponentDefinition.Component component) {
            this.component = Objects.requireNonNull(component, "component");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putComponentProperties(String key, ComponentDefinition.Property value) {
            this.componentProperties.put(Objects.requireNonNull(key, "componentProperties key"), Objects.requireNonNull(value, "componentProperties value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder putComponentProperties(Map.Entry<String, ? extends ComponentDefinition.Property> entry) {
            String k = entry.getKey();
            ComponentDefinition.Property v = entry.getValue();
            this.componentProperties.put(Objects.requireNonNull(k, "componentProperties key"), Objects.requireNonNull(v, "componentProperties value"));
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="componentProperties")
        public final Builder componentProperties(Map<String, ? extends ComponentDefinition.Property> componentProperties) {
            this.componentProperties.clear();
            this.optBits |= 1L;
            return this.putAllComponentProperties(componentProperties);
        }

        public final Builder putAllComponentProperties(Map<String, ? extends ComponentDefinition.Property> componentProperties) {
            for (Map.Entry<String, ? extends ComponentDefinition.Property> entry : componentProperties.entrySet()) {
                String k = entry.getKey();
                ComponentDefinition.Property v = entry.getValue();
                this.componentProperties.put(Objects.requireNonNull(k, "componentProperties key"), Objects.requireNonNull(v, "componentProperties value"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder putEndpointProperties(String key, ComponentDefinition.Property value) {
            this.endpointProperties.put(Objects.requireNonNull(key, "endpointProperties key"), Objects.requireNonNull(value, "endpointProperties value"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder putEndpointProperties(Map.Entry<String, ? extends ComponentDefinition.Property> entry) {
            String k = entry.getKey();
            ComponentDefinition.Property v = entry.getValue();
            this.endpointProperties.put(Objects.requireNonNull(k, "endpointProperties key"), Objects.requireNonNull(v, "endpointProperties value"));
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="properties")
        public final Builder endpointProperties(Map<String, ? extends ComponentDefinition.Property> endpointProperties) {
            this.endpointProperties.clear();
            this.optBits |= 2L;
            return this.putAllEndpointProperties(endpointProperties);
        }

        public final Builder putAllEndpointProperties(Map<String, ? extends ComponentDefinition.Property> endpointProperties) {
            for (Map.Entry<String, ? extends ComponentDefinition.Property> entry : endpointProperties.entrySet()) {
                String k = entry.getKey();
                ComponentDefinition.Property v = entry.getValue();
                this.endpointProperties.put(Objects.requireNonNull(k, "endpointProperties key"), Objects.requireNonNull(v, "endpointProperties value"));
            }
            this.optBits |= 2L;
            return this;
        }

        public ImmutableComponentDefinition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableComponentDefinition(this);
        }

        private boolean componentPropertiesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean endpointPropertiesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("component");
            }
            return "Cannot build ComponentDefinition, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private Map<String, ComponentDefinition.Property> componentProperties;
        private int componentPropertiesBuildStage;
        private Map<String, ComponentDefinition.Property> endpointProperties;
        private int endpointPropertiesBuildStage;

        private InitShim() {
        }

        Map<String, ComponentDefinition.Property> getComponentProperties() {
            if (this.componentPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.componentPropertiesBuildStage == 0) {
                this.componentPropertiesBuildStage = -1;
                this.componentProperties = ImmutableComponentDefinition.createUnmodifiableMap(true, false, ImmutableComponentDefinition.this.getComponentPropertiesInitialize());
                this.componentPropertiesBuildStage = 1;
            }
            return this.componentProperties;
        }

        void componentProperties(Map<String, ComponentDefinition.Property> componentProperties) {
            this.componentProperties = componentProperties;
            this.componentPropertiesBuildStage = 1;
        }

        Map<String, ComponentDefinition.Property> getEndpointProperties() {
            if (this.endpointPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.endpointPropertiesBuildStage == 0) {
                this.endpointPropertiesBuildStage = -1;
                this.endpointProperties = ImmutableComponentDefinition.createUnmodifiableMap(true, false, ImmutableComponentDefinition.this.getEndpointPropertiesInitialize());
                this.endpointPropertiesBuildStage = 1;
            }
            return this.endpointProperties;
        }

        void endpointProperties(Map<String, ComponentDefinition.Property> endpointProperties) {
            this.endpointProperties = endpointProperties;
            this.endpointPropertiesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.componentPropertiesBuildStage == -1) {
                attributes.add("componentProperties");
            }
            if (this.endpointPropertiesBuildStage == -1) {
                attributes.add("endpointProperties");
            }
            return "Cannot build ComponentDefinition, attribute initializers form cycle" + attributes;
        }
    }
}

