/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.syndesis.integration.component.proxy.ComponentDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutablePropertyRelation
implements ComponentDefinition.PropertyRelation {
    private final String action;
    private final List<ComponentDefinition.When> when;

    private ImmutablePropertyRelation(String action, List<ComponentDefinition.When> when) {
        this.action = action;
        this.when = when;
    }

    @Override
    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    @Override
    @JsonProperty(value="when")
    public List<ComponentDefinition.When> getWhen() {
        return this.when;
    }

    public final ImmutablePropertyRelation withAction(String value) {
        if (this.action.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "action");
        return new ImmutablePropertyRelation(newValue, this.when);
    }

    public final ImmutablePropertyRelation withWhen(ComponentDefinition.When ... elements) {
        List<ComponentDefinition.When> newValue = ImmutablePropertyRelation.createUnmodifiableList(false, ImmutablePropertyRelation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePropertyRelation(this.action, newValue);
    }

    public final ImmutablePropertyRelation withWhen(Iterable<? extends ComponentDefinition.When> elements) {
        if (this.when == elements) {
            return this;
        }
        List<ComponentDefinition.When> newValue = ImmutablePropertyRelation.createUnmodifiableList(false, ImmutablePropertyRelation.createSafeList(elements, true, false));
        return new ImmutablePropertyRelation(this.action, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePropertyRelation && this.equalTo((ImmutablePropertyRelation)another);
    }

    private boolean equalTo(ImmutablePropertyRelation another) {
        return this.action.equals(another.action) && this.when.equals(another.when);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + this.when.hashCode();
        return h;
    }

    public String toString() {
        return "PropertyRelation{action=" + this.action + ", when=" + this.when + "}";
    }

    public static ImmutablePropertyRelation copyOf(ComponentDefinition.PropertyRelation instance) {
        if (instance instanceof ImmutablePropertyRelation) {
            return (ImmutablePropertyRelation)instance;
        }
        return new Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ACTION = 1L;
        private long initBits = 1L;
        private String action;
        private List<ComponentDefinition.When> when = new ArrayList<ComponentDefinition.When>();

        public final Builder from(ComponentDefinition.PropertyRelation instance) {
            Objects.requireNonNull(instance, "instance");
            this.action(instance.getAction());
            this.addAllWhen(instance.getWhen());
            return this;
        }

        @JsonProperty(value="action")
        public final Builder action(String action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addWhen(ComponentDefinition.When element) {
            this.when.add(Objects.requireNonNull(element, "when element"));
            return this;
        }

        public final Builder addWhen(ComponentDefinition.When ... elements) {
            for (ComponentDefinition.When element : elements) {
                this.when.add(Objects.requireNonNull(element, "when element"));
            }
            return this;
        }

        @JsonProperty(value="when")
        public final Builder when(Iterable<? extends ComponentDefinition.When> elements) {
            this.when.clear();
            return this.addAllWhen(elements);
        }

        public final Builder addAllWhen(Iterable<? extends ComponentDefinition.When> elements) {
            for (ComponentDefinition.When when : elements) {
                this.when.add(Objects.requireNonNull(when, "when element"));
            }
            return this;
        }

        public ImmutablePropertyRelation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePropertyRelation(this.action, ImmutablePropertyRelation.createUnmodifiableList(true, this.when));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build PropertyRelation, some of required attributes are not set " + attributes;
        }
    }
}

