/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.syndesis.integration.component.proxy.ComponentDefinition;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableWhen
implements ComponentDefinition.When {
    private final String id;
    private final String value;

    private ImmutableWhen(String id, String value) {
        this.id = id;
        this.value = value;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public final ImmutableWhen withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "id");
        return new ImmutableWhen(newValue, this.value);
    }

    public final ImmutableWhen withValue(String value) {
        if (this.value.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "value");
        return new ImmutableWhen(this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWhen && this.equalTo((ImmutableWhen)another);
    }

    private boolean equalTo(ImmutableWhen another) {
        return this.id.equals(another.id) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "When{id=" + this.id + ", value=" + this.value + "}";
    }

    public static ImmutableWhen copyOf(ComponentDefinition.When instance) {
        if (instance instanceof ImmutableWhen) {
            return (ImmutableWhen)instance;
        }
        return new Builder().from(instance).build();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private String id;
        private String value;

        public final Builder from(ComponentDefinition.When instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.value(instance.getValue());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWhen build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWhen(this.id, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build When, some of required attributes are not set " + attributes;
        }
    }
}

