/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import io.syndesis.integration.component.proxy.ComponentProxyComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.sql.SqlComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.commons.dbcp.BasicDataSource;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ComponentOptionsTest {
    private DataSource ds;

    @Before
    public void setUp() {
        this.ds = new BasicDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPojoOption() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("dataSource", this.ds);
        properties.put("query", "select from dual");
        ComponentProxyComponent component = new ComponentProxyComponent("my-sql-proxy", "sql");
        component.setOptions(properties);
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)(component.getComponentId() + "-component"), (Object)component);
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        try {
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)((RouteDefinition)this.from("direct:start").id("test-route")).to("my-sql-proxy")).to("mock:result");
                }
            });
            this.validatePojoOption((CamelContext)context);
            this.validatePojoOption((CamelContext)context);
        }
        finally {
            context.stop();
        }
    }

    private void validatePojoOption(CamelContext context) throws Exception {
        context.start();
        List names = context.getComponentNames();
        Assertions.assertThat((Iterable)names).contains((Object[])new String[]{"my-sql-proxy"});
        Assertions.assertThat((Iterable)names).contains((Object[])new String[]{"sql-my-sql-proxy"});
        SqlComponent sqlComponent = (SqlComponent)context.getComponent("sql-my-sql-proxy", SqlComponent.class);
        DataSource sqlDatasource = sqlComponent.getDataSource();
        Assertions.assertThat((Object)sqlDatasource).isEqualTo((Object)this.ds);
        Map endpoints = context.getEndpointMap();
        Assertions.assertThat((Map)endpoints).containsKey((Object)"sql-my-sql-proxy://select%20from%20dual");
        context.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegistryOption() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("dataSource", "#ds");
        properties.put("query", "select from dual");
        ComponentProxyComponent component = new ComponentProxyComponent("my-sql-proxy", "sql");
        component.setOptions(properties);
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"ds", (Object)this.ds);
        registry.put((Object)(component.getComponentId() + "-component"), (Object)component);
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        try {
            context.setAutoStartup(Boolean.valueOf(false));
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:start").to("my-sql-proxy")).to("mock:result");
                }
            });
            this.validateRegistryOption((CamelContext)context);
            this.validateRegistryOption((CamelContext)context);
        }
        finally {
            context.stop();
        }
    }

    private void validateRegistryOption(CamelContext context) throws Exception {
        context.start();
        List names = context.getComponentNames();
        Assertions.assertThat((Iterable)names).contains((Object[])new String[]{"my-sql-proxy"});
        Assertions.assertThat((Iterable)names).contains((Object[])new String[]{"sql"});
        Assertions.assertThat((Iterable)names).doesNotContain((Object[])new String[]{"sql-my-sql-proxy"});
        SqlComponent sqlComponent = (SqlComponent)context.getComponent("sql", SqlComponent.class);
        DataSource sqlDatasource = sqlComponent.getDataSource();
        Assertions.assertThat((Object)sqlDatasource).isNull();
        Map endpoints = context.getEndpointMap();
        Assertions.assertThat((Map)endpoints).containsKey((Object)"sql://select%20from%20dual?dataSource=%23ds");
        context.stop();
    }
}

