/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import io.syndesis.integration.component.proxy.ComponentProxyComponent;
import java.util.HashMap;
import org.apache.camel.Body;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ComponentProxyComponentTest
extends CamelTestSupport {
    protected JndiRegistry createRegistry() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("beanName", "my-bean");
        ComponentProxyComponent component = new ComponentProxyComponent("my-bean-proxy", "bean");
        component.setOptions(properties);
        JndiRegistry registry = super.createRegistry();
        registry.bind("my-bean", (Object)new MyBean());
        registry.bind(component.getComponentId() + "-component", (Object)component);
        return registry;
    }

    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("my-bean-proxy")).to("mock:result");
            }
        };
    }

    @Test
    public void testRequest() {
        String body = "hello";
        String result = (String)this.template().requestBody("direct:start", (Object)"hello", String.class);
        Assertions.assertThat((String)result).isEqualTo((Object)"hello".toUpperCase());
    }

    @Test
    public void testSend() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        String body = "hello";
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"hello".toUpperCase()});
        this.template().sendBody("direct:start", (Object)"hello");
        mock.assertIsSatisfied();
    }

    public static class MyBean {
        public String process(@Body String body) {
            return body.toUpperCase();
        }
    }
}

