/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import io.syndesis.integration.component.proxy.ComponentDefinition;
import io.syndesis.integration.component.proxy.ComponentProxyComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.sql.SqlComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.commons.dbcp.BasicDataSource;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.Before;
import org.junit.Test;

public class ComponentProxyWithCustomComponentTest {
    private DataSource ds;

    @Before
    public void setUp() {
        this.ds = new BasicDataSource();
    }

    @Test
    public void testCreateDelegateComponent() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("dataSource", this.ds);
        properties.put("query", "select from dual");
        ComponentProxyComponent component = new ComponentProxyComponent("my-sql-proxy", "sql"){

            protected Optional<Component> createDelegateComponent(ComponentDefinition definition, Map<String, Object> options) throws Exception {
                return Optional.of(new SqlComponent());
            }
        };
        component.setOptions(properties);
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)(component.getComponentId() + "-component"), (Object)component);
        this.validate((Registry)registry);
    }

    @Test
    public void testConfigureDelegateComponent() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("dataSource", this.ds);
        properties.put("query", "select from dual");
        ComponentProxyComponent component = new ComponentProxyComponent("my-sql-proxy", "sql"){

            protected void configureDelegateComponent(ComponentDefinition definition, Component component, Map<String, Object> options) throws Exception {
                Assertions.assertThat((Object)component).isInstanceOf(SqlComponent.class);
                Assertions.assertThat(options).containsKey((Object)"dataSource");
                Assertions.assertThat(options).hasEntrySatisfying((Object)"dataSource", (Condition)new Condition<Object>(){

                    public boolean matches(Object value) {
                        return value instanceof DataSource;
                    }
                });
                ((SqlComponent)component).setDataSource((DataSource)options.remove("dataSource"));
            }
        };
        component.setOptions(properties);
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)(component.getComponentId() + "-component"), (Object)component);
        this.validate((Registry)registry);
    }

    @Test
    public void testCreateAndConfigureDelegateComponent() throws Exception {
        final AtomicReference componentRef = new AtomicReference();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("dataSource", this.ds);
        properties.put("query", "select from dual");
        ComponentProxyComponent component = new ComponentProxyComponent("my-sql-proxy", "sql"){

            protected Optional<Component> createDelegateComponent(ComponentDefinition definition, Map<String, Object> options) throws Exception {
                componentRef.set(new SqlComponent());
                return Optional.of((Component)componentRef.get());
            }

            protected void configureDelegateComponent(ComponentDefinition definition, Component component, Map<String, Object> options) throws Exception {
                Assertions.assertThat((Object)component).isSameAs(componentRef.get());
                Assertions.assertThat((Object)component).isInstanceOf(SqlComponent.class);
                Assertions.assertThat(options).containsKey((Object)"dataSource");
                Assertions.assertThat(options).hasEntrySatisfying((Object)"dataSource", (Condition)new Condition<Object>(){

                    public boolean matches(Object value) {
                        return value instanceof DataSource;
                    }
                });
                ((SqlComponent)component).setDataSource((DataSource)options.remove("dataSource"));
            }
        };
        component.setOptions(properties);
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)(component.getComponentId() + "-component"), (Object)component);
        this.validate((Registry)registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(Registry registry) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(registry);
        try {
            context.setAutoStartup(Boolean.valueOf(false));
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:start").to("my-sql-proxy")).to("mock:result");
                }
            });
            context.start();
            List names = context.getComponentNames();
            Assertions.assertThat((Iterable)names).contains((Object[])new String[]{"my-sql-proxy"});
            Assertions.assertThat((Iterable)names).contains((Object[])new String[]{"sql-my-sql-proxy"});
            SqlComponent sqlComponent = (SqlComponent)context.getComponent("sql-my-sql-proxy", SqlComponent.class);
            DataSource sqlDatasource = sqlComponent.getDataSource();
            Assertions.assertThat((Object)sqlDatasource).isEqualTo((Object)this.ds);
            Map endpoints = context.getEndpointMap();
            Assertions.assertThat((Map)endpoints).containsKey((Object)"sql-my-sql-proxy://select%20from%20dual");
        }
        finally {
            context.stop();
        }
    }
}

