/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import io.syndesis.integration.component.proxy.ComponentDefinition;
import io.syndesis.integration.component.proxy.ComponentProxyComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ComponentProxyWithCustomEndpointTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomizeDelegatedEndpoint() throws Exception {
        boolean binary = true;
        String username = "my-user";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("transfer-mode-binary", Boolean.toString(true));
        properties.put("username", "my-user");
        properties.put("host", "localhost");
        ComponentProxyComponent component = new ComponentProxyComponent("my-ftp-proxy", "ftp"){

            protected void configureDelegateEndpoint(ComponentDefinition definition, Endpoint endpoint, Map<String, Object> options) throws Exception {
                Assertions.assertThat((Object)endpoint).isNotNull();
                Assertions.assertThat((Object)endpoint).isInstanceOf(FtpEndpoint.class);
                FtpEndpoint ftpEndpoint = (FtpEndpoint)FtpEndpoint.class.cast(endpoint);
                boolean binary = Objects.equals("true", options.get("transfer-mode-binary"));
                ftpEndpoint.getConfiguration().setBinary(binary);
                Assertions.assertThat((boolean)ftpEndpoint.getConfiguration().isBinary()).isEqualTo(binary);
            }
        };
        component.setOptions(properties);
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)(component.getComponentId() + "-component"), (Object)component);
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        try {
            context.setAutoStartup(Boolean.valueOf(false));
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:start").to("my-ftp-proxy")).to("mock:result");
                }
            });
            context.start();
            List names = context.getComponentNames();
            Assertions.assertThat((Iterable)names).contains((Object[])new String[]{"my-ftp-proxy"});
            Assertions.assertThat((Iterable)names).contains((Object[])new String[]{"ftp-my-ftp-proxy"});
            Assertions.assertThat(context.getEndpointMap().keySet()).contains((Object[])new String[]{"ftp-my-ftp-proxy://localhost?username=my-user"});
            FtpEndpoint ftpEndpoint = (FtpEndpoint)context.getEndpoint("ftp-my-ftp-proxy://localhost?username=my-user", FtpEndpoint.class);
            Assertions.assertThat((Object)ftpEndpoint).isNotNull();
            Assertions.assertThat((Object)ftpEndpoint.getConfiguration()).hasFieldOrPropertyWithValue("binary", (Object)true);
            Assertions.assertThat((Object)ftpEndpoint.getConfiguration()).hasFieldOrPropertyWithValue("username", (Object)"my-user");
        }
        finally {
            context.stop();
        }
    }
}

