/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import io.syndesis.integration.component.proxy.ComponentDefinition;
import io.syndesis.integration.component.proxy.ComponentProxyEndpoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.function.Predicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentProxyComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentProxyComponent.class);
    private final CamelCatalog catalog;
    private final String componentId;
    private final String componentScheme;
    private final Map<String, Object> configuredOptions;
    private final Map<String, Object> remainingOptions;
    private final ComponentDefinition definition;
    private Optional<String> componentSchemeAlias;
    private Processor beforeProducer;
    private Processor afterProducer;
    private Processor beforeConsumer;
    private Processor afterConsumer;

    public ComponentProxyComponent(String componentId, String componentScheme) {
        this(componentId, componentScheme, (String)null, (CamelCatalog)new DefaultCamelCatalog(false));
    }

    public ComponentProxyComponent(String componentId, String componentScheme, CamelCatalog catalog) {
        this(componentId, componentScheme, (String)null, catalog);
    }

    public ComponentProxyComponent(String componentId, String componentScheme, String componentClass) {
        this(componentId, componentScheme, componentClass, (CamelCatalog)new DefaultCamelCatalog(false));
    }

    public ComponentProxyComponent(String componentId, String componentScheme, Class<?> componentClass) {
        this(componentId, componentScheme, componentClass.getName(), (CamelCatalog)new DefaultCamelCatalog(false));
    }

    public ComponentProxyComponent(String componentId, String componentScheme, Class<?> componentClass, CamelCatalog catalog) {
        this(componentId, componentScheme, componentClass.getName(), catalog);
    }

    public ComponentProxyComponent(String componentId, String componentScheme, String componentClass, CamelCatalog catalog) {
        this.componentId = StringHelper.notEmpty((String)componentId, (String)"componentId");
        this.componentScheme = StringHelper.notEmpty((String)componentScheme, (String)"componentScheme");
        this.componentSchemeAlias = Optional.empty();
        this.configuredOptions = new HashMap<String, Object>();
        this.remainingOptions = new HashMap<String, Object>();
        this.catalog = (CamelCatalog)ObjectHelper.notNull((Object)catalog, (String)"catalog");
        if (ObjectHelper.isNotEmpty((Object)componentClass)) {
            this.catalog.addComponent(componentScheme, componentClass);
        }
        try {
            this.definition = ComponentDefinition.forScheme(catalog, componentScheme);
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        this.registerExtension(this::getComponentVerifierExtension);
    }

    public void setOptions(Map<String, Object> options) {
        this.configuredOptions.clear();
        if (ObjectHelper.isNotEmpty(options)) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                if (entry.getValue() == null) continue;
                this.configuredOptions.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected ComponentDefinition getDefinition() {
        return this.definition;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.doAddOptions(options, this.remainingOptions);
        this.doAddOptions(options, parameters);
        Map<String, String> endpointOptions = this.buildEndpointOptions(remaining, options);
        String endpointScheme = this.componentSchemeAlias.orElse(this.componentScheme);
        ComponentDefinition definition = this.getDefinition();
        Endpoint delegate = this.createDelegateEndpoint(definition, endpointScheme, endpointOptions);
        LOGGER.info("Connector resolved: {} -> {}", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizeUri((String)delegate.getEndpointUri()));
        options.keySet().removeIf(endpointOptions::containsKey);
        this.configureDelegateEndpoint(definition, delegate, options);
        ComponentProxyEndpoint answer = new ComponentProxyEndpoint(uri, this, delegate);
        answer.setBeforeProducer((Processor)ObjectHelper.trySetCamelContext((Object)this.getBeforeProducer(), (CamelContext)this.getCamelContext()));
        answer.setAfterProducer((Processor)ObjectHelper.trySetCamelContext((Object)this.getAfterProducer(), (CamelContext)this.getCamelContext()));
        answer.setBeforeConsumer((Processor)ObjectHelper.trySetCamelContext((Object)this.getBeforeConsumer(), (CamelContext)this.getCamelContext()));
        answer.setAfterConsumer((Processor)ObjectHelper.trySetCamelContext((Object)this.getAfterConsumer(), (CamelContext)this.getCamelContext()));
        parameters.clear();
        this.remainingOptions.clear();
        return answer;
    }

    protected void doStart() throws Exception {
        this.remainingOptions.clear();
        this.remainingOptions.putAll(this.configuredOptions);
        this.enrichOptions(this.remainingOptions);
        ComponentDefinition definition = this.getDefinition();
        Optional<Component> component = this.createDelegateComponent(definition, this.remainingOptions);
        if (component.isPresent()) {
            this.configureDelegateComponent(definition, component.get(), this.remainingOptions);
            this.componentSchemeAlias = Optional.of(this.componentScheme + "-" + this.componentId);
            if (!this.catalog.findComponentNames().contains(this.componentSchemeAlias.get())) {
                this.catalog.addComponent(this.componentSchemeAlias.get(), definition.getComponent().getJavaType(), this.catalog.componentJSonSchema(this.componentScheme));
            }
            LOGGER.info("Register component: {} (type: {}) with scheme: {} and alias: {}", new Object[]{this.componentId, component.get().getClass().getName(), this.componentScheme, this.componentSchemeAlias.get()});
            this.getCamelContext().removeComponent(this.componentSchemeAlias.get());
            if (!this.getCamelContext().hasService((Object)component.get())) {
                this.getCamelContext().addService((Object)component.get(), true, true);
            }
            this.getCamelContext().addComponent(this.componentSchemeAlias.get(), component.get());
        } else {
            this.componentSchemeAlias = Optional.empty();
        }
        LOGGER.debug("Starting connector: {}", (Object)this.componentId);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.componentSchemeAlias.isPresent()) {
            LOGGER.debug("Stopping component: {}", (Object)this.componentSchemeAlias.get());
            this.getCamelContext().removeComponent(this.componentSchemeAlias.get());
        }
        LOGGER.debug("Stopping connector: {}", (Object)this.componentId);
        super.doStop();
    }

    public Processor getBeforeProducer() {
        return this.beforeProducer;
    }

    public void setBeforeProducer(Processor beforeProducer) {
        this.beforeProducer = beforeProducer;
    }

    public Processor getAfterProducer() {
        return this.afterProducer;
    }

    public void setAfterProducer(Processor afterProducer) {
        this.afterProducer = afterProducer;
    }

    public Processor getBeforeConsumer() {
        return this.beforeConsumer;
    }

    public void setBeforeConsumer(Processor beforeConsumer) {
        this.beforeConsumer = beforeConsumer;
    }

    public Processor getAfterConsumer() {
        return this.afterConsumer;
    }

    public void setAfterConsumer(Processor afterConsumer) {
        this.afterConsumer = afterConsumer;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentScheme() {
        return this.componentScheme;
    }

    protected void enrichOptions(Map<String, Object> options) {
    }

    protected Optional<Component> createDelegateComponent(ComponentDefinition definition, Map<String, Object> options) throws Exception {
        String componentClass = definition.getComponent().getJavaType();
        if (componentClass != null && !options.isEmpty()) {
            Set<String> endpointOptions = definition.getEndpointProperties().keySet();
            boolean hasComponentOptions = options.keySet().stream().anyMatch(Predicates.negate(endpointOptions::contains));
            boolean hasPojoOptions = options.values().stream().anyMatch(Predicates.negate(String.class::isInstance));
            if (hasComponentOptions || hasPojoOptions) {
                CamelContext context = this.getCamelContext();
                Class type = context.getClassResolver().resolveClass(componentClass, Component.class);
                Component component = (Component)context.getInjector().newInstance(type);
                component.setCamelContext(context);
                return Optional.of(component);
            }
        }
        return Optional.empty();
    }

    protected void configureDelegateComponent(ComponentDefinition definition, Component component, Map<String, Object> options) throws Exception {
        CamelContext context = this.getCamelContext();
        ArrayList entries = new ArrayList();
        Set<String> endpointOptions = definition.getEndpointProperties().keySet();
        options.entrySet().stream().filter(e -> !endpointOptions.contains(e.getKey())).forEach(entries::add);
        options.entrySet().stream().filter(e -> e.getValue() != null).filter(Predicates.negate(e -> e.getValue() instanceof String)).forEach(entries::add);
        if (!entries.isEmpty()) {
            component.setCamelContext(context);
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val instanceof String) {
                    val = this.getCamelContext().resolvePropertyPlaceholders((String)val);
                }
                if (!IntrospectionSupport.setProperty((CamelContext)context, (Object)component, (String)key, val)) continue;
                options.remove(key);
            }
        }
    }

    protected Endpoint createDelegateEndpoint(ComponentDefinition definition, String scheme, Map<String, String> options) throws Exception {
        String uri = this.catalog.asEndpointUri(scheme, options, false);
        return this.getCamelContext().getEndpoint(uri);
    }

    protected void configureDelegateEndpoint(ComponentDefinition definition, Endpoint endpoint, Map<String, Object> options) throws Exception {
    }

    protected Map<String, String> buildEndpointOptions(String remaining, Map<String, Object> options) throws Exception {
        String targetUri;
        Map extra;
        TypeConverter converter = this.getCamelContext().getTypeConverter();
        LinkedHashMap<String, String> endpointOptions = new LinkedHashMap<String, String>();
        Set<String> endpointProperties = this.getDefinition().getEndpointProperties().keySet();
        for (String key2 : endpointProperties) {
            Object val = options.get(key2);
            if (val == null) continue;
            this.doAddOption(endpointOptions, key2, (String)converter.mandatoryConvertTo(String.class, val));
        }
        if (remaining != null && (extra = this.catalog.endpointProperties(targetUri = this.componentScheme + ":" + remaining)) != null && !extra.isEmpty()) {
            extra.forEach((key, value) -> this.doAddOption((Map)endpointOptions, (String)key, (Object)value));
        }
        return endpointOptions;
    }

    private <T> void doAddOptions(Map<String, T> destination, Map<String, T> options) {
        options.forEach((k, v) -> this.doAddOption(destination, (String)k, (Object)v));
    }

    private <T> void doAddOption(Map<String, T> options, String name, T value) {
        LOGGER.trace("Adding option: {}={}", (Object)name, value);
        T val = options.put(name, value);
        if (val != null) {
            LOGGER.debug("Options {} overridden, old value was {}", (Object)name, val);
        }
    }

    protected Object getOption(String key) {
        return this.configuredOptions.get(key);
    }

    protected CamelCatalog getCatalog() {
        return this.catalog;
    }

    public Collection<Class<? extends ComponentExtension>> getSupportedExtensions() {
        HashSet<Class<? extends ComponentExtension>> extensions = new HashSet<Class<? extends ComponentExtension>>();
        extensions.addAll(super.getSupportedExtensions());
        extensions.addAll(this.getCamelContext().getComponent(this.componentScheme, true, false).getSupportedExtensions());
        return extensions;
    }

    public <T extends ComponentExtension> Optional<T> getExtension(Class<T> extensionType) {
        Optional extension = super.getExtension(extensionType);
        if (!extension.isPresent()) {
            extension = this.getCamelContext().getComponent(this.componentScheme, true, false).getExtension(extensionType);
        }
        return extension;
    }

    private ComponentVerifierExtension getComponentVerifierExtension() {
        try {
            Component component = this.getCamelContext().getComponent(this.componentScheme, true, false);
            Optional extension = component.getExtension(ComponentVerifierExtension.class);
            if (extension.isPresent()) {
                return (scope, map) -> {
                    Map options;
                    try {
                        Map tmp;
                        options = tmp = (Map)Map.class.cast(this.buildEndpointOptions(null, map));
                    }
                    catch (Exception e) {
                        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)scope).error(ResultErrorBuilder.withException((Exception)e).build()).build();
                    }
                    return ((ComponentVerifierExtension)extension.get()).verify(scope, options);
                };
            }
            return (scope, map) -> ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.UNSUPPORTED, (ComponentVerifierExtension.Scope)scope).error(ResultErrorBuilder.withCode((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED).detail("camel_connector_id", (Object)this.componentId).detail("camel_component_scheme", (Object)this.componentScheme).detail("camel_component_scheme_alias", this.componentSchemeAlias).build()).build();
        }
        catch (Exception e) {
            return (scope, map) -> ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)scope).error(ResultErrorBuilder.withException((Exception)e).build()).build();
        }
    }
}

