/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.component.proxy;

import io.syndesis.integration.component.proxy.ComponentProxyComponent;
import io.syndesis.integration.component.proxy.ComponentProxyProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.util.ServiceHelper;

public class ComponentProxyEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private final Endpoint endpoint;
    private Processor beforeProducer;
    private Processor afterProducer;
    private Processor beforeConsumer;
    private Processor afterConsumer;

    public ComponentProxyEndpoint(String endpointUri, ComponentProxyComponent component, Endpoint endpoint) {
        super(endpointUri, (Component)component);
        this.endpoint = endpoint;
    }

    public Producer createProducer() throws Exception {
        Producer producer = this.endpoint.createProducer();
        Processor beforeProducer = this.getBeforeProducer();
        Processor afterProducer = this.getAfterProducer();
        Processor pipeline = Pipeline.newInstance((CamelContext)this.getCamelContext(), (Processor[])new Processor[]{beforeProducer, producer, afterProducer});
        return new ComponentProxyProducer(this.endpoint, pipeline);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Processor beforeConsumer = this.getBeforeConsumer();
        Processor afterConsumer = this.getAfterConsumer();
        Processor pipeline = Pipeline.newInstance((CamelContext)this.getCamelContext(), (Processor[])new Processor[]{beforeConsumer, processor, afterConsumer});
        Consumer consumer = this.endpoint.createConsumer(pipeline);
        this.configureConsumer(consumer);
        return consumer;
    }

    public ComponentProxyComponent getComponent() {
        return (ComponentProxyComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @ManagedAttribute(description="Delegate Endpoint URI", mask=true)
    public String getDelegateEndpointUri() {
        return this.endpoint.getEndpointUri();
    }

    public Processor getBeforeProducer() {
        return this.beforeProducer;
    }

    public void setBeforeProducer(Processor beforeProducer) {
        this.beforeProducer = beforeProducer;
    }

    public Processor getAfterProducer() {
        return this.afterProducer;
    }

    public void setAfterProducer(Processor afterProducer) {
        this.afterProducer = afterProducer;
    }

    public Processor getBeforeConsumer() {
        return this.beforeConsumer;
    }

    public void setBeforeConsumer(Processor beforeConsumer) {
        this.beforeConsumer = beforeConsumer;
    }

    public Processor getAfterConsumer() {
        return this.afterConsumer;
    }

    public void setAfterConsumer(Processor afterConsumer) {
        this.afterConsumer = afterConsumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.endpoint);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.endpoint);
        super.doStop();
    }
}

