/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.runtime.sb;

import io.syndesis.integration.runtime.ActivityTrackingPolicyFactory;
import io.syndesis.integration.runtime.IntegrationRouteBuilder;
import io.syndesis.integration.runtime.IntegrationStepHandler;
import io.syndesis.integration.runtime.sb.IntegrationRuntimeConfiguration;
import io.syndesis.integration.runtime.sb.logging.IntegrationLoggingConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="syndesis.integration.runtime", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={IntegrationRuntimeConfiguration.class, IntegrationLoggingConfiguration.class})
public class IntegrationRuntimeAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationRuntimeAutoConfiguration.class);
    @Autowired
    private IntegrationRuntimeConfiguration configuration;
    @Autowired(required=false)
    private List<ActivityTrackingPolicyFactory> activityTrackingPolicyFactories = Collections.emptyList();
    @Autowired(required=false)
    private List<IntegrationStepHandler> integrationStepHandlers = Collections.emptyList();

    @Bean
    public CamelContextConfiguration integrationContextRuntimeConfiguration() {
        return new CamelContextConfiguration(){

            public void beforeApplicationStart(CamelContext camelContext) {
                String location = IntegrationRuntimeAutoConfiguration.this.configuration.getConfigurationLocation();
                ArrayList<IntegrationStepHandler> handlers = new ArrayList<IntegrationStepHandler>();
                handlers.addAll(IntegrationRuntimeAutoConfiguration.this.integrationStepHandlers);
                LOGGER.info("Autowired IntegrationStepHandlers found: {}", (Object)IntegrationRuntimeAutoConfiguration.this.integrationStepHandlers.size());
                for (IntegrationStepHandler handler : ServiceLoader.load(IntegrationStepHandler.class, Thread.currentThread().getContextClassLoader())) {
                    handlers.add(handler);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("ServiceLoader loaded IntegrationStepHandlers: {}", (Object)(handlers.size() - IntegrationRuntimeAutoConfiguration.this.integrationStepHandlers.size()));
                }
                IntegrationRouteBuilder routeBuilder = new IntegrationRouteBuilder(location, handlers, IntegrationRuntimeAutoConfiguration.this.activityTrackingPolicyFactories);
                try {
                    camelContext.addRoutes((RoutesBuilder)routeBuilder);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public void afterApplicationStart(CamelContext camelContext) {
                RoutesDefinition routes = new RoutesDefinition();
                routes.setRoutes(camelContext.getRouteDefinitions());
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Routes: \n{}", (Object)ModelHelper.dumpModelAsXml((CamelContext)camelContext, (NamedNode)routes));
                    }
                }
                catch (JAXBException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }
}

