/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.runtime.sb;

import io.syndesis.integration.runtime.util.SyndesisHeaderStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration
@Conditional(value={NeedsHeaderFilterStrategy.class})
@AutoConfigureBefore(name={"org.apache.camel.component.servlet.springboot.ServletComponentAutoConfiguration"})
public class SyndesisHttpConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HeaderFilterStrategy syndesisHeaderStrategy() {
        return new SyndesisHeaderStrategy();
    }

    static class NeedsHeaderFilterStrategy
    extends AnyNestedCondition {
        public NeedsHeaderFilterStrategy() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnResource(resources={"classpath:META-INF/syndesis/connector/webhook.json"})
        static class WebhookUsed {
            WebhookUsed() {
            }
        }

        @ConditionalOnResource(resources={"classpath:META-INF/syndesis/connector/rest-swagger.json"})
        static class SyndesisApiClientUsed {
            SyndesisApiClientUsed() {
            }
        }

        @ConditionalOnResource(resources={"classpath:META-INF/syndesis/connector/https4.json"})
        static class HttpsUsed {
            HttpsUsed() {
            }
        }

        @ConditionalOnResource(resources={"classpath:META-INF/syndesis/connector/http4.json"})
        static class HttpUsed {
            HttpUsed() {
            }
        }

        @ConditionalOnClass(name={"org.apache.camel.component.servlet.springboot.ServletComponentAutoConfiguration"})
        static class CamelServletUsed {
            CamelServletUsed() {
            }
        }
    }
}

